import { promisify } from 'node:util'
import child_process from 'node:child_process'
import { readFileSync } from 'node:fs'
import { writeFile } from 'node:fs/promises'

export default defineEventHandler(async (event) => {
  let data: any = {}
  const exec = promisify(child_process.exec);
  const path = '00000'

  try {
    await exec(`if [ ! -d /root/storage/${path} ]; then mkdir /root/storage/${path}; fi`);
    await writeFile(`/root/storage/${path}/test.txt`, 'Test text 00000 v2')

    data['message'] = 'success'
    data['content'] = readFileSync(`/root/storage/${path}/test.txt`, 'utf8')
  } catch(err: any) {
    data = err
  }

  return data
})