import { string } from 'alga-js'
import refreshTokenHelper from "../../../../utils/refreshTokenHelper"
import getTokenHelper from "../../../../utils/getTokenHelper"
import forceLogoutHelper from "../../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../../utils/errorHandlingHelper"
import fetchHelper from "../../../../utils/fetchHelper"
import dhlHelper from "../../../../utils/dhlHelper"
import dhlCustomHelper from "../../../../utils/dhlCustomHelper"

const handleInoutFunc = async (event: any, authToken: any = null, id) => {
  let data: any = {}
  const token = authToken ?? await getTokenHelper(event)

  const resp: any = await fetchHelper(event, 'models/m_inout/'+id, 'PUT', token, {
    TrackingNo: null,
    DHL_Shipment_Code: null,
    DHL_Routing_Code: null,
    DHL_Label_Base64: null,
    IsCommissioned: false,
    IsCommissionedConfirmed: false,
    ack_commissioned_laravel: false,
    tableName: 'M_Inout'
  })
  if(resp) {
    data['shipment'] = resp
    data['status'] = 200
    data['message'] = ''
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}
  const body = await readBody(event)

  try {
    let dhlCustomActive = false
    let dhlCustomData = {}
    const tokenCustom = await getTokenHelper(event)
    //@ts-ignore
    const respInout: any = await fetchHelper(event, 'models/m_inout/'+body.inOutId+'?$expand=c_order_id', 'GET', tokenCustom, null)
  
    if(respInout?.C_Order_ID?.C_OrderSource_ID?.id) {
      //@ts-ignore
      const respOrderSource: any = await fetchHelper(event, 'models/c_ordersource/'+respInout.C_Order_ID.C_OrderSource_ID.id, 'GET', tokenCustom, null)
      if(respOrderSource?.DHL_USE_CUSTOM == true && respOrderSource?.DHLURL) {
        dhlCustomActive = true
        dhlCustomData = {
          dhlurl: respOrderSource.DHLURL,
          dhlkey: respOrderSource.DHLKEY,
          dhlsecret: respOrderSource.DHLSECRET,
          dhluser: respOrderSource.DHLUSER,
          dhlpass: respOrderSource.DHLPASS,
          iscustom: respOrderSource.DHL_USE_CUSTOM
        }
      }
    }

    try {
      data = await handleInoutFunc(event, null, body.inOutId)
    } catch(err: any) {
      try {
        let authToken: any = await refreshTokenHelper(event)
        data = await handleInoutFunc(event, authToken, body.inOutId)
      } catch(error: any) {
        data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
        forceLogoutHelper(event, data)
      }
    }
    
    let res: any = {}
    if(dhlCustomActive) {
      res = await dhlCustomHelper(event, dhlCustomData, `shipping/v2/orders?profile=STANDARD_GRUPPENPROFIL&shipment=${body.shipmentNo}`, 'DELETE', null)
      data['dhl_custom'] = dhlCustomData 
    } else {
      res = await dhlHelper(event, `shipping/v2/orders?profile=STANDARD_GRUPPENPROFIL&shipment=${body.shipmentNo}`, 'DELETE', null)
    }
    if(res) {
      data['dhl_parcel'] = res
    }
  } catch(error: any) {
    data['status'] = 500
    data['message'] = error?.message ?? 'DHL Parcel is not being properly cancelled!'
  }

  return data
})