export default {
  create: [
    { 
      path: 'sales-order', 
      component: () => import('../../pages/sales/orders/add.vue').then(r => r.default || r) 
    },
    { 
      path: 'sales-fulfillment-order', 
      component: () => import('../../pages/sales/fulfillment-orders/add.vue').then(r => r.default || r) 
    },
    { 
      path: 'sales-order-return', 
      component: () => import('../../pages/sales/orders/return.vue').then(r => r.default || r) 
    },
  ],
  edit: [
    { 
      path: 'sales-order-:id', 
      component: () => import('../../pages/sales/orders/[id]/edit.vue').then(r => r.default || r) 
    },
    { 
      path: 'sales-fulfillment-order-:id', 
      component: () => import('../../pages/sales/fulfillment-orders/[id]/edit.vue').then(r => r.default || r) 
    },
  ],
  view: [
    { 
      path: 'sales-order-:id', 
      component: () => import('../../pages/sales/orders/[id]/view.vue').then(r => r.default || r) 
    },
    { 
      path: 'sales-fulfillment-order-:id', 
      component: () => import('../../pages/sales/fulfillment-orders/[id]/view.vue').then(r => r.default || r) 
    },
  ],
  duplicate: [
    { 
      path: 'sales-order-:id', 
      component: () => import('../../pages/sales/orders/[id]/duplicate.vue').then(r => r.default || r) 
    },
    { 
      path: 'sales-fulfillment-order-:id', 
      component: () => import('../../pages/sales/fulfillment-orders/[id]/duplicate.vue').then(r => r.default || r) 
    },
  ]
}