import refreshTokenHelper from "../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../utils/errorHandlingHelper"
import fetchHelper from "../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const config = useRuntimeConfig()
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  let newObjValue = {}
  if(body.taxCategoryId) {
    newObjValue = {...newObjValue, 
      C_TaxCategory_ID: {
        id: body.taxCategoryId,
        tableName: 'C_TaxCategory'
      }
    }
  }
  if(body.partnerId) {
    newObjValue = {...newObjValue, 
      C_BPartner_ID: {
        id: body.partnerId,
        tableName: 'C_BPartner'
      }
    }
  }
  if(body.chargeTypeId) {
    newObjValue = {...newObjValue, 
      C_ChargeType_ID: {
        id: body.chargeTypeId,
        tableName: 'C_ChargeType'
      }
    }
  }

  const res: any = await fetchHelper(event, 'models/c_charge', 'POST', token, {
    AD_Org_ID: {
      id: body.organizationId,
      tableName: 'AD_Org'
    },
    isActive: body.isActive,
    name: body.name,
    description: body.description,
    chargeAmt: body.chargeAmt,
    isSameTax: body.isSameTax,
    isSameCurrency: body.isSameCurrency,
    isTaxIncluded: body.isTaxIncluded,
    ...newObjValue,
    tableName: 'c_charge'
  })
  if(res) {
    data = res
    data['status'] = 200
    data['message'] = ''
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})