import { string } from 'alga-js'
import refreshTokenHelper from "../../../utils/refreshTokenHelper"
import getTokenHelper from "../../../utils/getTokenHelper"
import forceLogoutHelper from "../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../utils/errorHandlingHelper"
import fetchHelper from "../../../utils/fetchHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const config = useRuntimeConfig()
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  if(body?.ids) {
    for(let id of body.ids) {
      const res: any = await fetchHelper(event, `models/m_freight?$filter=${string.urlEncode('M_Shipper_ID eq '+id)}`, 'GET', token, null)
      if(res) {
        for(let fi of res.records) {
          await fetchHelper(event, 'models/m_freight/'+fi.id, 'DELETE', token, null)
        }
      }

      /*await $fetch(config.api.url+'/models/m_shipper/'+id, {
        method: 'DELETE',
        headers: {
          Authorization: 'Bearer '+token
        }
      })*/
      await fetchHelper(event, 'models/m_shipper/'+id, 'DELETE', token, null)
    }
  }
 
  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error: any) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})