export default defineEventHandler(async (event) => {
  const config = useRuntimeConfig()
  const body = await readBody(event)
  let user: any = {}

  if(event.context.auth.user) {
    user = event.context.auth.user
    user.isRegistered = true
  } else {
    await $fetch(config.api.url+'/register', {
      method: 'POST',
      headers: {
        'Authorization': 'Bearer '+event.context.auth.token
      },
      body: {
        activated: body.activated,
        authorities: body.authorities,
        email: body.email,
        login: body.login,
        password: body.password,
        imageUrl: body.imageUrl,
        langKey: body.langKey
      }
    })

    user.isRegistered = true
  }

  return user
})