// https://nuxt.com/docs/api/configuration/nuxt-config
export default defineNuxtConfig({
    devtools: { enabled: true },
    telemetry: false,
    // extends: ['@nuxt/ui-pro'],
    modules: ['@nuxt/ui', '@nuxt/ui-pro', 'nuxt-lazy-load'],

    /*i18n: {
      vueI18n: './i18n.config.ts' // if you are using custom path, default
    },*/
    plugins: [
        '~/plugins/amcharts.client.js'
    ],

    vite: {
        build: {
            target: "es2022"
        },
        esbuild: {
            target: "es2022"
        },
        optimizeDeps: {
            include: ["pdfjs-dist"], // optionally specify dependency name
            esbuildOptions: {
                target: "es2022",
                supported: {
                    "top-level-await": true
                },
            },
        }
    },

    /*nitro: {
      storage: {
        db: {
          driver: 'fs',
          base: './.data/db'
        }
      }
    },*/
    ui: {
        icons: ['mdi']
    },

    colorMode: {
        preference: 'light'
    },

    lazyLoad: {
        // These are the default values
        images: true,
        videos: true,
        audios: true,
        iframes: true,
        native: false,
        directiveOnly: false,

        // Default image must be in the public folder
        defaultImage: '/assets/skeleton-loader-placeholder.jpg',

        // To remove class set value to false
        loadingClass: 'isLoading',
        loadedClass: 'isLoaded',
        appendClass: 'lazyLoad',

        observerConfig: {
            // See IntersectionObserver documentation
        }
    },

    css: [
        '~/assets/sass/main.scss',
        '~/assets/css/style.css',
        // '~/assets/css/helper.css',
        // '~/node_modules/bulma/css/bulma.css',
        '~/assets/css/main.css',
        '~/node_modules/bulma/css/versions/bulma-no-dark-mode.min.css',
        '~/node_modules/bulma-extensions/dist/css/bulma-extensions.min.css',
        '~/node_modules/@creativebulma/bulma-tooltip/src/docs/static/css/bulma-tooltip.css',
        '~/node_modules/bulma-responsive-tables/css/main.min.css',
        '~/assets/css/custom.css',
    ],

    postcss: {
        plugins: {
            'alga-css': {
                important: false,
                //extract: [
                //'./layouts/**/*.vue',
                //'./pages/**/*.vue',
                //'./components/**/*.vue'
                //],
                src: './assets/alga/*.alga',
                plugins: ['tedir-table', 'tedir-dropzone', 'tedir-select', 'tedir-calendar']      }
        }
    },

    app: {
        head: {
            title: 'ERP Solutions',
            link: [
                { rel: "stylesheet", href: "/assets/vendor/fonts/tabler-icons.css" },
                { rel: "stylesheet", href: "/css/styles.css" }
            ],
            htmlAttrs: {
                'data-mode': 'light',
                'lang': 'en-US'
            },
            script: [
                {
                    innerHTML: `
          let defaultLanguage = 'en-US'

          if(localStorage.getItem('logship_lang')) {
            defaultLanguage = localStorage.getItem('logship_lang')
          }

          document.documentElement.setAttribute('lang', defaultLanguage)
          `
                }
            ]
        }
    },

    runtimeConfig: {
        api: {
            url: process.env.URLV1,
            strapi: process.env.STRAPIV1,
            strapitoken: process.env.STRAPITOKEN,
            idempieretoken: process.env.IDEMPIERETOKEN,
            postgrest: process.env.POSTGREST,
            laravel: process.env.LARAVEL,
            sendcloud: process.env.SENDCLOUD,
            sendcloudpublickey: process.env.SENDCLOUDPUBLICKEY,
            sendcloudprivatekey: process.env.SENDCLOUDPRIVATEKEY,
            dhlurl: process.env.DHLURL,
            dhlkey: process.env.DHLKEY,
            dhlsecret: process.env.DHLSECRET,
            dhluser: process.env.DHLUSER,
            dhlpass: process.env.DHLPASS,
            elastic: process.env.ELASTIC,
            elastickey: process.env.ELASTICKEY,
            elasticusername: process.env.ELASTIC_USER,
            elasticpass: process.env.ELASTIC_PASS
        },
        public: {
            strapi:  process.env.STRAPIPUBLIC,
            strapitoken: process.env.STRAPITOKEN,
            githash: process.env.GITHASH,
            buildtime: process.env.BUILDTIME,
            solutionname: process.env.SOLUTIONNAME,
            doctypeid: process.env.TARGET_DOCUMENT_TYPE_ID,
            doctypevalue: process.env.TARGET_DOCUMENT_TYPE_VALUE,
            partnergroupid: process.env.BUSINESS_PARTNER_GROUP_ID,
            partnergroupvalue: process.env.BUSINESS_PARTNER_GROUP_VALUE,
            iscustomer: process.env.IS_CUSTOMER,
            pricelistid: process.env.PRICE_LIST_ID,
            pricelistvalue: process.env.PRICE_LIST_VALUE,
            countryid: process.env.COUNTRY_ID,
            countryvalue: process.env.COUNTRY_VALUE,
            elastic: process.env.ELASTIC,
            aggrid: process.env.AGGRID,
        }
    },

    compatibilityDate: '2024-12-10',
})