export default defineNuxtRouteMiddleware(async (to, from) => {
  const guestPaths = ['/signin', '/select-role', '/login', '/register', '/verify-email', '/forgot-password', '/reset-password']

  if(!guestPaths.includes(from.path)) {
    const user = useCookie('logship_user')
    const authenticated = await $fetch('/api/idempiere-auth/authenticated', {
      headers: useRequestHeaders(['cookie'])
    })
    if(authenticated.user?.id === undefined || user.value?.id === undefined) {
      return navigateTo('/signin')
    }
  }
  /*if (to.params.id === '1') {
    return abortNavigation()
  }*/
})
