export const useMaterials = () => {
  return useState<any[]>('materials', () => ([
    {
      menu: true,
      text: 'Materials',
      translatedText: '', 
      value: 'materials', 
      link: '#', 
      icon: 'menu-icon tf-icons ti ti-box-seam',
      active: false,
      child: true,
      children: [
        {
          text: 'Products',
          translatedText: '', 
          value: 'products_or_inventories', 
          link: '#', 
          active: false,
          child: true,
          children: [
            {
              text: 'Products',
              translatedText: '', 
              value: 'products', 
              link: '/materials/products', 
              active: false,
            },
            {
              text: 'Product Categories',
              translatedText: '', 
              value: 'product_categories', 
              link: '/materials/product-categories', 
              active: false
            },
            {
              text: 'Stock Units',
              translatedText: '', 
              value: 'stock_units', 
              link: '/materials/stock-units', 
              active: false
            },
            {
              text: 'Product Info',
              translatedText: '', 
              value: 'product_info', 
              link: '/materials/product-infos', 
              active: false
            }
          ]
        },
        {
          text: 'Stock Missings', 
          value: 'stock_missings', 
          link: '/materials/stock-missings',
          active: false,
        },
        {
          text: 'Physical Inventory', 
          value: 'stock_takes', 
          link: '/materials/stock-takes',
          active: false,
        },
        {
          text: 'Stock Transfers', 
          value: 'stock_transfers', 
          link: '/materials/stock-transfers',
          active: false,
        },
        {
          text: 'Warehouses', 
          value: 'warehouses_and_locators', 
          link: '#', 
          active: false,
          child: true,
          children: [
            {
              text: 'Warehouses', 
              value: 'warehouses', 
              link: '/materials/warehouses', 
              active: false
            },
            {
              text: 'Locator Types', 
              value: 'locator_types', 
              link: '/materials/locator-types', 
              active: false
            }
          ]
        },
        {
          text: 'Price Lists', 
          value: 'price_lists_and_discount_schemas', 
          link: '#', 
          active: false,
          child: true,
          children: [
            {
              text: 'Price Lists', 
              value: 'price_lists', 
              link: '/materials/price-lists', 
              active: false
            },
            {
              text: 'Price List Versions', 
              value: 'price_list_versions', 
              link: '/materials/price-list-versions', 
              active: false
            },
            {
              text: 'Discount Schema', 
              value: 'discount_schema', 
              link: '/materials/discount-schemas', 
              active: false
            }
          ]
        },
        {
          text: 'Shippers', 
          value: 'shippers_and_freights', 
          link: '#', 
          active: false,
          child: true,
          children: [
            {
              text: 'Shippers', 
              value: 'shippers', 
              link: '/materials/shippers', 
              active: false
            },
            {
              text: 'Shipper Configurations', 
              value: 'shipper_configurations', 
              link: '/materials/shipper-configurations', 
              active: false
            },
            {
              text: 'Shipping Processors', 
              value: 'shipping_processors', 
              link: '/materials/shipping-processors', 
              active: false
            },
            {
              text: 'Processor Cfgs', 
              value: 'shipping_processor_configurations', 
              link: '/materials/shipping-processor-configurations', 
              active: false
            },
            /*{
              text: 'Freights', 
              value: 'freights', 
              link: '/materials/freights', 
              active: false
            },*/
            {
              text: 'Freight Categories', 
              value: 'freight_categories', 
              link: '/materials/freight-categories', 
              active: false
            },
            /*{
              text: 'Packagings', 
              value: 'packagings', 
              link: '/materials/packagings', 
              active: false
            },
            {
              text: 'Packaging Cfg', 
              value: 'packaging_configurations', 
              link: '/materials/packaging-configurations', 
              active: false
            },
            {
              text: 'Label Types', 
              value: 'label_types', 
              link: '/materials/label-types', 
              active: false
            },
            {
              text: 'Label Type Cfg', 
              value: 'label_type_configurations', 
              link: '/materials/label-type-configurations', 
              active: false
            },
            {
              text: 'Pickup Types', 
              value: 'pickup_types', 
              link: '/materials/pickup-types', 
              active: false
            },
            {
              text: 'Pickup Type Cfg', 
              value: 'pickup_type_configurations', 
              link: '/materials/pickup-type-configurations', 
              active: false
            }*/
          ]
        },
        {
          text: 'Promotions', 
          value: 'promotions_and_groups', 
          link: '#', 
          active: false,
          child: true,
          children: [
            {
              text: 'Promotions', 
              value: 'promotions', 
              link: '/materials/promotions', 
              active: false
            },
            {
              text: 'Promotion Groups', 
              value: 'promotion_groups', 
              link: '/materials/promotion-groups', 
              active: false
            }
          ]
        }
      ]
    },
  ]))
}