import { string } from 'alga-js'

export default async function dhlTrackingHelper(event: any, credential: any, url: string, method: string = 'GET', body: any) {
  const config = credential?.api ? credential : useRuntimeConfig()

  let options: any = {}
  if(credential?.headers) {
    options = {
      ...options,
      headers: credential.headers,
    }
  }
  if(body) {
    options = {
      ...options,
      body: body
    }
  }

  return await $fetch(String(config.api.dhlurl ?? '').replace('/parcel/de', '')+'/'+url, {
    method: method,
    ...options
  })
}