import refreshTokenHelper from "../../../utils/refreshTokenHelper"
import forceLogoutHelper from "../../../utils/forceLogoutHelper"
import errorHandlingHelper from "../../../utils/errorHandlingHelper"

const handleFunc = async (event: any, authToken: any = null) => {
  let data: any = {}
  const config = useRuntimeConfig()
  const token = authToken ?? await getTokenHelper(event)
  const body = await readBody(event)

  const res: any = await event.context.fetch('models/c_currency/'+body.id, 'PUT', token, {
    isActive: body.isActive,
    ISO_Code: body.iso_code,
    stdPrecision: body.stdPrecision,
    description: body.description,
    costingPrecision: body.costingPrecision,
    EMURate: body.emuRate,
    curSymbol: body.curSymbol,
    isEuro: body.isEuro,
    isEMUMember: body.isEMUMember,
    tableName: 'C_Currency'
  })
  if(res) {
    data = res
    data['status'] = 200
    data['message'] = ''
  }

  return data
}

export default defineEventHandler(async (event) => {
  let data: any = {}

  try {
    data = await handleFunc(event)
  } catch(err: any) {
    try {
      let authToken: any = await refreshTokenHelper(event)
      data = await handleFunc(event, authToken)
    } catch(error) {
      data = errorHandlingHelper(err?.data ?? err, error?.data ?? error)
      forceLogoutHelper(event, data)
    }
  }

  return data
})