import { string } from 'alga-js'
import dhlHelper from "../../../../utils/dhlHelper"
import errorHandlingHelper from "../../../../utils/errorHandlingHelper"

export default defineEventHandler(async (event) => {
  let data: any = null
  const query = getQuery(event)

  try {
    const res: any = await dhlHelper(event, `shipping/v2/orders?shipment=${query?.shipment_code ?? ''}&printFormat=910-300-400`, 'GET', null)
    if(res) {
      data = res
    }
  } catch(err: any) {
    data = errorHandlingHelper(err?.data ?? err, err?.data ?? err)
  }

  return data
})