export default defineEventHandler(async (event) => {
  const config = useRuntimeConfig()
  const body = await readBody(event)
  let user: any = {}

  if(event.context.auth.user) {
    user = event.context.auth.user
    user.isSuccess = true
  } else {
    await $fetch(config.api.url+'/account/reset-password/init-email', {
      method: 'POST',
      headers: {
        'Authorization': 'Bearer '+event.context.auth.token
      },
      body: {
        email: body.email
      }
    })

    user.isSuccess = true
  }

  return user
})