export const useSettings = () => {
  return useState<any[]>('settings', () => ([
    {
      menu: true,
      text: 'Settings',
      translatedText: '', 
      value: 'settings', 
      link: '#', 
      icon: 'menu-icon tf-icons ti ti-settings',
      active: false,
      child: true,
      children: [
        {
          text: 'General',
          translatedText: '', 
          value: 'general_settings', 
          link: '#', 
          active: false
        },
        {
          text: 'Activities',
          translatedText: '', 
          value: 'activities', 
          link: '/settings/activities', 
          active: false,
        },
        {
          text: 'Order Sources',
          translatedText: '', 
          value: 'order_sources', 
          link: '/settings/order-sources', 
          active: false,
        },
        {
          text: 'RMA Types',
          translatedText: '', 
          value: 'rma_types', 
          link: '/settings/rma-types', 
          active: false
        },
        {
          text: 'Currencies',
          translatedText: '', 
          value: 'currencies_and_rates', 
          link: '#', 
          active: false,
          child: true,
          children: [
            {
              text: 'Currencies',
              translatedText: '', 
              value: 'currencies', 
              link: '/settings/currencies', 
              active: false
            },
            {
              text: 'Currency Types',
              translatedText: '', 
              value: 'currency_types', 
              link: '#', 
              active: false
            },
            {
              text: 'Currency Rates',
              translatedText: '', 
              value: 'currency_rates', 
              link: '#', 
              active: false
            }
          ]
        },
        {
          text: 'Address Books',
          translatedText: '', 
          value: 'address_books', 
          link: '#', 
          active: false,
          child: true,
          children: [
            {
              text: 'Countries',
              translatedText: '', 
              value: 'countries', 
              link: '/settings/countries', 
              active: false
            },
            {
              text: 'Regions',
              translatedText: '', 
              value: 'regions', 
              link: '/settings/regions', 
              active: false
            },
            {
              text: 'Locations',
              translatedText: '', 
              value: 'locations', 
              link: '/settings/locations', 
              active: false
            }
          ]
        },
        {
          text: 'Documents',
          translatedText: '', 
          value: 'documents', 
          link: '#', 
          active: false,
          child: true,
          children: [
            {
              text: 'Document Status',
              translatedText: '', 
              value: 'document_status', 
              link: '/settings/document-status', 
              active: false
            },
            {
              text: 'Document Types',
              translatedText: '', 
              value: 'document_types', 
              link: '/settings/document-types', 
              active: false
            },
            {
              text: 'Document Groups',
              translatedText: '', 
              value: 'document_groups', 
              link: '/settings/document-groups', 
              active: false
            },
            {
              text: 'Document Sequences',
              translatedText: '', 
              value: 'document_sequences', 
              link: '/settings/document-sequences', 
              active: false
            },
            {
              text: 'Validation Rules',
              translatedText: '', 
              value: 'validation_rules', 
              link: '#', 
              active: false
            }
          ]
        },
        {
          text: 'Taxes',
          translatedText: '', 
          value: 'taxes', 
          link: '#', 
          active: false,
          child: true,
          children: [
            {
              text: 'Tax Categories',
              translatedText: '', 
              value: 'tax_categories', 
              link: '/settings/tax-categories', 
              active: false
            },
            {
              text: 'Tax Providers',
              translatedText: '',
              value: 'tax_providers', 
              link: '/settings/tax-providers', 
              active: false
            },
            {
              text: 'Tax Configurations', 
              translatedText: '',
              value: 'tax_configurations', 
              link: '/settings/tax-configurations', 
              active: false
            },
            {
              text: 'Tax Rates', 
              translatedText: '',
              value: 'tax_rates', 
              link: '/settings/tax-rates', 
              active: false
            }
          ]
        },
        {
          text: 'Charges',
          translatedText: '', 
          value: 'charges_and_types', 
          link: '#', 
          active: false,
          child: true,
          children: [
            {
              text: 'Charges',
              translatedText: '', 
              value: 'charges', 
              link: '/settings/charges', 
              active: false
            },
            {
              text: 'Charge Types',
              translatedText: '', 
              value: 'charge_types', 
              link: '/settings/charge-types', 
              active: false
            }
          ]
        },
      ]
    },
    { menu: false, text: '   ' },
    { menu: false, text: '   ' },
    { menu: false, text: '   ' }
  ]))
}