export default {
  create: [
    { 
      path: 'user', 
      component: () => import('../../pages/users/users/create.vue').then(r => r.default || r) 
    },
    { 
      path: 'lead', 
      component: () => import('../../pages/users/leads/create.vue').then(r => r.default || r) 
    },
    { 
      path: 'external-user', 
      component: () => import('../../pages/users/external-users/create.vue').then(r => r.default || r) 
    },
    { 
      path: 'role', 
      component: () => import('../../pages/users/roles/create.vue').then(r => r.default || r) 
    },
    { 
      path: 'organization', 
      component: () => import('../../pages/users/organizations/create.vue').then(r => r.default || r) 
    },
  ],
  edit: [
    { 
      path: 'user-:id', 
      component: () => import('../../pages/users/users/[id]/edit.vue').then(r => r.default || r) 
    },
    { 
      path: 'lead-:id', 
      component: () => import('../../pages/users/leads/[id]/edit.vue').then(r => r.default || r) 
    },
    { 
      path: 'external-user-:id', 
      component: () => import('../../pages/users/external-users/[id]/edit.vue').then(r => r.default || r) 
    },
    { 
      path: 'role-:id', 
      component: () => import('../../pages/users/roles/[id]/edit.vue').then(r => r.default || r) 
    },
    { 
      path: 'organization-:id', 
      component: () => import('../../pages/users/organizations/[id]/edit.vue').then(r => r.default || r) 
    },
  ],
  view: [
    { 
      path: 'user-:id', 
      component: () => import('../../pages/users/users/[id]/view.vue').then(r => r.default || r) 
    },
    { 
      path: 'lead-:id', 
      component: () => import('../../pages/users/leads/[id]/view.vue').then(r => r.default || r) 
    },
    { 
      path: 'external-user-:id', 
      component: () => import('../../pages/users/external-users/[id]/view.vue').then(r => r.default || r) 
    },
    { 
      path: 'role-:id', 
      component: () => import('../../pages/users/roles/[id]/view.vue').then(r => r.default || r) 
    },
    { 
      path: 'organization-:id', 
      component: () => import('../../pages/users/organizations/[id]/view.vue').then(r => r.default || r) 
    },
  ],
  duplicate: [
    { 
      path: 'user-:id', 
      component: () => import('../../pages/users/users/[id]/duplicate.vue').then(r => r.default || r) 
    },
    { 
      path: 'lead-:id', 
      component: () => import('../../pages/users/leads/[id]/duplicate.vue').then(r => r.default || r) 
    },
    { 
      path: 'external-user-:id', 
      component: () => import('../../pages/users/external-users/[id]/duplicate.vue').then(r => r.default || r) 
    },
    { 
      path: 'role-:id', 
      component: () => import('../../pages/users/roles/[id]/duplicate.vue').then(r => r.default || r) 
    },
    { 
      path: 'organization-:id', 
      component: () => import('../../pages/users/organizations/[id]/duplicate.vue').then(r => r.default || r) 
    },
  ]
}