/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.jaxrs.provider.xmlbeans;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.jaxrs.provider.xmlbeans.XMLBeanStreamSerializer;
import org.apache.cxf.jaxrs.provider.xmlbeans.XMLBeansElementProvider;
import org.apache.xmlbeans.XmlObject;
import org.codehaus.jettison.mapped.Configuration;
import org.codehaus.jettison.mapped.MappedXMLOutputFactory;
import org.idempiere.jettison.mapped.CustomMappedNamespaceConvention;
import org.idempiere.jettison.mapped.MappedXMLInputFactory;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Provider
public class XMLBeansJSONProvider
extends XMLBeansElementProvider {
    private static final String AD_INTERFACE_1_0_NAMESPACE = "http://idempiere.org/ADInterface/1_0";

    public XmlObject readFrom(Class<XmlObject> type, Type genericType, Annotation[] annotations, MediaType m, MultivaluedMap<String, String> headers, InputStream is) throws IOException {
        XmlObject result = null;
        try {
            HashMap<String, String> nstojns = new HashMap<String, String>();
            nstojns.put(AD_INTERFACE_1_0_NAMESPACE, "");
            Configuration conf = new Configuration(nstojns);
            conf.setIgnoreNamespaces(false);
            CustomMappedNamespaceConvention convention = new CustomMappedNamespaceConvention(conf);
            convention.addNamespacePrefix("i", AD_INTERFACE_1_0_NAMESPACE);
            MappedXMLInputFactory factory = new MappedXMLInputFactory(convention);
            XMLStreamReader xsr = factory.createXMLStreamReader(is);
            result = this.parseXmlBean(type, xsr);
            xsr.close();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebApplicationException(500);
        }
        return result;
    }

    protected XmlObject parseXmlBean(Class<?> type, XMLStreamReader xsr) {
        XmlObject result = null;
        Field factory = this.getFactory(type);
        try {
            Method m = factory.getType().getMethod("parse", XMLStreamReader.class);
            Object[] args = new Object[]{xsr};
            Object obj = m.invoke(factory.get(type), args);
            if (obj instanceof XmlObject) {
                result = (XmlObject)obj;
            }
        }
        catch (NoSuchMethodException nsme) {
            nsme.printStackTrace();
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        return result;
    }

    private Field getFactory(Class<?> type) {
        Field factory = null;
        try {
            factory = type.getDeclaredField("Factory");
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        return factory;
    }

    public void writeTo(XmlObject obj, Class<?> cls, Type genericType, Annotation[] annotations, MediaType m, MultivaluedMap<String, Object> headers, OutputStream os) {
        try {
            HashMap nstojns = new HashMap();
            Configuration conf = new Configuration(nstojns);
            conf.setIgnoreNamespaces(true);
            MappedXMLOutputFactory factory = new MappedXMLOutputFactory(conf);
            XMLStreamWriter xsw = factory.createXMLStreamWriter(os);
            xsw.writeStartDocument();
            if (obj instanceof XmlObject) {
                XmlObject xObj = obj;
                XMLBeanStreamSerializer ser = new XMLBeanStreamSerializer();
                ser.serialize(xObj, xsw);
            }
            xsw.flush();
            xsw.close();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new WebApplicationException(500);
        }
        catch (IOException iOException) {
            throw new WebApplicationException(500);
        }
    }
}

