/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.performance;

import java.math.BigDecimal;
import java.net.URL;
import java.sql.Timestamp;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.adempiere.base.Core;
import org.adempiere.base.DefaultPaymentExporterFactory;
import org.adempiere.base.IAddressValidationFactory;
import org.adempiere.base.IBankStatementLoaderFactory;
import org.adempiere.base.IBankStatementMatcherFactory;
import org.adempiere.base.IDisplayTypeFactory;
import org.adempiere.base.IPaymentExporterFactory;
import org.adempiere.base.IReplenishFactory;
import org.adempiere.base.IResourceFinder;
import org.adempiere.base.LookupFactoryHelper;
import org.adempiere.base.ServiceQuery;
import org.adempiere.model.IAddressValidation;
import org.adempiere.model.IShipmentProcessor;
import org.adempiere.model.ITaxProvider;
import org.adempiere.model.MShipperFacade;
import org.adempiere.model.ProductPriceValidator;
import org.assertj.core.api.Assertions;
import org.compiere.acct.Doc;
import org.compiere.acct.DocManager;
import org.compiere.db.AdempiereDatabase;
import org.compiere.db.Database;
import org.compiere.impexp.BankStatementLoaderInterface;
import org.compiere.impexp.BankStatementMatcherInterface;
import org.compiere.impexp.OFXFileBankStatementLoader;
import org.compiere.model.Callout;
import org.compiere.model.GridFieldVO;
import org.compiere.model.GridTabVO;
import org.compiere.model.GridWindowVO;
import org.compiere.model.IArchiveStore;
import org.compiere.model.IAttachmentStore;
import org.compiere.model.IImageStore;
import org.compiere.model.Lookup;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAddressValidation;
import org.compiere.model.MBPartner;
import org.compiere.model.MBankAccountProcessor;
import org.compiere.model.MClientInfo;
import org.compiere.model.MColumn;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MProduct;
import org.compiere.model.MRefTable;
import org.compiere.model.MShipper;
import org.compiere.model.MStorageProvider;
import org.compiere.model.MTable;
import org.compiere.model.MTaxProvider;
import org.compiere.model.MTest;
import org.compiere.model.MZoomCondition;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.model.PaymentProcessor;
import org.compiere.model.Query;
import org.compiere.model.StandardTaxProvider;
import org.compiere.model.X_C_AddressValidationCfg;
import org.compiere.model.X_C_TaxProviderCfg;
import org.compiere.print.MPrintFormat;
import org.compiere.process.BPartnerValidate;
import org.compiere.process.DocumentEngine;
import org.compiere.process.ProcessCall;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CCache;
import org.compiere.util.CacheInterface;
import org.compiere.util.CacheMgt;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.GenericPaymentExport;
import org.compiere.util.PaymentExport;
import org.compiere.util.ReplenishInterface;
import org.compiere.util.TimeUtil;
import org.compiere.wf.MWorkflow;
import org.eevolution.model.CalloutBOM;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.fa.service.api.DepreciationFactoryLookupDTO;
import org.idempiere.fa.service.api.IDepreciationMethod;
import org.idempiere.fa.service.api.IDepreciationMethodFactory;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.idempiere.test.TestActivator;
import org.idempiere.test.performance.FakeAddressValidationFactory;
import org.idempiere.test.performance.FakeBankStatementLoaderFactory;
import org.idempiere.test.performance.FakeBankStatementMatcherFactory;
import org.idempiere.test.performance.FakeDepreciationMethodFactory;
import org.idempiere.test.performance.FakeDisplayTypeFactory;
import org.idempiere.test.performance.FakeReplenishFactory;
import org.idempiere.test.performance.FakeResourceFinder;
import org.idempiere.test.performance.FakeScriptEngineFactory;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
public class CacheTest
extends AbstractTestCase {
    private static final int ORDER_HEADER_PRINT_FORMAT_ID = 118;
    private static final int SHIPMENT_HEADER_PRINT_FORMAT_ID = 122;

    @Test
    public void testZoomConditionCache() {
        MZoomCondition[] conditions1 = MZoomCondition.getConditions((int)259);
        org.junit.jupiter.api.Assertions.assertTrue((conditions1 != null && conditions1.length > 0 ? 1 : 0) != 0);
        MZoomCondition[] conditions2 = MZoomCondition.getConditions((int)259);
        org.junit.jupiter.api.Assertions.assertTrue((conditions2 != null && conditions2.length > 0 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((conditions1 == conditions2 ? 1 : 0) != 0);
        CacheMgt.get().reset();
        MZoomCondition[] conditions3 = MZoomCondition.getConditions((int)259);
        org.junit.jupiter.api.Assertions.assertTrue((conditions3 != null && conditions3.length == conditions1.length ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((conditions1 != conditions3 ? 1 : 0) != 0);
    }

    @Test
    public void testTableCache() {
        MTable table = MTable.get((Properties)Env.getCtx(), (int)259);
        CCache<?, ?> tblCache = this.findByTableNameAndKey("AD_Table", 259);
        if (tblCache == null) {
            org.junit.jupiter.api.Assertions.fail((String)"Table cache instance missing");
        }
        long hit = tblCache.getHit();
        MColumn column = table.getColumn("C_Order_ID");
        column.getAD_Table();
        org.junit.jupiter.api.Assertions.assertEquals((long)(hit + 1L), (long)tblCache.getHit());
        table = MTable.get((Properties)Env.getCtx(), (int)190);
        MRefTable refTable = MRefTable.get((Properties)Env.getCtx(), (int)197);
        tblCache = this.findByTableNameAndKey("AD_Table", 190);
        if (tblCache == null) {
            org.junit.jupiter.api.Assertions.fail((String)"Table cache instance missing");
        }
        hit = tblCache.getHit();
        refTable.getAD_Table();
        org.junit.jupiter.api.Assertions.assertEquals((long)(hit + 1L), (long)tblCache.getHit());
    }

    @Test
    public void testPOCacheAfterUpdate() throws InterruptedException {
        int mulch = 137;
        int oak = 123;
        MProduct p1 = MProduct.get((Properties)Env.getCtx(), (int)mulch);
        CCache<?, ?> pc = this.findByTableNameAndKey("M_Product", mulch);
        if (pc == null) {
            org.junit.jupiter.api.Assertions.fail((String)"Product cache instance missing");
        }
        long hit = pc.getHit();
        p1 = MProduct.get((Properties)Env.getCtx(), (int)mulch);
        org.junit.jupiter.api.Assertions.assertEquals((int)mulch, (int)p1.getM_Product_ID());
        org.junit.jupiter.api.Assertions.assertTrue((pc.getHit() > hit ? 1 : 0) != 0, (String)"Second get of product Mulch, cache hit should increase");
        long miss = pc.getMiss();
        MProduct p2 = MProduct.get((Properties)Env.getCtx(), (int)oak);
        org.junit.jupiter.api.Assertions.assertEquals((int)oak, (int)p2.getM_Product_ID());
        org.junit.jupiter.api.Assertions.assertTrue((pc.getMiss() > miss ? 1 : 0) != 0, (String)"First get of product Oak, cache miss should increase");
        hit = pc.getHit();
        p2 = MProduct.get((Properties)Env.getCtx(), (int)oak);
        org.junit.jupiter.api.Assertions.assertEquals((int)oak, (int)p2.getM_Product_ID());
        org.junit.jupiter.api.Assertions.assertTrue((pc.getHit() > hit ? 1 : 0) != 0, (String)"Second get of product Oak, cache hit should increase");
        String oakDescription = p2.getDescription();
        p2 = new MProduct(Env.getCtx(), p2, this.getTrxName());
        p2.setDescription("Test Update @ " + System.currentTimeMillis());
        p2.saveEx();
        this.commit();
        Thread.sleep(500L);
        miss = pc.getMiss();
        p2 = MProduct.get((Properties)Env.getCtx(), (int)oak);
        org.junit.jupiter.api.Assertions.assertEquals((int)oak, (int)p2.getM_Product_ID());
        org.junit.jupiter.api.Assertions.assertTrue((pc.getMiss() > miss ? 1 : 0) != 0, (String)("Get of product Oak after update of product Oak, cache miss should increase. before=" + miss + " after=" + pc.getMiss()));
        hit = pc.getHit();
        p1 = MProduct.get((Properties)Env.getCtx(), (int)mulch);
        org.junit.jupiter.api.Assertions.assertEquals((int)mulch, (int)p1.getM_Product_ID());
        org.junit.jupiter.api.Assertions.assertTrue((pc.getHit() > hit ? 1 : 0) != 0, (String)("Get of product Mulch after update of product Oak, cache hit should increase. before=" + hit + " after=" + pc.getHit()));
        MProduct p3 = new MProduct(Env.getCtx(), 0, this.getTrxName());
        String name = "Test@" + System.currentTimeMillis();
        p3.setValue(name);
        p3.setName(name);
        p3.setM_Product_Category_ID(p1.getM_Product_Category_ID());
        p3.setC_UOM_ID(p1.getC_UOM_ID());
        p3.setC_TaxCategory_ID(p1.getC_TaxCategory_ID());
        p3.saveEx();
        p3.deleteEx(true);
        this.commit();
        hit = pc.getHit();
        p2 = MProduct.get((Properties)Env.getCtx(), (int)oak);
        org.junit.jupiter.api.Assertions.assertEquals((int)oak, (int)p2.getM_Product_ID());
        org.junit.jupiter.api.Assertions.assertTrue((pc.getHit() > hit ? 1 : 0) != 0, (String)"Get of product Oak after delete of product Mulch, cache hit should increase");
        CacheMgt.get().reset();
        p2 = new MProduct(Env.getCtx(), p2, this.getTrxName());
        p2.setDescription("Test1@" + System.currentTimeMillis());
        p2.saveEx();
        this.rollback();
        p2 = new MProduct(Env.getCtx(), oak, null);
        p2.setDescription(oakDescription);
        p2.saveEx();
    }

    @Test
    public void testServices() {
        GridTabVO gridTabVO;
        Optional<GridFieldVO> optional1;
        TestActivator.context.registerService(IResourceFinder.class, (Object)new FakeResourceFinder(), null);
        IResourceFinder resourceFinder = Core.getResourceFinder();
        org.junit.jupiter.api.Assertions.assertNotNull((Object)resourceFinder, (String)"Can't find resource finder service");
        Object cacheKey = FakeResourceFinder.class.getName();
        URL url = Core.getResourceFinder().getResource((String)cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)url);
        String cacheName = "IResourceFinder";
        CCache<?, ?> cache = this.findByNameAndKey(cacheName, cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull(cache, (String)("Can't find cache for " + cacheName));
        long hit = cache.getHit();
        url = Core.getResourceFinder().getResource((String)cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)url);
        org.junit.jupiter.api.Assertions.assertTrue((cache.getHit() > hit ? 1 : 0) != 0, (String)("Hit for " + cacheName + " doesn't increase as expected"));
        List callouts = Core.findCallout((String)"M_InventoryLine", (String)"M_Product_ID");
        org.junit.jupiter.api.Assertions.assertTrue((callouts.size() > 0 ? 1 : 0) != 0, (String)"Can't find callouts for M_InventoryLine, M_Product_ID");
        cacheKey = "M_InventoryLine.M_Product_ID";
        cacheName = "List<IColumnCalloutFactory>";
        cache = this.findByNameAndKey(cacheName, cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull(cache, (String)("Can't find cache for " + cacheName));
        hit = cache.getHit();
        callouts = Core.findCallout((String)"M_InventoryLine", (String)"M_Product_ID");
        org.junit.jupiter.api.Assertions.assertTrue((callouts.size() > 0 ? 1 : 0) != 0, (String)"Can't find callouts for M_InventoryLine, M_Product_ID");
        org.junit.jupiter.api.Assertions.assertTrue((cache.getHit() > hit ? 1 : 0) != 0, (String)("Hit for " + cacheName + " doesn't increase as expected"));
        cacheKey = CalloutBOM.class.getName() + "::parent";
        Callout callout = Core.getCallout((String)CalloutBOM.class.getName(), (String)"parent");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)callout, (String)("Can't find callout for " + (String)cacheKey));
        cacheName = "ICalloutFactory";
        cache = this.findByNameAndKey(cacheName, cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull(cache, (String)("Can't find cache for " + cacheName));
        hit = cache.getHit();
        callout = Core.getCallout((String)CalloutBOM.class.getName(), (String)"parent");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)callout, (String)("Can't find callout for " + (String)cacheKey));
        org.junit.jupiter.api.Assertions.assertTrue((cache.getHit() > hit ? 1 : 0) != 0, (String)("Hit for " + cacheName + " doesn't increase as expected"));
        cacheKey = BPartnerValidate.class.getName();
        ProcessCall process = Core.getProcess((String)cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)process, (String)("Can't find process for " + (String)cacheKey));
        cacheName = "IProcessFactory";
        cache = this.findByNameAndKey(cacheName, cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull(cache, (String)("Can't find cache for " + cacheName));
        hit = cache.getHit();
        process = Core.getProcess((String)cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)process, (String)("Can't find process for " + (String)cacheKey));
        org.junit.jupiter.api.Assertions.assertTrue((cache.getHit() > hit ? 1 : 0) != 0, (String)("Hit for " + cacheName + " doesn't increase as expected"));
        cacheKey = ProductPriceValidator.class.getName();
        ModelValidator modelValidator = Core.getModelValidator((String)cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)modelValidator, (String)("Can't find model validator for " + (String)cacheKey));
        cacheName = "IModelValidatorFactory";
        cache = this.findByNameAndKey(cacheName, cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull(cache, (String)("Can't find cache for " + cacheName));
        hit = cache.getHit();
        modelValidator = Core.getModelValidator((String)cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)modelValidator, (String)("Can't find model validator for " + (String)cacheKey));
        org.junit.jupiter.api.Assertions.assertTrue((cache.getHit() > hit ? 1 : 0) != 0, (String)("Hit for " + cacheName + " doesn't increase as expected"));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)Core.getKeyStore(), (String)"Can't find key store service");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)Core.getKeyStore(), (String)"Can't find key store service");
        int pp_payflowpro_id = 100;
        MBankAccountProcessor bankAccountProcessor = MBankAccountProcessor.get((Properties)Env.getCtx(), (int)pp_payflowpro_id, (int)pp_payflowpro_id, (String)this.getTrxName());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)bankAccountProcessor, (String)"Can't load bank account processor for PP_PayFlowPro");
        PaymentProcessor paymentProcessor = Core.getPaymentProcessor((MBankAccountProcessor)bankAccountProcessor, null);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)paymentProcessor, (String)"Can't load payment processor for PP_PayFlowPro");
        cacheKey = "org.compiere.model.PP_PayFlowPro";
        cacheName = "IPaymentProcessorFactory";
        cache = this.findByNameAndKey(cacheName, cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull(cache, (String)("Can't find cache for " + cacheName));
        hit = cache.getHit();
        paymentProcessor = Core.getPaymentProcessor((MBankAccountProcessor)bankAccountProcessor, null);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)paymentProcessor, (String)"Can't load payment processor for PP_PayFlowPro");
        org.junit.jupiter.api.Assertions.assertTrue((cache.getHit() > hit ? 1 : 0) != 0, (String)("Hit for " + cacheName + " doesn't increase as expected"));
        TestActivator.context.registerService(IBankStatementLoaderFactory.class, (Object)new FakeBankStatementLoaderFactory(), null);
        cacheKey = OFXFileBankStatementLoader.class.getName();
        BankStatementLoaderInterface bankStatementLoader = Core.getBankStatementLoader((String)cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)bankStatementLoader, (String)("Can't find BankStatementLoader for " + (String)cacheKey));
        cacheName = "IBankStatementLoaderFactory";
        cache = this.findByNameAndKey(cacheName, cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull(cache, (String)("Can't find cache for " + cacheName));
        hit = cache.getHit();
        bankStatementLoader = Core.getBankStatementLoader((String)cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)bankStatementLoader, (String)("Can't find BankStatementLoader for " + (String)cacheKey));
        org.junit.jupiter.api.Assertions.assertTrue((cache.getHit() > hit ? 1 : 0) != 0, (String)("Hit for " + cacheName + " doesn't increase as expected"));
        TestActivator.context.registerService(IBankStatementMatcherFactory.class, (Object)new FakeBankStatementMatcherFactory(), null);
        cacheKey = FakeBankStatementMatcherFactory.class.getName();
        BankStatementMatcherInterface bankStatementMatcher = Core.getBankStatementMatcher((String)cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)bankStatementMatcher, (String)"Can't find bank statement matcher service");
        cacheName = "IBankStatementMatcherFactory";
        cache = this.findByNameAndKey(cacheName, cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull(cache, (String)("Can't find cache for " + cacheName));
        hit = cache.getHit();
        bankStatementMatcher = Core.getBankStatementMatcher((String)cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)bankStatementMatcher, (String)"Can't find bank statement matcher service");
        org.junit.jupiter.api.Assertions.assertTrue((cache.getHit() > hit ? 1 : 0) != 0, (String)("Hit for " + cacheName + " doesn't increase as expected"));
        int m_shipper_id = 100;
        MShipperFacade shipperFacade = new MShipperFacade(new MShipper(Env.getCtx(), m_shipper_id, this.getTrxName()));
        cacheKey = shipperFacade.getShippingProcessorClass();
        cacheName = "IShipmentProcessorFactory";
        IShipmentProcessor shipmentProcessor = Core.getShipmentProcessor((MShipperFacade)shipperFacade);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)shipmentProcessor, (String)"Can't find shipment processor");
        cache = this.findByNameAndKey(cacheName, cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull(cache, (String)("Can't find cache for " + cacheName));
        hit = cache.getHit();
        shipmentProcessor = Core.getShipmentProcessor((MShipperFacade)shipperFacade);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)shipmentProcessor, (String)"Can't find shipment processor");
        org.junit.jupiter.api.Assertions.assertTrue((cache.getHit() > hit ? 1 : 0) != 0, (String)("Hit for " + cacheName + " doesn't increase as expected"));
        X_C_AddressValidationCfg cfg = new X_C_AddressValidationCfg(Env.getCtx(), 0, this.getTrxName());
        cfg.setHostAddress("10.8.0.1");
        cfg.setHostPort(433);
        cfg.setName("Test Cfg");
        cacheKey = FakeAddressValidationFactory.class.getName();
        cfg.setAddressValidationClass((String)cacheKey);
        cfg.saveEx();
        MAddressValidation addressValidation = new MAddressValidation(Env.getCtx(), 0, this.getTrxName());
        addressValidation.setC_AddressValidationCfg_ID(cfg.get_ID());
        addressValidation.setConnectionPassword("password");
        addressValidation.setName("Test Address Validation");
        addressValidation.setUserID("userid");
        addressValidation.setSeqNo(10);
        addressValidation.saveEx();
        TestActivator.context.registerService(IAddressValidationFactory.class, (Object)new FakeAddressValidationFactory(), null);
        IAddressValidation addressValidationService = Core.getAddressValidation((MAddressValidation)addressValidation);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)addressValidationService, (String)"Can't find address validation service");
        cacheName = "IAddressValidationFactory";
        cache = this.findByNameAndKey(cacheName, cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull(cache, (String)("Can't find cache for " + cacheName));
        hit = cache.getHit();
        addressValidationService = Core.getAddressValidation((MAddressValidation)addressValidation);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)addressValidationService, (String)"Can't find address validation service");
        org.junit.jupiter.api.Assertions.assertTrue((cache.getHit() > hit ? 1 : 0) != 0, (String)("Hit for " + cacheName + " doesn't increase as expected"));
        X_C_TaxProviderCfg taxProviderCfg = new X_C_TaxProviderCfg(Env.getCtx(), 0, this.getTrxName());
        taxProviderCfg.setName("Standard Provider Configuration");
        taxProviderCfg.setTaxProviderClass(StandardTaxProvider.class.getName());
        taxProviderCfg.saveEx();
        MTaxProvider taxProvider = new MTaxProvider(Env.getCtx(), 0, this.getTrxName());
        taxProvider.setC_TaxProviderCfg_ID(taxProviderCfg.get_ID());
        taxProvider.setName("Standard Provider");
        taxProvider.saveEx();
        ITaxProvider taxProviderService = Core.getTaxProvider((MTaxProvider)taxProvider);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)taxProviderService, (String)"Can't find tax provider service");
        cacheKey = StandardTaxProvider.class.getName();
        cacheName = "ITaxProviderFactory";
        cache = this.findByNameAndKey(cacheName, cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull(cache, (String)("Can't find cache for " + cacheName));
        hit = cache.getHit();
        taxProviderService = Core.getTaxProvider((MTaxProvider)taxProvider);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)taxProviderService, (String)"Can't find tax provider service");
        org.junit.jupiter.api.Assertions.assertTrue((cache.getHit() > hit ? 1 : 0) != 0, (String)("Hit for " + cacheName + " doesn't increase as expected"));
        TestActivator.context.registerService(IReplenishFactory.class, (Object)new FakeReplenishFactory(), null);
        cacheKey = FakeReplenishFactory.class.getName();
        ReplenishInterface replenishService = Core.getReplenish((String)cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)replenishService, (String)"Can't find replenish service");
        cacheName = "IReplenishFactory";
        cache = this.findByNameAndKey(cacheName, cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull(cache, (String)("Can't find cache for " + cacheName));
        hit = cache.getHit();
        replenishService = Core.getReplenish((String)cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)replenishService, (String)"Can't find replenish service");
        org.junit.jupiter.api.Assertions.assertTrue((cache.getHit() > hit ? 1 : 0) != 0, (String)("Hit for " + cacheName + " doesn't increase as expected"));
        TestActivator.context.registerService(ScriptEngineFactory.class, (Object)new FakeScriptEngineFactory(), null);
        cacheKey = FakeScriptEngineFactory.class.getName();
        ScriptEngine scriptEngine = Core.getScriptEngine((String)cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)scriptEngine, (String)"Can't find script engine service");
        cacheName = "ScriptEngineFactory";
        cache = this.findByNameAndKey(cacheName, cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull(cache, (String)("Can't find cache for " + cacheName));
        hit = cache.getHit();
        scriptEngine = Core.getScriptEngine((String)cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)scriptEngine, (String)"Can't find script engine service");
        org.junit.jupiter.api.Assertions.assertTrue((cache.getHit() > hit ? 1 : 0) != 0, (String)("Hit for " + cacheName + " doesn't increase as expected"));
        TestActivator.context.registerService(IPaymentExporterFactory.class, (Object)new DefaultPaymentExporterFactory(), null);
        cacheKey = GenericPaymentExport.class.getName();
        PaymentExport paymentExportService = Core.getPaymentExporter((String)cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)paymentExportService, (String)"Can't find payment exporter service");
        cacheName = "IPaymentExporterFactory";
        cache = this.findByNameAndKey(cacheName, cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull(cache, (String)("Can't find cache for " + cacheName));
        hit = cache.getHit();
        paymentExportService = Core.getPaymentExporter((String)cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)paymentExportService, (String)"Can't find payment exporter service");
        org.junit.jupiter.api.Assertions.assertTrue((cache.getHit() > hit ? 1 : 0) != 0, (String)("Hit for " + cacheName + " doesn't increase as expected"));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)Core.getProductPricing(), (String)"Can't find product pricing service");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)Core.getProductPricing(), (String)"Can't find product pricing service");
        TestActivator.context.registerService(IDepreciationMethodFactory.class, (Object)new FakeDepreciationMethodFactory(), null);
        cacheKey = FakeDepreciationMethodFactory.class.getName();
        DepreciationFactoryLookupDTO dto = new DepreciationFactoryLookupDTO();
        dto.depreciationType = cacheKey;
        IDepreciationMethod depreciationMethod = Core.getDepreciationMethod((DepreciationFactoryLookupDTO)dto);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)depreciationMethod, (String)"Can't find depreciation method service");
        cacheName = "IDepreciationMethodFactory";
        cache = this.findByNameAndKey(cacheName, cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull(cache, (String)("Can't find cache for " + cacheName));
        hit = cache.getHit();
        depreciationMethod = Core.getDepreciationMethod((DepreciationFactoryLookupDTO)dto);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)depreciationMethod, (String)"Can't find depreciation method service");
        org.junit.jupiter.api.Assertions.assertTrue((cache.getHit() > hit ? 1 : 0) != 0, (String)("Hit for " + cacheName + " doesn't increase as expected"));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)Core.getMessageService(), (String)"Can't find message service");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)Core.getMessageService(), (String)"Can't find message service");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)Core.getClusterService(), (String)"Can't find cluster service");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)Core.getClusterService(), (String)"Can't find cluster service");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)Core.getCacheService(), (String)"Can't find cache service");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)Core.getCacheService(), (String)"Can't find cache service");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)Core.getDictionaryService(), (String)"Can't find dictionary service");
        org.junit.jupiter.api.Assertions.assertNotNull((Object)Core.getDictionaryService(), (String)"Can't find dictionary service");
        int ad_window_id = 143;
        int ad_tab_id = 187;
        int ad_field_id = 1127;
        GridFieldVO gridField = null;
        Lookup lookup = null;
        GridWindowVO gridWindow = GridWindowVO.create((int)1, (int)ad_window_id);
        Optional<GridTabVO> optional = gridWindow.Tabs.stream().filter(e -> e.AD_Tab_ID == ad_tab_id).findFirst();
        if (optional.isPresent() && (optional1 = (gridTabVO = optional.get()).getFields().stream().filter(e -> e.AD_Field_ID == ad_field_id).findFirst()).isPresent()) {
            gridField = optional1.get();
        }
        org.junit.jupiter.api.Assertions.assertNotNull(gridField, (String)"Can't find grid field");
        lookup = LookupFactoryHelper.getLookup(gridField);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)lookup, (String)"Can't find lookup service");
        cacheName = "ILookupFactory";
        cacheKey = null;
        cache = this.findByNameAndKey(cacheName, cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull(cache, (String)("Can't find cache for " + cacheName));
        hit = cache.getHit();
        lookup = LookupFactoryHelper.getLookup((GridFieldVO)gridField);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)lookup, (String)"Can't find lookup service");
        org.junit.jupiter.api.Assertions.assertTrue((cache.getHit() > hit ? 1 : 0) != 0, (String)("Hit for " + cacheName + " doesn't increase as expected"));
        hit = cache.getHit();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)LookupFactoryHelper.isLookup((GridFieldVO)gridField), (String)("Lookup should be true for " + gridField.toString()));
        org.junit.jupiter.api.Assertions.assertTrue((cache.getHit() > hit ? 1 : 0) != 0, (String)("Hit for " + cacheName + " doesn't increase as expected"));
        int C_AcctSchema_ID = MClientInfo.get().getC_AcctSchema1_ID();
        cacheKey = C_AcctSchema_ID + "|318";
        cacheName = "IDocFactory";
        MInvoice invoice = new MInvoice(Env.getCtx(), 0, this.getTrxName());
        invoice.setBPartner(MBPartner.get((Properties)Env.getCtx(), (int)117));
        invoice.setC_DocTypeTarget_ID("ARI");
        invoice.setC_DocType_ID(invoice.getC_DocTypeTarget_ID());
        invoice.setPaymentRule("S");
        invoice.setC_PaymentTerm_ID(105);
        Timestamp today = TimeUtil.getDay((long)System.currentTimeMillis());
        invoice.setDateInvoiced(today);
        invoice.setDateAcct(today);
        invoice.setDocStatus("DR");
        invoice.setDocAction("CO");
        invoice.saveEx();
        MInvoiceLine line1 = new MInvoiceLine(invoice);
        line1.setLine(10);
        line1.setC_Charge_ID(100);
        line1.setQty(new BigDecimal("1"));
        line1.setPrice(Env.ONEHUNDRED);
        line1.saveEx();
        ProcessInfo info = MWorkflow.runDocumentActionWorkflow((PO)invoice, (String)"CO");
        invoice.load(this.getTrxName(), new String[0]);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)info.isError(), (String)info.getSummary());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"CO", (Object)invoice.getDocStatus());
        if (!invoice.isPosted()) {
            String error = DocumentEngine.postImmediate((Properties)Env.getCtx(), (int)invoice.getAD_Client_ID(), (int)318, (int)invoice.get_ID(), (boolean)true, (String)this.getTrxName());
            org.junit.jupiter.api.Assertions.assertNull((Object)error, (String)("Error posting invoice: " + error));
        }
        MAcctSchema as = MAcctSchema.get((int)C_AcctSchema_ID);
        Doc doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)invoice.get_ID(), (String)this.getTrxName());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)doc, (String)"Failed load acct doc for invoice");
        cache = this.findByNameAndKey(cacheName, cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull(cache, (String)("Can't find cache for " + cacheName));
        hit = cache.getHit();
        doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)invoice.get_ID(), (String)this.getTrxName());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)doc, (String)"Failed load acct doc for invoice");
        org.junit.jupiter.api.Assertions.assertTrue((cache.getHit() > hit ? 1 : 0) != 0, (String)("Hit for " + cacheName + " doesn't increase as expected"));
        AdempiereDatabase db = Database.getDatabase((String)Database.DB_POSTGRESQL);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)db, (String)("Failed to load db service for " + Database.DB_POSTGRESQL));
        cacheKey = Database.DB_POSTGRESQL;
        cacheName = "IDatabase";
        cache = this.findByNameAndKey(cacheName, cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull(cache, (String)("Can't find cache for " + cacheName));
        hit = cache.getHit();
        db = Database.getDatabase((String)Database.DB_POSTGRESQL);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)db, (String)("Failed to load db service for " + Database.DB_POSTGRESQL));
        org.junit.jupiter.api.Assertions.assertTrue((cache.getHit() > hit ? 1 : 0) != 0, (String)("Hit for " + cacheName + " doesn't increase as expected"));
        ServiceQuery dbServiceQuery = new ServiceQuery();
        dbServiceQuery.put((Object)"method", (Object)"DB");
        IArchiveStore archiveStoreService = MStorageProvider.getArchiveStoreService((ServiceQuery)dbServiceQuery);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)archiveStoreService, (String)"Can't find archive store service");
        cacheName = "IArchiveStore";
        cache = this.findByNameAndKey(cacheName, dbServiceQuery);
        org.junit.jupiter.api.Assertions.assertNotNull(cache, (String)("Can't find cache for " + cacheName));
        hit = cache.getHit();
        archiveStoreService = MStorageProvider.getArchiveStoreService((ServiceQuery)dbServiceQuery);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)archiveStoreService, (String)"Can't find archive store service");
        org.junit.jupiter.api.Assertions.assertTrue((cache.getHit() > hit ? 1 : 0) != 0, (String)("Hit for " + cacheName + " doesn't increase as expected"));
        ServiceQuery fileSystemServiceQuery = new ServiceQuery();
        fileSystemServiceQuery.put((Object)"method", (Object)"FileSystem");
        archiveStoreService = MStorageProvider.getArchiveStoreService((ServiceQuery)fileSystemServiceQuery);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)archiveStoreService, (String)"Can't find archive store service");
        hit = cache.getHit();
        archiveStoreService = MStorageProvider.getArchiveStoreService((ServiceQuery)fileSystemServiceQuery);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)archiveStoreService, (String)"Can't find archive store service");
        org.junit.jupiter.api.Assertions.assertTrue((cache.getHit() > hit ? 1 : 0) != 0, (String)("Hit for " + cacheName + " doesn't increase as expected"));
        org.junit.jupiter.api.Assertions.assertTrue((cache.size() == 2 ? 1 : 0) != 0, (String)("Size for " + cacheName + " != 2"));
        IAttachmentStore attachmentStoreService = MStorageProvider.getAttachmentStoreService((ServiceQuery)dbServiceQuery);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)attachmentStoreService, (String)"Can't find attachment store service");
        cacheName = "IAttachmentStore";
        cache = this.findByNameAndKey(cacheName, dbServiceQuery);
        org.junit.jupiter.api.Assertions.assertNotNull(cache, (String)("Can't find cache for " + cacheName));
        hit = cache.getHit();
        attachmentStoreService = MStorageProvider.getAttachmentStoreService((ServiceQuery)dbServiceQuery);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)attachmentStoreService, (String)"Can't find attachment store service");
        org.junit.jupiter.api.Assertions.assertTrue((cache.getHit() > hit ? 1 : 0) != 0, (String)("Hit for " + cacheName + " doesn't increase as expected"));
        attachmentStoreService = MStorageProvider.getAttachmentStoreService((ServiceQuery)fileSystemServiceQuery);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)attachmentStoreService, (String)"Can't find attachment store service");
        hit = cache.getHit();
        attachmentStoreService = MStorageProvider.getAttachmentStoreService((ServiceQuery)fileSystemServiceQuery);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)attachmentStoreService, (String)"Can't find attachment store service");
        org.junit.jupiter.api.Assertions.assertTrue((cache.getHit() > hit ? 1 : 0) != 0, (String)("Hit for " + cacheName + " doesn't increase as expected"));
        org.junit.jupiter.api.Assertions.assertTrue((cache.size() == 2 ? 1 : 0) != 0, (String)("Size for " + cacheName + " != 2"));
        IImageStore imagetStoreService = MStorageProvider.getImageStoreService((ServiceQuery)dbServiceQuery);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)imagetStoreService, (String)"Can't find image store service");
        cacheName = "IImageStore";
        cache = this.findByNameAndKey(cacheName, dbServiceQuery);
        org.junit.jupiter.api.Assertions.assertNotNull(cache, (String)("Can't find cache for " + cacheName));
        hit = cache.getHit();
        imagetStoreService = MStorageProvider.getImageStoreService((ServiceQuery)dbServiceQuery);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)imagetStoreService, (String)"Can't find image store service");
        org.junit.jupiter.api.Assertions.assertTrue((cache.getHit() > hit ? 1 : 0) != 0, (String)("Hit for " + cacheName + " doesn't increase as expected"));
        imagetStoreService = MStorageProvider.getImageStoreService((ServiceQuery)fileSystemServiceQuery);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)imagetStoreService, (String)"Can't find image store service");
        hit = cache.getHit();
        imagetStoreService = MStorageProvider.getImageStoreService((ServiceQuery)fileSystemServiceQuery);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)imagetStoreService, (String)"Can't find image store service");
        org.junit.jupiter.api.Assertions.assertTrue((cache.getHit() > hit ? 1 : 0) != 0, (String)("Hit for " + cacheName + " doesn't increase as expected"));
        org.junit.jupiter.api.Assertions.assertTrue((cache.size() == 2 ? 1 : 0) != 0, (String)("Size for " + cacheName + " != 2"));
        cacheName = "IModelFactory";
        cacheKey = "C_Invoice";
        Class modelClass = MTable.getClass((String)cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)modelClass, (String)("Can't find model class for " + (String)cacheKey));
        cache = this.findByNameAndKey(cacheName, cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull(cache, (String)("Can't find cache for " + cacheName));
        hit = cache.getHit();
        modelClass = MTable.getClass((String)cacheKey);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)modelClass, (String)("Can't find model class for " + (String)cacheKey));
        org.junit.jupiter.api.Assertions.assertTrue((cache.getHit() > hit ? 1 : 0) != 0, (String)("Hit for " + cacheName + " doesn't increase as expected"));
        TestActivator.context.registerService(IDisplayTypeFactory.class, (Object)new FakeDisplayTypeFactory(), null);
        cacheName = "IDisplayTypeFactory";
        boolean isLOB = DisplayType.isLOB((int)9876543);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)isLOB);
        boolean isText = DisplayType.isText((int)9876543);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)isText);
        cache = this.findByNameAndKey(cacheName, 9876543);
        org.junit.jupiter.api.Assertions.assertNotNull(cache, (String)("Can't find cache for " + cacheName));
        hit = cache.getHit();
        isText = DisplayType.isText((int)9876543);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)isText);
        org.junit.jupiter.api.Assertions.assertTrue((cache.getHit() > hit ? 1 : 0) != 0, (String)("Hit for " + cacheName + " doesn't increase as expected"));
    }

    private CCache<?, ?> findByTableNameAndKey(String tableName, Object key) {
        CacheInterface[] cis;
        CacheInterface[] cacheInterfaceArray = cis = CacheMgt.get().getInstancesAsArray();
        int n = cis.length;
        int n2 = 0;
        while (n2 < n) {
            CCache ccache;
            CacheInterface ci = cacheInterfaceArray[n2];
            if (ci instanceof CCache && (ccache = (CCache)ci).getName().equals(ccache.getTableName()) && ccache.getTableName().equals(tableName) && ccache.containsKey(key)) {
                return ccache;
            }
            ++n2;
        }
        return null;
    }

    private CCache<?, ?> findByNameAndKey(String name, Object key) {
        CacheInterface[] cis;
        CacheInterface[] cacheInterfaceArray = cis = CacheMgt.get().getInstancesAsArray();
        int n = cis.length;
        int n2 = 0;
        while (n2 < n) {
            CCache ccache;
            CacheInterface ci = cacheInterfaceArray[n2];
            if (ci instanceof CCache && (ccache = (CCache)ci).getName().equals(name)) {
                if (key != null) {
                    if (ccache.containsKey(key)) {
                        return ccache;
                    }
                } else {
                    return ccache;
                }
            }
            ++n2;
        }
        return null;
    }

    @Test
    public void testPrintFormatCacheReset() {
        MPrintFormat cache = MPrintFormat.get((int)118);
        String description = cache.getDescription();
        MPrintFormat cache1 = MPrintFormat.get((int)122);
        MPrintFormat update = new MPrintFormat(Env.getCtx(), cache.get_ID(), null);
        try {
            update.setDescription(update.getAD_PrintFormat_UU());
            update.saveEx();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
            cache = MPrintFormat.get((int)118);
            org.junit.jupiter.api.Assertions.assertEquals((Object)update.getDescription(), (Object)cache.getDescription(), (String)"Expected cache reset doesn't happens");
            cache = MPrintFormat.get((int)122);
            org.junit.jupiter.api.Assertions.assertTrue((cache == cache1 ? 1 : 0) != 0, (String)"Unexpected cache reset for print format record that's not being updated");
        }
        finally {
            update.load(null, new String[0]);
            update.setDescription(description);
            update.saveEx();
        }
    }

    @Test
    public void testSuspendCacheReset() {
        MTest test1 = new MTest(Env.getCtx(), 0, this.getTrxName());
        MTest test2 = new MTest(Env.getCtx(), 0, this.getTrxName());
        MTest test3 = new MTest(Env.getCtx(), 0, this.getTrxName());
        try {
            MTestCache cache = new MTestCache("Test", 10);
            test1.setName("test1");
            test1.saveEx();
            test2.setName("test2");
            test2.saveEx();
            test3.setName("test3");
            test3.saveEx();
            cache.put(test1.get_ID(), test1);
            cache.put(test2.get_ID(), test2);
            cache.put(test3.get_ID(), test3);
            cache.clearResetCount();
            this.commit();
            this.getTrx().start();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
            org.junit.jupiter.api.Assertions.assertTrue((cache.getResetCount() > 0 ? 1 : 0) != 0, (String)"Cache reset count is zero");
            test1.setName("test1.1");
            test1.saveEx();
            test2.setName("test2.1");
            test2.saveEx();
            test3.setName("test3.1");
            test3.saveEx();
            cache.put(test1.get_ID(), test1);
            cache.put(test2.get_ID(), test2);
            cache.put(test3.get_ID(), test3);
            cache.clearResetCount();
            this.commit();
            this.getTrx().start();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
            org.junit.jupiter.api.Assertions.assertTrue((cache.getResetCount() > 0 ? 1 : 0) != 0, (String)"Cache reset count is zero");
            CacheMgt.get().suspendTableCacheReset("Test");
            test1.setName("test1.2");
            test1.saveEx();
            test2.setName("test2.2");
            test2.saveEx();
            test3.setName("test3.2");
            test3.saveEx();
            cache.put(test1.get_ID(), test1);
            cache.put(test2.get_ID(), test2);
            cache.put(test3.get_ID(), test3);
            cache.clearResetCount();
            this.commit();
            this.getTrx().start();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
            org.junit.jupiter.api.Assertions.assertTrue((cache.getResetCount() == 0 ? 1 : 0) != 0, (String)"Cache reset count is not zero with suspendTableCacheReset active");
            cache.put(test1.get_ID(), test1);
            cache.put(test2.get_ID(), test2);
            cache.put(test3.get_ID(), test3);
            test1.deleteEx(true);
            test1 = null;
            test2.deleteEx(true);
            test2 = null;
            test3.deleteEx(true);
            test3 = null;
            cache.clearResetCount();
            this.commit();
            this.getTrx().start();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
            org.junit.jupiter.api.Assertions.assertTrue((cache.getResetCount() == 0 ? 1 : 0) != 0, (String)"Cache reset count is not zero with suspendTableCacheReset active");
            CacheMgt.get().resumeTableCacheReset("Test");
            test1 = new MTest(Env.getCtx(), 0, this.getTrxName());
            test2 = new MTest(Env.getCtx(), 0, this.getTrxName());
            test3 = new MTest(Env.getCtx(), 0, this.getTrxName());
            test1.setName("test1");
            test1.saveEx();
            test2.setName("test2");
            test2.saveEx();
            test3.setName("test3");
            test3.saveEx();
            cache.put(test1.get_ID(), test1);
            cache.put(test2.get_ID(), test2);
            cache.put(test3.get_ID(), test3);
            cache.clearResetCount();
            this.commit();
            this.getTrx().start();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
            org.junit.jupiter.api.Assertions.assertTrue((cache.getResetCount() > 0 ? 1 : 0) != 0, (String)"Cache reset count is zero");
        }
        finally {
            if (test1 != null && test1.get_ID() > 0) {
                test1.deleteEx(true);
            }
            if (test2 != null && test2.get_ID() > 0) {
                test2.deleteEx(true);
            }
            if (test3 != null && test3.get_ID() > 0) {
                test3.deleteEx(true);
            }
            this.commit();
        }
    }

    @Test
    public void testExpire() {
        ImmutableIntPOCache cache = new ImmutableIntPOCache("M_Product", 40, 1);
        cache.put((Object)DictionaryIDs.M_Product.AZALEA_BUSH.id, (PO)new MProduct(Env.getCtx(), DictionaryIDs.M_Product.AZALEA_BUSH.id, null));
        cache.put((Object)DictionaryIDs.M_Product.P_CHAIR.id, (PO)new MProduct(Env.getCtx(), DictionaryIDs.M_Product.P_CHAIR.id, null));
        int i = 0;
        while (i < 2) {
            org.junit.jupiter.api.Assertions.assertNotNull((Object)cache.get((Object)DictionaryIDs.M_Product.P_CHAIR.id), (String)("Unexpected expire of cache item after " + i + " access"));
            try {
                Thread.sleep(35000L);
            }
            catch (InterruptedException interruptedException) {}
            ++i;
        }
        org.junit.jupiter.api.Assertions.assertNotNull((Object)cache.get((Object)DictionaryIDs.M_Product.P_CHAIR.id), (String)"Cache item expire despite being access recently");
        org.junit.jupiter.api.Assertions.assertNull((Object)cache.get((Object)DictionaryIDs.M_Product.AZALEA_BUSH.id), (String)"Cache item not expire despite not being access for more than 1 minutes");
        CacheMgt.get().unregister((CacheInterface)cache);
    }

    @Test
    public void testNullKey() {
        CCache testCache = new CCache(null, "Test_Cache", 10, 60, false);
        Assertions.assertThatNoException().isThrownBy(() -> {
            Object object = testCache.get(null);
        });
        Assertions.assertThatNoException().isThrownBy(() -> {
            boolean bl = testCache.containsKey(null);
        });
        Assertions.assertThatNoException().isThrownBy(() -> {
            boolean bl = testCache.containsValue(null);
        });
        org.junit.jupiter.api.Assertions.assertFalse((boolean)testCache.containsValue(null));
        testCache.put((Object)"TestNull", null);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)testCache.containsValue(null));
    }

    @Test
    public void testTrlCacheReset() {
        String locale = "es_CO";
        MProduct p = new MProduct(Env.getCtx(), DictionaryIDs.M_Product.AZALEA_BUSH.id, null);
        String esName = p.get_Translation("Name", locale);
        Query query = new Query(Env.getCtx(), "M_Product_Trl", "M_Product_ID=? AND AD_Language=?", null);
        PO po = query.setParameters(new Object[]{p.get_ID(), locale}).firstOnly();
        org.junit.jupiter.api.Assertions.assertEquals((Object)esName, (Object)po.get_Value("Name"), (String)"Expected translation not found");
        try {
            po.set_ValueOfColumn("Name", (Object)(esName + "1"));
            po.saveEx();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
            org.junit.jupiter.api.Assertions.assertEquals((Object)(esName + "1"), (Object)p.get_Translation("Name", locale), (String)"Translation not refresh in cache");
        }
        finally {
            po.set_ValueOfColumn("Name", (Object)esName);
            po.saveEx();
        }
    }

    private static class MTestCache
    extends CCache<Integer, MTest> {
        private static final long serialVersionUID = 1L;
        private int resetCount = 0;

        public MTestCache(String name, int capacity) {
            super(name, capacity);
        }

        public int reset() {
            ++this.resetCount;
            return super.reset();
        }

        public int reset(int recordId) {
            ++this.resetCount;
            return super.reset(recordId);
        }

        public void newRecord(int record_ID) {
            ++this.resetCount;
            super.newRecord(record_ID);
        }

        public int getResetCount() {
            return this.resetCount;
        }

        public void clearResetCount() {
            this.resetCount = 0;
        }
    }
}

