/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.parser;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http3.frames.GoAwayFrame;
import org.eclipse.jetty.http3.internal.VarLenInt;
import org.eclipse.jetty.http3.parser.BodyParser;
import org.eclipse.jetty.http3.parser.HeaderParser;
import org.eclipse.jetty.http3.parser.ParserListener;

public class GoAwayBodyParser
extends BodyParser {
    private final VarLenInt varLenInt = new VarLenInt();

    public GoAwayBodyParser(HeaderParser headerParser, ParserListener listener) {
        super(headerParser, listener);
    }

    @Override
    public BodyParser.Result parse(ByteBuffer buffer) {
        if (this.varLenInt.decode(buffer, this::onGoAway)) {
            return BodyParser.Result.WHOLE_FRAME;
        }
        return BodyParser.Result.NO_FRAME;
    }

    private void onGoAway(long id) {
        GoAwayFrame frame = new GoAwayFrame(id);
        this.notifyGoAway(frame);
    }
}

