/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.internal;

import java.nio.ByteBuffer;
import java.util.function.LongConsumer;

public class VarLenInt {
    public static final int MAX_LENGTH = 8;
    private static final int ENCODING_MASK = 192;
    private static final int VALUE_MASK = 63;
    private int encoding = -1;
    private int length;
    private long value;

    public void reset() {
        this.encoding = -1;
        this.length = 0;
        this.value = 0L;
    }

    public boolean decode(ByteBuffer buffer, LongConsumer consumer) {
        while (buffer.hasRemaining()) {
            if (this.encoding < 0) {
                byte hiByte = buffer.get(buffer.position());
                this.encoding = (hiByte & 0xC0) >>> 6;
                this.length = 1 << this.encoding;
                this.value = buffer.get() & 0x3F;
                if (--this.length != 0) continue;
                return this.result(consumer);
            }
            if (this.length > 0) {
                this.value = (this.value << 8) + (long)(buffer.get() & 0xFF);
                if (--this.length != 0) continue;
                return this.result(consumer);
            }
            throw new IllegalStateException();
        }
        return false;
    }

    private boolean result(LongConsumer consumer) {
        consumer.accept(this.value);
        this.reset();
        return true;
    }

    public static void encode(ByteBuffer buffer, long value) {
        int length = VarLenInt.length(value);
        int encoding = 31 - Integer.numberOfLeadingZeros(length);
        int position = buffer.position();
        for (int i = length - 1; i > 0; --i) {
            buffer.put(position + i, (byte)(value & 0xFFL));
            value >>>= 8;
        }
        buffer.put(position, (byte)(value & 0x3FL | (long)(encoding << 6)));
        buffer.position(position + length);
    }

    public static int length(long value) {
        if (value < 0L) {
            throw new InvalidException("invalid_variable_length_integer");
        }
        if (value < 64L) {
            return 1;
        }
        if (value < 16384L) {
            return 2;
        }
        if (value < 0x40000000L) {
            return 4;
        }
        if (value < 0x4000000000000000L) {
            return 8;
        }
        throw new InvalidException("invalid_variable_length_integer");
    }

    public static class InvalidException
    extends RuntimeException {
        public InvalidException(String message) {
            super(message);
        }
    }
}

