/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.filter;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.felix.webconsole.DefaultVariableResolver;
import org.apache.felix.webconsole.VariableResolver;

class ResourceFilteringWriter
extends FilterWriter {
    private static final int STATE_NULL = 0;
    private static final int STATE_DOLLAR = 1;
    private static final int STATE_BUFFERING = 2;
    private static final int STATE_ESCAPE = 3;
    private final ResourceBundle locale;
    private final VariableResolver variables;
    private final StringBuffer lineBuffer = new StringBuffer();
    private int state = 0;

    ResourceFilteringWriter(Writer out, ResourceBundle locale, VariableResolver variables) {
        super(out);
        this.locale = locale;
        this.variables = variables != null ? variables : new DefaultVariableResolver();
    }

    @Override
    public void write(int c) throws IOException {
        switch (this.state) {
            case 0: {
                if (c == 36) {
                    this.state = 1;
                    break;
                }
                if (c == 92) {
                    this.state = 3;
                    break;
                }
                this.out.write(c);
                break;
            }
            case 1: {
                if (c == 123) {
                    this.state = 2;
                    break;
                }
                this.state = 0;
                this.out.write(36);
                this.out.write(c);
                break;
            }
            case 2: {
                if (c == 125) {
                    this.state = 0;
                    super.write(this.translate());
                    break;
                }
                this.lineBuffer.append((char)c);
                break;
            }
            case 3: {
                this.state = 0;
                if (c != 36) {
                    this.out.write(92);
                }
                this.out.write(c);
            }
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int limit = off + len;
        for (int i = off; i < limit; ++i) {
            this.write(cbuf[i]);
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        int limit = off + len;
        for (int i = off; i < limit; ++i) {
            this.write(str.charAt(i));
        }
    }

    private String translate() {
        String key = this.lineBuffer.toString();
        this.lineBuffer.delete(0, this.lineBuffer.length());
        String value = this.variables.resolve(key);
        if (value == null) {
            try {
                value = this.locale.getString(key);
            }
            catch (MissingResourceException mre) {
                value = key;
            }
        }
        return value;
    }
}

