/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.SFooter;
import io.keikai.model.SHeader;
import io.keikai.model.SSheetViewInfo;
import io.keikai.model.impl.HeaderFooterImpl;
import java.io.Serializable;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class SheetViewInfoImpl
implements SSheetViewInfo,
Serializable {
    private static final long serialVersionUID = 1L;
    private boolean _displayGridlines = true;
    private int _rowFreeze = 0;
    private int _columnFreeze = 0;
    private SHeader _header;
    private SFooter _footer;
    private TreeSet<Integer> _rowBreaks;
    private TreeSet<Integer> _columnBreaks;

    @Override
    public boolean isDisplayGridlines() {
        return this._displayGridlines;
    }

    @Override
    public void setDisplayGridlines(boolean enable) {
        this._displayGridlines = enable;
    }

    @Override
    public int getNumOfRowFreeze() {
        return this._rowFreeze;
    }

    @Override
    public int getNumOfColumnFreeze() {
        return this._columnFreeze;
    }

    @Override
    public void setNumOfRowFreeze(int num) {
        this._rowFreeze = num;
    }

    @Override
    public void setNumOfColumnFreeze(int num) {
        this._columnFreeze = num;
    }

    @Override
    public SHeader getHeader() {
        if (this._header == null) {
            this._header = new HeaderFooterImpl();
        }
        return this._header;
    }

    @Override
    public SFooter getFooter() {
        if (this._footer == null) {
            this._footer = new HeaderFooterImpl();
        }
        return this._footer;
    }

    @Override
    public int[] getRowBreaks() {
        if (this._rowBreaks == null) {
            return new int[0];
        }
        int[] arr = new int[this._rowBreaks.size()];
        Iterator<Integer> iter = this._rowBreaks.iterator();
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = iter.next();
        }
        return arr;
    }

    @Override
    public void setRowBreaks(int[] breaks) {
        if (this._rowBreaks != null) {
            this._rowBreaks.clear();
        } else {
            this._rowBreaks = new TreeSet();
        }
        if (breaks != null) {
            for (int i : breaks) {
                this._rowBreaks.add(i);
            }
        }
    }

    @Override
    public void addRowBreak(int row) {
        if (this._rowBreaks == null) {
            this._rowBreaks = new TreeSet();
        }
        this._rowBreaks.add(row);
    }

    @Override
    public void addColumnBreak(int column) {
        if (this._columnBreaks == null) {
            this._columnBreaks = new TreeSet();
        }
        this._columnBreaks.add(column);
    }

    @Override
    public int[] getColumnBreaks() {
        if (this._columnBreaks == null) {
            return new int[0];
        }
        int[] arr = new int[this._columnBreaks.size()];
        Iterator<Integer> iter = this._columnBreaks.iterator();
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = iter.next();
        }
        return arr;
    }

    @Override
    public void setColumnBreaks(int[] breaks) {
        if (this._rowBreaks != null) {
            this._columnBreaks.clear();
        } else {
            this._columnBreaks = new TreeSet();
        }
        if (breaks != null) {
            for (int i : breaks) {
                this._columnBreaks.add(i);
            }
        }
    }

    void copyFrom(SheetViewInfoImpl src) {
        this._displayGridlines = src._displayGridlines;
        this._rowFreeze = src._rowFreeze;
        this._columnFreeze = src._columnFreeze;
        if (src._header != null) {
            this._header = ((HeaderFooterImpl)src._header).cloneHeaderFooterImpl();
        }
        if (src._footer != null) {
            this._footer = ((HeaderFooterImpl)src._footer).cloneHeaderFooterImpl();
        }
        if (src._rowBreaks != null) {
            this._rowBreaks = new TreeSet<Integer>((SortedSet<Integer>)src._rowBreaks);
        }
        if (src._columnBreaks != null) {
            this._columnBreaks = new TreeSet<Integer>((SortedSet<Integer>)src._columnBreaks);
        }
    }
}

