/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hssf.usermodel;

import org.zkoss.poi.hssf.model.HSSFFormulaParser;
import org.zkoss.poi.hssf.model.InternalWorkbook;
import org.zkoss.poi.hssf.record.NameRecord;
import org.zkoss.poi.hssf.record.aggregates.FormulaRecordAggregate;
import org.zkoss.poi.hssf.usermodel.HSSFCell;
import org.zkoss.poi.hssf.usermodel.HSSFEvaluationCell;
import org.zkoss.poi.hssf.usermodel.HSSFEvaluationSheet;
import org.zkoss.poi.hssf.usermodel.HSSFSheet;
import org.zkoss.poi.hssf.usermodel.HSSFWorkbook;
import org.zkoss.poi.ss.SpreadsheetVersion;
import org.zkoss.poi.ss.formula.EvaluationCell;
import org.zkoss.poi.ss.formula.EvaluationName;
import org.zkoss.poi.ss.formula.EvaluationSheet;
import org.zkoss.poi.ss.formula.EvaluationWorkbook;
import org.zkoss.poi.ss.formula.FormulaParsingWorkbook;
import org.zkoss.poi.ss.formula.FormulaRenderingWorkbook;
import org.zkoss.poi.ss.formula.ptg.NamePtg;
import org.zkoss.poi.ss.formula.ptg.NameXPtg;
import org.zkoss.poi.ss.formula.ptg.Ptg;
import org.zkoss.poi.ss.formula.ptg.TablePtg;
import org.zkoss.poi.ss.formula.udf.UDFFinder;
import org.zkoss.poi.util.POILogFactory;
import org.zkoss.poi.util.POILogger;

public final class HSSFEvaluationWorkbook
implements FormulaRenderingWorkbook,
EvaluationWorkbook,
FormulaParsingWorkbook {
    private static POILogger logger = POILogFactory.getLogger(HSSFEvaluationWorkbook.class);
    private final HSSFWorkbook _uBook;
    private final InternalWorkbook _iBook;

    public static HSSFEvaluationWorkbook create(HSSFWorkbook book) {
        if (book == null) {
            return null;
        }
        return new HSSFEvaluationWorkbook(book);
    }

    private HSSFEvaluationWorkbook(HSSFWorkbook book) {
        this._uBook = book;
        this._iBook = book.getWorkbook();
    }

    @Override
    public int getExternalSheetIndex(String sheetName) {
        int j = sheetName.indexOf(58);
        String sheetName1 = j < 0 ? sheetName : sheetName.substring(0, j);
        String sheetName2 = j < 0 ? sheetName : sheetName.substring(j + 1);
        int sheetIndex1 = this._uBook.getSheetIndex(sheetName1);
        int sheetIndex2 = this._uBook.getSheetIndex(sheetName2);
        return this._iBook.checkExternSheet(sheetIndex1, sheetIndex2);
    }

    @Override
    public int getExternalSheetIndex(String workbookName, String sheetName) {
        return this._iBook.getExternalSheetIndex(workbookName, sheetName);
    }

    @Override
    public NameXPtg getNameXPtg(String name) {
        return this._iBook.getNameXPtg(name, this._uBook.getUDFFinder());
    }

    @Override
    public EvaluationName getName(String name, int sheetIndex) {
        for (int i = 0; i < this._iBook.getNumNames(); ++i) {
            NameRecord nr = this._iBook.getNameRecord(i);
            if (nr.getSheetNumber() != sheetIndex + 1 || !name.equalsIgnoreCase(nr.getNameText())) continue;
            return new Name(nr, i);
        }
        return sheetIndex == -1 ? null : this.getName(name, -1);
    }

    @Override
    public int getSheetIndex(EvaluationSheet evalSheet) {
        HSSFSheet sheet = ((HSSFEvaluationSheet)evalSheet).getHSSFSheet();
        return this._uBook.getSheetIndex(sheet);
    }

    @Override
    public int getSheetIndex(String sheetName) {
        return this._uBook.getSheetIndex(sheetName);
    }

    @Override
    public String getSheetName(int sheetIndex) {
        return this._uBook.getSheetName(sheetIndex);
    }

    @Override
    public EvaluationSheet getSheet(int sheetIndex) {
        return new HSSFEvaluationSheet(this._uBook.getSheetAt(sheetIndex));
    }

    @Override
    public int convertFromExternSheetIndex(int externSheetIndex) {
        return this._iBook.getSheetIndexFromExternSheetIndex(externSheetIndex);
    }

    @Override
    public int convertLastIndexFromExternSheetIndex(int externSheetIndex) {
        return this._iBook.getLastSheetIndexFromExternSheetIndex(externSheetIndex);
    }

    @Override
    public EvaluationWorkbook.ExternalSheet getExternalSheet(int externSheetIndex) {
        return this._iBook.getExternalSheet(externSheetIndex);
    }

    @Override
    public EvaluationWorkbook.ExternalName getExternalName(int externSheetIndex, int externNameIndex) {
        return this._iBook.getExternalName(externSheetIndex, externNameIndex);
    }

    @Override
    public String resolveNameXText(NameXPtg n) {
        return this._iBook.resolveNameXText(n.getSheetRefIndex(), n.getNameIndex());
    }

    @Override
    public String getSheetNameByExternSheet(int externSheetIndex) {
        return this._iBook.findSheetNameFromExternSheet(externSheetIndex);
    }

    @Override
    public String getNameText(NamePtg namePtg) {
        return this._iBook.getNameRecord(namePtg.getIndex()).getNameText();
    }

    @Override
    public EvaluationName getName(NamePtg namePtg) {
        int ix = namePtg.getIndex();
        return new Name(this._iBook.getNameRecord(ix), ix);
    }

    @Override
    public EvaluationName getName(NamePtg namePtg, int contextSheetIndex) {
        return this.getName(namePtg);
    }

    @Override
    public Ptg[] getFormulaTokens(EvaluationCell evalCell) {
        HSSFCell cell = ((HSSFEvaluationCell)evalCell).getHSSFCell();
        FormulaRecordAggregate fra = (FormulaRecordAggregate)cell.getCellValueRecord();
        return fra.getFormulaTokens();
    }

    @Override
    public UDFFinder getUDFFinder() {
        return this._uBook.getUDFFinder();
    }

    @Override
    public SpreadsheetVersion getSpreadsheetVersion() {
        return SpreadsheetVersion.EXCEL97;
    }

    @Override
    public String getBookNameFromExternalLinkIndex(String externalLinkIndex) {
        return externalLinkIndex;
    }

    @Override
    public EvaluationName getOrCreateName(String name, int sheetIndex) {
        for (int i = 0; i < this._iBook.getNumNames(); ++i) {
            NameRecord nr = this._iBook.getNameRecord(i);
            if (nr.getSheetNumber() != sheetIndex + 1 || !name.equalsIgnoreCase(nr.getNameText())) continue;
            return new Name(nr, i);
        }
        if (sheetIndex == -1) {
            NameRecord nr = this._iBook.createName();
            nr.setNameText(name);
            return new Name(nr, this._iBook.getNumNames() - 1);
        }
        return this.getOrCreateName(name, -1);
    }

    @Override
    public Ptg[] getFormulaTokens(int sheetIndex, String formula) {
        return HSSFFormulaParser.parse(formula, this._uBook, 0, sheetIndex);
    }

    @Override
    public String getExternalLinkIndexFromBookName(String bookname) {
        return bookname;
    }

    @Override
    public boolean isAllowedDeferredNamePtg() {
        return false;
    }

    @Override
    public EvaluationName getName(String name, String sheetName) {
        int sheetIndex = this._uBook.getSheetIndex(sheetName);
        return this.getName(name, sheetIndex);
    }

    @Override
    public String getFullNameText(NamePtg namePtg) {
        int sheetIndex = this._iBook.getNameRecord(namePtg.getIndex()).getSheetNumber() - 1;
        String sheetName = sheetIndex >= 0 ? this.getSheetName(sheetIndex) : null;
        return (sheetName == null ? "" : sheetName + '!') + this.getNameText(namePtg);
    }

    @Override
    public TablePtg createTablePtg(String tableName, Object[] specifiers, int sheetIndex, int rowIdx, int colIdx) {
        return null;
    }

    @Override
    public String getTableName(String name) {
        return null;
    }

    private static final class Name
    implements EvaluationName {
        private final NameRecord _nameRecord;
        private final int _index;

        public Name(NameRecord nameRecord, int index) {
            this._nameRecord = nameRecord;
            this._index = index;
        }

        @Override
        public Ptg[] getNameDefinition() {
            return this._nameRecord.getNameDefinition();
        }

        @Override
        public String getNameText() {
            return this._nameRecord.getNameText();
        }

        @Override
        public boolean hasFormula() {
            return this._nameRecord.hasFormula();
        }

        @Override
        public boolean isFunctionName() {
            return this._nameRecord.isFunctionName();
        }

        @Override
        public boolean isRange() {
            return this._nameRecord.hasFormula();
        }

        @Override
        public NamePtg createPtg() {
            return new NamePtg(this._index);
        }
    }
}

