/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.jet.JobStatusEvent;
import com.hazelcast.jet.JobStatusListener;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.eventservice.EventPublishingService;
import com.hazelcast.spi.impl.eventservice.EventRegistration;
import com.hazelcast.spi.impl.eventservice.impl.EventServiceImpl;
import com.hazelcast.spi.impl.eventservice.impl.Registration;
import com.hazelcast.spi.impl.eventservice.impl.TrueEventFilter;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class JobEventService
implements EventPublishingService<JobStatusEvent, JobStatusListener> {
    public static final String SERVICE_NAME = "hz:impl:jobEventService";
    private final EventServiceImpl eventService;
    private final Address address;

    public JobEventService(NodeEngine nodeEngine) {
        this.eventService = (EventServiceImpl)nodeEngine.getEventService();
        this.address = nodeEngine.getThisAddress();
    }

    @Override
    public void dispatchEvent(JobStatusEvent event, JobStatusListener listener) {
        listener.jobStatusChanged(event);
    }

    public void publishEvent(long jobId, JobStatus oldStatus, JobStatus newStatus, String description, boolean userRequested) {
        Collection<EventRegistration> registrations = this.eventService.getRegistrations(SERVICE_NAME, Util.idToString(jobId));
        if (!registrations.isEmpty()) {
            JobStatusEvent event = new JobStatusEvent(jobId, oldStatus, newStatus, description, userRequested);
            this.eventService.publishEvent(SERVICE_NAME, registrations, (Object)event, (int)jobId);
        }
    }

    public UUID addEventListener(long jobId, JobStatusListener listener) {
        return this.eventService.registerListener(SERVICE_NAME, Util.idToString(jobId), listener).getId();
    }

    public Registration prepareRegistration(long jobId, JobStatusListener listener, boolean localOnly) {
        UUID registrationId = UuidUtil.newUnsecureUUID();
        Registration registration = new Registration(registrationId, SERVICE_NAME, Util.idToString(jobId), TrueEventFilter.INSTANCE, this.address, listener, localOnly);
        this.eventService.cacheListener(registration);
        return registration;
    }

    public EventRegistration handleAllRegistrations(long jobId, Registration registration) {
        return this.eventService.handleAllRegistrations(registration, (int)jobId);
    }

    public boolean removeEventListener(long jobId, UUID id) {
        return this.eventService.deregisterListener(SERVICE_NAME, Util.idToString(jobId), id);
    }

    public CompletableFuture<Boolean> removeEventListenerAsync(long jobId, UUID id) {
        return this.eventService.deregisterListenerAsync(SERVICE_NAME, Util.idToString(jobId), id);
    }

    public void removeAllEventListeners(long jobId) {
        this.eventService.deregisterAllListeners(SERVICE_NAME, Util.idToString(jobId), (int)jobId);
    }
}

