/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.tpcengine.nio;

import com.hazelcast.internal.tpcengine.Reactor;
import com.hazelcast.internal.tpcengine.ReactorBuilder;
import com.hazelcast.internal.tpcengine.net.AcceptRequest;
import com.hazelcast.internal.tpcengine.nio.NioAcceptRequest;
import com.hazelcast.internal.tpcengine.nio.NioAsyncServerSocketBuilder;
import com.hazelcast.internal.tpcengine.nio.NioAsyncSocketBuilder;
import com.hazelcast.internal.tpcengine.nio.NioEventloop;
import com.hazelcast.internal.tpcengine.nio.NioReactorBuilder;
import com.hazelcast.internal.tpcengine.util.Preconditions;
import java.nio.channels.Selector;

public final class NioReactor
extends Reactor {
    final Selector selector;

    NioReactor(NioReactorBuilder builder) {
        super(builder);
        this.selector = ((NioEventloop)this.eventloop()).selector;
    }

    @Override
    public NioAsyncSocketBuilder newAsyncSocketBuilder() {
        this.verifyRunning();
        return new NioAsyncSocketBuilder(this, null);
    }

    @Override
    public NioAsyncSocketBuilder newAsyncSocketBuilder(AcceptRequest acceptRequest) {
        this.verifyRunning();
        NioAcceptRequest nioAcceptRequest = Preconditions.checkInstanceOf(NioAcceptRequest.class, acceptRequest, "acceptRequest");
        return new NioAsyncSocketBuilder(this, nioAcceptRequest);
    }

    @Override
    public NioAsyncServerSocketBuilder newAsyncServerSocketBuilder() {
        this.verifyRunning();
        return new NioAsyncServerSocketBuilder(this);
    }

    @Override
    protected NioEventloop newEventloop(ReactorBuilder builder) {
        return new NioEventloop(this, (NioReactorBuilder)builder);
    }

    @Override
    public void wakeup() {
        if (this.spin || Thread.currentThread() == this.eventloopThread) {
            return;
        }
        if (this.wakeupNeeded.get() && this.wakeupNeeded.compareAndSet(true, false)) {
            this.selector.wakeup();
        }
    }
}

