/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cp.internal.datastructures.atomicref;

import com.hazelcast.client.impl.ClientDelegatingFuture;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.AtomicRefApplyCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicRefCompareAndSetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicRefContainsCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicRefGetCodec;
import com.hazelcast.client.impl.protocol.codec.AtomicRefSetCodec;
import com.hazelcast.client.impl.protocol.codec.CPGroupDestroyCPObjectCodec;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.ClientProxy;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.core.IFunction;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.IAtomicReference;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.datastructures.atomicref.operation.ApplyOp;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.spi.impl.InternalCompletableFuture;

public class AtomicRefProxy<T>
extends ClientProxy
implements IAtomicReference<T> {
    private final RaftGroupId groupId;
    private final String objectName;

    public AtomicRefProxy(ClientContext context, RaftGroupId groupId, String proxyName, String objectName) {
        super("hz:raft:atomicRefService", proxyName, context);
        this.groupId = groupId;
        this.objectName = objectName;
    }

    @Override
    public boolean compareAndSet(T expect, T update) {
        return (Boolean)((InternalCompletableFuture)this.compareAndSetAsync((Object)expect, (Object)update)).joinInternal();
    }

    @Override
    public T get() {
        return (T)((InternalCompletableFuture)this.getAsync()).joinInternal();
    }

    @Override
    public void set(T newValue) {
        ((InternalCompletableFuture)this.setAsync((Object)newValue)).joinInternal();
    }

    @Override
    public T getAndSet(T newValue) {
        return (T)((InternalCompletableFuture)this.getAndSetAsync((Object)newValue)).joinInternal();
    }

    @Override
    public boolean isNull() {
        return (Boolean)((InternalCompletableFuture)this.isNullAsync()).joinInternal();
    }

    @Override
    public void clear() {
        ((InternalCompletableFuture)this.clearAsync()).joinInternal();
    }

    @Override
    public boolean contains(T value) {
        return (Boolean)((InternalCompletableFuture)this.containsAsync((Object)value)).joinInternal();
    }

    @Override
    public void alter(IFunction<T, T> function) {
        ((InternalCompletableFuture)this.alterAsync((IFunction)function)).joinInternal();
    }

    @Override
    public T alterAndGet(IFunction<T, T> function) {
        return (T)((InternalCompletableFuture)this.alterAndGetAsync((IFunction)function)).joinInternal();
    }

    @Override
    public T getAndAlter(IFunction<T, T> function) {
        return (T)((InternalCompletableFuture)this.getAndAlterAsync((IFunction)function)).joinInternal();
    }

    @Override
    public <R> R apply(IFunction<T, R> function) {
        return (R)((InternalCompletableFuture)this.applyAsync((IFunction)function)).joinInternal();
    }

    public InternalCompletableFuture<Boolean> compareAndSetAsync(T expect, T update) {
        Object expectedData = this.getContext().getSerializationService().toData(expect);
        Object newData = this.getContext().getSerializationService().toData(update);
        ClientMessage request = AtomicRefCompareAndSetCodec.encodeRequest(this.groupId, this.objectName, expectedData, newData);
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.name).invoke();
        return new ClientDelegatingFuture<Boolean>(future, this.getSerializationService(), AtomicRefCompareAndSetCodec::decodeResponse);
    }

    @Override
    public InternalCompletableFuture<T> getAsync() {
        ClientMessage request = AtomicRefGetCodec.encodeRequest(this.groupId, this.objectName);
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.name).invoke();
        return new ClientDelegatingFuture(future, this.getSerializationService(), AtomicRefGetCodec::decodeResponse);
    }

    public InternalCompletableFuture<Void> setAsync(T newValue) {
        Object data = this.getContext().getSerializationService().toData(newValue);
        ClientMessage request = AtomicRefSetCodec.encodeRequest(this.groupId, this.objectName, data, false);
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.name).invoke();
        return new ClientDelegatingFuture<Void>(future, this.getSerializationService(), AtomicRefSetCodec::decodeResponse);
    }

    @Override
    public InternalCompletableFuture<T> getAndSetAsync(T newValue) {
        Object data = this.getContext().getSerializationService().toData(newValue);
        ClientMessage request = AtomicRefSetCodec.encodeRequest(this.groupId, this.objectName, data, true);
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.name).invoke();
        return new ClientDelegatingFuture(future, this.getSerializationService(), AtomicRefSetCodec::decodeResponse);
    }

    public InternalCompletableFuture<Boolean> isNullAsync() {
        return this.containsAsync((Object)null);
    }

    public InternalCompletableFuture<Void> clearAsync() {
        return this.setAsync((Object)null);
    }

    public InternalCompletableFuture<Boolean> containsAsync(T expected) {
        Object data = this.getContext().getSerializationService().toData(expected);
        ClientMessage request = AtomicRefContainsCodec.encodeRequest(this.groupId, this.objectName, data);
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.name).invoke();
        return new ClientDelegatingFuture<Boolean>(future, this.getSerializationService(), AtomicRefContainsCodec::decodeResponse);
    }

    public InternalCompletableFuture<Void> alterAsync(IFunction<T, T> function) {
        return this.invokeApply(function, ApplyOp.ReturnValueType.NO_RETURN_VALUE, true);
    }

    @Override
    public InternalCompletableFuture<T> alterAndGetAsync(IFunction<T, T> function) {
        return this.invokeApply(function, ApplyOp.ReturnValueType.RETURN_NEW_VALUE, true);
    }

    @Override
    public InternalCompletableFuture<T> getAndAlterAsync(IFunction<T, T> function) {
        return this.invokeApply(function, ApplyOp.ReturnValueType.RETURN_OLD_VALUE, true);
    }

    @Override
    public <R> InternalCompletableFuture<R> applyAsync(IFunction<T, R> function) {
        return this.invokeApply(function, ApplyOp.ReturnValueType.RETURN_NEW_VALUE, false);
    }

    @Override
    public void onDestroy() {
        ClientMessage request = CPGroupDestroyCPObjectCodec.encodeRequest(this.groupId, this.getServiceName(), this.objectName);
        new ClientInvocation(this.getClient(), request, this.name).invoke().joinInternal();
    }

    @Override
    public String getPartitionKey() {
        throw new UnsupportedOperationException();
    }

    public CPGroupId getGroupId() {
        return this.groupId;
    }

    private <T2, T3> InternalCompletableFuture<T3> invokeApply(IFunction<T, T2> function, ApplyOp.ReturnValueType returnValueType, boolean alter) {
        Preconditions.checkTrue(function != null, "Function cannot be null");
        Object data = this.getContext().getSerializationService().toData(function);
        ClientMessage request = AtomicRefApplyCodec.encodeRequest(this.groupId, this.objectName, data, returnValueType.value(), alter);
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.name).invoke();
        return new ClientDelegatingFuture(future, this.getSerializationService(), AtomicRefApplyCodec::decodeResponse);
    }
}

