/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.customizers.shape;

import java.awt.Shape;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import net.sf.jasperreports.customizers.shape.AbstractShapeCustomizer;
import net.sf.jasperreports.customizers.shape.Point;
import net.sf.jasperreports.customizers.util.CategoryCounter;
import net.sf.jasperreports.customizers.util.CategorySeriesNameProvider;
import net.sf.jasperreports.customizers.util.CustomizerUtil;
import net.sf.jasperreports.customizers.util.ItemsCounter;
import net.sf.jasperreports.customizers.util.SeriesNameProvider;
import net.sf.jasperreports.engine.JRChart;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;

public class LineDotShapeCustomizer
extends AbstractShapeCustomizer {
    public void customize(JFreeChart jfc, JRChart jrc) {
        Plot plot = jfc.getPlot();
        ItemsCounter itemsCounter = null;
        SeriesNameProvider seriesNameProvider = null;
        XYItemRenderer renderer = null;
        if (plot instanceof XYPlot) {
            XYPlot xyPlot = jfc.getXYPlot();
            renderer = xyPlot.getRenderer();
            itemsCounter = new XYPlotSeriesCounter(xyPlot);
            seriesNameProvider = new AbstractShapeCustomizer.XYPlotSeriesNameProvider(xyPlot);
        } else if (plot instanceof CategoryPlot) {
            CategoryPlot categoryPlot = jfc.getCategoryPlot();
            renderer = categoryPlot.getRenderer();
            itemsCounter = new CategoryCounter(categoryPlot);
            seriesNameProvider = new CategorySeriesNameProvider(categoryPlot);
        }
        Integer seriesItemIndex = CustomizerUtil.resolveIndex(this, itemsCounter, seriesNameProvider);
        if (seriesItemIndex != null && renderer instanceof AbstractRenderer) {
            AbstractRendererSeriesShapeSetter shapeSetter = new AbstractRendererSeriesShapeSetter((AbstractRenderer)renderer);
            if (seriesItemIndex == -1) {
                this.updateItems(itemsCounter, shapeSetter);
            } else {
                this.updateItem(itemsCounter, shapeSetter, seriesItemIndex);
            }
        }
    }

    @Override
    protected Point getOffset(Dimension2D size) {
        return new Point((int)(size.getWidth() / 2.0), (int)(size.getHeight() / 2.0));
    }

    @Override
    protected Point getOffset(Rectangle2D bounds) {
        return new Point((int)(bounds.getWidth() / 2.0 + bounds.getX()), (int)(bounds.getHeight() / 2.0 + bounds.getY()));
    }

    protected class AbstractRendererSeriesShapeSetter
    implements AbstractShapeCustomizer.ShapeSetter {
        private final AbstractRenderer renderer;

        public AbstractRendererSeriesShapeSetter(AbstractRenderer renderer) {
            this.renderer = renderer;
        }

        @Override
        public void setShape(int seriesIndex, Shape shape) {
            this.renderer.setSeriesShape(seriesIndex, shape);
        }
    }

    protected class XYPlotSeriesCounter
    implements ItemsCounter {
        private final XYPlot xyPlot;

        public XYPlotSeriesCounter(XYPlot xyPlot) {
            this.xyPlot = xyPlot;
        }

        @Override
        public int getCount() {
            return this.xyPlot.getSeriesCount();
        }
    }
}

