/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.process;

import java.util.ArrayList;
import org.adempiere.base.annotation.Process;
import org.compiere.model.MProcessPara;
import org.compiere.model.Query;
import org.compiere.print.MPrintFormat;
import org.compiere.print.MPrintFormatItem;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Language;

@Process
public class PrintFormatItemSync
extends SvrProcess {
    private int p_reportViewID = 0;
    private int p_printFormatID = 0;
    private String p_language = "";
    private String p_source = "";
    private int no = 0;
    private static final String SOURCE_TABLE = "1";
    private static final String SOURCE_RV_COLUMN = "2";

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("AD_ReportView_ID")) {
                this.p_reportViewID = para[i].getParameterAsInt();
            } else if (name.equals("AD_PrintFormat_ID")) {
                this.p_printFormatID = para[i].getParameterAsInt();
            } else if (name.equals("AD_Language")) {
                this.p_language = para[i].getParameterAsString();
            } else if (name.equals("Source")) {
                this.p_source = para[i].getParameterAsString();
            } else {
                MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para[i]);
            }
            ++i;
        }
    }

    protected String doIt() {
        StringBuilder whereClause = new StringBuilder("AD_ReportView_ID = ?");
        ArrayList<Integer> listParams = new ArrayList<Integer>();
        listParams.add(this.p_reportViewID);
        if (this.p_printFormatID > 0) {
            whereClause.append(" AND AD_PrintFormat_ID = ?");
            listParams.add(this.p_printFormatID);
        }
        Query query = new Query(this.getCtx(), "AD_PrintFormat", whereClause.toString(), this.get_TrxName()).setClient_ID().setParameters(listParams).setOnlyActiveRecords(true).setOrderBy("AD_PrintFormat_ID");
        for (MPrintFormat pf : query.list()) {
            this.addMissingItems(pf);
        }
        return "@ProcessOK@ : " + this.no + " @AD_PrintFormatItem_ID@";
    }

    void addMissingItems(MPrintFormat pf) {
        pf.setLanguage(Language.getLanguage((String)this.p_language));
        ArrayList<Integer> listParams = new ArrayList<Integer>();
        listParams.add(pf.getAD_PrintFormat_ID());
        listParams.add(this.p_reportViewID);
        StringBuilder whereClause = new StringBuilder("");
        whereClause.append(" NOT EXISTS (SELECT * FROM AD_PrintFormatItem pfi").append(" WHERE pfi.AD_PrintFormat_ID = ?").append(" AND pfi.AD_Column_ID = AD_Column.AD_Column_ID)");
        if (this.p_source.equals(SOURCE_TABLE)) {
            whereClause.append(" AND AD_Column.AD_Table_ID = AD_ReportView.AD_Table_ID AND AD_ReportView.AD_ReportView_ID = ?");
        } else if (this.p_source.equals(SOURCE_RV_COLUMN)) {
            whereClause.append(" AND AD_ReportView_Column.AD_ReportView_ID = ? AND AD_ReportView.AD_ReportView_ID = ?");
            listParams.add(this.p_reportViewID);
        }
        Query query = new Query(this.getCtx(), "AD_Column", whereClause.toString(), this.get_TrxName()).addJoinClause("INNER JOIN AD_ReportView ON (AD_Column.AD_Table_ID = AD_ReportView.AD_Table_ID)").setParameters(listParams).setOnlyActiveRecords(true).setOrderBy("AD_Column.AD_Column_ID");
        if (this.p_source.equals(SOURCE_RV_COLUMN)) {
            query.addJoinClause("INNER JOIN AD_ReportView_Column ON (AD_Column.AD_Column_ID = AD_ReportView_Column.AD_Column_ID)");
        }
        int[] nArray = query.getIDs();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int columnID = nArray[n2];
            MPrintFormatItem pfi = MPrintFormatItem.createFromColumn((MPrintFormat)pf, (int)columnID, (int)0);
            this.statusUpdate(pf.getName() + " - " + pfi.getName());
            this.addLog(pfi.getAD_PrintFormatItem_ID(), null, null, pf.getName() + " - " + pfi.getName(), 489, pfi.getAD_PrintFormatItem_ID());
            ++this.no;
            ++n2;
        }
    }
}

