/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.process;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.base.Core;
import org.adempiere.base.IGridTabImporter;
import org.adempiere.base.annotation.Process;
import org.adempiere.base.equinox.EquinoxExtensionLocator;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.DataStatusListener;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridTable;
import org.compiere.model.GridWindow;
import org.compiere.model.MImportTemplate;
import org.compiere.model.MLookup;
import org.compiere.model.MProcessPara;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;

@Process
public class ImportCSVProcess
extends SvrProcess
implements DataStatusListener {
    private InputStream m_file_istream = null;
    private int p_AD_ImportTemplate_ID = 0;
    private MImportTemplate m_importTemplate;
    private String p_FileName = "";
    private String p_ImportMode = "I";
    GridWindow m_gridWindow = null;
    GridTab m_gridTab = null;
    List<GridTab> m_Childs = null;

    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        int n = processInfoParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoParameter para = processInfoParameterArray[n2];
            String name = para.getParameterName();
            if ("AD_ImportTemplate_ID".equals(name)) {
                this.p_AD_ImportTemplate_ID = para.getParameterAsInt();
            } else if ("FileName".equals(name)) {
                this.p_FileName = para.getParameterAsString();
            } else if ("ImportMode".equals(name)) {
                this.p_ImportMode = para.getParameterAsString();
            } else {
                MProcessPara.validateUnknownParameter((int)this.getProcessInfo().getAD_Process_ID(), (ProcessInfoParameter)para);
            }
            ++n2;
        }
    }

    protected String doIt() throws Exception {
        try {
            this.initGridTab();
            IGridTabImporter csvImport = this.initImporter();
            this.importFile(this.p_FileName, csvImport, this.m_gridTab, this.m_Childs);
        }
        finally {
            Env.clearWinContext((int)-1);
        }
        return "@OK@";
    }

    protected void initGridTab() throws Exception {
        this.m_importTemplate = new MImportTemplate(this.getCtx(), this.p_AD_ImportTemplate_ID, this.get_TrxName());
        int l_AD_Window_ID = this.m_importTemplate.getAD_Window_ID();
        int l_AD_Tab_ID = this.m_importTemplate.getAD_Tab_ID();
        if (!this.m_importTemplate.isAllowed(this.p_ImportMode, Env.getAD_Role_ID((Properties)Env.getCtx()))) {
            throw new AdempiereException(Msg.getMsg((Properties)this.getCtx(), (String)"TemplateNotAllowedRole"));
        }
        this.m_gridWindow = GridWindow.get((Properties)this.getCtx(), (int)-1, (int)l_AD_Window_ID);
        Env.setContext((Properties)this.getCtx(), (int)-1, (String)"IsSOTrx", (boolean)this.m_gridWindow.isSOTrx());
        this.m_Childs = new ArrayList<GridTab>();
        int i = 0;
        while (i < this.m_gridWindow.getTabCount()) {
            GridTab gridtab = this.m_gridWindow.getTab(i);
            if (!gridtab.isLoadComplete()) {
                this.m_gridWindow.initTab(i);
            }
            if (this.m_gridWindow.getTab(i).getAD_Tab_ID() == l_AD_Tab_ID) {
                this.m_gridTab = this.m_gridWindow.getTab(i);
            } else if (this.m_gridTab != null && gridtab.getTabLevel() > this.m_gridTab.getTabLevel()) {
                this.m_Childs.add(gridtab);
            }
            ++i;
        }
        if (this.m_gridTab == null) {
            throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"NoActiveTab"));
        }
        this.m_gridTab.addDataStatusListener((DataStatusListener)this);
        for (GridTab childTab : this.m_Childs) {
            childTab.addDataStatusListener((DataStatusListener)this);
        }
    }

    protected IGridTabImporter initImporter() throws Exception {
        IGridTabImporter csvImport = null;
        List importerList = EquinoxExtensionLocator.instance().list(IGridTabImporter.class).getExtensions();
        for (IGridTabImporter importer : importerList) {
            if (!"csv".equals(importer.getFileExtension())) continue;
            csvImport = importer;
            break;
        }
        if (csvImport == null) {
            throw new Exception(Msg.getMsg((Properties)this.getCtx(), (String)"NoCSVImporter"));
        }
        return csvImport;
    }

    protected void importFile(String filePath, IGridTabImporter csvImporter, GridTab activeTab, List<GridTab> childTabs) throws Exception {
        this.m_file_istream = new FileInputStream(filePath);
        this.m_file_istream = this.m_importTemplate.validateFile(this.m_file_istream);
        File outFile = csvImporter.fileImport(activeTab, childTabs, this.m_file_istream, Charset.forName(this.m_importTemplate.getCharacterSet()), this.p_ImportMode, this.m_importTemplate.getSeparatorChar(), this.m_importTemplate.getQuoteChar(), this.processUI);
        if (this.processUI != null) {
            this.processUI.download(outFile);
        } else if (this.getProcessInfo() != null) {
            ProcessInfo m_pi = this.getProcessInfo();
            m_pi.setExport(true);
            m_pi.setExportFile(outFile);
            m_pi.setExportFileExtension("csv");
        }
        this.m_file_istream.close();
    }

    public void dataStatusChanged(DataStatusEvent e) {
        GridField mField;
        GridTable gt;
        int col = e.getChangedColumn();
        if (col < 0) {
            return;
        }
        GridTab l_gridTab = null;
        if (e.getSource() != null && e.getSource() instanceof GridTable && (l_gridTab = this.m_gridWindow.getTab((gt = (GridTable)e.getSource()).getTabNo())).getAD_Table_ID() != e.AD_Table_ID) {
            throw new RuntimeException(Msg.getMsg((Properties)this.getCtx(), (String)"TableDoesntMatchWithUpdatedTab"));
        }
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("(" + String.valueOf(l_gridTab) + ") Col=" + col + ": " + e.toString());
        }
        if ((mField = l_gridTab.getField(col)) != null && (mField.getCallout().length() > 0 || Core.findCallout((String)l_gridTab.getTableName(), (String)mField.getColumnName()).size() > 0 || l_gridTab.hasDependants(mField.getColumnName()))) {
            String msg = l_gridTab.processFieldChange(mField);
            if (msg.length() > 0) {
                this.log.warning(msg);
            }
            for (GridField dependentField : l_gridTab.getDependantFields(mField.getColumnName())) {
                MLookup mLookup;
                if (dependentField == null || !(dependentField.getLookup() instanceof MLookup) || (mLookup = (MLookup)dependentField.getLookup()).getValidation().indexOf("@" + mField.getColumnName() + "@") == -1) continue;
                mLookup.refresh();
            }
        }
    }
}

