/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.base;

import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.Properties;
import org.adempiere.model.MRelationType;
import org.compiere.model.MBPartner;
import org.compiere.model.MClient;
import org.compiere.model.MInOut;
import org.compiere.model.MMailText;
import org.compiere.model.MOrder;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.model.PO;
import org.compiere.util.DefaultEvaluatee;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.Evaluator;
import org.compiere.util.Util;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EnvTest
extends AbstractTestCase {
    @Test
    public void testParseVariable() {
        MOrder order = new MOrder(Env.getCtx(), 100, this.getTrxName());
        String summary = order.getSummary();
        Object expr = "@=Summary@";
        String parsedText = Env.parseVariable((String)expr, (PO)order, (String)this.getTrxName(), (boolean)true, (boolean)true, (boolean)true);
        Assertions.assertEquals((Object)summary, (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        expr = "@=summary@";
        parsedText = Env.parseVariable((String)expr, (PO)order, (String)this.getTrxName(), (boolean)true, (boolean)true, (boolean)true);
        Assertions.assertEquals((Object)summary, (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        String docNo = order.getDocumentNo();
        expr = "@DocumentNo@";
        parsedText = Env.parseVariable((String)expr, (PO)order, (String)this.getTrxName(), (boolean)true, (boolean)true, (boolean)true);
        Assertions.assertEquals((Object)docNo, (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        String dateOrdered = DisplayType.getDateFormat((int)MTable.get((int)259).getColumn("DateOrdered").getAD_Reference_ID()).format(order.getDateOrdered());
        expr = "@DateOrdered@";
        parsedText = Env.parseVariable((String)expr, (PO)order, (String)this.getTrxName(), (boolean)true, (boolean)true, (boolean)true);
        Assertions.assertEquals((Object)dateOrdered, (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        dateOrdered = sdf.format(order.getDateOrdered());
        expr = "@DateOrdered<" + sdf.toPattern() + ">@";
        parsedText = Env.parseVariable((String)expr, (PO)order, (String)this.getTrxName(), (boolean)true, (boolean)true, (boolean)true);
        Assertions.assertEquals((Object)dateOrdered, (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        String clientId = Env.getContext((Properties)Env.getCtx(), (String)"#AD_Client_ID");
        expr = "@#AD_Client_ID@";
        parsedText = Env.parseVariable((String)expr, (PO)order, (String)this.getTrxName(), (boolean)true, (boolean)true, (boolean)true);
        Assertions.assertEquals((Object)clientId, (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        String clientName = MClient.get((int)this.getAD_Client_ID()).getName();
        expr = "@#AD_Client_ID<Name>@";
        parsedText = Env.parseVariable((String)expr, (PO)order, (String)this.getTrxName(), (boolean)true, (boolean)true, (boolean)true);
        Assertions.assertEquals((Object)clientName, (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        expr = "@#AD_Client_ID.Name@";
        parsedText = Env.parseVariable((String)expr, (PO)order, (String)this.getTrxName(), (boolean)true, (boolean)true, (boolean)true);
        Assertions.assertEquals((Object)clientName, (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        String bpartnerValue = MBPartner.get((Properties)Env.getCtx(), (int)order.getC_BPartner_ID()).getValue();
        expr = "@C_BPartner_ID<Value>@";
        parsedText = Env.parseVariable((String)expr, (PO)order, (String)this.getTrxName(), (boolean)true, (boolean)true, (boolean)true);
        Assertions.assertEquals((Object)bpartnerValue, (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        expr = "@C_BPartner_ID:0<Value>@";
        parsedText = Env.parseVariable((String)expr, (PO)order, (String)this.getTrxName(), (boolean)true, (boolean)true, (boolean)true);
        Assertions.assertEquals((Object)bpartnerValue, (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        expr = "@C_BPartner_ID.Value@";
        parsedText = Env.parseVariable((String)expr, (PO)order, (String)this.getTrxName(), (boolean)true, (boolean)true, (boolean)true);
        Assertions.assertEquals((Object)bpartnerValue, (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        expr = "@C_BPartner_ID:0.Value@";
        parsedText = Env.parseVariable((String)expr, (PO)order, (String)this.getTrxName(), (boolean)true, (boolean)true, (boolean)true);
        Assertions.assertEquals((Object)bpartnerValue, (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        String docStatusName = order.getDocStatusName();
        expr = "@DocStatus<Name>@";
        parsedText = Env.parseVariable((String)expr, (PO)order, (String)this.getTrxName(), (boolean)true, (boolean)true, (boolean)true);
        Assertions.assertEquals((Object)docStatusName, (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        expr = "test@@mail.com";
        parsedText = Env.parseVariable((String)expr, null, (String)this.getTrxName(), (boolean)true, (boolean)true, (boolean)true);
        Assertions.assertEquals((Object)"test@mail.com", (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        expr = "test@@mail.com";
        expr = Env.parseVariable((String)expr, null, (String)this.getTrxName(), (boolean)true, (boolean)true, (boolean)true, (boolean)true);
        Assertions.assertEquals((Object)"test@@mail.com", (Object)expr, (String)("Unexpected parsed text for " + (String)expr + " with keepEscapeSequence=true"));
        parsedText = Env.parseVariable((String)expr, null, (String)this.getTrxName(), (boolean)true, (boolean)true, (boolean)true, (boolean)false);
        Assertions.assertEquals((Object)"test@mail.com", (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr + " with keepEscapeSequence=false"));
        expr = "@C_Order_ID<C_Order.DocumentNo>@";
        parsedText = Env.parseVariable((String)expr, (PO)order, (String)this.getTrxName(), (boolean)true, (boolean)true, (boolean)true);
        Assertions.assertEquals((Object)order.getDocumentNo(), (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
    }

    @Test
    public void testParseContext() {
        String parsedText = Env.parseContext((Properties)Env.getCtx(), (int)0, (String)"@#AD_Client_ID@", (boolean)false);
        Assertions.assertEquals((Object)Env.getContext((Properties)Env.getCtx(), (String)"#AD_Client_ID"), (Object)parsedText, (String)"Unexpected parseContext value");
        Env.setContext((Properties)Env.getCtx(), (int)1, (String)"AnInt", (int)1);
        parsedText = Env.parseContext((Properties)Env.getCtx(), (int)1, (String)"@AnInt@", (boolean)true);
        Assertions.assertEquals((Object)"1", (Object)parsedText, (String)"Unexpected parseContext value");
        parsedText = Env.parseContext((Properties)Env.getCtx(), (int)1, (int)1, (String)"@AnInt@", (boolean)true);
        Assertions.assertTrue((boolean)Util.isEmpty((String)parsedText), (String)"Unexpected parseContext value");
        parsedText = Env.parseContext((Properties)Env.getCtx(), (int)1, (int)1, (String)"@AnInt@", (boolean)false, (boolean)true);
        Assertions.assertEquals((Object)"1", (Object)parsedText, (String)"Unexpected parseContext value");
        parsedText = Env.parseContext((Properties)Env.getCtx(), (int)1, (String)"@1|AnInt@", (boolean)true);
        Assertions.assertEquals((Object)"1", (Object)parsedText, (String)"Unexpected parseContext value");
        parsedText = Env.parseContext((Properties)Env.getCtx(), (int)1, (int)1, (String)"@1|AnInt@", (boolean)true, (boolean)true);
        Assertions.assertTrue((boolean)Util.isEmpty((String)parsedText), (String)"Unexpected parseContext value");
        Env.setContext((Properties)Env.getCtx(), (int)1, (String)"AnInt", null);
        Env.setContext((Properties)Env.getCtx(), (int)1, (int)1, (String)"AnInt", (int)1);
        parsedText = Env.parseContext((Properties)Env.getCtx(), (int)1, (String)"@AnInt@", (boolean)true);
        Assertions.assertTrue((boolean)Util.isEmpty((String)parsedText), (String)"Unexpected parseContext value");
        parsedText = Env.parseContext((Properties)Env.getCtx(), (int)1, (int)1, (String)"@AnInt@", (boolean)true, (boolean)true);
        Assertions.assertEquals((Object)"1", (Object)parsedText, (String)"Unexpected parseContext value");
        Env.setContext((Properties)Env.getCtx(), (int)1, (String)"EMail", (String)"test@idempiere.com");
        parsedText = Env.parseContext((Properties)Env.getCtx(), (int)1, (String)"@EMail@='test@@idempiere.com'", (boolean)true, (boolean)true);
        Assertions.assertEquals((Object)"test@idempiere.com='test@idempiere.com'", (Object)parsedText, (String)"Unexpected parseContext value");
        parsedText = Env.parseContext((Properties)Env.getCtx(), (int)1, (String)"@EMail@='test@@idempiere.com'", (boolean)true, (boolean)true, (boolean)false);
        Assertions.assertEquals((Object)"test@idempiere.com='test@idempiere.com'", (Object)parsedText, (String)"Unexpected parseContext value");
        parsedText = Env.parseContext((Properties)Env.getCtx(), (int)1, (String)"@EMail@='test@@idempiere.com'", (boolean)true, (boolean)true, (boolean)true);
        Assertions.assertEquals((Object)"test@idempiere.com='test@@idempiere.com'", (Object)parsedText, (String)"Unexpected parseContext value");
        Evaluatee contextEvaluatee = v -> Env.getContext((Properties)Env.getCtx(), (int)1, (String)v);
        boolean evaluation = Evaluator.evaluateLogic((Evaluatee)contextEvaluatee, (String)"@EMail@='test@idempiere.com'");
        Assertions.assertTrue((boolean)evaluation, (String)"Unexpected logic evaluation result");
        evaluation = Evaluator.evaluateLogic((Evaluatee)contextEvaluatee, (String)"@EMail@=test@idempiere.com");
        Assertions.assertTrue((boolean)evaluation, (String)"Unexpected logic evaluation result");
        evaluation = Evaluator.evaluateLogic((Evaluatee)contextEvaluatee, (String)"@EMail@=test1@idempiere.com");
        Assertions.assertFalse((boolean)evaluation, (String)"Unexpected logic evaluation result");
        String clientName = MClient.get((int)this.getAD_Client_ID()).getName();
        Object expr = "@#AD_Client_ID<Name>@";
        parsedText = Env.parseContext((Properties)Env.getCtx(), (int)1, (String)expr, (boolean)false);
        Assertions.assertEquals((Object)clientName, (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        expr = "@#AD_Client_ID.Name@";
        parsedText = Env.parseContext((Properties)Env.getCtx(), (int)1, (String)expr, (boolean)false);
        Assertions.assertEquals((Object)clientName, (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        String bpartnerValue = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id).getValue();
        Env.setContext((Properties)Env.getCtx(), (int)1, (String)"C_BPartner_ID", (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id);
        expr = "@C_BPartner_ID<Value>@";
        parsedText = Env.parseContext((Properties)Env.getCtx(), (int)1, (String)expr, (boolean)true);
        Assertions.assertEquals((Object)bpartnerValue, (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        expr = "@C_BPartner_ID.Value@";
        parsedText = Env.parseContext((Properties)Env.getCtx(), (int)1, (String)expr, (boolean)true);
        Assertions.assertEquals((Object)bpartnerValue, (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        expr = "@C_BPartner_ID:0<Value>@";
        parsedText = Env.parseContext((Properties)Env.getCtx(), (int)1, (String)expr, (boolean)true);
        Assertions.assertEquals((Object)bpartnerValue, (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        expr = "@C_BPartner_ID:0.Value@";
        parsedText = Env.parseContext((Properties)Env.getCtx(), (int)1, (String)expr, (boolean)true);
        Assertions.assertEquals((Object)bpartnerValue, (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        Env.setContext((Properties)Env.getCtx(), (int)1, (String)"C_BPartner_ID", (String)"");
        Env.setContext((Properties)Env.getCtx(), (int)1, (int)1, (String)"C_BPartner_ID", (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id);
        expr = "@C_BPartner_ID<Value>@";
        parsedText = Env.parseContext((Properties)Env.getCtx(), (int)1, (int)1, (String)expr, (boolean)true);
        Assertions.assertEquals((Object)bpartnerValue, (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        expr = "@C_BPartner_ID.Value@";
        parsedText = Env.parseContext((Properties)Env.getCtx(), (int)1, (int)1, (String)expr, (boolean)true);
        Assertions.assertEquals((Object)bpartnerValue, (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        expr = "@C_BPartner_ID:0<Value>@";
        parsedText = Env.parseContext((Properties)Env.getCtx(), (int)1, (int)1, (String)expr, (boolean)true);
        Assertions.assertEquals((Object)bpartnerValue, (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        expr = "@C_BPartner_ID:0.Value@";
        parsedText = Env.parseContext((Properties)Env.getCtx(), (int)1, (int)1, (String)expr, (boolean)true);
        Assertions.assertEquals((Object)bpartnerValue, (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        expr = "@1|C_BPartner_ID<Value>@";
        parsedText = Env.parseContext((Properties)Env.getCtx(), (int)1, (int)-1, (String)expr, (boolean)false, (boolean)true);
        Assertions.assertEquals((Object)bpartnerValue, (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        expr = "@1|C_BPartner_ID.Value@";
        parsedText = Env.parseContext((Properties)Env.getCtx(), (int)1, (int)-1, (String)expr, (boolean)false, (boolean)true);
        Assertions.assertEquals((Object)bpartnerValue, (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        expr = "@1|C_BPartner_ID:0<Value>@";
        parsedText = Env.parseContext((Properties)Env.getCtx(), (int)1, (int)-1, (String)expr, (boolean)false, (boolean)true);
        Assertions.assertEquals((Object)bpartnerValue, (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        expr = "@1|C_BPartner_ID:0.Value@";
        parsedText = Env.parseContext((Properties)Env.getCtx(), (int)1, (int)-1, (String)expr, (boolean)false, (boolean)true);
        Assertions.assertEquals((Object)bpartnerValue, (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        DefaultEvaluatee evaluatee = new DefaultEvaluatee(null, 1, 1, true);
        expr = "@C_BPartner_ID<Value>@='" + bpartnerValue + "'";
        evaluation = Evaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr);
        Assertions.assertTrue((boolean)evaluation, (String)"Unexpected logic evaluation result");
        expr = "@C_BPartner_ID.Value@='" + bpartnerValue + "'";
        evaluation = Evaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr);
        Assertions.assertTrue((boolean)evaluation, (String)"Unexpected logic evaluation result");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String created = sdf.format(MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.JOE_BLOCK.id).getCreated());
        expr = "@C_BPartner_ID.Created<yyyy-MM-dd>@='" + created + "'";
        evaluation = Evaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr);
        Assertions.assertTrue((boolean)evaluation, (String)"Unexpected logic evaluation result");
        expr = "@C_BPartner_ID:0.Created<yyyy-MM-dd>@='" + created + "'";
        evaluation = Evaluator.evaluateLogic((Evaluatee)evaluatee, (String)expr);
        Assertions.assertTrue((boolean)evaluation, (String)"Unexpected logic evaluation result");
        expr = "@AD_Client_ID@";
        parsedText = Env.parseContext((Properties)Env.getCtx(), (int)-1, (String)expr, (boolean)false, (boolean)true);
        Assertions.assertEquals((Object)"11", (Object)parsedText, (String)("Unexpected parsed text for " + (String)expr));
        Properties ctx = new Properties();
        ctx.putAll((Map<?, ?>)Env.getCtx());
        String customValue = "MyCustomValue";
        String customVariable = "CustomVariable";
        Env.setContext((Properties)ctx, (String)customVariable, (String)customValue);
        parsedText = Env.parseContext((Properties)ctx, (int)-1, (String)("@" + customVariable + "@"), (boolean)false, (boolean)false);
        Assertions.assertEquals((Object)customValue, (Object)parsedText, (String)"Failed to get value from custom context");
        expr = "C_BPartner.C_BPartner_ID=@C_BPartner_ID@";
        MInOut inout = new MInOut(Env.getCtx(), 100, null);
        parsedText = MRelationType.parseWhereClause((PO)inout, (String)expr);
        Assertions.assertEquals((Object)("C_BPartner.C_BPartner_ID=" + inout.getC_BPartner_ID()), (Object)parsedText, (String)"Failed to get value from custom context");
        expr = "C_BPartner.C_BPartner_ID=@#C_BPartner_ID@";
        parsedText = MRelationType.parseWhereClause((PO)inout, (String)expr);
        Assertions.assertEquals((Object)("C_BPartner.C_BPartner_ID=" + inout.getC_BPartner_ID()), (Object)parsedText, (String)"Failed to get value from custom context");
        Env.setContext((Properties)Env.getCtx(), (String)"#NonExisting_AD_Org_ID", (int)0);
        Env.setContext((Properties)Env.getCtx(), (int)-1, (String)"NonExisting_AD_Org_ID", (int)11);
        Env.setContext((Properties)Env.getCtx(), (int)-1, (int)0, (String)"NonExisting_AD_Org_ID", (int)11);
        String validationCode = "M_Warehouse.AD_Org_ID=@NonExisting_AD_Org_ID@";
        String dynamicValid = Env.parseContext((Properties)Env.getCtx(), (int)-1, (int)0, (String)validationCode, (boolean)false);
        Assertions.assertEquals((Object)"M_Warehouse.AD_Org_ID=11", (Object)dynamicValid, (String)("Unexpected parsed text for " + validationCode));
    }

    @Test
    public void testParseMailText() {
        String mailText = "Hello @Name@\n\nHere is some text\n\nContact us at: test@@test.com\n\nor to this another mail test2@@test.com";
        MMailText mMailText = new MMailText(Env.getCtx(), 0, this.getTrxName());
        mMailText.setMailHeader("Mail Header");
        mMailText.setMailText(mailText);
        MBPartner bPartner = MBPartner.get((Properties)Env.getCtx(), (int)DictionaryIDs.C_BPartner.SEED_FARM.id);
        mMailText.setBPartner(bPartner);
        MUser[] contacts = bPartner.getContacts(true);
        mMailText.setUser(contacts[0]);
        String parsedText = mMailText.getMailText();
        String expectedText = "Hello %s\n\nHere is some text\n\nContact us at: test@test.com\n\nor to this another mail test2@test.com".formatted(contacts[0].getName());
        Assertions.assertEquals((Object)expectedText, (Object)parsedText, (String)"Unexpected parsed mail text");
    }
}

