/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.base;

import java.util.Arrays;
import java.util.Collection;
import org.compiere.util.EMail;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class EmailFormatValidatorTest {
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{"javacodegeeks@gmail.com.2j", true}, {"java@java@oracle.com", false}, {"java!!!@example.com", true}, {"mysite@.com", false}, {"javacodegees.com", false}, {".javacodegees.com@at.com", false}, {"javacodegees..javacom@at.com", false}, {"javacodegeeks@gmail.com", true}, {"nikos+mylist@gmail.com", true}, {"abc.efg-900@gmail-list.com", true}, {"abc123@example.com.gr", true}, {"username+detail@example.com", true}, {"user@example.museum", true}, {"myemail+sketchysite@gmail.com", true}, {"micky.o'finnagan@wherever.com", true}, {"exampleemail@testing.info", true}, {"marcelo.calbucci%mandic@fapesp.com.br", true}, {"customer/department=shipping@example.com", true}, {"$A12345@example.com", true}, {"!def!xyz%abc@example.com", true}, {"_somename@example.com", true}, {"nu\u00f1ez@globalqss.com", true}, {"name@tld", true}, {"john@server.department.company.com", true}};
        return Arrays.asList(data);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void test(String arg, Boolean expectedValidation) {
        Boolean res = EMail.validate((String)arg);
        Assertions.assertEquals((Object)expectedValidation, (Object)res, (String)"Result");
    }
}

