/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.test.model;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.model.MProduct;
import org.compiere.model.MStorageOnHand;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ServerProcessCtl;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.idempiere.test.AbstractTestCase;
import org.idempiere.test.DictionaryIDs;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
public class MStorageOnHandTestIsolated
extends AbstractTestCase {
    @Test
    public void testStorageCleanUp() {
        MProduct product = new MProduct(Env.getCtx(), 0, this.getTrxName());
        product.setName("testStorageCleanUp");
        product.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.FERTILIZER_LOT.id);
        product.setIsStocked(true);
        product.setProductType("I");
        product.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
        product.setM_Product_Category_ID(DictionaryIDs.M_Product_Category.CHEMICALS.id);
        product.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
        product.saveEx();
        Timestamp today = TimeUtil.getDay(null);
        MStorageOnHand.add((Properties)Env.getCtx(), (int)DictionaryIDs.M_Locator.HQ.id, (int)product.get_ID(), (int)0, (BigDecimal)new BigDecimal("2"), (Timestamp)today, (String)this.getTrxName());
        Query query = new Query(Env.getCtx(), "M_StorageOnHand", "M_Product_ID=?", this.getTrxName());
        int count = query.setParameters(new Object[]{product.get_ID()}).count();
        Assertions.assertEquals((int)1, (int)count);
        MStorageOnHand.add((Properties)Env.getCtx(), (int)DictionaryIDs.M_Locator.HQ.id, (int)product.get_ID(), (int)0, (BigDecimal)new BigDecimal("-2"), (Timestamp)today, (String)this.getTrxName());
        DB.executeUpdateEx((String)"UPDATE M_StorageOnHand SET Created=? WHERE M_Product_ID=?", (Object[])new Object[]{TimeUtil.addDays((Timestamp)today, (int)-7), product.get_ID()}, (String)this.getTrxName());
        query = new Query(Env.getCtx(), "M_StorageOnHand", "M_Product_ID=?", this.getTrxName());
        count = query.setParameters(new Object[]{product.get_ID()}).count();
        Assertions.assertEquals((int)1, (int)count);
        MProduct product1 = new MProduct(Env.getCtx(), 0, null);
        product1.setName("testStorageCleanUp#1");
        product1.setValue(product1.getName());
        product1.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.FERTILIZER_LOT.id);
        product1.setIsStocked(true);
        product1.setProductType("I");
        product1.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
        product1.setM_Product_Category_ID(DictionaryIDs.M_Product_Category.CHEMICALS.id);
        product1.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
        product1.saveEx();
        try {
            MAttributeSetInstance asi1 = new MAttributeSetInstance(Env.getCtx(), 0, this.getTrxName());
            asi1.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.FERTILIZER_LOT.id);
            asi1.setLot("Lot1");
            asi1.saveEx();
            MStorageOnHand.add((Properties)Env.getCtx(), (int)DictionaryIDs.M_Locator.HQ.id, (int)product1.get_ID(), (int)asi1.get_ID(), (BigDecimal)new BigDecimal("-1"), (Timestamp)today, (String)this.getTrxName());
            MStorageOnHand.add((Properties)Env.getCtx(), (int)DictionaryIDs.M_Locator.HQ.id, (int)product1.get_ID(), (int)0, (BigDecimal)new BigDecimal("1"), (Timestamp)today, (String)this.getTrxName());
            query = new Query(Env.getCtx(), "M_StorageOnHand", "M_Product_ID=? AND M_AttributeSetInstance_ID=?", this.getTrxName());
            MStorageOnHand onhand = (MStorageOnHand)query.setParameters(new Object[]{product1.get_ID(), asi1.get_ID()}).first();
            Assertions.assertNotNull((Object)onhand);
            Assertions.assertEquals((int)-1, (int)onhand.getQtyOnHand().intValue());
            query = new Query(Env.getCtx(), "M_StorageOnHand", "M_Product_ID=? AND M_AttributeSetInstance_ID=?", this.getTrxName());
            onhand = (MStorageOnHand)query.setParameters(new Object[]{product1.get_ID(), 0}).first();
            Assertions.assertNotNull((Object)onhand);
            Assertions.assertEquals((int)1, (int)onhand.getQtyOnHand().intValue());
            MProduct product2 = new MProduct(Env.getCtx(), 0, this.getTrxName());
            product2.setName("testStorageCleanUp#2");
            product2.setValue(product2.getName());
            product2.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.FERTILIZER_LOT.id);
            product2.setIsStocked(true);
            product2.setProductType("I");
            product2.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            product2.setM_Product_Category_ID(DictionaryIDs.M_Product_Category.CHEMICALS.id);
            product2.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
            product2.saveEx();
            MAttributeSetInstance asi2 = new MAttributeSetInstance(Env.getCtx(), 0, this.getTrxName());
            asi2.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.FERTILIZER_LOT.id);
            asi2.setLot("LotX");
            asi2.saveEx();
            MStorageOnHand.add((Properties)Env.getCtx(), (int)DictionaryIDs.M_Locator.HQ.id, (int)product2.get_ID(), (int)asi2.get_ID(), (BigDecimal)new BigDecimal("-1"), (Timestamp)today, (String)this.getTrxName());
            MAttributeSetInstance asi3 = new MAttributeSetInstance(Env.getCtx(), 0, this.getTrxName());
            asi3.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.FERTILIZER_LOT.id);
            asi3.setLot("LotY");
            asi3.saveEx();
            MStorageOnHand.add((Properties)Env.getCtx(), (int)DictionaryIDs.M_Locator.HQ.id, (int)product2.get_ID(), (int)asi3.get_ID(), (BigDecimal)new BigDecimal("1"), (Timestamp)today, (String)this.getTrxName());
            query = new Query(Env.getCtx(), "M_StorageOnHand", "M_Product_ID=? AND M_AttributeSetInstance_ID=?", this.getTrxName());
            onhand = (MStorageOnHand)query.setParameters(new Object[]{product2.get_ID(), asi2.get_ID()}).first();
            Assertions.assertNotNull((Object)onhand);
            Assertions.assertEquals((int)-1, (int)onhand.getQtyOnHand().intValue());
            query = new Query(Env.getCtx(), "M_StorageOnHand", "M_Product_ID=? AND M_AttributeSetInstance_ID=?", this.getTrxName());
            onhand = (MStorageOnHand)query.setParameters(new Object[]{product2.get_ID(), asi3.get_ID()}).first();
            Assertions.assertNotNull((Object)onhand);
            Assertions.assertEquals((int)1, (int)onhand.getQtyOnHand().intValue());
            MProduct product3 = new MProduct(Env.getCtx(), 0, this.getTrxName());
            product3.setName("testStorageCleanUp#3");
            product3.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.FERTILIZER_LOT.id);
            product3.setIsStocked(true);
            product3.setProductType("I");
            product3.setC_UOM_ID(DictionaryIDs.C_UOM.EACH.id);
            product3.setM_Product_Category_ID(DictionaryIDs.M_Product_Category.CHEMICALS.id);
            product3.setC_TaxCategory_ID(DictionaryIDs.C_TaxCategory.STANDARD.id);
            product3.saveEx();
            MAttributeSetInstance asi4 = new MAttributeSetInstance(Env.getCtx(), 0, this.getTrxName());
            asi4.setM_AttributeSet_ID(DictionaryIDs.M_AttributeSet.FERTILIZER_LOT.id);
            asi4.setSerNo(product3.getName() + "SerialNo#1");
            asi4.saveEx();
            MStorageOnHand.add((Properties)Env.getCtx(), (int)DictionaryIDs.M_Locator.HQ.id, (int)product3.get_ID(), (int)asi4.get_ID(), (BigDecimal)new BigDecimal("1"), (Timestamp)today, (String)this.getTrxName());
            query = new Query(Env.getCtx(), "M_StorageOnHand", "M_Product_ID=?", this.getTrxName());
            count = query.setParameters(new Object[]{product3.get_ID()}).count();
            Assertions.assertEquals((int)1, (int)count);
            MStorageOnHand.add((Properties)Env.getCtx(), (int)DictionaryIDs.M_Locator.HQ.id, (int)product3.get_ID(), (int)asi4.get_ID(), (BigDecimal)new BigDecimal("-1"), (Timestamp)today, (String)this.getTrxName());
            DB.executeUpdateEx((String)"UPDATE M_StorageOnHand SET Created=? WHERE M_Product_ID=?", (Object[])new Object[]{TimeUtil.addDays((Timestamp)today, (int)-7), product3.get_ID()}, (String)this.getTrxName());
            query = new Query(Env.getCtx(), "M_StorageOnHand", "M_Product_ID=?", this.getTrxName());
            count = query.setParameters(new Object[]{product3.get_ID()}).count();
            Assertions.assertEquals((int)1, (int)count);
            MPInstance instance = new MPInstance(Env.getCtx(), 325, 0, 0, null);
            instance.saveEx();
            MPInstancePara para = new MPInstancePara(instance, 10);
            para.setParameterName("C_DocType_ID");
            para.setP_Number(DictionaryIDs.C_DocType.MATERIAL_MOVEMENT.id);
            para.saveEx();
            MProcess process = MProcess.get((Properties)Env.getCtx(), (int)325);
            ProcessInfo pi = new ProcessInfo(process.getName(), process.get_ID());
            pi.setAD_PInstance_ID(instance.get_ID());
            pi.setAD_Client_ID(this.getAD_Client_ID());
            pi.setAD_User_ID(this.getAD_User_ID());
            pi.setTransactionName(this.getTrxName());
            ServerProcessCtl.process((ProcessInfo)pi, (Trx)this.getTrx(), (boolean)false);
            Assertions.assertFalse((boolean)pi.isError(), (String)pi.getSummary());
            query = new Query(Env.getCtx(), "M_StorageOnHand", "M_Product_ID=?", this.getTrxName());
            count = query.setParameters(new Object[]{product.get_ID()}).count();
            Assertions.assertEquals((int)0, (int)count);
            query = new Query(Env.getCtx(), "M_StorageOnHand", "M_Product_ID=?", this.getTrxName());
            List onhands = query.setParameters(new Object[]{product3.get_ID()}).list();
            Assertions.assertEquals((int)1, (int)onhands.size());
            Assertions.assertEquals((int)0, (int)((MStorageOnHand)onhands.get(0)).getQtyOnHand().intValue());
            Assertions.assertEquals((int)asi4.get_ID(), (int)((MStorageOnHand)onhands.get(0)).getM_AttributeSetInstance_ID());
            query = new Query(Env.getCtx(), "M_StorageOnHand", "M_Product_ID=? AND M_AttributeSetInstance_ID=?", this.getTrxName());
            onhand = (MStorageOnHand)query.setParameters(new Object[]{product1.get_ID(), asi1.get_ID()}).first();
            Assertions.assertNotNull((Object)onhand);
            Assertions.assertEquals((int)0, (int)onhand.getQtyOnHand().intValue());
            query = new Query(Env.getCtx(), "M_StorageOnHand", "M_Product_ID=? AND M_AttributeSetInstance_ID=?", this.getTrxName());
            onhand = (MStorageOnHand)query.setParameters(new Object[]{product1.get_ID(), 0}).first();
            Assertions.assertNotNull((Object)onhand);
            Assertions.assertEquals((int)0, (int)onhand.getQtyOnHand().intValue());
            query = new Query(Env.getCtx(), "M_StorageOnHand", "M_Product_ID=? AND M_AttributeSetInstance_ID=?", this.getTrxName());
            onhand = (MStorageOnHand)query.setParameters(new Object[]{product2.get_ID(), asi2.get_ID()}).first();
            Assertions.assertNotNull((Object)onhand);
            Assertions.assertEquals((int)-1, (int)onhand.getQtyOnHand().intValue());
            query = new Query(Env.getCtx(), "M_StorageOnHand", "M_Product_ID=? AND M_AttributeSetInstance_ID=?", this.getTrxName());
            onhand = (MStorageOnHand)query.setParameters(new Object[]{product2.get_ID(), asi3.get_ID()}).first();
            Assertions.assertNotNull((Object)onhand);
            Assertions.assertEquals((int)1, (int)onhand.getQtyOnHand().intValue());
        }
        finally {
            this.getTrx().rollback();
            product1.deleteEx(true);
        }
    }
}

