/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestFactory;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.support.AnnotationConsumer;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.StringUtils;

class MethodArgumentsProvider
implements ArgumentsProvider,
AnnotationConsumer<MethodSource> {
    private String[] methodNames;

    MethodArgumentsProvider() {
    }

    @Override
    public void accept(MethodSource annotation) {
        this.methodNames = annotation.value();
    }

    public Stream<Arguments> provideArguments(ExtensionContext context) {
        Object testInstance = context.getTestInstance().orElse(null);
        return Arrays.stream(this.methodNames).map(factoryMethodName -> this.getFactoryMethod(context, (String)factoryMethodName)).map(factoryMethod -> context.getExecutableInvoker().invoke(factoryMethod, testInstance)).flatMap(CollectionUtils::toStream).map(MethodArgumentsProvider::toArguments);
    }

    private Method getFactoryMethod(ExtensionContext context, String factoryMethodName) {
        Method testMethod = context.getRequiredTestMethod();
        if (StringUtils.isBlank((String)factoryMethodName)) {
            factoryMethodName = testMethod.getName();
        }
        if (factoryMethodName.contains(".") || factoryMethodName.contains("#")) {
            return this.getFactoryMethodByFullyQualifiedName(factoryMethodName);
        }
        return this.getFactoryMethodBySimpleName(context.getRequiredTestClass(), testMethod, factoryMethodName);
    }

    private Method getFactoryMethodByFullyQualifiedName(String fullyQualifiedMethodName) {
        String[] methodParts = ReflectionUtils.parseFullyQualifiedMethodName((String)fullyQualifiedMethodName);
        String className = methodParts[0];
        String methodName = methodParts[1];
        String methodParameters = methodParts[2];
        return (Method)ReflectionUtils.findMethod(this.loadRequiredClass(className), (String)methodName, (String)methodParameters).orElseThrow(() -> new JUnitException(String.format("Could not find factory method [%s(%s)] in class [%s]", methodName, methodParameters, className)));
    }

    private Method getFactoryMethodBySimpleName(Class<?> testClass, Method testMethod, String factoryMethodName) {
        Predicate<Method> isCandidate = candidate -> factoryMethodName.equals(candidate.getName()) && !testMethod.equals(candidate);
        List candidates = ReflectionUtils.findMethods(testClass, isCandidate);
        Predicate<Method> isFactoryMethod = method -> CollectionUtils.isConvertibleToStream(method.getReturnType()) && !this.isTestMethod((Method)method);
        List factoryMethods = candidates.stream().filter(isFactoryMethod).collect(Collectors.toList());
        Preconditions.condition((factoryMethods.size() > 0 ? 1 : 0) != 0, () -> {
            if (candidates.size() > 0) {
                return String.format("Could not find valid factory method [%s] in class [%s] but found the following invalid candidates: %s", factoryMethodName, testClass.getName(), candidates);
            }
            return String.format("Could not find factory method [%s] in class [%s]", factoryMethodName, testClass.getName());
        });
        Preconditions.condition((factoryMethods.size() == 1 ? 1 : 0) != 0, () -> String.format("%d factory methods named [%s] were found in class [%s]: %s", factoryMethods.size(), factoryMethodName, testClass.getName(), factoryMethods));
        return (Method)factoryMethods.get(0);
    }

    private boolean isTestMethod(Method candidate) {
        return AnnotationUtils.isAnnotated((AnnotatedElement)candidate, Test.class) || AnnotationUtils.isAnnotated((AnnotatedElement)candidate, TestTemplate.class) || AnnotationUtils.isAnnotated((AnnotatedElement)candidate, TestFactory.class);
    }

    private Class<?> loadRequiredClass(String className) {
        return (Class)ReflectionUtils.tryToLoadClass((String)className).getOrThrow(cause -> new JUnitException(String.format("Could not load class [%s]", className), (Throwable)cause));
    }

    private static Arguments toArguments(Object item) {
        if (item instanceof Arguments) {
            return (Arguments)item;
        }
        if (ReflectionUtils.isMultidimensionalArray((Object)item)) {
            return Arguments.arguments(item);
        }
        if (item instanceof Object[]) {
            return Arguments.arguments((Object[])item);
        }
        return Arguments.arguments(item);
    }
}

