/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.agent;

import com.sun.jna.LastErrorException;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.StdCallLibrary;
import com.sun.jna.win32.W32APIOptions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.FileLock;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.bytebuddy.agent.utility.nullability.MaybeNull;
import net.bytebuddy.agent.utility.nullability.UnknownNull;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface VirtualMachine {
    public Properties getSystemProperties() throws IOException;

    public Properties getAgentProperties() throws IOException;

    public void loadAgent(String var1) throws IOException;

    public void loadAgent(String var1, @MaybeNull String var2) throws IOException;

    public void loadAgentPath(String var1) throws IOException;

    public void loadAgentPath(String var1, @MaybeNull String var2) throws IOException;

    public void loadAgentLibrary(String var1) throws IOException;

    public void loadAgentLibrary(String var1, @MaybeNull String var2) throws IOException;

    public void startManagementAgent(Properties var1) throws IOException;

    public String startLocalManagementAgent() throws IOException;

    public void detach() throws IOException;

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class ForOpenJ9
    extends AbstractBase {
        private static final String IBM_TEMPORARY_FOLDER = "com.ibm.tools.attach.directory";
        private static final SecureRandom SECURE_RANDOM = new SecureRandom();
        private final Socket socket;

        protected ForOpenJ9(Socket socket) {
            this.socket = socket;
        }

        public static VirtualMachine attach(String processId) throws IOException {
            return ForOpenJ9.attach(processId, 5000, Platform.isWindows() ? new Dispatcher.ForJnaWindowsEnvironment() : new Dispatcher.ForJnaPosixEnvironment(15, 100L, TimeUnit.MILLISECONDS));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static VirtualMachine attach(String processId, int timeout, Dispatcher dispatcher) throws IOException {
            File directory = new File(System.getProperty(IBM_TEMPORARY_FOLDER, dispatcher.getTemporaryFolder(processId)), ".com_ibm_tools_attach");
            long userId = dispatcher.userId();
            try (RandomAccessFile attachLock = new RandomAccessFile(new File(directory, "_attachlock"), "rw");){
                FileLock attachLockLock = attachLock.getChannel().lock();
                try {
                    ArrayList<Properties> virtualMachines;
                    try (RandomAccessFile master = new RandomAccessFile(new File(directory, "_master"), "rw");){
                        FileLock masterLock = master.getChannel().lock();
                        try {
                            File[] vmFolder = directory.listFiles();
                            if (vmFolder == null) {
                                throw new IllegalStateException("No descriptor files found in " + directory);
                            }
                            virtualMachines = new ArrayList<Properties>();
                            for (File aVmFolder : vmFolder) {
                                long targetUserId;
                                File attachInfo;
                                if (!aVmFolder.isDirectory() || userId != 0L && (long)dispatcher.getOwnerIdOf(aVmFolder) != userId || !(attachInfo = new File(aVmFolder, "attachInfo")).isFile()) continue;
                                Properties virtualMachine = new Properties();
                                try (FileInputStream inputStream = new FileInputStream(attachInfo);){
                                    virtualMachine.load(inputStream);
                                }
                                int targetProcessId = Integer.parseInt(virtualMachine.getProperty("processId"));
                                try {
                                    targetUserId = Long.parseLong(virtualMachine.getProperty("userUid"));
                                }
                                catch (NumberFormatException numberFormatException) {
                                    targetUserId = 0L;
                                }
                                if (userId != 0L && targetUserId == 0L) {
                                    targetUserId = dispatcher.getOwnerIdOf(attachInfo);
                                }
                                if ((long)targetProcessId == 0L || dispatcher.isExistingProcess(targetProcessId)) {
                                    virtualMachines.add(virtualMachine);
                                    continue;
                                }
                                if (userId != 0L && targetUserId != userId) continue;
                                File[] fileArray = aVmFolder.listFiles();
                                if (fileArray != null) {
                                    for (File aVmFile : fileArray) {
                                        if (aVmFile.delete()) continue;
                                        aVmFile.deleteOnExit();
                                    }
                                }
                                if (aVmFolder.delete()) continue;
                                aVmFolder.deleteOnExit();
                            }
                        }
                        finally {
                            masterLock.release();
                        }
                    }
                    Properties target = null;
                    for (Properties virtualMachine : virtualMachines) {
                        if (!virtualMachine.getProperty("processId").equalsIgnoreCase(processId)) continue;
                        target = virtualMachine;
                        break;
                    }
                    if (target == null) {
                        throw new IllegalStateException("Could not locate target process info in " + directory);
                    }
                    try (ServerSocket serverSocket = new ServerSocket(0);){
                        long targetUserId;
                        String key;
                        serverSocket.setSoTimeout(timeout);
                        File receiver = new File(directory, target.getProperty("vmId"));
                        SecureRandom secureRandom = SECURE_RANDOM;
                        synchronized (secureRandom) {
                            key = Long.toHexString(SECURE_RANDOM.nextLong());
                        }
                        File reply = new File(receiver, "replyInfo");
                        try {
                            targetUserId = Long.parseLong(target.getProperty("userUid"));
                        }
                        catch (NumberFormatException ignored) {
                            targetUserId = 0L;
                        }
                        try {
                            ForOpenJ9 forOpenJ9;
                            if (reply.createNewFile()) {
                                dispatcher.setPermissions(reply, 384);
                            }
                            if (userId == 0L && targetUserId != 0L) {
                                dispatcher.chownFileToUser(reply, targetUserId);
                            }
                            try (FileOutputStream outputStream = new FileOutputStream(reply);){
                                outputStream.write(key.getBytes("UTF-8"));
                                outputStream.write("\n".getBytes("UTF-8"));
                                outputStream.write(Long.toString(serverSocket.getLocalPort()).getBytes("UTF-8"));
                                outputStream.write("\n".getBytes("UTF-8"));
                            }
                            HashMap<RandomAccessFile, FileLock> locks = new HashMap<RandomAccessFile, FileLock>();
                            try {
                                String answer;
                                Socket socket;
                                String pid = Long.toString(dispatcher.pid());
                                for (Properties virtualMachine : virtualMachines) {
                                    if (virtualMachine.getProperty("processId").equalsIgnoreCase(pid)) continue;
                                    String string = virtualMachine.getProperty("attachNotificationSync");
                                    RandomAccessFile syncFile = new RandomAccessFile(string == null ? new File(directory, "attachNotificationSync") : new File(string), "rw");
                                    try {
                                        locks.put(syncFile, syncFile.getChannel().lock());
                                    }
                                    catch (IOException ignored) {
                                        syncFile.close();
                                    }
                                }
                                int notifications = 0;
                                File[] item = directory.listFiles();
                                if (item != null) {
                                    for (File anItem : item) {
                                        String name = anItem.getName();
                                        if (name.startsWith(".trash_") || name.equalsIgnoreCase("_attachlock") || name.equalsIgnoreCase("_master") || name.equalsIgnoreCase("_notifier")) continue;
                                        ++notifications;
                                    }
                                }
                                boolean bl = Boolean.parseBoolean(target.getProperty("globalSemaphore"));
                                dispatcher.incrementSemaphore(directory, "_notifier", bl, notifications);
                                try {
                                    socket = serverSocket.accept();
                                    answer = new String(ForOpenJ9.read(socket), "UTF-8");
                                    if (answer.contains(' ' + key + ' ')) {
                                        forOpenJ9 = new ForOpenJ9(socket);
                                        dispatcher.decrementSemaphore(directory, "_notifier", bl, notifications);
                                    }
                                }
                                catch (Throwable throwable) {
                                    dispatcher.decrementSemaphore(directory, "_notifier", bl, notifications);
                                    throw throwable;
                                }
                                {
                                    socket.close();
                                    throw new IllegalStateException("Unexpected answered to attachment: " + answer);
                                }
                            }
                            finally {
                                Iterator iterator = locks.entrySet().iterator();
                                while (true) {
                                    if (!iterator.hasNext()) {
                                        return forOpenJ9;
                                    }
                                    Map.Entry entry = iterator.next();
                                    try {
                                        try {
                                            ((FileLock)entry.getValue()).release();
                                        }
                                        finally {
                                            ((RandomAccessFile)entry.getKey()).close();
                                        }
                                    }
                                    catch (Throwable throwable) {}
                                }
                            }
                        }
                        finally {
                            if (!reply.delete()) {
                                reply.deleteOnExit();
                            }
                        }
                    }
                }
                finally {
                    attachLockLock.release();
                }
            }
        }

        @Override
        public Properties getSystemProperties() throws IOException {
            ForOpenJ9.write(this.socket, "ATTACH_GETSYSTEMPROPERTIES".getBytes("UTF-8"));
            Properties properties = new Properties();
            properties.load(new ByteArrayInputStream(ForOpenJ9.read(this.socket)));
            return properties;
        }

        @Override
        public Properties getAgentProperties() throws IOException {
            ForOpenJ9.write(this.socket, "ATTACH_GETAGENTPROPERTIES".getBytes("UTF-8"));
            Properties properties = new Properties();
            properties.load(new ByteArrayInputStream(ForOpenJ9.read(this.socket)));
            return properties;
        }

        @Override
        public void loadAgent(String jarFile, @MaybeNull String argument) throws IOException {
            ForOpenJ9.write(this.socket, ("ATTACH_LOADAGENT(instrument," + jarFile + '=' + (argument == null ? "" : argument) + ')').getBytes("UTF-8"));
            String answer = new String(ForOpenJ9.read(this.socket), "UTF-8");
            if (answer.startsWith("ATTACH_ERR")) {
                throw new IllegalStateException("Target VM failed loading agent: " + answer);
            }
            if (!answer.startsWith("ATTACH_ACK") && !answer.startsWith("ATTACH_RESULT=")) {
                throw new IllegalStateException("Unexpected response: " + answer);
            }
        }

        @Override
        public void loadAgentPath(String path, @MaybeNull String argument) throws IOException {
            ForOpenJ9.write(this.socket, ("ATTACH_LOADAGENTPATH(" + path + (argument == null ? "" : ',' + argument) + ')').getBytes("UTF-8"));
            String answer = new String(ForOpenJ9.read(this.socket), "UTF-8");
            if (answer.startsWith("ATTACH_ERR")) {
                throw new IllegalStateException("Target VM failed loading native agent: " + answer);
            }
            if (!answer.startsWith("ATTACH_ACK") && !answer.startsWith("ATTACH_RESULT=")) {
                throw new IllegalStateException("Unexpected response: " + answer);
            }
        }

        @Override
        public void loadAgentLibrary(String library, @MaybeNull String argument) throws IOException {
            ForOpenJ9.write(this.socket, ("ATTACH_LOADAGENTLIBRARY(" + library + (argument == null ? "" : ',' + argument) + ')').getBytes("UTF-8"));
            String answer = new String(ForOpenJ9.read(this.socket), "UTF-8");
            if (answer.startsWith("ATTACH_ERR")) {
                throw new IllegalStateException("Target VM failed loading native library: " + answer);
            }
            if (!answer.startsWith("ATTACH_ACK") && !answer.startsWith("ATTACH_RESULT=")) {
                throw new IllegalStateException("Unexpected response: " + answer);
            }
        }

        @Override
        public void startManagementAgent(Properties properties) throws IOException {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            properties.store(outputStream, null);
            ForOpenJ9.write(this.socket, "ATTACH_START_MANAGEMENT_AGENT".getBytes("UTF-8"));
            ForOpenJ9.write(this.socket, outputStream.toByteArray());
            String answer = new String(ForOpenJ9.read(this.socket), "UTF-8");
            if (answer.startsWith("ATTACH_ERR")) {
                throw new IllegalStateException("Target VM could not start management agent: " + answer);
            }
            if (!answer.startsWith("ATTACH_ACK") && !answer.startsWith("ATTACH_RESULT=")) {
                throw new IllegalStateException("Unexpected response: " + answer);
            }
        }

        @Override
        public String startLocalManagementAgent() throws IOException {
            ForOpenJ9.write(this.socket, "ATTACH_START_LOCAL_MANAGEMENT_AGENT".getBytes("UTF-8"));
            String answer = new String(ForOpenJ9.read(this.socket), "UTF-8");
            if (answer.startsWith("ATTACH_ERR")) {
                throw new IllegalStateException("Target VM could not start management agent: " + answer);
            }
            if (answer.startsWith("ATTACH_ACK")) {
                return answer.substring("ATTACH_ACK".length());
            }
            if (answer.startsWith("ATTACH_RESULT=")) {
                return answer.substring("ATTACH_RESULT=".length());
            }
            throw new IllegalStateException("Unexpected response: " + answer);
        }

        @Override
        public void detach() throws IOException {
            try {
                ForOpenJ9.write(this.socket, "ATTACH_DETACH".getBytes("UTF-8"));
                ForOpenJ9.read(this.socket);
            }
            finally {
                this.socket.close();
            }
        }

        private static void write(Socket socket, byte[] value) throws IOException {
            socket.getOutputStream().write(value);
            socket.getOutputStream().write(0);
            socket.getOutputStream().flush();
        }

        private static byte[] read(Socket socket) throws IOException {
            int length;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = socket.getInputStream().read(buffer)) != -1) {
                if (length > 0 && buffer[length - 1] == 0) {
                    outputStream.write(buffer, 0, length - 1);
                    break;
                }
                outputStream.write(buffer, 0, length);
            }
            return outputStream.toByteArray();
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        public static interface Dispatcher {
            public String getTemporaryFolder(String var1);

            public int pid();

            public int userId();

            public boolean isExistingProcess(int var1);

            public int getOwnerIdOf(File var1);

            public void setPermissions(File var1, int var2);

            public void incrementSemaphore(File var1, String var2, boolean var3, int var4);

            public void decrementSemaphore(File var1, String var2, boolean var3, int var4);

            public void chownFileToUser(File var1, long var2);

            /*
             * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
             */
            public static class ForJnaWindowsEnvironment
            implements Dispatcher {
                private static final int NO_USER_ID = 0;
                private static final String CREATION_MUTEX_NAME = "j9shsemcreationMutex";
                private final WindowsLibrary library = (WindowsLibrary)Native.loadLibrary((String)"kernel32", WindowsLibrary.class, (Map)W32APIOptions.DEFAULT_OPTIONS);

                @Override
                public String getTemporaryFolder(String processId) {
                    WinDef.DWORD length = new WinDef.DWORD(260L);
                    char[] path = new char[length.intValue()];
                    if (Kernel32.INSTANCE.GetTempPath(length, path).intValue() == 0) {
                        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    }
                    return Native.toString((char[])path);
                }

                @Override
                public int pid() {
                    return Kernel32.INSTANCE.GetCurrentProcessId();
                }

                @Override
                public int userId() {
                    return 0;
                }

                @Override
                public boolean isExistingProcess(int processId) {
                    WinNT.HANDLE handle = Kernel32.INSTANCE.OpenProcess(1024, false, processId);
                    if (handle == null) {
                        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    }
                    IntByReference exists = new IntByReference();
                    if (!Kernel32.INSTANCE.GetExitCodeProcess(handle, exists)) {
                        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    }
                    return exists.getValue() == 259;
                }

                @Override
                public int getOwnerIdOf(File file) {
                    return 0;
                }

                @Override
                public void setPermissions(File file, int permissions) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void incrementSemaphore(File directory, String name, boolean global, int count) {
                    try (AttachmentHandle handle = this.openSemaphore(directory, name, global);){
                        while (count-- > 0) {
                            if (this.library.ReleaseSemaphore(handle.getHandle(), 1L, null)) continue;
                            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                        }
                    }
                }

                /*
                 * Exception decompiling
                 */
                @Override
                public void decrementSemaphore(File directory, String name, boolean global, int count) {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[UNCONDITIONALDOLOOP]], but top level block is 9[SIMPLE_IF_TAKEN]
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                @Override
                public void chownFileToUser(File file, long userId) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                private AttachmentHandle openSemaphore(File directory, String name, boolean global) {
                    WinNT.SECURITY_DESCRIPTOR securityDescriptor = new WinNT.SECURITY_DESCRIPTOR(65536);
                    try {
                        if (!Advapi32.INSTANCE.InitializeSecurityDescriptor(securityDescriptor, 1)) {
                            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                        }
                        if (!Advapi32.INSTANCE.SetSecurityDescriptorDacl(securityDescriptor, true, null, true)) {
                            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                        }
                        WindowsLibrary.SecurityAttributes securityAttributes = new WindowsLibrary.SecurityAttributes();
                        try {
                            securityAttributes.length = new WinDef.DWORD((long)securityAttributes.size());
                            securityAttributes.securityDescriptor = securityDescriptor.getPointer();
                            WinNT.HANDLE mutex = this.library.CreateMutex(securityAttributes, false, CREATION_MUTEX_NAME);
                            if (mutex == null) {
                                int lastError = Kernel32.INSTANCE.GetLastError();
                                if (lastError != 183) {
                                    throw new Win32Exception(lastError);
                                }
                                mutex = this.library.OpenMutex(0x1F0001, false, CREATION_MUTEX_NAME);
                                if (mutex == null) {
                                    throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                                }
                            }
                            int result = Kernel32.INSTANCE.WaitForSingleObject(mutex, 2000);
                            switch (result) {
                                case -1: 
                                case 258: {
                                    throw new Win32Exception(result);
                                }
                            }
                            try {
                                String target = (global ? "Global\\" : "") + (directory.getAbsolutePath() + '_' + name).replaceAll("[^a-zA-Z0-9_]", "") + "_semaphore";
                                WinNT.HANDLE parent = this.library.OpenSemaphoreW(2031619, false, target);
                                if (parent == null) {
                                    parent = this.library.CreateSemaphoreW(null, 0L, Integer.MAX_VALUE, target);
                                    if (parent == null) {
                                        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                                    }
                                    WinNT.HANDLE child = this.library.CreateSemaphoreW(null, 0L, Integer.MAX_VALUE, target + "_set0");
                                    if (child == null) {
                                        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                                    }
                                    AttachmentHandle attachmentHandle = new AttachmentHandle(parent, child);
                                    securityAttributes = null;
                                    securityDescriptor = null;
                                    return attachmentHandle;
                                }
                                WinNT.HANDLE child = this.library.OpenSemaphoreW(2031619, false, target + "_set0");
                                if (child == null) {
                                    throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                                }
                                AttachmentHandle attachmentHandle = new AttachmentHandle(parent, child);
                                securityAttributes = null;
                                return attachmentHandle;
                            }
                            finally {
                                if (!this.library.ReleaseMutex(mutex)) {
                                    throw new Win32Exception(Native.getLastError());
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            securityAttributes = null;
                            throw throwable;
                        }
                    }
                    catch (Throwable throwable) {
                        securityDescriptor = null;
                        throw throwable;
                    }
                }

                /*
                 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
                 */
                protected static class AttachmentHandle
                implements Closeable {
                    private final WinNT.HANDLE parent;
                    private final WinNT.HANDLE child;

                    protected AttachmentHandle(WinNT.HANDLE parent, WinNT.HANDLE child) {
                        this.parent = parent;
                        this.child = child;
                    }

                    protected WinNT.HANDLE getHandle() {
                        return this.child;
                    }

                    @Override
                    public void close() {
                        boolean closed;
                        try {
                            if (!Kernel32.INSTANCE.CloseHandle(this.child)) {
                                throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                            }
                        }
                        finally {
                            closed = Kernel32.INSTANCE.CloseHandle(this.parent);
                        }
                        if (!closed) {
                            throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                        }
                    }
                }

                /*
                 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
                 */
                protected static interface WindowsLibrary
                extends StdCallLibrary {
                    public static final int SEMAPHORE_ALL_ACCESS = 2031619;

                    @MaybeNull
                    public WinNT.HANDLE OpenSemaphoreW(int var1, boolean var2, String var3);

                    @MaybeNull
                    public WinNT.HANDLE CreateSemaphoreW(@MaybeNull WinBase.SECURITY_ATTRIBUTES var1, long var2, long var4, String var6);

                    public boolean ReleaseSemaphore(WinNT.HANDLE var1, long var2, @MaybeNull Long var4);

                    @MaybeNull
                    public WinNT.HANDLE CreateMutex(SecurityAttributes var1, boolean var2, String var3);

                    public WinNT.HANDLE OpenMutex(int var1, boolean var2, String var3);

                    public boolean ReleaseMutex(WinNT.HANDLE var1);

                    /*
                     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
                     */
                    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD", "UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="Field required by native implementation.")
                    public static class SecurityAttributes
                    extends Structure {
                        @MaybeNull
                        public WinDef.DWORD length;
                        @MaybeNull
                        public Pointer securityDescriptor;
                        public boolean inherit;

                        protected List<String> getFieldOrder() {
                            return Arrays.asList("length", "securityDescriptor", "inherit");
                        }
                    }
                }
            }

            /*
             * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
             */
            public static class ForJnaPosixEnvironment
            implements Dispatcher {
                private final PosixLibrary library;
                private final PosixOwnerProvider provider;

                public ForJnaPosixEnvironment(int attempts, long pause, TimeUnit timeUnit) {
                    this.provider = Platform.isAIX() ? new PosixOwnerProvider.UsingIStat(attempts, pause, timeUnit) : new PosixOwnerProvider.UsingStat(attempts, pause, timeUnit);
                    this.library = (PosixLibrary)Native.loadLibrary((String)"c", PosixLibrary.class);
                }

                @Override
                public String getTemporaryFolder(String processId) {
                    File file;
                    if (Platform.isLinux() && (file = new File("/proc/" + processId + "/root/tmp")).isDirectory() && file.canRead()) {
                        return file.getAbsolutePath();
                    }
                    String temporaryFolder = System.getenv("TMPDIR");
                    return temporaryFolder == null ? "/tmp" : temporaryFolder;
                }

                @Override
                public int pid() {
                    return this.library.getpid();
                }

                @Override
                public int userId() {
                    return this.library.getuid();
                }

                @Override
                public boolean isExistingProcess(int processId) {
                    return this.library.kill(processId, 0) != 3;
                }

                @Override
                @SuppressFBWarnings(value={"OS_OPEN_STREAM"}, justification="The stream life-cycle is bound to its process.")
                public int getOwnerIdOf(File file) {
                    return this.provider.getOwnerIdOf(file);
                }

                @Override
                public void setPermissions(File file, int permissions) {
                    this.library.chmod(file.getAbsolutePath(), permissions);
                }

                @Override
                public void incrementSemaphore(File directory, String name, boolean global, int count) {
                    this.notifySemaphore(directory, name, count, (short)1, (short)0, false);
                }

                @Override
                public void decrementSemaphore(File directory, String name, boolean global, int count) {
                    this.notifySemaphore(directory, name, count, (short)-1, (short)6144, true);
                }

                @Override
                public void chownFileToUser(File file, long userId) {
                    this.library.chown(file.getAbsolutePath(), userId);
                }

                @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD", "UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD"}, justification="Modifier is required by JNA.")
                private void notifySemaphore(File directory, String name, int count, short operation, short flags, boolean acceptUnavailable) {
                    int semaphore = this.library.semget(this.library.ftok(new File(directory, name).getAbsolutePath(), 161), 2, 438);
                    PosixLibrary.SemaphoreOperation target = new PosixLibrary.SemaphoreOperation();
                    target.operation = operation;
                    target.flags = flags;
                    while (count-- > 0) {
                        try {
                            this.library.semop(semaphore, target, 1);
                        }
                        catch (LastErrorException exception) {
                            if (acceptUnavailable && (Native.getLastError() == 11 || Native.getLastError() == 35)) break;
                            throw exception;
                        }
                    }
                }

                /*
                 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
                 */
                protected static interface PosixOwnerProvider {
                    public int getOwnerIdOf(File var1);

                    /*
                     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
                     */
                    public static class UsingIStat
                    implements PosixOwnerProvider {
                        private static final Pattern AIX_OWNER_PATTERN = Pattern.compile("Owner: (\\d+)\\(");
                        private final int attempts;
                        private final long pause;
                        private final TimeUnit timeUnit;

                        public UsingIStat(int attempts, long pause, TimeUnit timeUnit) {
                            this.attempts = attempts;
                            this.pause = pause;
                            this.timeUnit = timeUnit;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public int getOwnerIdOf(File file) {
                            try {
                                Process process = Runtime.getRuntime().exec(new String[]{"istat", file.getAbsolutePath()});
                                int attempts = this.attempts;
                                String lines = null;
                                while (true) {
                                    try {
                                        if (process.exitValue() != 0) {
                                            throw new IllegalStateException("Error while executing istat");
                                        }
                                        StringBuilder output = new StringBuilder();
                                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), "UTF-8"));){
                                            String line;
                                            while ((line = reader.readLine()) != null) {
                                                output.append(line).append("\n");
                                            }
                                        }
                                        lines = output.toString();
                                    }
                                    catch (IllegalThreadStateException ignored) {
                                        try {
                                            Thread.sleep(this.timeUnit.toMillis(this.pause));
                                            continue;
                                        }
                                        catch (InterruptedException exception) {
                                            Thread.currentThread().interrupt();
                                            throw new IllegalStateException(exception);
                                        }
                                        if (--attempts > 0) continue;
                                    }
                                    break;
                                }
                                if (lines == null) {
                                    process.destroy();
                                    throw new IllegalStateException("Command for istat did not exit in time");
                                }
                                Matcher matcher = AIX_OWNER_PATTERN.matcher(lines);
                                if (matcher.find()) {
                                    return Integer.parseInt(matcher.group(1));
                                }
                                throw new IllegalStateException("Unable to parse response from istat command: " + lines);
                            }
                            catch (IOException exception) {
                                throw new IllegalStateException("Unable to execute istat command", exception);
                            }
                        }
                    }

                    /*
                     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
                     */
                    public static class UsingStat
                    implements PosixOwnerProvider {
                        private final int attempts;
                        private final long pause;
                        private final TimeUnit timeUnit;

                        public UsingStat(int attempts, long pause, TimeUnit timeUnit) {
                            this.attempts = attempts;
                            this.pause = pause;
                            this.timeUnit = timeUnit;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public int getOwnerIdOf(File file) {
                            try {
                                Process process = Runtime.getRuntime().exec(new String[]{"stat", Platform.isMac() ? "-f" : "-c", "%u", file.getAbsolutePath()});
                                int attempts = this.attempts;
                                String line = null;
                                while (true) {
                                    try {
                                        if (process.exitValue() != 0) {
                                            throw new IllegalStateException("Error while executing stat");
                                        }
                                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), "UTF-8"));){
                                            line = reader.readLine();
                                        }
                                    }
                                    catch (IllegalThreadStateException ignored) {
                                        try {
                                            Thread.sleep(this.timeUnit.toMillis(this.pause));
                                            continue;
                                        }
                                        catch (InterruptedException exception) {
                                            Thread.currentThread().interrupt();
                                            throw new IllegalStateException(exception);
                                        }
                                        if (--attempts > 0) continue;
                                    }
                                    break;
                                }
                                if (line == null) {
                                    process.destroy();
                                    throw new IllegalStateException("Command for stat did not exit in time");
                                }
                                return Integer.parseInt(line);
                            }
                            catch (IOException exception) {
                                throw new IllegalStateException("Unable to execute stat command", exception);
                            }
                        }
                    }
                }

                /*
                 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
                 */
                protected static interface PosixLibrary
                extends Library {
                    public static final int NULL_SIGNAL = 0;
                    public static final int ESRCH = 3;
                    public static final int EAGAIN = 11;
                    public static final int EDEADLK = 35;
                    public static final short SEM_UNDO = 4096;
                    public static final short IPC_NOWAIT = 2048;

                    public int getpid() throws LastErrorException;

                    public int getuid() throws LastErrorException;

                    public int kill(int var1, int var2) throws LastErrorException;

                    public int chmod(String var1, int var2) throws LastErrorException;

                    public int chown(String var1, long var2) throws LastErrorException;

                    public int ftok(String var1, int var2) throws LastErrorException;

                    public int semget(int var1, int var2, int var3) throws LastErrorException;

                    public int semop(int var1, SemaphoreOperation var2, int var3) throws LastErrorException;

                    /*
                     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
                     */
                    public static class SemaphoreOperation
                    extends Structure {
                        public short number;
                        public short operation;
                        public short flags;

                        protected List<String> getFieldOrder() {
                            return Arrays.asList("number", "operation", "flags");
                        }
                    }
                }
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class ForHotSpot
    extends AbstractBase {
        private static final String PROTOCOL_VERSION = "1";
        private static final String LOAD_COMMAND = "load";
        private static final String INSTRUMENT_COMMAND = "instrument";
        private static final String ARGUMENT_DELIMITER = "=";
        private final Connection connection;

        protected ForHotSpot(Connection connection) {
            this.connection = connection;
        }

        public static VirtualMachine attach(String processId) throws IOException {
            if (Platform.isWindows()) {
                return ForHotSpot.attach(processId, new Connection.ForJnaWindowsNamedPipe.Factory());
            }
            if (Platform.isSolaris()) {
                return ForHotSpot.attach(processId, new Connection.ForJnaSolarisDoor.Factory(15, 100L, TimeUnit.MILLISECONDS));
            }
            return ForHotSpot.attach(processId, Connection.ForJnaPosixSocket.Factory.withDefaultTemporaryFolder(15, 100L, TimeUnit.MILLISECONDS));
        }

        public static VirtualMachine attach(String processId, Connection.Factory connectionFactory) throws IOException {
            return new ForHotSpot(connectionFactory.connect(processId));
        }

        private static void checkHeader(Connection.Response response) throws IOException {
            int length;
            byte[] buffer = new byte[1];
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            while ((length = response.read(buffer)) != -1) {
                if (length <= 0) continue;
                if (buffer[0] == 10) break;
                outputStream.write(buffer[0]);
            }
            switch (Integer.parseInt(outputStream.toString("UTF-8"))) {
                case 0: {
                    return;
                }
                case 101: {
                    throw new IOException("Protocol mismatch with target VM");
                }
            }
            buffer = new byte[1024];
            outputStream = new ByteArrayOutputStream();
            while ((length = response.read(buffer)) != -1) {
                outputStream.write(buffer, 0, length);
            }
            throw new IllegalStateException(outputStream.toString("UTF-8"));
        }

        @Override
        public Properties getSystemProperties() throws IOException {
            return this.getProperties("properties");
        }

        @Override
        public Properties getAgentProperties() throws IOException {
            return this.getProperties("agentProperties");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Properties getProperties(String command) throws IOException {
            try (Connection.Response response = this.connection.execute(PROTOCOL_VERSION, command, null, null, null);){
                int length;
                ForHotSpot.checkHeader(response);
                byte[] buffer = new byte[1024];
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                while ((length = response.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, length);
                }
                Properties properties = new Properties();
                properties.load(new ByteArrayInputStream(outputStream.toByteArray()));
                Properties properties2 = properties;
                return properties2;
            }
        }

        @Override
        public void loadAgent(String jarFile, @MaybeNull String argument) throws IOException {
            this.load(jarFile, false, argument);
        }

        @Override
        public void loadAgentPath(String path, @MaybeNull String argument) throws IOException {
            this.load(path, true, argument);
        }

        @Override
        public void loadAgentLibrary(String library, @MaybeNull String argument) throws IOException {
            this.load(library, false, argument);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void load(String file, boolean absolute, @MaybeNull String argument) throws IOException {
            try (Connection.Response response = this.connection.execute(PROTOCOL_VERSION, LOAD_COMMAND, INSTRUMENT_COMMAND, Boolean.toString(absolute), argument == null ? file : file + ARGUMENT_DELIMITER + argument);){
                ForHotSpot.checkHeader(response);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startManagementAgent(Properties properties) throws IOException {
            StringBuilder stringBuilder = new StringBuilder("ManagementAgent.start ");
            boolean first = true;
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                if (!(entry.getKey() instanceof String) || !((String)entry.getKey()).startsWith("com.sun.management.")) {
                    throw new IllegalArgumentException("Illegal property name: " + entry.getKey());
                }
                if (first) {
                    first = false;
                } else {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(((String)entry.getKey()).substring("com.sun.management.".length())).append('=');
                String value = entry.getValue().toString();
                if (value.contains(" ")) {
                    stringBuilder.append('\'').append(value).append('\'');
                    continue;
                }
                stringBuilder.append(value);
            }
            try (Connection.Response response = this.connection.execute(PROTOCOL_VERSION, "jcmd", stringBuilder.toString(), null, null);){
                ForHotSpot.checkHeader(response);
            }
        }

        @Override
        public String startLocalManagementAgent() throws IOException {
            try (Connection.Response response = this.connection.execute(PROTOCOL_VERSION, "jcmd", "ManagementAgent.start_local", null, null);){
                ForHotSpot.checkHeader(response);
                String string = this.getAgentProperties().getProperty("com.sun.management.jmxremote.localConnectorAddress");
                return string;
            }
        }

        @Override
        public void detach() throws IOException {
            this.connection.close();
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        public static interface Connection
        extends Closeable {
            public Response execute(String var1, String ... var2) throws IOException;

            /*
             * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
             */
            public static class ForJnaSolarisDoor
            implements Connection {
                private final SolarisLibrary library;
                private final File socket;

                protected ForJnaSolarisDoor(SolarisLibrary library, File socket) {
                    this.library = library;
                    this.socket = socket;
                }

                /*
                 * Exception decompiling
                 */
                @Override
                @SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="This pattern is required for use of JNA.")
                public net.bytebuddy.agent.VirtualMachine$ForHotSpot$Connection$Response execute(String protocol, String ... argument) throws IOException {
                    /*
                     * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                     * 
                     * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                     *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                     *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                     *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                     *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                     *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                     *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                     *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                     *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                     *     at org.benf.cfr.reader.Main.main(Main.java:54)
                     */
                    throw new IllegalStateException("Decompilation failed");
                }

                @Override
                public void close() {
                }

                /*
                 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
                 */
                public static class Factory
                extends Factory.ForSocketFile {
                    private final SolarisLibrary library = (SolarisLibrary)Native.loadLibrary((String)"c", SolarisLibrary.class);

                    public Factory(int attempts, long pause, TimeUnit timeUnit) {
                        super("/tmp", attempts, pause, timeUnit);
                    }

                    @Override
                    protected void kill(String processId, int signal) {
                        this.library.kill(Integer.parseInt(processId), signal);
                    }

                    @Override
                    protected Connection doConnect(File socket) {
                        return new ForJnaSolarisDoor(this.library, socket);
                    }
                }

                /*
                 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
                 */
                protected static class Response
                implements net.bytebuddy.agent.VirtualMachine$ForHotSpot$Connection$Response {
                    private final SolarisLibrary library;
                    private final int handle;

                    protected Response(SolarisLibrary library, int handle) {
                        this.library = library;
                        this.handle = handle;
                    }

                    @Override
                    public int read(byte[] buffer) {
                        int read = this.library.read(this.handle, ByteBuffer.wrap(buffer), buffer.length);
                        return read == 0 ? -1 : read;
                    }

                    @Override
                    public void close() {
                        this.library.close(this.handle);
                    }
                }

                /*
                 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
                 */
                protected static interface SolarisLibrary
                extends Library {
                    public int kill(int var1, int var2) throws LastErrorException;

                    public int open(String var1, int var2) throws LastErrorException;

                    public int read(int var1, ByteBuffer var2, int var3) throws LastErrorException;

                    public int close(int var1) throws LastErrorException;

                    public int door_call(int var1, DoorArgument var2) throws LastErrorException;

                    /*
                     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
                     */
                    public static class DoorArgument
                    extends Structure {
                        @MaybeNull
                        public Pointer dataPointer;
                        public int dataSize;
                        @MaybeNull
                        public Pointer descriptorPointer;
                        public int descriptorCount;
                        @UnknownNull
                        public Pointer resultPointer;
                        public int resultSize;

                        protected List<String> getFieldOrder() {
                            return Arrays.asList("dataPointer", "dataSize", "descriptorPointer", "descriptorCount", "resultPointer", "resultSize");
                        }
                    }
                }
            }

            /*
             * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
             */
            public static class ForJnaWindowsNamedPipe
            implements Connection {
                private static final int MEM_RELEASE = 32768;
                private final WindowsLibrary library;
                private final WindowsAttachLibrary attachLibrary;
                private final WinNT.HANDLE process;
                private final WinDef.LPVOID code;
                private final SecureRandom random;

                protected ForJnaWindowsNamedPipe(WindowsLibrary library, WindowsAttachLibrary attachLibrary, WinNT.HANDLE process, WinDef.LPVOID code) {
                    this.library = library;
                    this.attachLibrary = attachLibrary;
                    this.process = process;
                    this.code = code;
                    this.random = new SecureRandom();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public Response execute(String protocol, String ... argument) {
                    WinBase.SECURITY_ATTRIBUTES sa;
                    if (!ForHotSpot.PROTOCOL_VERSION.equals(protocol)) {
                        throw new IllegalArgumentException("Unknown protocol version: " + protocol);
                    }
                    if (argument.length > 4) {
                        throw new IllegalArgumentException("Cannot supply more then four arguments to Windows attach mechanism: " + Arrays.asList(argument));
                    }
                    String name = "\\\\.\\pipe\\javatool" + Math.abs(this.random.nextInt() + 1);
                    WinNT.HANDLE pipe = Kernel32.INSTANCE.CreateNamedPipe(name, 1, 0, 1, 4096, 8192, 0, sa = this.createSecurityAttributesToAllowMediumIntegrity());
                    if (pipe == null) {
                        throw new Win32Exception(Native.getLastError());
                    }
                    try {
                        WinDef.LPVOID data = this.attachLibrary.allocate_remote_argument(this.process, name, argument.length < 1 ? null : argument[0], argument.length < 2 ? null : argument[1], argument.length < 3 ? null : argument[2], argument.length < 4 ? null : argument[3]);
                        if (data == null) {
                            throw new Win32Exception(Native.getLastError());
                        }
                        try {
                            NamedPipeResponse namedPipeResponse;
                            WinNT.HANDLE thread = this.library.CreateRemoteThread(this.process, null, 0, this.code.getPointer(), data.getPointer(), null, null);
                            if (thread == null) {
                                throw new Win32Exception(Native.getLastError());
                            }
                            try {
                                int code;
                                int result = Kernel32.INSTANCE.WaitForSingleObject(thread, -1);
                                if (result != 0) {
                                    throw new Win32Exception(result);
                                }
                                IntByReference exitCode = new IntByReference();
                                if (!this.library.GetExitCodeThread(thread, exitCode)) {
                                    throw new Win32Exception(Native.getLastError());
                                }
                                if (exitCode.getValue() != 0) {
                                    throw new IllegalStateException("Target VM could not dispatch command successfully: " + exitCode.getValue());
                                }
                                if (!Kernel32.INSTANCE.ConnectNamedPipe(pipe, null) && (code = Native.getLastError()) != 535) {
                                    throw new Win32Exception(code);
                                }
                                namedPipeResponse = new NamedPipeResponse(pipe);
                            }
                            catch (Throwable throwable) {
                                if (!Kernel32.INSTANCE.CloseHandle(thread)) {
                                    throw new Win32Exception(Native.getLastError());
                                }
                                throw throwable;
                            }
                            if (!Kernel32.INSTANCE.CloseHandle(thread)) {
                                throw new Win32Exception(Native.getLastError());
                            }
                            return namedPipeResponse;
                        }
                        finally {
                            if (!this.library.VirtualFreeEx(this.process, data.getPointer(), 0, 32768)) {
                                throw new Win32Exception(Native.getLastError());
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        if (!Kernel32.INSTANCE.CloseHandle(pipe)) {
                            throw new Win32Exception(Native.getLastError());
                        }
                        if (throwable instanceof RuntimeException) {
                            throw (RuntimeException)throwable;
                        }
                        throw new IllegalStateException(throwable);
                    }
                }

                private WinBase.SECURITY_ATTRIBUTES createSecurityAttributesToAllowMediumIntegrity() {
                    WinNT.PSID pSidEverybody = new WinNT.PSID(68);
                    if (!Advapi32.INSTANCE.CreateWellKnownSid(1, null, pSidEverybody, new IntByReference(68))) {
                        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    }
                    WinNT.PSID pSidSystem = new WinNT.PSID(68);
                    if (!Advapi32.INSTANCE.CreateWellKnownSid(31, null, pSidSystem, new IntByReference(68))) {
                        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    }
                    WinNT.PSID pSidAdmin = new WinNT.PSID(68);
                    if (!Advapi32.INSTANCE.CreateWellKnownSid(26, null, pSidAdmin, new IntByReference(68))) {
                        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    }
                    int cbAcl = Native.getNativeSize(WinNT.ACL.class, null);
                    cbAcl += Native.getNativeSize(WinNT.ACCESS_ALLOWED_ACE.class, null) * 3;
                    cbAcl += Advapi32.INSTANCE.GetLengthSid(pSidEverybody) - 4;
                    cbAcl += Advapi32.INSTANCE.GetLengthSid(pSidSystem) - 4;
                    cbAcl += Advapi32.INSTANCE.GetLengthSid(pSidAdmin) - 4;
                    WinNT.ACL pAcl = new WinNT.ACL(cbAcl = Advapi32Util.alignOnDWORD((int)cbAcl));
                    if (!Advapi32.INSTANCE.InitializeAcl(pAcl, cbAcl, 2)) {
                        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    }
                    if (!Advapi32.INSTANCE.AddAccessAllowedAce(pAcl, 2, -1073741824, pSidEverybody)) {
                        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    }
                    if (!Advapi32.INSTANCE.AddAccessAllowedAce(pAcl, 2, 0x10000000, pSidSystem)) {
                        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    }
                    if (!Advapi32.INSTANCE.AddAccessAllowedAce(pAcl, 2, 0x10000000, pSidAdmin)) {
                        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    }
                    WinNT.SECURITY_DESCRIPTOR sd = new WinNT.SECURITY_DESCRIPTOR(65536);
                    if (!Advapi32.INSTANCE.InitializeSecurityDescriptor(sd, 1)) {
                        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    }
                    if (!Advapi32.INSTANCE.SetSecurityDescriptorDacl(sd, true, pAcl, false)) {
                        throw new Win32Exception(Kernel32.INSTANCE.GetLastError());
                    }
                    WinBase.SECURITY_ATTRIBUTES sa = new WinBase.SECURITY_ATTRIBUTES();
                    sa.dwLength = new WinDef.DWORD((long)sa.size());
                    sa.lpSecurityDescriptor = sd.getPointer();
                    return sa;
                }

                @Override
                public void close() {
                    try {
                        if (!this.library.VirtualFreeEx(this.process, this.code.getPointer(), 0, 32768)) {
                            throw new Win32Exception(Native.getLastError());
                        }
                    }
                    finally {
                        if (!Kernel32.INSTANCE.CloseHandle(this.process)) {
                            throw new Win32Exception(Native.getLastError());
                        }
                    }
                }

                /*
                 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
                 */
                public static class Factory
                implements net.bytebuddy.agent.VirtualMachine$ForHotSpot$Connection$Factory {
                    public static final String LIBRARY_NAME = "net.bytebuddy.library.name";
                    private final WindowsLibrary library = (WindowsLibrary)Native.loadLibrary((String)"kernel32", WindowsLibrary.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                    private final WindowsAttachLibrary attachLibrary = (WindowsAttachLibrary)Native.loadLibrary((String)System.getProperty("net.bytebuddy.library.name", "attach_hotspot_windows"), WindowsAttachLibrary.class);

                    @Override
                    public Connection connect(String processId) {
                        WinNT.HANDLE process = Kernel32.INSTANCE.OpenProcess(0x1F1FFB, false, Integer.parseInt(processId));
                        if (process == null) {
                            throw new Win32Exception(Native.getLastError());
                        }
                        try {
                            WinDef.LPVOID code = this.attachLibrary.allocate_remote_code(process);
                            if (code == null) {
                                throw new Win32Exception(Native.getLastError());
                            }
                            return new ForJnaWindowsNamedPipe(this.library, this.attachLibrary, process, code);
                        }
                        catch (Throwable throwable) {
                            if (!Kernel32.INSTANCE.CloseHandle(process)) {
                                throw new Win32Exception(Native.getLastError());
                            }
                            if (throwable instanceof RuntimeException) {
                                throw (RuntimeException)throwable;
                            }
                            throw new IllegalStateException(throwable);
                        }
                    }
                }

                /*
                 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
                 */
                protected static class NamedPipeResponse
                implements Response {
                    private final WinNT.HANDLE pipe;

                    protected NamedPipeResponse(WinNT.HANDLE pipe) {
                        this.pipe = pipe;
                    }

                    @Override
                    public int read(byte[] buffer) {
                        IntByReference read = new IntByReference();
                        if (!Kernel32.INSTANCE.ReadFile(this.pipe, buffer, buffer.length, read, null)) {
                            int code = Native.getLastError();
                            if (code == 109) {
                                return -1;
                            }
                            throw new Win32Exception(code);
                        }
                        return read.getValue();
                    }

                    @Override
                    public void close() {
                        try {
                            if (!Kernel32.INSTANCE.DisconnectNamedPipe(this.pipe)) {
                                throw new Win32Exception(Native.getLastError());
                            }
                        }
                        finally {
                            if (!Kernel32.INSTANCE.CloseHandle(this.pipe)) {
                                throw new Win32Exception(Native.getLastError());
                            }
                        }
                    }
                }

                /*
                 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
                 */
                protected static interface WindowsAttachLibrary
                extends StdCallLibrary {
                    @MaybeNull
                    public WinDef.LPVOID allocate_remote_code(WinNT.HANDLE var1);

                    @MaybeNull
                    public WinDef.LPVOID allocate_remote_argument(WinNT.HANDLE var1, String var2, @MaybeNull String var3, @MaybeNull String var4, @MaybeNull String var5, @MaybeNull String var6);
                }

                /*
                 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
                 */
                protected static interface WindowsLibrary
                extends StdCallLibrary {
                    public Pointer VirtualAllocEx(WinNT.HANDLE var1, Pointer var2, int var3, int var4, int var5);

                    public boolean VirtualFreeEx(WinNT.HANDLE var1, Pointer var2, int var3, int var4);

                    @MaybeNull
                    public WinNT.HANDLE CreateRemoteThread(WinNT.HANDLE var1, @MaybeNull WinBase.SECURITY_ATTRIBUTES var2, int var3, Pointer var4, Pointer var5, @MaybeNull WinDef.DWORD var6, @MaybeNull Pointer var7);

                    public boolean GetExitCodeThread(WinNT.HANDLE var1, IntByReference var2);
                }
            }

            /*
             * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
             */
            public static class ForJnaPosixSocket
            extends OnPersistentByteChannel<Integer> {
                private final PosixLibrary library;
                private final File socket;

                protected ForJnaPosixSocket(PosixLibrary library, File socket) {
                    this.library = library;
                    this.socket = socket;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected Integer connect() {
                    int handle = this.library.socket(1, 1, 0);
                    PosixLibrary.SocketAddress address = new PosixLibrary.SocketAddress();
                    try {
                        address.setPath(this.socket.getAbsolutePath());
                        this.library.connect(handle, address, address.size());
                        Integer n = handle;
                        address = null;
                        return n;
                    }
                    catch (Throwable throwable) {
                        try {
                            address = null;
                            throw throwable;
                        }
                        catch (RuntimeException exception) {
                            this.library.close(handle);
                            throw exception;
                        }
                    }
                }

                @Override
                protected int read(Integer handle, byte[] buffer) {
                    int read = this.library.read(handle, ByteBuffer.wrap(buffer), buffer.length);
                    return read == 0 ? -1 : read;
                }

                @Override
                protected void write(Integer handle, byte[] buffer) {
                    this.library.write(handle, ByteBuffer.wrap(buffer), buffer.length);
                }

                @Override
                protected void close(Integer handle) {
                    this.library.close(handle);
                }

                @Override
                public void close() {
                }

                /*
                 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
                 */
                public static class Factory
                extends Factory.ForSocketFile {
                    private final PosixLibrary library = (PosixLibrary)Native.loadLibrary((String)"c", PosixLibrary.class);

                    public Factory(String temporaryDirectory, int attempts, long pause, TimeUnit timeUnit) {
                        super(temporaryDirectory, attempts, pause, timeUnit);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public static net.bytebuddy.agent.VirtualMachine$ForHotSpot$Connection$Factory withDefaultTemporaryFolder(int attempts, long pause, TimeUnit timeUnit) {
                        String temporaryDirectory;
                        if (Platform.isMac()) {
                            MacLibrary library = (MacLibrary)Native.loadLibrary((String)"c", MacLibrary.class);
                            Memory memory = new Memory(4096L);
                            try {
                                long length = library.confstr(65537, (Pointer)memory, memory.size());
                                if (length == 0L || length > 4096L) {
                                    temporaryDirectory = "/tmp";
                                }
                                temporaryDirectory = memory.getString(0L);
                            }
                            finally {
                                memory = null;
                            }
                        } else {
                            temporaryDirectory = "/tmp";
                        }
                        return new Factory(temporaryDirectory, attempts, pause, timeUnit);
                    }

                    @Override
                    protected void kill(String processId, int signal) {
                        this.library.kill(Integer.parseInt(processId), signal);
                    }

                    @Override
                    public Connection doConnect(File socket) {
                        return new ForJnaPosixSocket(this.library, socket);
                    }

                    /*
                     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
                     */
                    public static interface MacLibrary
                    extends Library {
                        public static final int CS_DARWIN_USER_TEMP_DIR = 65537;

                        public long confstr(int var1, Pointer var2, long var3);
                    }
                }

                /*
                 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
                 */
                protected static interface PosixLibrary
                extends Library {
                    public int kill(int var1, int var2) throws LastErrorException;

                    public int socket(int var1, int var2, int var3) throws LastErrorException;

                    public int connect(int var1, SocketAddress var2, int var3) throws LastErrorException;

                    public int read(int var1, ByteBuffer var2, int var3) throws LastErrorException;

                    public int write(int var1, ByteBuffer var2, int var3) throws LastErrorException;

                    public int close(int var1) throws LastErrorException;

                    /*
                     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
                     */
                    public static class SocketAddress
                    extends Structure {
                        @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"}, justification="Field required by native implementation.")
                        public short family = 1;
                        public byte[] path = new byte[100];

                        protected void setPath(String path) {
                            try {
                                System.arraycopy(path.getBytes("UTF-8"), 0, this.path, 0, path.length());
                                System.arraycopy(new byte[]{0}, 0, this.path, path.length(), 1);
                            }
                            catch (UnsupportedEncodingException exception) {
                                throw new IllegalStateException(exception);
                            }
                        }

                        protected List<String> getFieldOrder() {
                            return Arrays.asList("family", "path");
                        }
                    }
                }
            }

            /*
             * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
             */
            public static abstract class OnPersistentByteChannel<T>
            implements Connection {
                private static final byte[] BLANK = new byte[]{0};

                @Override
                public net.bytebuddy.agent.VirtualMachine$ForHotSpot$Connection$Response execute(String protocol, String ... argument) throws IOException {
                    T connection = this.connect();
                    try {
                        this.write(connection, protocol.getBytes("UTF-8"));
                        this.write(connection, BLANK);
                        for (String anArgument : argument) {
                            if (anArgument != null) {
                                this.write(connection, anArgument.getBytes("UTF-8"));
                            }
                            this.write(connection, BLANK);
                        }
                        return new Response(connection);
                    }
                    catch (Throwable throwable) {
                        this.close(connection);
                        if (throwable instanceof RuntimeException) {
                            throw (RuntimeException)throwable;
                        }
                        if (throwable instanceof IOException) {
                            throw (IOException)throwable;
                        }
                        throw new IllegalStateException(throwable);
                    }
                }

                protected abstract T connect() throws IOException;

                protected abstract void close(T var1) throws IOException;

                protected abstract void write(T var1, byte[] var2) throws IOException;

                protected abstract int read(T var1, byte[] var2) throws IOException;

                /*
                 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
                 */
                private class Response
                implements net.bytebuddy.agent.VirtualMachine$ForHotSpot$Connection$Response {
                    private final T connection;

                    private Response(T connection) {
                        this.connection = connection;
                    }

                    @Override
                    public int read(byte[] buffer) throws IOException {
                        return OnPersistentByteChannel.this.read(this.connection, buffer);
                    }

                    @Override
                    public void close() throws IOException {
                        OnPersistentByteChannel.this.close(this.connection);
                    }
                }
            }

            /*
             * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
             */
            public static interface Factory {
                public Connection connect(String var1) throws IOException;

                /*
                 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
                 */
                public static abstract class ForSocketFile
                implements Factory {
                    private static final String SOCKET_FILE_PREFIX = ".java_pid";
                    private static final String ATTACH_FILE_PREFIX = ".attach_pid";
                    private final String temporaryDirectory;
                    private final int attempts;
                    private final long pause;
                    private final TimeUnit timeUnit;

                    protected ForSocketFile(String temporaryDirectory, int attempts, long pause, TimeUnit timeUnit) {
                        this.temporaryDirectory = temporaryDirectory;
                        this.attempts = attempts;
                        this.pause = pause;
                        this.timeUnit = timeUnit;
                    }

                    @Override
                    @SuppressFBWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"}, justification="File name convention is specified.")
                    public Connection connect(String processId) throws IOException {
                        File socket = new File(this.temporaryDirectory, SOCKET_FILE_PREFIX + processId);
                        if (!socket.exists()) {
                            File attachFile;
                            block12: {
                                String target = ATTACH_FILE_PREFIX + processId;
                                String path = "/proc/" + processId + "/cwd/" + target;
                                attachFile = new File(path);
                                try {
                                    if (!attachFile.createNewFile() && !attachFile.isFile()) {
                                        throw new IllegalStateException("Could not create attach file: " + attachFile);
                                    }
                                }
                                catch (IOException ignored) {
                                    attachFile = new File(this.temporaryDirectory, target);
                                    if (attachFile.createNewFile() || attachFile.isFile()) break block12;
                                    throw new IllegalStateException("Could not create attach file: " + attachFile);
                                }
                            }
                            try {
                                this.kill(processId, 3);
                                int attempts = this.attempts;
                                while (!socket.exists() && attempts-- > 0) {
                                    this.timeUnit.sleep(this.pause);
                                }
                                if (!socket.exists()) {
                                    throw new IllegalStateException("Target VM did not respond: " + processId);
                                }
                            }
                            catch (InterruptedException exception) {
                                Thread.currentThread().interrupt();
                                throw new IllegalStateException(exception);
                            }
                            finally {
                                if (!attachFile.delete()) {
                                    attachFile.deleteOnExit();
                                }
                            }
                        }
                        return this.doConnect(socket);
                    }

                    protected abstract void kill(String var1, int var2);

                    protected abstract Connection doConnect(File var1) throws IOException;
                }
            }

            /*
             * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
             */
            public static interface Response
            extends Closeable {
                public int read(byte[] var1) throws IOException;
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static abstract class AbstractBase
    implements VirtualMachine {
        @Override
        public void loadAgent(String jarFile) throws IOException {
            this.loadAgent(jarFile, null);
        }

        @Override
        public void loadAgentPath(String path) throws IOException {
            this.loadAgentPath(path, null);
        }

        @Override
        public void loadAgentLibrary(String library) throws IOException {
            this.loadAgentLibrary(library, null);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static enum Resolver implements PrivilegedAction<Class<? extends VirtualMachine>>
    {
        INSTANCE;


        @Override
        public Class<? extends VirtualMachine> run() {
            try {
                Class.forName("com.sun.jna.Platform");
            }
            catch (ClassNotFoundException exception) {
                throw new IllegalStateException("Optional JNA dependency is not available", exception);
            }
            return System.getProperty("java.vm.name", "").toUpperCase(Locale.US).contains("J9") ? ForOpenJ9.class : ForHotSpot.class;
        }
    }
}

