/******/ (function() { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ "./extends.js":
/*!********************!*\
  !*** ./extends.js ***!
  \********************/
/***/ (function(__unused_webpack_module, exports) {



Object.defineProperty(exports, "__esModule", ({
  value: true
}));
/* extends.js

    Purpose:
        
    Description:
        
    History:
        1:02 PM 2023/8/21, Created by jumperchen

Copyright (C) 2023 Potix Corporation. All Rights Reserved.
*/
var extendStatics = function (d, b) {
  extendStatics = Object.setPrototypeOf || {
    __proto__: []
  } instanceof Array && function (d, b) {
    d.__proto__ = b;
  } || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
  };
  return extendStatics(d, b);
};
// refer tslib#__extends
function default_1(d, b) {
  extendStatics(d, b);
  function __() {
    this.constructor = d;
  }
  d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
  d.prototype._$super = d.name == '$subclass$' && b.prototype._$super ? b.prototype._$super : b.prototype; // Potix: Jumper Chen adds to support `$supers(foo.Bar, 'bind_')`
}
exports["default"] = default_1;

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/sel/ItemWidget.ts":
/*!*************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/sel/ItemWidget.ts ***!
  \*************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ItemWidget = void 0;
/* ItemWidget.ts

    Purpose:

    Description:

    History:
        Fri May 22 21:50:50     2009, Created by tomyeh

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
function _isListgroup(w) {
  return zk.isLoaded('zkex.sel') && w instanceof zkex.sel.Listgroup;
}
function _isListgroupfoot(w) {
  return zk.isLoaded('zkex.sel') && w instanceof zkex.sel.Listgroupfoot;
}
/**
 * The item widget for {@link Treeitem} and {@link Listitem}
 */
var ItemWidget = /** @class */function (_super) {
  __extends(ItemWidget, _super);
  function ItemWidget() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._selectable = true;
    return _this;
  }
  /**
   * @deprecated As of release 8.0.0, please use {@link isSelectable}
   * @returns boolean
   */
  ItemWidget.prototype.isCheckable = function () {
    return !!this._checkable;
  };
  /**
   * @deprecated As of release 8.0.0, please use {@link setSelectable}
   */
  ItemWidget.prototype.setCheckable = function (checkable, opts) {
    var o = this._checkable;
    this._checkable = checkable;
    if (o !== checkable || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this.setSelectable(checkable);
    }
    return this;
  };
  /**
   * @returns whether it is selectable.
   * @defaultValue `true`.
   * @since 8.0.0
   */
  ItemWidget.prototype.isSelectable = function () {
    return this._selectable;
  };
  /**
   * Sets whether it is selectable.
   * @defaultValue `true`.
   * @since 8.0.0
   */
  ItemWidget.prototype.setSelectable = function (selectable, opts) {
    var o = this._selectable;
    this._selectable = selectable;
    if (o !== selectable || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.desktop) this.rerender();
    }
    return this;
  };
  /**
   * @returns whether it is disabled.
   * @defaultValue `false`.
   */
  ItemWidget.prototype.isDisabled = function () {
    return !!this._disabled;
  };
  /**
   * Sets whether it is disabled.
   */
  ItemWidget.prototype.setDisabled = function (disabled, opts) {
    var o = this._disabled;
    this._disabled = disabled;
    if (o !== disabled || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.desktop) this.rerender();
    }
    return this;
  };
  /**
   * @returns the value.
   * @defaultValue `null`.
   * <p>Note: the value is application dependent, you can place
   * whatever value you want.
   * <p>If you are using listitem/treeitem with HTML Form (and with
   * the name attribute), it is better to specify a String-typed
   * value.
   */
  ItemWidget.prototype.getValue = function () {
    return this._value;
  };
  /**
   * @returns the index of this item (a.k.a., the order in the SelectWidget).
   * @since 10.0.0
   */
  ItemWidget.prototype.getIndex = function () {
    return this._index;
  };
  /**
   * Sets the value.
   * @param value - the value.
   * <p>Note: the value is application dependent, you can place
   * whatever value you want.
   * <p>If you are using listitem/treeitem with HTML Form (and with
   * the name attribute), it is better to specify a String-typed
   * value.
   */
  ItemWidget.prototype.setValue = function (value) {
    this._value = value;
    return this;
  };
  /**
   * Sets whether it is selected.
   */
  ItemWidget.prototype.setSelected = function (selected) {
    var _a;
    if (this._selected != selected) {
      (_a = this.getMeshWidget()) === null || _a === void 0 ? void 0 : _a.toggleItemSelection(this);
      this._setSelectedDirectly(selected);
    }
    return this;
  };
  /** @internal */
  ItemWidget.prototype._setSelectedDirectly = function (selected) {
    var n = this.$n();
    // do this before _updHeaderCM(), otherwise, it will call too many times to sync the state.
    this._selected = selected;
    if (n) {
      jq(n)[selected ? 'addClass' : 'removeClass'](this.$s('selected'));
      this._updHeaderCM();
    }
  };
  /**
   * @returns the label of the {@link Listcell} or {@link Treecell} it contains, or null
   * if no such cell.
   */
  ItemWidget.prototype.getLabel = function () {
    // Note: Only Listitem uses this method. Treeitem overrides this method.
    return this.firstChild ? this.firstChild.getLabel() : undefined;
  };
  /**
   * @returns whether it is selected.
   * @defaultValue `false`.
   */
  ItemWidget.prototype.isSelected = function () {
    return !!this._selected;
  };
  /**
   * @returns whether is stripeable or not.
   * @defaultValue `true`.
   * @internal
   */
  ItemWidget.prototype.isStripeable_ = function () {
    return true;
  };
  /**
   * @returns the mesh widget.
   */
  ItemWidget.prototype.getMeshWidget = function () {
    return this.parent;
  };
  /** @internal */
  ItemWidget.prototype._getVisibleChild = function (row) {
    for (var i = 0, j = row.cells.length; i < j; i++) if (zk(row.cells[i]).isVisible()) return row.cells[i];
    return row;
  };
  ItemWidget.prototype.setVisible = function (visible) {
    var _a;
    if (this._visible != visible) {
      // not to use isVisible()
      _super.prototype.setVisible.call(this, visible);
      if (this.isStripeable_()) {
        // Only Listbox is stripeable.
        (_a = this.getMeshWidget()) === null || _a === void 0 ? void 0 : _a.stripe();
      }
    }
    return this;
  };
  /** @internal */
  ItemWidget.prototype.domClass_ = function (no) {
    var /*safe*/scls = _super.prototype.domClass_.call(this, no);
    if (!no || !no.zclass) {
      if (this.isDisabled()) scls += (scls ? ' ' : '') + this.$s('disabled');
      //Bug ZK-1998: only apply selected style if groupSelect is true
      if (_isListgroup(this) || _isListgroupfoot(this)) {
        if (this.getMeshWidget().groupSelect && this.isSelected()) scls += (scls ? ' ' : '') + this.$s('selected');
      } else {
        if (this.isSelected()) scls += (scls ? ' ' : '') + this.$s('selected');
      }
    }
    return scls;
  };
  /** @internal */
  ItemWidget.prototype.focus_ = function (timeout) {
    var mesh = this.getMeshWidget();
    this._doFocusIn();
    mesh._syncFocus(this);
    mesh.focusA_(mesh.$n('a'), timeout);
    return true;
  };
  /** @internal */
  ItemWidget.prototype._doFocusIn = function () {
    var _a;
    var n = this.$n(),
      mesh = this.getMeshWidget();
    if (n) {
      var cls = this.$s('focus'),
        lastn = (_a = mesh === null || mesh === void 0 ? void 0 : mesh._focusItem) === null || _a === void 0 ? void 0 : _a.$n();
      // ZK-3077: focus out the last focused item first (for draggable issue)
      if (lastn) jq(lastn).removeClass(cls);
      // Bugfix: add focus class on itself, not on its children elements
      jq(n).addClass(cls);
    }
    if (mesh) mesh._focusItem = this;
  };
  /** @internal */
  ItemWidget.prototype._doFocusOut = function () {
    var n = this.$n();
    if (n) {
      var cls = this.$s('focus');
      jq(n).removeClass(cls);
      jq(n.cells).removeClass(cls);
    }
  };
  /** @internal */
  ItemWidget.prototype._updHeaderCM = function (bRemove) {
    var box = this.getMeshWidget();
    if ((box === null || box === void 0 ? void 0 : box._headercm) && box._multiple) {
      if (bRemove) {
        box._updHeaderCM();
        return;
      }
      var headerWgt = zk.Widget.$(box._headercm),
        zcls = headerWgt.$s('checked'),
        $headercm = jq(box._headercm);
      // only update for user's selection or sharable model case (ZK-2969 test case)
      if (!this.isSelected() && (box.$$selectAll == undefined || this._userSelection)) {
        $headercm.removeClass(zcls);
        headerWgt._checked = false;
      } else if (!$headercm.hasClass(zcls)) box._updHeaderCM(); //update in batch since we have to examine one-by-one
    }
  };
  /** @internal */
  ItemWidget.prototype.getDragMessage_ = function () {
    var iterator = this.getMeshWidget().itemIterator();
    var cnt = 2,
      msg;
    if (!this.isSelected()) return zUtl.encodeXML(this.getLabel());
    while (iterator.hasNext()) {
      var item = iterator.next();
      if (item.isSelected()) {
        var label = item.getLabel();
        if (label.length > 9) label = label.substring(0, 9) + '...';
        label = zUtl.encodeXML(label);
        if (!msg) msg = label;else /*safe*/msg += '</div><div class="z-drop-content">' + "<span id=\"zk_ddghost-img".concat(cnt++, "\" class=\"z-drop-icon\"></span>&nbsp;").concat(label);
      }
    }
    return msg;
  };
  // override it because msg cut in getDragMessage_,
  // do not want cut again here, and change _dragImg to array
  /** @internal */
  ItemWidget.prototype.cloneDrag_ = function (drag, ofs) {
    //See also bug 1783363 and 1766244
    var msg = this.getDragMessage_(),
      dgelm = zk.DnD.ghost(drag, ofs, msg);
    drag._orgcursor = document.body.style.cursor;
    document.body.style.cursor = 'pointer';
    jq(this.getDragNode()).addClass('z-dragged'); //after clone
    // has multi drag image
    drag._dragImg = jq('span[id^="zk_ddghost-img"]');
    return dgelm;
  };
  /** @internal */
  ItemWidget.prototype.beforeParentChanged_ = function (newp) {
    if (!newp) {
      //remove
      var mesh = this.getMeshWidget();
      if (mesh) mesh._shallSyncCM = true;
    }
    _super.prototype.beforeParentChanged_.call(this, newp);
  };
  /** @internal */
  ItemWidget.prototype.afterParentChanged_ = function (oldparent) {
    if (this.parent) {
      //add
      var mesh = this.getMeshWidget();
      if (mesh) mesh._shallSyncCM = true;
    }
    _super.prototype.afterParentChanged_.call(this, oldparent);
  };
  // event
  /** @internal */
  ItemWidget.prototype.doSelect_ = function (evt) {
    if (this.isDisabled() || !this.isSelectable()) return;
    try {
      this._userSelection = true;
      if (!evt.itemSelected) {
        this.getMeshWidget()._doItemSelect(this, evt);
        evt.itemSelected = true;
      }
      _super.prototype.doSelect_.call(this, evt);
    } finally {
      this._userSelection = undefined;
    }
  };
  /** @internal */
  ItemWidget.prototype.doKeyDown_ = function (evt) {
    var mesh = this.getMeshWidget();
    // disable item's content selection excluding input box and textarea
    if (!jq.nodeName(evt.domTarget, 'input', 'textarea')) {
      this._disableSelection_ = true;
      zk(mesh.$n()).disableSelection();
    }
    mesh._doKeyDown(evt);
    _super.prototype.doKeyDown_.call(this, evt);
  };
  /** @internal */
  ItemWidget.prototype.doKeyUp_ = function (evt) {
    var mesh = this.getMeshWidget();
    if (this._disableSelection_) {
      zk(mesh.$n()).enableSelection();
      this._disableSelection_ = false;
    }
    mesh._doKeyUp(evt);
    _super.prototype.doKeyUp_.call(this, evt);
  };
  /** @internal */
  ItemWidget.prototype.deferRedrawHTML_ = function (out) {
    out.push("<tr ".concat(this.domAttrs_({
      domClass: true
    }), " class=\"z-renderdefer\"></tr>"));
  };
  /**
   * This method should be overridden by its subwidget.
   * @returns -1 if item is before this object,
   * 0 if item is the same as this object,
   * 1 if item is after this object.
   * @since 8.5.0
   * @internal
   */
  ItemWidget.prototype.compareItemPos_ = function (item) {
    return 0;
  };
  /** @internal */
  ItemWidget.prototype.getFlexContainer_ = function () {
    return undefined;
  };
  /** @internal */
  ItemWidget.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    zWatch.listen({
      onResponse: this
    });
  };
  /** @internal */
  ItemWidget.prototype.unbind_ = function (skipper, after, keepRod) {
    zWatch.unlisten({
      onResponse: this
    });
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /** @internal */
  ItemWidget.prototype.onChildAdded_ = function (child) {
    _super.prototype.onChildAdded_.call(this, child);
    // ZK-5038
    this._shallCheckClearCache = true;
  };
  /** @internal */
  ItemWidget.prototype.onChildRemoved_ = function (child) {
    _super.prototype.onChildRemoved_.call(this, child);
    // ZK-5038
    this._shallCheckClearCache = true;
  };
  ItemWidget.prototype.onResponse = function () {
    var _a;
    if (this._shallCheckClearCache) {
      this._shallCheckClearCache = false;
      if ((_a = this.getMeshWidget()) === null || _a === void 0 ? void 0 : _a.isCheckmark()) {
        this.clearCache();
      }
    }
  };
  ItemWidget = __decorate([zk.WrapClass('zul.sel.ItemWidget')], ItemWidget);
  return ItemWidget;
}(zul.Widget);
exports.ItemWidget = ItemWidget;
if (!window.zul) window.zul = {};
if (!window.zul.sel) window.zul.sel = {};
if (!window.zul.sel.ItemWidget) window.zul.sel.ItemWidget = {};
window.zul.sel.ItemWidget._ = {
  _isListgroup: _isListgroup,
  _isListgroupfoot: _isListgroupfoot,
  ItemWidget: ItemWidget
};

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/sel/Listbox.ts":
/*!**********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/sel/Listbox.ts ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.ItemIter = exports.Listbox = void 0;
/* Listbox.ts

    Purpose:

    Description:

    History:
        Thu Apr 30 22:16:07     2009, Created by tomyeh

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
function _isListgroup(wgt) {
  return zk.isLoaded('zkex.sel') && wgt instanceof zkex.sel.Listgroup;
}
function _syncFrozen(wgt) {
  var frozen = wgt.frozen;
  if (wgt._nativebar && frozen) frozen._syncFrozen();
}
function _fixForEmpty(wgt) {
  if (wgt.desktop) {
    var empty = wgt.$n_('empty'),
      colspan = 0;
    if (wgt._nrows) {
      empty.style.display = 'none';
    } else {
      if (wgt.listhead) {
        for (var w = wgt.listhead.firstChild; w; w = w.nextSibling) colspan++;
      }
      empty.colSpan = colspan || 1;
      // ZK-2365 table cell needs the "display:table-cell" when colspan is enable.
      empty.style.display = 'table-cell';
    }
  }
  wgt._shallFixEmpty = false;
}
var Listbox = /** @class */function (_super) {
  __extends(Listbox, _super);
  function Listbox() {
    var _this = _super.call(this) || this; // FIXME: params?
    // override firstChild!: zul.sel.Listitem | null;
    // override lastChild!: zul.sel.Listitem | null;
    /** @internal */
    _this._nrows = 0;
    /**
     * Whether to allow Listgroup to be selected
     * @defaultValue `false`
     * @since 5.0.7
     */
    _this.groupSelect = false;
    /** @internal */
    _this._scrollbar = undefined;
    /** @internal */
    _this._emptyMessage = undefined;
    /**
     * @returns the list item iterator.
     * @see {@link itemIterator}
     */
    _this.getBodyWidgetIterator = Listbox_1.prototype.itemIterator;
    _this._groupsInfo = [];
    return _this;
  }
  Listbox_1 = Listbox;
  /**
   * @returns the message to display when there are no items
   * @since 5.0.7
   */
  Listbox.prototype.getEmptyMessage = function () {
    return this._emptyMessage;
  };
  /**
   * Sets the message to display when there are no items
   * @since 5.0.7
   */
  Listbox.prototype.setEmptyMessage = function (emptyMessage, opts) {
    var o = this._emptyMessage;
    this._emptyMessage = emptyMessage;
    if (o !== emptyMessage || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.desktop) {
        var emptyContentDiv = jq(this.$n_('empty-content')),
          emptyContentClz = this.$s('emptybody-content');
        if (emptyMessage && emptyMessage.trim().length != 0) emptyContentDiv.addClass(emptyContentClz);else emptyContentDiv.removeClass(emptyContentClz);
        emptyContentDiv.text(emptyMessage);
      }
    }
    return this;
  };
  /**
   * @returns the number of listgroup
   */
  Listbox.prototype.getGroupCount = function () {
    return this._groupsInfo.length;
  };
  /**
   * @returns a list of all {@link Listgroup}.
   */
  Listbox.prototype.getGroups = function () {
    return this._groupsInfo.$clone();
  };
  /**
   * @returns whether listgroup exists.
   */
  Listbox.prototype.hasGroup = function () {
    return !!this._groupsInfo.length;
  };
  /**
   * @returns the next item.
   */
  Listbox.prototype.nextItem = function (p) {
    if (p) while ((p = p.nextSibling) && !(p instanceof zul.sel.Listitem));
    return p;
  };
  /**
   * @returns the previous item.
   */
  Listbox.prototype.previousItem = function (p) {
    if (p) while ((p = p.previousSibling) && !(p instanceof zul.sel.Listitem));
    return p;
  };
  /**
   * @returns the style class for the odd rows.
   * @defaultValue {@link getZclass}-odd.
   */
  Listbox.prototype.getOddRowSclass = function () {
    return this._scOddRow == null ? this.$s('odd') : this._scOddRow;
  };
  /**
   * Sets the style class for the odd rows. If the style class doesn't exist,
   * the striping effect disappears. You can provide different effects by
   * providing the proper style classes.
   * @returns Listbox
   */
  Listbox.prototype.setOddRowSclass = function (oddRowSclass) {
    var scls = oddRowSclass || undefined;
    if (this._scOddRow != scls) {
      this._scOddRow = scls;
      var n = this.$n();
      // FIXME: Prior to TS migration, it has been `this.rows`, but that
      // seems wrong, as no `rows` is only defined in Grid, and MeshWidget
      // from which this class inherits, defines `_rows`.
      if (n && this._rows) this.stripe();
    }
    return this;
  };
  /**
   * @returns whether the HTML's select tag is used.
   */
  Listbox.prototype.inSelectMold = function () {
    return 'select' == this.getMold();
  };
  // bug ZK-56 for non-ROD to scroll after onSize ready
  Listbox.prototype.onSize = function () {
    var _this = this;
    _super.prototype.onSize.call(this);
    var canInitScrollbar = this.desktop && !this.inSelectMold() && !this._nativebar;
    // refix ZK-2840: only init scrollbar when height or vflex is set in mobile
    if (!this._scrollbar && canInitScrollbar) {
      if (!zk.mobile || zk.mobile && (this.getHeight() || this.getVflex())) {
        this._scrollbar = zul.mesh.Scrollbar.init(this); // 1823278: should show scrollbar here
      }
    }
    setTimeout(function () {
      if (_this.desktop) {
        if (canInitScrollbar) {
          _this.refreshBar_();
        }
        // we have to do this for B50-ZK-56.zul, no matter native scroll or not
        _this._syncSelInView();
      }
    }, 300);
  };
  /** @internal */
  Listbox.prototype.destroyBar_ = function () {
    var bar = this._scrollbar;
    if (bar) {
      bar.destroy();
      bar = this._scrollbar = undefined;
    }
  };
  /** @internal */
  Listbox.prototype.bind_ = function (desktop, skipper, after) {
    var _this = this;
    _super.prototype.bind_.call(this, desktop, skipper, after); //it might invoke replaceHTML and then call bind_ again
    this._shallStripe = true;
    after.push(function () {
      _this.stripe();
      _syncFrozen(_this);
      _fixForEmpty(_this);
    });
    this._shallScrollIntoView = true;
    if (this._listbox$shallUpdateScrollPos) {
      this._fireOnScrollPos();
    }
    zWatch.listen({
      onCommandReady: this
    }); //ZK-3152
  };
  /** @internal */
  Listbox.prototype.unbind_ = function (skipper, after, keepRod) {
    zWatch.unlisten({
      onCommandReady: this
    }); //ZK-3152
    this.destroyBar_();
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /** @internal */
  Listbox.prototype._syncSelInView = function () {
    var _a;
    if (this._shallScrollIntoView) {
      // ZK-2971: should scroll when not in paging or in paging but operating with keyboard
      // ZK-3103: if in paging mode, should also scroll when setting selected item/index
      var $class = this.$class;
      if (!this.paging || ((_a = $class.shallSyncSelInView) === null || _a === void 0 ? void 0 : _a[this.uuid]) || this._listbox$shallSyncSelInView) {
        var selItems = this._selItems,
          selItemIndex = -1;
        // FIXME: If the purpose of the following loop is to find the selItem with the smallest _index, then the logic is wrong.
        for (var i = 0; i < selItems.length; i++) {
          // ZK-4323: find item that has the smallest index
          if (selItems[i]._index < selItemIndex || selItemIndex < 0) selItemIndex = i;
        }
        var selItem = selItems[selItemIndex],
          isSetSelectedItemIndexCalled = this._listbox$shallSyncSelInView;
        if (selItem) {
          var bar = this._scrollbar,
            selItemTop = selItem.$n_().offsetTop;
          if (bar) {
            if (isSetSelectedItemIndexCalled) bar.scrollToElement(selItem.$n_());else bar.scrollTo(zul.mesh.Scrollbar.getScrollPosH(this), selItemTop);
          } else {
            if (isSetSelectedItemIndexCalled) zk(selItem).scrollIntoView(this.ebody);else this.ebody.scrollTop = selItemTop;
            this._tmpScrollTop = this.ebody.scrollTop;
          }
        }
        if ($class.shallSyncSelInView) $class.shallSyncSelInView[this.uuid] = false;
        if (isSetSelectedItemIndexCalled) this._listbox$shallSyncSelInView = false;
      }
      // do only once
      this._shallScrollIntoView = false;
    }
  };
  /** @internal */
  Listbox.prototype._doScroll = function () {
    // B50-ZK-56
    // ebody.scrollTop will be reset after between fireOnRender and _doScroll after bind_
    if (this._tmpScrollTop) {
      this.ebody.scrollTop = this._tmpScrollTop;
      this._tmpScrollTop = undefined;
    }
    _super.prototype._doScroll.call(this);
  };
  Listbox.prototype.onCommandReady = function () {
    //ZK-3152: stripe here will be after all commands and before onResponse to avoid flickering
    if (this._shallStripe) this.stripe();
  };
  Listbox.prototype.onResponse = function (ctl, opts) {
    if (this.desktop) {
      //ZK-3152: no need to stripe here, already done in onCommandReady
      if (this._shallFixEmpty) _fixForEmpty(this);
    }
    _super.prototype.onResponse.call(this, ctl, opts);
  };
  /** @internal */
  Listbox.prototype._syncStripe = function () {
    this._shallStripe = true;
  };
  /**
   * Stripes the class for each item.
   * @returns Listbox
   */
  Listbox.prototype.stripe = function () {
    var scOdd = this.getOddRowSclass();
    if (!scOdd) return;
    var odd = this._offset & 1,
      even = !odd,
      it = this.getBodyWidgetIterator();
    for (var w; w = it.next();) {
      if (w.isVisible() && w.isStripeable_()) {
        jq(w)[even ? 'removeClass' : 'addClass'](scOdd);
        even = !even;
      }
    }
    this._shallStripe = false;
    return this;
  };
  Listbox.prototype.rerender = function (skipper) {
    _super.prototype.rerender.call(this, skipper);
    this._syncStripe();
    return this;
  };
  Listbox.prototype.getCaveNode = function () {
    var _a;
    return (_a = this.$n('rows')) !== null && _a !== void 0 ? _a : this.$n('cave');
  };
  /** @internal */
  Listbox.prototype.insertChildHTML_ = function (child, before, desktop) {
    var nodeOfBefore = before && (!(child instanceof zul.sel.Listitem) || before instanceof zul.sel.Listitem) ? before.getFirstNode_() : undefined;
    if (nodeOfBefore) jq(nodeOfBefore).before( /*safe*/child.redrawHTML_());else jq(this.getCaveNode()).append( /*safe*/child.redrawHTML_());
    child.bind(desktop);
  };
  Listbox.prototype.insertBefore = function (child, sibling, ignoreDom) {
    if (_super.prototype.insertBefore.call(this, child, sibling, ignoreDom || !this.z_rod && !(child instanceof zul.sel.Listitem))) {
      this._fixOnAdd(child, ignoreDom);
      return true;
    }
    return false;
  };
  Listbox.prototype.appendChild = function (child, ignoreDom) {
    if (_super.prototype.appendChild.call(this, child, ignoreDom || !this.z_rod && !(child instanceof zul.sel.Listitem))) {
      if (!this.insertingBefore_) this._fixOnAdd(child, ignoreDom);
      return true;
    }
    return false;
  };
  /** @internal */
  Listbox.prototype._fixOnAdd = function (child, ignoreDom, stripe, ignoreAll) {
    var noRerender;
    if (child instanceof zul.sel.Listitem) {
      if (_isListgroup(child)) this._groupsInfo.push(child);
      if (!this.firstItem || !this.previousItem(child)) this.firstItem = child;
      if (!this.lastItem || !this.nextItem(child)) this.lastItem = child;
      ++this._nrows;
      if (child.isSelected() && !this._selItems.$contains(child)) this._selItems.push(child);
      noRerender = stripe = true;
    } else if (child instanceof zul.sel.Listhead) {
      this.listhead = child;
    } else if (child instanceof zul.mesh.Paging) {
      this.paging = child;
      this.paging.setMeshWidget(this);
    } else if (child instanceof zul.sel.Listfoot) {
      this.listfoot = child;
    } else if (child instanceof zul.mesh.Frozen) {
      this.frozen = child;
    }
    this._syncEmpty();
    if (!ignoreAll) {
      if (!ignoreDom && !noRerender) return this.rerender();
      if (stripe) this._syncStripe();
      if (!ignoreDom) this._syncSize();
      if (this.desktop) _syncFrozen(this);
    }
  };
  Listbox.prototype.removeChild = function (child, ignoreDom) {
    if (_super.prototype.removeChild.call(this, child, ignoreDom)) {
      this._fixOnRemove(child, ignoreDom);
      return true;
    }
    return false;
  };
  /** @internal */
  Listbox.prototype._fixOnRemove = function (child, ignoreDom) {
    var stripe;
    if (child == this.listhead) this.listhead = undefined;else if (child == this.paging) {
      this.paging.setMeshWidget(undefined);
      this.paging = undefined;
    } else if (child == this.frozen) {
      this.frozen = undefined;
      this.destroyBar_();
    } else if (child == this.listfoot) this.listfoot = undefined;else if (!(child instanceof zul.mesh.Auxhead)) {
      if (child == this.firstItem) {
        for (var p = this.firstChild, Listitem = zul.sel.Listitem; p && !(p instanceof Listitem); p = p.nextSibling);
        this.firstItem = p;
      }
      if (child == this.lastItem) {
        for (var p = this.lastChild, Listitem = zul.sel.Listitem; p && !(p instanceof Listitem); p = p.previousSibling);
        this.lastItem = p;
      }
      if (_isListgroup(child)) this._groupsInfo.$remove(child);
      --this._nrows;
      if (child.isSelected()) this._selItems.$remove(child);
      stripe = true;
    }
    this._syncEmpty();
    if (!ignoreDom) {
      //unlike _fixOnAdd, it ignores strip too (historical reason; might be able to be better)
      if (stripe) this._syncStripe();
      this._syncSize();
    }
  };
  /**
   * A redraw method for the empty message , if you want to customize the message ,
   * you could overwrite this.
   * @param out - A array that contains html structure, it usually come from `mold(redraw_)`.
   * @internal
   */
  Listbox.prototype.redrawEmpty_ = function (out) {
    out.push('<tbody class="', this.$s('emptybody'), '"><tr><td id="', this.uuid, '-empty" style="display:none">', '<div id="', this.uuid, '-empty-content"');
    if (this._emptyMessage && this._emptyMessage.trim().length != 0) out.push('class="', this.$s('emptybody-content'), '"');
    out.push('>', zUtl.encodeXML(this._emptyMessage), '</div></td></tr></tbody>');
  };
  /** @internal */
  Listbox.prototype.replaceChildHTML_ = function (child, n, desktop, skipper, _trim_) {
    if (child._renderdefer) {
      var scOdd = this.getOddRowSclass(),
        isOdd = jq(n).hasClass(scOdd); // supers will change this result, we need to cache it
      _super.prototype.replaceChildHTML_.call(this, child, n, desktop, skipper, _trim_);
      if (isOdd) jq(child).addClass(scOdd);
    } else _super.prototype.replaceChildHTML_.call(this, child, n, desktop, skipper, _trim_);
  };
  /** @internal */
  Listbox.prototype._syncEmpty = function () {
    this._shallFixEmpty = true;
  };
  /** @internal */
  Listbox.prototype.onChildReplaced_ = function (oldc, newc) {
    _super.prototype.onChildReplaced_.call(this, oldc, newc);
    if (oldc) this._fixOnRemove(oldc, true);
    if (newc) this._fixOnAdd(newc, true, false, true); //ignoreAll: no sync stripe...
    if (oldc && oldc instanceof zul.sel.Listitem || newc && newc instanceof zul.sel.Listitem) this._syncStripe();
    this._syncSize();
    if (this.desktop) _syncFrozen(this);
  };
  /**
   * @returns the head widget class
   */
  Listbox.prototype.getHeadWidgetClass = function () {
    return zul.sel.Listhead;
  };
  /**
   * @returns the list item iterator.
   */
  Listbox.prototype.itemIterator = function (opts) {
    return new zul.sel.ItemIter(this, opts);
  };
  /** @internal */
  Listbox.prototype._getListitemIterator = function () {
    return this.getBodyWidgetIterator();
  };
  /** @internal */
  Listbox.prototype._updHeaderCM = function () {
    var _a;
    // B50-3322970: need to clear Listheader _check cache
    var lh = (_a = this.listhead) === null || _a === void 0 ? void 0 : _a.firstChild;
    if (this._headercm && this._multiple && lh) lh._checked = this._isAllSelected();
    _super.prototype._updHeaderCM.call(this);
  }; // @Override F70-ZK-2433
  /** @internal */
  Listbox.prototype.checkOnHighlightDisabled_ = function () {
    if (this._selectOnHighlightDisabled) {
      return window.getSelection().toString().length > 0;
    }
    return false;
  };
  /**
   * Scroll to the specified item by the given index.
   * @param index - the index of listitem
   * @param scrollRatio - the scroll ratio
   * @since 8.5.2
   */
  Listbox.prototype.scrollToIndex = function (index, scrollRatio) {
    var _this = this;
    void this.waitForRendered_().then(function () {
      _this._scrollToIndex(index, scrollRatio);
    });
  };
  /** @internal */
  Listbox.prototype._getFirstItemIndex = function () {
    return this.firstItem._index;
  };
  /** @internal */
  Listbox.prototype._getLastItemIndex = function () {
    return this.lastItem._index;
  };
  /** @internal */
  Listbox.prototype.setItemsInvalid_ = function (itemsInvalid) {
    var _this = this;
    zAu.createWidgets(itemsInvalid, function (ws) {
      if (_this.$n('rows')) {
        _this.replaceCavedChildren_('rows', ws);
      } else {
        //remove all listitems
        var fc;
        for (var item = _this.firstItem; item;) {
          // B60-ZK-1230: Only removes the first list item
          var n = _this.nextItem(item);
          if (!n) fc = item.nextSibling;
          _this.removeChild(item, true);
          item = n;
        }
        //add new items
        for (var j = 0, len = ws.length; j < len; ++j) _this.insertBefore(ws[j], fc, true); //no dom
      }
    }, function (wx) {
      for (var w = wx, p = wx; w; p = w, w = w.parent) if (w == _this && p instanceof zul.sel.Listitem) return; //ignore it since it is going to be removed
      return wx;
    });
    return this;
  };
  var Listbox_1;
  Listbox = Listbox_1 = __decorate([zk.WrapClass('zul.sel.Listbox')], Listbox);
  return Listbox;
}(zul.sel.SelectWidget);
exports.Listbox = Listbox;
/**
 * The listitem iterator.
 */
var ItemIter = /** @class */function (_super) {
  __extends(ItemIter, _super);
  /**
   * @param listbox - the widget that the iterator belongs to
   */
  function ItemIter(box, opts) {
    var _this = _super.call(this) || this;
    _this.box = box;
    _this.opts = opts;
    return _this;
  }
  /** @internal */
  ItemIter.prototype._init = function () {
    var _a;
    if (!this._isInit) {
      this._isInit = true;
      var p = this.box.firstItem;
      if ((_a = this.opts) === null || _a === void 0 ? void 0 : _a.skipHidden) for (; p && !p.isVisible(); p = this.box.nextItem(p)) {/* empty */}
      this.p = p;
    }
  };
  /**
  * @returns `true` if the iteration has more elements
  */
  ItemIter.prototype.hasNext = function () {
    this._init();
    return !!this.p;
  };
  /**
   * @returns the next element in the iteration.
   */
  ItemIter.prototype.next = function () {
    var _a;
    this._init();
    var p = this.p,
      q = p ? p.parent.nextItem(p) : undefined;
    if ((_a = this.opts) === null || _a === void 0 ? void 0 : _a.skipHidden) for (; q && !q.isVisible(); q = q.parent.nextItem(q)) {/* empty */}
    if (p) this.p = q;
    return p;
  };
  ItemIter = __decorate([zk.WrapClass('zul.sel.ItemIter')], ItemIter);
  return ItemIter;
}(zk.Object);
exports.ItemIter = ItemIter;
if (!window.zul) window.zul = {};
if (!window.zul.sel) window.zul.sel = {};
if (!window.zul.sel.Listbox) window.zul.sel.Listbox = {};
window.zul.sel.Listbox._ = {
  _isListgroup: _isListgroup,
  _syncFrozen: _syncFrozen,
  _fixForEmpty: _fixForEmpty,
  Listbox: Listbox,
  ItemIter: ItemIter
};

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/sel/Listcell.ts":
/*!***********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/sel/Listcell.ts ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Listcell = void 0;
/* Listcell.ts

    Purpose:

    Description:

    History:
        Thu Apr 30 22:17:54     2009, Created by tomyeh

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
function _isListgroup(wgt) {
  return zk.isLoaded('zkex.sel') && wgt instanceof zkex.sel.Listgroup;
}
function _isListgroupfoot(wgt) {
  return zk.isLoaded('zkex.sel') && wgt instanceof zkex.sel.Listgroupfoot;
}
/**
 * A list cell.
 *
 * @defaultValue {@link getZclass}: z-listcell
 */
var Listcell = /** @class */function (_super) {
  __extends(Listcell, _super);
  function Listcell() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._span = 1;
    return _this;
  }
  /**
   * @returns number of columns to span this cell.
   * @defaultValue `1`.
   */
  Listcell.prototype.getColspan = function () {
    return this.getSpan();
  };
  /**
   * Sets the number of columns to span this cell.
   * <p>It is the same as the colspan attribute of HTML TD tag.
   */
  Listcell.prototype.setColspan = function (colspan, opts) {
    return this.setSpan(colspan, opts);
  };
  // change colspan to span since ZK 10.0.0
  Listcell.prototype.getSpan = function () {
    return this._span;
  };
  // change colspan to span since ZK 10.0.0
  Listcell.prototype.setSpan = function (span, opts) {
    var o = this._span;
    this._span = span = Math.max(span, 1);
    if (o !== span || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n();
      if (n) n.colSpan = this._span;
    }
    return this;
  };
  Listcell.prototype.setLabel = function (label, opts) {
    _super.prototype.setLabel.call(this, label, opts);
    if (this.desktop) {
      var p = this.parent;
      if (_isListgroup(p)) p.rerender();else if (p instanceof zul.sel.Option || p instanceof zul.sel.Optgroup) p.updateLabel_();
    }
    return this;
  };
  /**
   * @returns the list box that it belongs to.
   */
  Listcell.prototype.getListbox = function () {
    var p = this.parent;
    return p ? p.parent : undefined;
  };
  Listcell.prototype.getTextNode = function () {
    return jq(this.$n_()).find('>div:first')[0];
  };
  /**
   * @returns the maximal length for this cell.
   * If listbox's mold is "select", it is the same as
   * {@link Select#getMaxlength}
   * If not, it is the same as the correponding {@link getListheader}'s
   * {@link Listheader#getMaxlength}.
   *
   * <p>Note: {@link Option#getMaxlength} is the same as {@link Select#getMaxlength}.
   */
  Listcell.prototype.getMaxlength = function () {
    var box = this.getListbox();
    if (!box) return 0;
    if (box.getMold() == 'select') {
      // @ts-expect-error: This is likely dead code and Listbox doesn't have getMaxlength.
      // eslint-disable-next-line @typescript-eslint/no-unsafe-return, @typescript-eslint/no-unsafe-call
      return box.getMaxlength();
    }
    var lc = this.getListheader();
    return lc ? lc.getMaxlength() : 0;
  };
  /**
   * @returns the list header that is in the same column as
   * this cell, or null if not available.
   */
  Listcell.prototype.getListheader = function () {
    var box = this.getListbox();
    if (box === null || box === void 0 ? void 0 : box.listhead) {
      var j = this.getChildIndex();
      if (j < box.listhead.nChildren) return box.listhead.getChildAt(j);
    }
    return undefined;
  };
  /** @internal */
  Listcell.prototype.domLabel_ = function () {
    return zUtl.encodeXML(this.getLabel(), {
      maxlength: this.getMaxlength()
    });
  };
  /** @internal */
  Listcell.prototype.domContent_ = function () {
    var /*safe*/s1 = _super.prototype.domContent_.call(this),
      s2 = this._colHtmlPre();
    return s1 ? s2 ? s2 + '&nbsp;' + s1 : s1 : s2;
  };
  /** @internal */
  Listcell.prototype.domClass_ = function (no) {
    var /*safe*/scls = _super.prototype.domClass_.call(this, no),
      p = this.parent,
      head = this.getListheader();
    if ((!no || !no.zclass) && (_isListgroup(p) || _isListgroupfoot(p))) scls += ' ' + p.$s('inner');
    if (head && !head.isVisible()) scls += ' ' + this.$s('hidden-header');
    return scls;
  };
  Listcell.prototype.clearCache = function () {
    if (this.parent) {
      // Listitem.$n('cm') may be wrong if only the listcell is rerendered.
      this.parent.clearCache();
    }
    _super.prototype.clearCache.call(this);
  };
  /** @internal */
  Listcell.prototype._isFirstVisibleChild = function () {
    var firstVisibleChild = this.parent.firstChild;
    while (firstVisibleChild && !firstVisibleChild.isVisible()) firstVisibleChild = firstVisibleChild.nextSibling;
    return this == firstVisibleChild;
  };
  /** @internal */
  Listcell.prototype._colHtmlPre = function () {
    var _a, _b, _c;
    var s = '',
      box = this.getListbox(),
      p = this.parent;
    // ZK-5037: invisible first column hides checkmarks in a listbox
    if (box != null && ((_a = this.getListheader()) !== null && _a !== void 0 ? _a : this)._isFirstVisibleChild()) {
      var isGrp = _isListgroup(p);
      // insert checkmark
      //B70-ZK-2053:make sure checkmark won't display on multiple listgroup
      if (box.isCheckmark() && !_isListgroupfoot(p) && (!isGrp || box.groupSelect && box.isMultiple())) {
        // ZK-5035: Remove the old checkmark to prevent duplicate checkmarks
        if ((_b = this.parent) === null || _b === void 0 ? void 0 : _b.$n('cm')) (_c = this.nextSibling) === null || _c === void 0 ? void 0 : _c.rerender();
        var chkable = p.isSelectable(),
          multi = box.isMultiple();
        /*safe*/
        s += '<span id="' + /*safe*/p.uuid + '-cm" class="' + p.$s('checkable') + ' ' + (multi ? p.$s('checkbox') : p.$s('radio'));
        if (!chkable || p.isDisabled()) s += ' ' + p.$s('disabled');
        s += '"';
        if (!chkable) s += ' style="visibility:hidden"';
        s += '><i class="' + p.$s('icon') + ' ' + (multi ? 'z-icon-check' : 'z-icon-radio') + '"></i></span>';
      }
      // insert toggle icon
      if (_isListgroup(p)) {
        // For "type predicates" to work, isGrp cannot be used.
        var cls = p._open ? p.getIconOpenClass_() + ' ' + p.$s('icon-open') : p.getIconCloseClass_() + ' ' + p.$s('icon-close');
        /*safe*/
        s += '<span id="' + /*safe*/p.uuid + '-img" class="' + p.$s('icon') + '"><i class="' + /*safe*/cls + '"></i></span>';
      }
      if (s) return s;
    }
    return !this.getImage() && !this.getLabel() && !this.firstChild ? '&nbsp;' : '';
  };
  /** @internal */
  Listcell.prototype.doFocus_ = function (evt) {
    _super.prototype.doFocus_.call(this, evt);
    //sync frozen
    var box = this.getListbox(),
      frozen = box ? box.frozen : undefined,
      node = this.$n();
    if (frozen && node)
      // NOTE: non-null frozen implies non-null box
      box._moveToHidingFocusCell(node.cellIndex);
  };
  /** @internal */
  Listcell.prototype.doMouseOver_ = function (evt) {
    var n = this.$n();
    // ZK-2136: all children should apply -moz-user-select: none
    if (n && zk.gecko && (this._draggable || this.parent._draggable) && !jq.nodeName(evt.domTarget, 'input', 'textarea')) {
      jq(n).addClass('z-draggable-over');
    }
    _super.prototype.doMouseOver_.call(this, evt);
  };
  /** @internal */
  Listcell.prototype.doMouseOut_ = function (evt) {
    var n = this.$n();
    // ZK-2136: all children should apply -moz-user-select: none
    if (n && zk.gecko && (this._draggable || this.parent._draggable) && !jq.nodeName(evt.domTarget, 'input', 'textarea')) {
      jq(n).removeClass('z-draggable-over'); // Bug ZK-580
    }
    _super.prototype.doMouseOut_.call(this, evt);
  };
  /** @internal */
  Listcell.prototype.domAttrs_ = function (no) {
    return _super.prototype.domAttrs_.call(this, no) + (this._span > 1 ? " colspan=\"".concat(this._span, "\"") : '');
  };
  //-- super --//
  /** @internal */
  Listcell.prototype.domStyle_ = function (no) {
    var style = '',
      head = this.getListheader();
    if (head) {
      if (head._align) style += 'text-align:' + head._align + ';';
      if (head._valign) style += 'vertical-align:' + head._valign + ';';
      if (!head.isVisible()) no = zk.copy(no, {
        visible: true
      });
    }
    return _super.prototype.domStyle_.call(this, no) + style;
  };
  /** @internal */
  Listcell.prototype.bindChildren_ = function (desktop, skipper, after) {
    var p = this.parent;
    if (!p || !(p instanceof zul.sel.Option || p instanceof zul.sel.Optgroup)) _super.prototype.bindChildren_.call(this, desktop, skipper, after);
  };
  /** @internal */
  Listcell.prototype.unbindChildren_ = function (skipper, after, keepRod) {
    var p = this.parent;
    if (!p || !(p instanceof zul.sel.Option || p instanceof zul.sel.Optgroup)) _super.prototype.unbindChildren_.call(this, skipper, after, keepRod);
  };
  /** @internal */
  Listcell.prototype.deferRedrawHTML_ = function (out) {
    out.push("<td ".concat(this.domAttrs_({
      domClass: true
    }), " class=\"z-renderdefer\"></td>"));
  };
  Listcell = __decorate([zk.WrapClass('zul.sel.Listcell')], Listcell);
  return Listcell;
}(zul.LabelImageWidget);
exports.Listcell = Listcell;
if (!window.zul) window.zul = {};
if (!window.zul.sel) window.zul.sel = {};
if (!window.zul.sel.Listcell) window.zul.sel.Listcell = {};
window.zul.sel.Listcell._ = {
  _isListgroup: _isListgroup,
  _isListgroupfoot: _isListgroupfoot,
  Listcell: Listcell
};

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/sel/Listfoot.ts":
/*!***********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/sel/Listfoot.ts ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Listfoot = void 0;
/* Listfoot.ts

    Purpose:

    Description:

    History:
        Tue Jun  9 18:03:06     2009, Created by jumperchen

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.0 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * A row of {@link Listfooter}.
 *
 * <p>Like {@link Listhead}, each listbox has at most one {@link Listfoot}.
 * @defaultValue {@link getZclass}: z-listfoot
 */
var Listfoot = /** @class */function (_super) {
  __extends(Listfoot, _super);
  function Listfoot() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  /**
   * @returns the list box that it belongs to.
   */
  Listfoot.prototype.getListbox = function () {
    return this.parent;
  };
  //bug #3014664
  Listfoot.prototype.setVflex = function (vflex) {
    var vflex0 = false;
    return _super.prototype.setVflex.call(this, vflex0);
  };
  //bug #3014664
  Listfoot.prototype.setHflex = function (hflex) {
    var hflex0 = false;
    return _super.prototype.setHflex.call(this, hflex0);
  };
  /** @internal */
  Listfoot.prototype.deferRedrawHTML_ = function (out) {
    out.push('<tr', this.domAttrs_({
      domClass: true
    }), ' class="z-renderdefer"></tr>');
  };
  Listfoot = __decorate([zk.WrapClass('zul.sel.Listfoot')], Listfoot);
  return Listfoot;
}(zul.Widget);
exports.Listfoot = Listfoot;
if (!window.zul) window.zul = {};
if (!window.zul.sel) window.zul.sel = {};
if (!window.zul.sel.Listfoot) window.zul.sel.Listfoot = {};
window.zul.sel.Listfoot._ = {
  Listfoot: Listfoot
};

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/sel/Listfooter.ts":
/*!*************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/sel/Listfooter.ts ***!
  \*************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Listfooter = void 0;
/* Listfooter.ts

    Purpose:

    Description:

    History:
        Tue Jun  9 18:03:07     2009, Created by jumperchen

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.0 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * A column of the footer of a list box ({@link Listbox}).
 * Its parent must be {@link Listfoot}.
 *
 * <p>Unlike {@link Listheader}, you could place any child in a list footer.
 * <p>Note: {@link Listcell} also accepts children.
 * @defaultValue {@link getZclass}: z-listfooter.
 */
var Listfooter = /** @class */function (_super) {
  __extends(Listfooter, _super);
  function Listfooter() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  /**
   * @returns the listbox that this belongs to.
   */
  Listfooter.prototype.getListbox = function () {
    return this.getMeshWidget();
  };
  /**
   * @returns the list header that is in the same column as
   * this footer, or null if not available.
   */
  Listfooter.prototype.getListheader = function () {
    return this.getHeaderWidget();
  };
  /**
   * @returns the maximal length for this cell.
   * If listbox's mold is "select", it is the same as
   * {@link Select#getMaxlength}
   * If not, it is the same as the correponding {@link getListheader}'s
   * {@link Listheader#getMaxlength}.
   *
   * <p>Note: {@link Option#getMaxlength} is the same as {@link Select#getMaxlength}.
   * @since 5.0.5
   */
  Listfooter.prototype.getMaxlength = function () {
    var lc = this.getListheader();
    return lc ? lc.getMaxlength() : 0;
  };
  /** @internal */
  Listfooter.prototype.domLabel_ = function () {
    return zUtl.encodeXML(this.getLabel(), {
      maxlength: this.getMaxlength()
    });
  };
  Listfooter = __decorate([zk.WrapClass('zul.sel.Listfooter')], Listfooter);
  return Listfooter;
}(zul.mesh.FooterWidget);
exports.Listfooter = Listfooter;
if (!window.zul) window.zul = {};
if (!window.zul.sel) window.zul.sel = {};
if (!window.zul.sel.Listfooter) window.zul.sel.Listfooter = {};
window.zul.sel.Listfooter._ = {
  Listfooter: Listfooter
};

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/sel/Listhead.ts":
/*!***********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/sel/Listhead.ts ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Listhead = void 0;
/* Listhead.ts

    Purpose:

    Description:

    History:
        Thu Apr 30 22:25:45     2009, Created by tomyeh

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * A list headers used to define multi-columns and/or headers.
 *
 * @defaultValue {@link getZclass}: z-listhead.
 */
var Listhead = /** @class */function (_super) {
  __extends(Listhead, _super);
  function Listhead() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  /**
   * @returns the listbox that this belongs to.
   */
  Listhead.prototype.getListbox = function () {
    return this.parent;
  };
  /** @internal */
  Listhead.prototype.getGroupPackage_ = function () {
    return 'zkex.sel';
  };
  Listhead = __decorate([zk.WrapClass('zul.sel.Listhead')], Listhead);
  return Listhead;
}(zul.mesh.ColumnMenuWidget);
exports.Listhead = Listhead;
if (!window.zul) window.zul = {};
if (!window.zul.sel) window.zul.sel = {};
if (!window.zul.sel.Listhead) window.zul.sel.Listhead = {};
window.zul.sel.Listhead._ = {
  Listhead: Listhead
};

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/sel/Listheader.ts":
/*!*************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/sel/Listheader.ts ***!
  \*************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Listheader = void 0;
/* Listheader.ts

    Purpose:

    Description:

    History:
        Thu Apr 30 22:25:24     2009, Created by tomyeh

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * The list header which defines the attributes and header of a column
 * of a list box.
 * Its parent must be {@link Listhead}.
 *
 * <p>Difference from XUL:
 * <ol>
 * <li>There is no listcol in ZUL because it is merged into {@link Listheader}.
 * Reason: easier to write Listbox.</li>
 * </ol>
 * @defaultValue {@link getZclass}: z-listheader.
 */
var Listheader = /** @class */function (_super) {
  __extends(Listheader, _super);
  function Listheader() {
    var _this = _super.call(this) || this; // FIXME: params?
    /**
     * @returns the mesh body that this belongs to.
     */
    _this.getMeshBody = Listheader_1.prototype.getListbox;
    _this.listen({
      onGroup: _this
    }, -1000);
    return _this;
  }
  Listheader_1 = Listheader;
  /**
   * @returns the listbox that this belongs to.
   */
  Listheader.prototype.getListbox = function () {
    return this.parent ? this.parent.parent : undefined;
  };
  /** @internal */
  Listheader.prototype.checkClientSort_ = function (ascending) {
    var body = this.getMeshBody();
    return !(!body || body.hasGroup()) && _super.prototype.checkClientSort_.call(this, ascending);
  };
  /**
   * @returns the maximal length of each item's label.
   * @defaultValue `0` (no limit).
   */
  Listheader.prototype.getMaxlength = function () {
    return this._maxlength;
  };
  /**
   * Sets the maximal length of each item's label.
   */
  Listheader.prototype.setMaxlength = function (maxlength, opts) {
    var o = this._maxlength;
    this._maxlength = maxlength = !maxlength || maxlength < 0 ? 0 : maxlength;
    if (o !== maxlength || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.desktop) {
        this.rerender();
        this.updateCells_();
      }
    }
    return this;
  };
  //B70-ZK-1816, also add in zk 8, ZK-2660
  Listheader.prototype.setVisible = function (visible) {
    if (this.isVisible() != visible) {
      _super.prototype.setVisible.call(this, visible);
      if (this.desktop) this.smartUpdate('visible', visible);
    }
    return this;
  };
  /**
   * Groups and sorts the items ({@link Listitem}) based on
   * {@link getSortAscending}.
   * If the corresponding comparator is not set, it returns false
   * and does nothing.
   *
   * @param ascending - whether to use {@link getSortAscending}.
   * If the corresponding comparator is not set, it returns false
   * and does nothing.
   * @param evt - the event causes the group
   * @returns boolean whether the items are grouped.
   * @since 6.5.0
   */
  Listheader.prototype.group = function (ascending, evt) {
    var dir = this.getSortDirection();
    if (ascending) {
      if ('ascending' == dir) return false;
    } else {
      if ('descending' == dir) return false;
    }
    var sorter = ascending ? this._sortAscending : this._sortDescending;
    if (sorter == 'fromServer') return false;else if (sorter == 'none') {
      evt.stop();
      return false;
    }
    var mesh = this.getMeshWidget();
    if (!mesh || mesh.isModel() || !zk.feature.pe || !zk.isLoaded('zkex.sel')) return false;
    // if in model, the sort should be done by server
    var body = this.getMeshBody();
    if (!body) return false;
    evt.stop();
    var desktop = body.desktop,
      node = body.$n_();
    try {
      body.unbind();
      if (body.hasGroup()) {
        for (var gs = body.getGroups(), len = gs.length; --len >= 0;) body.removeChild(gs[len]);
      }
      var d = [],
        col = this.getChildIndex();
      for (var i = 0, z = 0, it = mesh.getBodyWidgetIterator(), w; w = it.next(); z++) for (var k = 0, cell = w.firstChild; cell; cell = cell.nextSibling, k++) if (k == col) {
        d[i++] = {
          wgt: cell,
          index: z
        };
      }
      var dsc = dir == 'ascending' ? -1 : 1,
        fn = this.sorting,
        isNumber = sorter == 'client(number)';
      d.sort(function (a, b) {
        var v = fn(a.wgt, b.wgt, isNumber) * dsc;
        if (v == 0) {
          v = a.index < b.index ? -1 : 1;
        }
        return v;
      });
      // clear all items
      for (var item = body.firstItem; item; item = body.nextItem(item)) body.removeChild(item);
      for (var previous, row, index = this.getChildIndex(), i = 0, k = d.length; i < k; i++) {
        row = d[i];
        if (!previous || fn(previous.wgt, row.wgt, isNumber) != 0) {
          //new group
          var group = void 0,
            cell_1 = row.wgt.parent.getChildAt(index);
          if (cell_1) {
            if (cell_1.getLabel()) {
              group = new zkex.sel.Listgroup({
                label: cell_1.getLabel()
              });
            } else {
              var cc = cell_1.firstChild;
              if (cc && cc instanceof zul.wgt.Label) {
                group = new zkex.sel.Listgroup({
                  label: cc.getValue()
                });
              } else {
                group = new zkex.sel.Listgroup({
                  label: msgzul.GRID_OTHER
                });
              }
            }
          }
          body.appendChild(group);
        }
        body.appendChild(row.wgt.parent);
        previous = row;
      }
      this._fixDirection(ascending);
    } finally {
      body.replaceHTML(node, desktop);
    }
    return true;
  };
  /**
   * It invokes {@link group} to group list items and maintain
   * {@link getSortDirection}.
   * @since 6.5.0
   */
  Listheader.prototype.onGroup = function (evt) {
    var dir = this.getSortDirection();
    if ('ascending' == dir) this.group(false, evt);else if ('descending' == dir) this.group(true, evt);else if (!this.group(true, evt)) this.group(false, evt);
  };
  /**
   * Updates the cells according to the listheader
   * @internal
   */
  Listheader.prototype.updateCells_ = function () {
    var box = this.getListbox();
    if (box == null || box.getMold() == 'select') return;
    var jcol = this.getChildIndex(),
      w;
    for (var it = box.getBodyWidgetIterator(); w = it.next();) if (jcol < w.nChildren) w.getChildAt(jcol).rerender();
    w = box.listfoot;
    if (w && jcol < w.nChildren) w.getChildAt(jcol).rerender();
  };
  /** @internal */
  Listheader.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    var cm = this.$n('cm'),
      n = this.$n();
    if (cm) {
      var box = this.getListbox();
      if (box) box._headercm = cm;
      this.domListen_(cm, 'onClick', '_doClick');
    }
    if (n) this.domListen_(n, 'onMouseOver', '_doMouseOver').domListen_(n, 'onMouseOut', '_doMouseOut');
    var btn = this.$n('btn');
    if (btn) this.domListen_(btn, 'onClick', '_doMenuClick');
  };
  /** @internal */
  Listheader.prototype.unbind_ = function (skipper, after, keepRod) {
    var cm = this.$n('cm'),
      n = this.$n();
    if (cm) {
      var box = this.getListbox();
      if (box) box._headercm = undefined;
      this._checked = undefined;
      this.domUnlisten_(cm, 'onClick', '_doClick');
    }
    if (n) this.domUnlisten_(n, 'onMouseOver', '_doMouseOver').domUnlisten_(n, 'onMouseOut', '_doMouseOut');
    var btn = this.$n('btn');
    if (btn) this.domUnlisten_(btn, 'onClick', '_doMenuClick');
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /** @internal */
  Listheader.prototype._doMouseOver = function (evt) {
    if (this.isSortable_() || this.parent._menupopup && this.parent._menupopup != 'none') jq(this.$n_()).addClass(this.$s('hover'));
  };
  /** @internal */
  Listheader.prototype._doMouseOut = function (evt) {
    if (this.isSortable_() || this.parent._menupopup && this.parent._menupopup != 'none') {
      var $n = jq(this.$n_());
      if (!$n.hasClass(this.$s('visited'))) $n.removeClass(this.$s('hover'));
    }
  };
  /** @internal */
  Listheader.prototype._doClick = function (evt) {
    this._checked = !this._checked;
    var box = this.getListbox(),
      cm = this.$n_('cm'),
      $n = jq(cm);
    if (this._checked) {
      $n.addClass(this.$s('checked'));
      box.selectAll(true, evt);
    } else {
      $n.removeClass(this.$s('checked'));
      box._select(undefined, evt);
    }
    box.fire('onCheckSelectAll', this._checked, {
      toServer: true
    });
  };
  /** @internal */
  Listheader.prototype.doClick_ = function (evt, popupOnly) {
    var box = this.getListbox(),
      cm = this.$n('cm');
    if (box && box._checkmark) {
      var n = evt.domTarget;
      if (n == cm || n.parentNode == cm)
        //may click on font-awesome element
        return; //ignore it (to avoid sort or other activity)
    }
    _super.prototype.doClick_.call(this, evt, popupOnly);
  };
  /** @internal */
  Listheader.prototype.domContent_ = function () {
    var /*safe*/s = _super.prototype.domContent_.call(this),
      box = this.getListbox();
    if (this._hasCheckbox()) /*safe*/s = '<span id="' + this.uuid + '-cm" class="' + this.$s('checkable') + (box.$$selectAll ? ' ' + this.$s('checked') : '') + '"><i class="' + this.$s('icon') + ' z-icon-check"></i></span>' + (s ? '&nbsp;' + /*safe*/s : '');
    return s;
  };
  /** @internal */
  Listheader.prototype._isFirstVisibleChild = function () {
    var firstVisibleChild = this.parent.firstChild;
    while (firstVisibleChild && !firstVisibleChild.isVisible()) firstVisibleChild = firstVisibleChild.nextSibling;
    return this == firstVisibleChild;
  };
  /** @internal */
  Listheader.prototype._hasCheckbox = function () {
    var box = this.getListbox();
    return !!(box != null && this._isFirstVisibleChild() // B100-ZK-5037
    && box._checkmark && box._multiple && !box._listbox$noSelectAll); // B50-ZK-873
  };
  /** @internal */
  Listheader.prototype.domLabel_ = function () {
    return zUtl.encodeXML(this.getLabel(), {
      maxlength: this._maxlength
    });
  };
  /** @internal */
  Listheader.prototype.getContentWidth_ = function () {
    var $cv = zk(this.$n('cave')),
      isTextOnly = !this.nChildren && !this._iconSclass && !this._hasCheckbox(),
      contentWidth = isTextOnly ? $cv.textWidth() : $cv.textSize()[0];
    return Math.ceil(contentWidth + $cv.padBorderWidth() + zk(this.$n()).padBorderWidth());
  };
  var Listheader_1;
  Listheader = Listheader_1 = __decorate([zk.WrapClass('zul.sel.Listheader')], Listheader);
  return Listheader;
}(zul.mesh.SortWidget);
exports.Listheader = Listheader;
if (!window.zul) window.zul = {};
if (!window.zul.sel) window.zul.sel = {};
if (!window.zul.sel.Listheader) window.zul.sel.Listheader = {};
window.zul.sel.Listheader._ = {
  Listheader: Listheader
};

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/sel/Listitem.ts":
/*!***********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/sel/Listitem.ts ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Listitem = void 0;
/* Listitem.ts

    Purpose:

    Description:

    History:
        Thu Apr 30 22:17:40     2009, Created by tomyeh

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
function _isPE() {
  return zk.isLoaded('zkex.sel');
}
// _dragImg changed to an array, update image node after original DD_dragging
function updateImg(drag) {
  var dragImg = drag._dragImg;
  if (dragImg) {
    // update drag image
    var allow = jq(drag.node).hasClass('z-drop-allow');
    // eslint-disable-next-line @typescript-eslint/prefer-for-of
    for (var len = 0; len < dragImg.length; len++) {
      if (allow) jq(dragImg[len]).removeClass('z-icon-times').addClass('z-icon-check');else jq(dragImg[len]).removeClass('z-icon-check').addClass('z-icon-times');
    }
  }
}
/**
 * A listitem.
 *
 * @defaultValue {@link getZclass}: z-listitem
 */
var Listitem = /** @class */function (_super) {
  __extends(Listitem, _super);
  function Listitem() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  /**
   * @returns the list box that it belongs to.
   */
  Listitem.prototype.getListbox = function () {
    return this.parent;
  };
  /**
   * @returns the listgroup that this item belongs to, or null.
   */
  Listitem.prototype.getListgroup = function () {
    var _a;
    // TODO: this performance is not good.
    if (_isPE() && ((_a = this.parent) === null || _a === void 0 ? void 0 : _a.hasGroup()))
      // eslint-disable-next-line @typescript-eslint/no-this-alias
      for (var w = this; w; w = w.previousSibling) if (w instanceof zkex.sel.Listgroup) return w;
    return undefined;
  };
  /**
   * Sets the label of the {@link Listcell} it contains.
   * <p>If it is not created, we automatically create it.
   */
  Listitem.prototype.setLabel = function (label) {
    this._autoFirstCell().setLabel(label);
    return this;
  };
  // replace the origional DD_dragging
  /** @internal */
  Listitem.prototype.getDragOptions_ = function (map) {
    var old = map.change;
    map.change = function (drag, pt, evt) {
      old(drag, pt, evt);
      // update drag image after origional function
      updateImg(drag);
    };
    return _super.prototype.getDragOptions_.call(this, map);
  };
  /**
   * Sets the image of the {@link Listcell} it contains.
   * <p>If it is not created, we automatically create it.
   */
  Listitem.prototype.setImage = function (image) {
    this._autoFirstCell().setImage(image);
    return this;
  };
  /** @internal */
  Listitem.prototype._autoFirstCell = function () {
    if (!this.firstChild) this.appendChild(new zul.sel.Listcell());
    return this.firstChild; // guaranteed to exist because appended in the previous line
  };
  /** @internal */
  Listitem.prototype.domStyle_ = function (no) {
    if (_isPE() && (this instanceof zkex.sel.Listgroup || this instanceof zkex.sel.Listgroupfoot) || (no === null || no === void 0 ? void 0 : no.visible)) return _super.prototype.domStyle_.call(this, no);
    var /*safe*/style = _super.prototype.domStyle_.call(this, no),
      group = this.getListgroup();
    return group && !group.isOpen() ? style + 'display:none;' : style;
  };
  /** @internal */
  Listitem.prototype.domClass_ = function (no) {
    var /*safe*/cls = _super.prototype.domClass_.call(this, no),
      list = this.getListbox();
    // NOTE: The following `this.$n()` could be null. This behavior is verified on old code.
    if (list) {
      var sclass = zUtl.encodeXML(list.getOddRowSclass());
      if (jq(this.$n()).hasClass(sclass)) return cls + ' ' + sclass;
    }
    return cls;
  };
  Listitem.prototype.replaceWidget = function (newwgt, skipper) {
    this._syncListitems(newwgt);
    _super.prototype.replaceWidget.call(this, newwgt, skipper);
  };
  Listitem.prototype.scrollIntoView = function () {
    var bar = this.getListbox()._scrollbar;
    if (bar) {
      bar.syncSize();
      bar.scrollToElement(this.$n_());
    } else {
      _super.prototype.scrollIntoView.call(this);
    }
    return this;
  };
  /** @internal */
  Listitem.prototype._syncListitems = function (newwgt) {
    var box = this.getListbox();
    if (box) {
      if (box.firstItem.uuid == newwgt.uuid) box.firstItem = newwgt;
      if (box.lastItem.uuid == newwgt.uuid) box.lastItem = newwgt;
      var items = box._selItems,
        b1 = this.isSelected();
      if (b1) items.$remove(this);
      var b2 = newwgt.isSelected();
      if (b2) items.push(newwgt);
      if (b1 != b2) box._updHeaderCM();
    }
  };
  /** @internal */
  Listitem.prototype.compareItemPos_ = function (item) {
    var thisIndex = this._index,
      itemIndex = item._index;
    return thisIndex == itemIndex ? 0 : thisIndex > itemIndex ? -1 : 1;
  };
  /** @internal */
  Listitem.prototype.shallFireSizedLaterWhenAddChd_ = function () {
    if (this.getListbox()._model == 'group') {
      zWatch.listen({
        onCommandReady: this
      });
      return true;
    }
    _super.prototype.shallFireSizedLaterWhenAddChd_.call(this);
    return false;
  };
  // ZK-3733
  Listitem.prototype.onCommandReady = function (ctl) {
    zUtl.fireSized(this);
    zWatch.unlisten({
      onCommandReady: this
    });
  };
  Listitem = __decorate([zk.WrapClass('zul.sel.Listitem')], Listitem);
  return Listitem;
}(zul.sel.ItemWidget);
exports.Listitem = Listitem;
if (!window.zul) window.zul = {};
if (!window.zul.sel) window.zul.sel = {};
if (!window.zul.sel.Listitem) window.zul.sel.Listitem = {};
window.zul.sel.Listitem._ = {
  _isPE: _isPE,
  updateImg: updateImg,
  Listitem: Listitem
};

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/sel/Optgroup.ts":
/*!***********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/sel/Optgroup.ts ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Optgroup = void 0;
/* Optgroup.ts

    Purpose:

    Description:

    History:
        Mon Sep 03 13:01:21 CST 2018, Created by rudyhuang

Copyright (C) 2018 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.0 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * A HTML optgroup tag.
 * @since 8.6.0
 */
var Optgroup = /** @class */function (_super) {
  __extends(Optgroup, _super);
  function Optgroup() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._open = true;
    return _this;
  }
  /**
   * @returns whether it is disabled.
   * @defaultValue `false`.
   */
  Optgroup.prototype.isDisabled = function () {
    return !!this._disabled;
  };
  /**
   * Sets whether it is disabled.
   */
  Optgroup.prototype.setDisabled = function (disabled, opts) {
    var o = this._disabled;
    this._disabled = disabled;
    if (o !== disabled || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n();
      if (n) n.disabled = disabled ? 'disabled' : '';
    }
    return this;
  };
  /**
   * @returns whether this container is open.
   * @defaultValue `true`.
   */
  Optgroup.prototype.isOpen = function () {
    return this._open;
  };
  /**
   * Sets whether this container is open.
   */
  Optgroup.prototype.setOpen = function (open, fromServer, opts) {
    var o = this._open;
    this._open = open;
    if (o !== open || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.desktop) this.parent.requestRerender_(fromServer);
    }
    return this;
  };
  /**
   * @returns the label of the {@link Listcell} it contains, or null
   * if no such cell.
   */
  Optgroup.prototype.getLabel = function () {
    return this.firstChild ? this.firstChild.domLabel_() : undefined;
  };
  /**
   * Sets the label of the {@link Optgroup} it contains.
   *
   * <p>If it is not created, we automatically create it.
   * @since 10.0.0
   */
  // To treat as "value" attribute from "label" at client side
  Optgroup.prototype.setLabel = function (label) {
    this._autoFirstCell().setLabel(label);
    return this;
  };
  /** @internal */
  Optgroup.prototype._autoFirstCell = function () {
    if (!this.firstChild) this.appendChild(new zul.sel.Listcell(), true);
    return this.firstChild; // guaranteed to exist because appended in the previous line
  };
  /** @internal */
  Optgroup.prototype.updateLabel_ = function () {
    var n = this.$n();
    if (n) n.label = this.getLabel();
  };
  Optgroup.prototype.setVisible = function (visible, fromServer) {
    if (this._visible != visible) {
      this._visible = visible;
      if (this.desktop) this.parent.requestRerender_(fromServer);
    }
    return this;
  };
  /** @internal */
  Optgroup.prototype.domAttrs_ = function (no) {
    var /*safe*/attr = _super.prototype.domAttrs_.call(this, no),
      label = this.getLabel(),
      disabled = this.isDisabled();
    if (label) attr += ' label="' + zUtl.encodeXML(label) + '"';
    if (disabled) attr += ' disabled="disabled"';
    return attr;
  };
  Optgroup = __decorate([zk.WrapClass('zul.sel.Optgroup')], Optgroup);
  return Optgroup;
}(zul.Widget);
exports.Optgroup = Optgroup;
if (!window.zul) window.zul = {};
if (!window.zul.sel) window.zul.sel = {};
if (!window.zul.sel.Optgroup) window.zul.sel.Optgroup = {};
window.zul.sel.Optgroup._ = {
  Optgroup: Optgroup
};

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/sel/Option.ts":
/*!*********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/sel/Option.ts ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Option = void 0;
/* Option.ts

    Purpose:

    Description:

    History:
        Mon Jun  1 16:43:59     2009, Created by jumperchen

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.0 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * A HTML option tag.
 */
var Option = /** @class */function (_super) {
  __extends(Option, _super);
  function Option() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._selected = false;
    return _this;
  }
  /**
   * @returns whether it is disabled.
   * @defaultValue `false`.
   */
  Option.prototype.isDisabled = function () {
    return !!this._disabled;
  };
  /**
   * Sets whether it is disabled.
   */
  Option.prototype.setDisabled = function (disabled, opts) {
    var o = this._disabled;
    this._disabled = disabled;
    if (o !== disabled || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n();
      if (n) n.disabled = disabled ? 'disabled' : '';
    }
    return this;
  };
  /**
   * @returns the value.
   * @defaultValue `null`.
   * <p>Note: the value is application dependent, you can place
   * whatever value you want.
   * <p>If you are using listitem with HTML Form (and with
   * the name attribute), it is better to specify a String-typed
   * value.
   */
  Option.prototype.getValue = function () {
    return this._value;
  };
  /**
   * Sets the value.
   * @param value - the value.
   * <p>Note: the value is application dependent, you can place
   * whatever value you want.
   * <p>If you are using listitem with HTML Form (and with
   * the name attribute), it is better to specify a String-typed
   * value.
   */
  Option.prototype.setValue = function (value) {
    this._value = value;
    return this;
  };
  /**
   * Sets the label of the {@link Option} it contains.
   *
   * <p>If it is not created, we automatically create it.
   * @since 10.0.0
   */
  // To treat as "value" attribute from "label" at client side
  Option.prototype.setLabel = function (label) {
    this._autoFirstCell().setLabel(label);
    return this;
  };
  /** @internal */
  Option.prototype._autoFirstCell = function () {
    if (!this.firstChild) this.appendChild(new zul.sel.Listcell(), true);
    return this.firstChild; // guaranteed to exist because appended in the previous line
  };
  Option.prototype.focus = function (timeout) {
    var p = this.parent;
    if (p) p.focus(timeout);
    // NOTE: Returning false agrees with the original logic (returning nothing,
    // which is will evaluate to undefined, which is falsey).
    return false;
  };
  Option.prototype.setVisible = function (visible, fromServer) {
    if (this._visible != visible) {
      this._visible = visible;
      if (this.desktop) this.parent.requestRerender_(fromServer);
    }
    return this;
  };
  /**
   * Sets whether it is selected.
   */
  Option.prototype.setSelected = function (selected) {
    if (this.__updating__) {
      // for B50-3012466.zul
      delete this.__updating__;
      return this; //nothing to do for second loop triggered by this.parent.toggleItemSelection
    }
    try {
      selected = selected || false;
      this.__updating__ = true;
      if (this._selected != selected) {
        if (this.parent) this.parent.toggleItemSelection(this);
        this._setSelectedDirectly(selected); // always setting for B50-3012466.zul
      }
    } finally {
      delete this.__updating__;
    }
    return this;
  };
  /** @internal */
  Option.prototype._setSelectedDirectly = function (selected) {
    var n = this.$n();
    // Bug ZK-2285, ignore if the status is the same for IE's issue
    if (n && n.selected != selected) {
      n.selected = selected ? 'selected' : '';
    }
    this._selected = selected;
  };
  /**
   * @returns whether it is selected.
   * @defaultValue `false`.
   */
  Option.prototype.isSelected = function () {
    return this._selected;
  };
  /**
   * @returns the label of the {@link Listcell} it contains, or null
   * if no such cell.
   */
  Option.prototype.getLabel = function () {
    return this.firstChild ? this.firstChild.getLabel() : undefined;
  };
  /** @internal */
  Option.prototype.updateLabel_ = function () {
    var n = this.$n();
    // eslint-disable-next-line @microsoft/sdl/no-inner-html
    if (n) n.innerHTML = DOMPurify.sanitize(this.domLabel_());
  };
  /**
   * @returns the maximal length of each item's label.
   * It is a shortcut of {@link Select#getMaxlength}.
   */
  Option.prototype.getMaxlength = function () {
    return this.parent ? this.parent.getMaxlength() : 0;
  };
  /** @internal */
  Option.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    //B60-ZK-1303: force update parent's selected index.
    if (this.isSelected()) {
      this.parent.updateSelectionDirectly(this);
    }
  };
  /** @internal */
  Option.prototype.doClick_ = function (evt /*, popupOnly?: boolean */) {
    evt.stop(); // Eats the non-standard onclick event
  };
  /**
   * The index for option widget only , not including the listhead.etc
   * @since 6.0.1
   * @internal
   */
  Option.prototype.getOptionIndex_ = function () {
    var parent = this.parent,
      ret = -1;
    if (parent) {
      for (var w = parent.firstChild; w; w = w.nextSibling) {
        if (w instanceof zul.sel.Option) {
          ret++;
          if (w == this) break;
        }
      }
    }
    return ret;
  };
  /** @internal */
  Option.prototype.domLabel_ = function () {
    return zUtl.encodeXML(this.getLabel(), {
      maxlength: this.getMaxlength()
    });
  };
  /** @internal */
  Option.prototype.domAttrs_ = function (no) {
    var value = this.getValue(),
      shallRenderValue = value && this.parent && this.parent.getName();
    return _super.prototype.domAttrs_.call(this, no) + (this.isDisabled() ? ' disabled="disabled"' : '') + (this.isSelected() ? ' selected="selected"' : '') + (shallRenderValue ? ' value="' + value + '"' : '');
  };
  Option.prototype.replaceWidget = function (newwgt, skipper) {
    this._syncItems(newwgt);
    _super.prototype.replaceWidget.call(this, newwgt, skipper);
  };
  /** @internal */
  Option.prototype._syncItems = function (newwgt) {
    if (this.parent && this.isSelected()) {
      var items = this.parent._selItems;
      if (items && items.$remove(this)) items.push(newwgt);
    }
  };
  Option = __decorate([zk.WrapClass('zul.sel.Option')], Option);
  return Option;
}(zul.Widget);
exports.Option = Option;
if (!window.zul) window.zul = {};
if (!window.zul.sel) window.zul.sel = {};
if (!window.zul.sel.Option) window.zul.sel.Option = {};
window.zul.sel.Option._ = {
  Option: Option
};

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/sel/Select.ts":
/*!*********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/sel/Select.ts ***!
  \*********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Select = void 0;
/* Select.ts

    Purpose:

    Description:

    History:
        Mon Jun  1 16:43:51     2009, Created by jumperchen

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.0 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * A HTML select tag.
 */
var Select = /** @class */function (_super) {
  __extends(Select, _super);
  function Select() {
    var _this = _super.call(this) || this; // FIXME: params?
    /** @internal */
    _this._selectedIndex = -1;
    /** @internal */
    _this._rows = 0;
    _this._selItems = [];
    _this._groupsInfo = [];
    return _this;
  }
  /**
   * @returns whether multiple selections are allowed.
   * @defaultValue `false`.
   */
  Select.prototype.isMultiple = function () {
    return !!this._multiple;
  };
  /**
   * Sets whether multiple selections are allowed.
   */
  Select.prototype.setMultiple = function (multiple, opts) {
    var o = this._multiple;
    this._multiple = multiple;
    if (o !== multiple || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n();
      if (n) n.multiple = multiple;
    }
    return this;
  };
  /**
   * @returns whether it is disabled.
   * @defaultValue `false`.
   */
  Select.prototype.isDisabled = function () {
    return !!this._disabled;
  };
  /**
   * Sets whether it is disabled.
   */
  Select.prototype.setDisabled = function (disabled, opts) {
    var o = this._disabled;
    this._disabled = disabled;
    if (o !== disabled || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n();
      if (n) n.disabled = disabled;
    }
    return this;
  };
  /**
   * @returns the index of the selected item (-1 if no one is selected).
   */
  Select.prototype.getSelectedIndex = function () {
    return this._selectedIndex;
  };
  /**
   * Deselects all of the currently selected items and selects the item with
   * the given index.
   */
  Select.prototype.setSelectedIndex = function (selectedIndex, opts) {
    var o = this._selectedIndex;
    this._selectedIndex = selectedIndex;
    if (o !== selectedIndex || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var i = 0,
        j = 0,
        w = void 0;
      var n = this.$n();
      this.clearSelection();
      // B50-ZK-989: original skipFixIndex way gives wrong value for this._selectedIndex
      // select from server API call, fix the index
      for (w = this.firstChild; w && i < selectedIndex; w = w.nextSibling, i++) {
        if (w instanceof zul.sel.Option) {
          if (!w.isVisible()) j++;
        } else if (w instanceof zul.sel.Optgroup) j++;else i--;
      }
      selectedIndex -= j;
      if (n) n.selectedIndex = selectedIndex;
      if (selectedIndex > -1 && w && w instanceof zul.sel.Option) {
        w.setSelected(true);
        this._selItems.push(w);
      }
    }
    return this;
  };
  /**
   * @returns the name of this component.
   * @defaultValue `null`.
   * <p>
   * The name is used only to work with "legacy" Web application that handles
   * user's request by servlets. It works only with HTTP/HTML-based browsers.
   * It doesn't work with other kind of clients.
   * <p>
   * Don't use this method if your application is purely based on ZK's
   * event-driven model.
   */
  Select.prototype.getName = function () {
    return this._name;
  };
  /**
   * Sets the name of this component.
   * <p>
   * The name is used only to work with "legacy" Web application that handles
   * user's request by servlets. It works only with HTTP/HTML-based browsers.
   * It doesn't work with other kind of clients.
   * <p>
   * Don't use this method if your application is purely based on ZK's
   * event-driven model.
   *
   * @param name - the name of this component.
   */
  Select.prototype.setName = function (name, opts) {
    var o = this._name;
    this._name = name;
    if (o !== name || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n();
      if (n) n.name = name;
    }
    return this;
  };
  /**
   * @returns the rows. Zero means no limitation.
   * @defaultValue `0`.
   */
  Select.prototype.getRows = function () {
    return this._rows;
  };
  /**
   * Sets the rows.
   * <p>
   * Note: if both {@link setHeight} is specified with non-empty,
   * {@link setRows} is ignored
   */
  Select.prototype.setRows = function (rows, opts) {
    var o = this._rows;
    this._rows = rows;
    if (o !== rows || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n();
      if (n) n.size = rows;
    }
    return this;
  };
  /**
   * @returns the maximal length of each item's label.
   */
  Select.prototype.getMaxlength = function () {
    return this._maxlength;
  };
  /**
   * Sets the maximal length of each item's label.
   */
  Select.prototype.setMaxlength = function (maxlength, fromServer, opts) {
    var o = this._maxlength;
    this._maxlength = maxlength;
    if (o !== maxlength || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.desktop) this.requestRerender_(fromServer);
    }
    return this;
  };
  // ZK-2133: should sync all items
  Select.prototype.setChgSel = function (chgSel) {
    var sels = {};
    for (var j = 0;;) {
      var k = chgSel.indexOf(',', j),
        s = (k >= 0 ? chgSel.substring(j, k) : chgSel.substring(j)).trim();
      if (s) sels[s] = true;
      if (k < 0) break;
      j = k + 1;
    }
    for (var w = this.firstChild; w; w = w.nextSibling) this._changeSelect(w, sels[w.uuid] == true);
    return this;
  };
  /* Changes the selected status of an item without affecting other items
   * and return true if the status is really changed.
   */
  /** @internal */
  Select.prototype._changeSelect = function (child, toSel) {
    if (child instanceof zul.sel.Option) {
      var changed = child.isSelected() != toSel;
      if (changed) {
        child.setSelected(toSel);
      }
      return changed;
    }
    return false;
  };
  /**
   * If the specified item is selected, it is deselected. If it is not
   * selected, it is selected. Other items in the list box that are selected
   * are not affected, and retain their selected state.
   */
  Select.prototype.toggleItemSelection = function (item) {
    if (item.isSelected()) this._removeItemFromSelection(item);else this._addItemToSelection(item);
  };
  /**
   * Deselects all of the currently selected items and selects the given item.
   *
   * @param item - the item to select. If null, all items are deselected.
   */
  Select.prototype.selectItem = function (item) {
    if (!item) this.setSelectedIndex(-1);else if (this._multiple || !item.isSelected()) {
      if (item.getOptionIndex_) this.setSelectedIndex(item.getOptionIndex_());else this.setSelectedIndex(item.getChildIndex());
    }
  };
  /** @internal */
  Select.prototype._addItemToSelection = function (item) {
    if (!item.isSelected()) {
      this.updateSelectionDirectly(item);
    }
  };
  /**
   * Internal used only
   * @hidden for jsdoc
   */
  Select.prototype.updateSelectionDirectly = function (item) {
    var multiple = this._multiple;
    if (!multiple) this.clearSelection();
    var index = item.getOptionIndex_ ? item.getOptionIndex_() : item.getChildIndex();
    if (!multiple || index < this._selectedIndex || this._selectedIndex < 0) this._selectedIndex = index;
    item._setSelectedDirectly(true);
    this._selItems.push(item);
  };
  /** @internal */
  Select.prototype._removeItemFromSelection = function (item) {
    if (item.isSelected()) {
      if (!this._multiple) {
        this.clearSelection();
      } else {
        item._setSelectedDirectly(false);
        this._selItems.$remove(item);
      }
    }
  };
  /**
   * Clears the selection.
   */
  Select.prototype.clearSelection = function () {
    if (this._selItems.length) {
      for (var item = void 0; item = this._selItems.pop();) item._setSelectedDirectly(false);
      this._selectedIndex = -1;
    }
  };
  /** @internal */
  Select.prototype.domAttrs_ = function (no) {
    var v;
    return _super.prototype.domAttrs_.call(this, no) + (this.isDisabled() ? ' disabled="disabled"' : '') + (this.isMultiple() ? ' multiple="multiple"' : '') + ((v = this.getSelectedIndex()) > -1 ? ' selectedIndex="' + v + '"' : '') + ((v = this.getRows()) > 0 ? ' size="' + v + '"' : '') + ((v = this.getName()) ? ' name="' + v + '"' : '');
  };
  /** @internal */
  Select.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    var n = this.$n_();
    this.domListen_(n, 'onChange').domListen_(n, 'onFocus', 'doFocus_').domListen_(n, 'onBlur', 'doBlur_');
    if (!zk.gecko) {
      var fn = [this, this._fixSelIndex];
      zWatch.listen({
        onRestore: fn,
        onVParent: fn
      });
    }
    zWatch.listen({
      onCommandReady: this
    });
    this._fixSelIndex();
  };
  /** @internal */
  Select.prototype.unbind_ = function (skipper, after, keepRod) {
    zWatch.unlisten({
      onCommandReady: this
    });
    var n = this.$n_();
    this.domUnlisten_(n, 'onChange').domUnlisten_(n, 'onFocus', 'doFocus_').domUnlisten_(n, 'onBlur', 'doBlur_');
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
    var fn = [this, this._fixSelIndex];
    zWatch.unlisten({
      onRestore: fn,
      onVParent: fn
    });
  };
  /** @internal */
  Select.prototype._fixSelIndex = function () {
    if (this._selectedIndex < 0) this.$n_().selectedIndex = -1;
  };
  /** @internal */
  Select.prototype._doChange = function (evt) {
    var n = this.$n_(),
      opts = n.options,
      multiple = this._multiple,
      data = [];
    var changed = false,
      reference;
    for (var j = 0, ol = opts.length; j < ol; ++j) {
      var opt = opts[j],
        o = zk.Widget.$(opt.id),
        v = opt.selected;
      if (multiple) {
        if (o && o._selected != v) {
          this.toggleItemSelection(o);
          changed = true;
        }
        if (v) {
          data.push(o);
          if (!reference) reference = o;
        }
      } else {
        if (o && o._selected != v && v) {
          // found the newly selected one
          this._addItemToSelection(o); //will clear other selection first
          changed = true;
          data.push(o);
          reference = o;
          break;
        }
      }
    }
    if (!changed) return;
    this.fire('onSelect', {
      items: data,
      reference: reference
    });
  };
  /** @internal */
  Select.prototype.doBlur_ = function (evt) {
    // Empty for override
  };
  //Bug 1756559: ctrl key shall fore it to be sent first
  /** @internal */
  Select.prototype.beforeCtrlKeys_ = function (evt) {
    this._doChange(evt);
  };
  /** @internal */
  Select.prototype.onChildAdded_ = function (child) {
    if (child instanceof zul.sel.Optgroup) this._groupsInfo.push(child);
    if (this.desktop) this.requestRerender_(true);
  };
  /** @internal */
  Select.prototype.onChildRemoved_ = function (child) {
    if (child instanceof zul.sel.Optgroup) this._groupsInfo.$remove(child);
    if (this.desktop && !this.childReplacing_) this.requestRerender_(true);
  };
  /** @internal */
  Select.prototype.requestRerender_ = function (fromServer) {
    if (fromServer) this._shouldRerenderFlag = true;else this.rerender();
  };
  Select.prototype.onCommandReady = function () {
    if (this._shouldRerenderFlag) {
      this._shouldRerenderFlag = false;
      this.rerender();
    }
  };
  /**
   * @returns whether any {@link Optgroup} exists.
   * @since 8.6.0
   */
  Select.prototype.hasGroup = function () {
    return !!this._groupsInfo.length;
  };
  /**
   * @returns the number of {@link Optgroup}.
   * @since 8.6.0
   */
  Select.prototype.getGroupCount = function () {
    return this._groupsInfo.length;
  };
  /**
   * @returns a list of all {@link Optgroup}. The order is unmaintained.
   * @since 8.6.0
   */
  Select.prototype.getGroups = function () {
    return this._groupsInfo.$clone();
  };
  /** @internal */
  Select.prototype.setItemsInvalid_ = function (itemsInvalid) {
    var _this = this;
    zAu.createWidgets(itemsInvalid, function (ws) {
      _this.replaceCavedChildren_('', ws);
    }, function (wx) {
      return wx;
    });
  };
  Select = __decorate([zk.WrapClass('zul.sel.Select')], Select);
  return Select;
}(zul.Widget);
exports.Select = Select;
if (!window.zul) window.zul = {};
if (!window.zul.sel) window.zul.sel = {};
if (!window.zul.sel.Select) window.zul.sel.Select = {};
window.zul.sel.Select._ = {
  Select: Select
};

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/sel/SelectWidget.ts":
/*!***************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/sel/SelectWidget.ts ***!
  \***************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.SelectWidget = void 0;
/* SelectWidget.ts

    Purpose:

    Description:

    History:
        Thu Apr 30 22:13:24     2009, Created by tomyeh

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.1 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * The selectable widgets, such as listbox and tree.
 * @internal
 */
//zk.$package('zul.sel');
function _beforeChildKey(wgt, evt) {
  return zAu.processing() || wgt._shallIgnore(evt);
}
function _afterChildKey(evt) {
  switch (evt.data.keyCode) {
    case 33: //PgUp
    case 34: //PgDn
    case 38: //UP
    case 40: //DOWN
    case 37: //LEFT
    case 39: //RIGHT
    case 32: //SPACE
    case 36: //Home
    case 35:
      //End
      evt.stop();
      return false;
  }
  return true;
}
function _updHeaderCM(box) {
  if (box.$$selectAll != undefined) return; // update by server's state
  if (--box._nUpdHeaderCM <= 0 && box.desktop && box._headercm && box._multiple) {
    var headerWgt = zk.Widget.$(box._headercm),
      /*safe*/zcls = headerWgt.getZclass() + '-checked',
      $headercm = jq(box._headercm),
      isAllSelected = box._isAllSelected();
    $headercm[isAllSelected ? 'addClass' : 'removeClass'](zcls);
    headerWgt._checked = isAllSelected;
  }
}
function _isButton(evt) {
  return evt.target.$button //for extension, it makes a widget as a button
  || zk.isLoaded('zul.wgt') && (evt.target instanceof zul.wgt.Button || evt.target instanceof zul.wgt.Toolbarbutton);
}
function _isInputWidget(evt) {
  return evt.target.$inputWidget //for extension, it makes a widget as a input widget
  || zk.isLoaded('zul.inp') && evt.target instanceof zul.inp.InputWidget;
}
function _focusable(evt) {
  return jq.nodeName(evt.domTarget, 'input', 'textarea', 'button', 'select', 'option', 'a') && !(evt.target instanceof zul.sel.SelectWidget) || _isButton(evt) || _isInputWidget(evt);
}
function _fixReplace(w) {
  return (w === null || w === void 0 ? void 0 : w.uuid) ? zk.Widget.$(w.uuid) : undefined;
}
function _isListgroup(w) {
  return zk.isLoaded('zkex.sel') && w instanceof zkex.sel.Listgroup;
}
function _isListgroupfoot(w) {
  return zk.isLoaded('zkex.sel') && w instanceof zkex.sel.Listgroupfoot;
}
var SelectWidget = /** @class */function (_super) {
  __extends(SelectWidget, _super);
  function SelectWidget() {
    var _this = _super.call(this) || this; // FIXME: params?
    /**
     * Whether to change a list item selection on right click
     * @defaultValue `true` (unless the server changes the setting)
     * @since 5.0.5
     */
    _this.rightSelect = true;
    /** @internal */
    _this._anchorTop = 0;
    /** @internal */
    _this._anchorLeft = 0;
    /** @internal */
    _this._isSelecting = true;
    /** @internal */
    _this._startRow = undefined;
    _this._selItems = [];
    return _this;
  }
  SelectWidget_1 = SelectWidget;
  /**
   * @returns whether the check mark shall be displayed in front of each item.
   * @defaultValue `false`.
   */
  SelectWidget.prototype.isCheckmark = function () {
    return !!this._checkmark;
  };
  /**
   * Sets whether the check mark shall be displayed in front of each item.
   * <p>
   * The check mark is a checkbox if {@link isMultiple} returns true. It is a
   * radio button if {@link isMultiple} returns false.
   */
  SelectWidget.prototype.setCheckmark = function (checkmark, opts) {
    var o = this._checkmark;
    this._checkmark = checkmark;
    if (o !== checkmark || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.desktop) this.rerenderLater_();
    }
    return this;
  };
  /**
   * @returns whether multiple selections are allowed.
   * @defaultValue `false`.
   */
  SelectWidget.prototype.isMultiple = function () {
    return !!this._multiple;
  };
  /**
   * Sets whether multiple selections are allowed.
   */
  SelectWidget.prototype.setMultiple = function (multiple, opts) {
    var o = this._multiple;
    this._multiple = multiple;
    if (o !== multiple || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (!this._multiple && this._selItems.length) {
        var item = this.getSelectedItem();
        for (var it; it = this._selItems.pop();) if (it != item) {
          if (!this._checkmark) it._setSelectedDirectly(false);else it._selected = false;
        }
        this._selItems.push(item);
      }
      if (this._checkmark && this.desktop) this.rerenderLater_();
    }
    return this;
  };
  /**
   * @returns the index of the selected item (-1 if no one is selected).
   */
  SelectWidget.prototype.getSelectedIndex = function () {
    return this._selectedIndex;
  };
  /**
   * Deselects all of the currently selected items and selects the item with
   * the given index.
   */
  SelectWidget.prototype.setSelectedIndex = function (selectedIndex, opts) {
    var o = this._selectedIndex,
      v = selectedIndex;
    selectedIndex = v < -1 || !v && v !== 0 ? -1 : v;
    this._selectedIndex = selectedIndex;
    if (o !== selectedIndex || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var selected = this._selectedIndex;
      this.clearSelection();
      this._selectedIndex = selected;
      if (selected > -1) {
        var w;
        for (var it = this.getBodyWidgetIterator(); selected-- >= 0;) w = it.next();
        if (w) {
          var isMultiSelected = this._selItems.length > 1;
          this._selectOne(w, true);
          // refix ZK-1483: do not have to scroll selected item into view when multiple items are selected
          if (!isMultiSelected) {
            var bar = this._scrollbar;
            if (bar) bar.scrollToElement(w.$n_());else zk(w).scrollIntoView(this.ebody);
          }
        }
      }
    }
    return this;
  };
  /**
   * @returns the name of this component.
   * @defaultValue `null`.
   * <p>
   * The name is used only to work with "legacy" Web application that handles
   * user's request by servlets. It works only with HTTP/HTML-based browsers.
   * It doesn't work with other kind of clients.
   * <p>
   * Don't use this method if your application is purely based on ZK's
   * event-driven model.
   */
  SelectWidget.prototype.getName = function () {
    return this._name;
  };
  /**
   * Sets the name of this component.
   * <p>
   * The name is used only to work with "legacy" Web application that handles
   * user's request by servlets. It works only with HTTP/HTML-based browsers.
   * It doesn't work with other kind of clients.
   * <p>
   * Don't use this method if your application is purely based on ZK's
   * event-driven model.
   *
   * @param name - the name of this component.
   */
  SelectWidget.prototype.setName = function (name, opts) {
    var o = this._name;
    this._name = name;
    if (o !== name || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.desktop) this.updateFormData();
    }
    return this;
  };
  SelectWidget.prototype.getSelectOnHighlightDisabled = function () {
    return !!this._selectOnHighlightDisabled;
  };
  SelectWidget.prototype.setSelectOnHighlightDisabled = function (selectOnHighlightDisabled) {
    this._selectOnHighlightDisabled = selectOnHighlightDisabled;
    return this;
  };
  SelectWidget.prototype.getCheckmarkDeselectOther = function () {
    return !!this._checkmarkDeselectOther;
  };
  SelectWidget.prototype.setCheckmarkDeselectOther = function (checkmarkDeselectOther, opts) {
    var o = this._checkmarkDeselectOther;
    this._checkmarkDeselectOther = checkmarkDeselectOther;
    if (o !== checkmarkDeselectOther || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      this._cdo = checkmarkDeselectOther; // backward compatible
    }
    return this;
  };
  SelectWidget.prototype.setChgSel = function (chgSel) {
    var sels = {};
    for (var j = 0;;) {
      var k = chgSel.indexOf(',', j),
        s = (k >= 0 ? chgSel.substring(j, k) : chgSel.substring(j)).trim();
      if (s) sels[s] = true;
      if (k < 0) break;
      j = k + 1;
    }
    // reset $$selectAll
    this.$$selectAll = undefined;
    for (var it = this.getBodyWidgetIterator(), w; w = it.next();) this._changeSelect(w, sels[w.uuid] == true);
    return this;
  };
  SelectWidget.prototype.setFocusIndex = function (focusIndex) {
    var _this = this;
    // F60-ZK-715
    if (focusIndex < 0) return this;
    setTimeout(function () {
      var w;
      for (var it = _this.getBodyWidgetIterator(); (w = it.next()) && focusIndex--;) if (!it.hasNext()) break;
      _this._focusItem = w;
    });
    return this;
  };
  SelectWidget.prototype.updateFormData = function () {
    if (this._name) {
      if (!this.efield) this.efield = jq(this.$n()).append( /*safe*/'<div style="display:none;"></div>').find('> div:last-child')[0];
      jq(this.efield).children().remove();
      // don't use jq.newHidden() in this case, because the performance is not good.
      var data = '',
        tmp = '<input type="hidden" name="' + zUtl.encodeXML(this._name) + '" value="';
      for (var i = 0, j = this._selItems.length; i < j; i++) /*safe*/data += tmp + zUtl.encodeXML(this._selItems[i].getValue()) + '"/>';
      jq(this.efield).append(data);
    } else if (this.efield) {
      jq(this.efield).remove();
      this.efield = undefined;
    }
  };
  /**
   * Deselects all of the currently selected items and selects the given item.
   * <p>
   * It is the same as {@link selectItem}.
   */
  SelectWidget.prototype.setSelectedItem = function (selectedItem) {
    if (!selectedItem) this.clearSelection();else {
      var isMultiSelected = this._selItems.length > 1;
      this._selectOne(selectedItem, true);
      // refix ZK-1483: do not have to scroll selected item into view when multiple items are selected
      if (!isMultiSelected) {
        var bar = this._scrollbar;
        if (bar) bar.scrollToElement(selectedItem.$n_());
        if (this._nativebar) zk(selectedItem).scrollIntoView(this.ebody);
      }
      if ((zk.edge_legacy || zk.ff >= 4) && this.ebody && this._nativebar) {
        // B50-ZK-293: FF5 misses to fire onScroll
        // B50-ZK-440: ebody can be null when ROD
        this._currentTop = this.ebody.scrollTop;
        this._currentLeft = this.ebody.scrollLeft;
      }
    }
    return this;
  };
  /**
   * @returns the selected item.
   */
  SelectWidget.prototype.getSelectedItem = function () {
    return this._selItems[0];
  };
  /**
   * @returns all selected items.
   */
  SelectWidget.prototype.getSelectedItems = function () {
    // returns a readonly array
    return this._selItems.$clone();
  };
  SelectWidget.prototype.setHeight = function (height) {
    if (!this._nvflex && this._height != height) {
      this._height = height;
      var n = this.$n();
      if (n) {
        n.style.height = height !== null && height !== void 0 ? height : '';
        this.onSize();
      }
    }
    return this;
  };
  SelectWidget.prototype.setVflex = function (vflex) {
    _super.prototype.setVflex.call(this, vflex);
    if (this.desktop) this.onSize();
    return this;
  };
  SelectWidget.prototype.setHflex = function (hflex) {
    _super.prototype.setHflex.call(this, hflex);
    if (this.desktop) this.onSize();
    return this;
  };
  /** @internal */
  SelectWidget.prototype._getEbodyWd = function () {
    var anchor = this.$n_('a');
    // Bug in B30-1823236.zul, the anchor needs to be hidden before invoking this.ebody.clientWidth
    if (zk.webkit) anchor.style.display = 'none';
    //Bug 1659601: we cannot do it in init(); or, IE failed!
    var tblwd = zk.opera && this.ebody.offsetHeight == 0 ?
    // B50-ZK-269
    this.ebody.offsetWidth : this.ebody.clientWidth;
    if (zk.webkit) anchor.style.display = '';
    return tblwd;
  };
  /** @internal */
  SelectWidget.prototype._beforeCalcSize = function () {
    this._calcHgh();
  };
  /**
   * @returns the index of the ItemWidget
   */
  SelectWidget.prototype.indexOfItem = function (item) {
    if (item.getMeshWidget() == this) {
      for (var i = 0, it = this.getBodyWidgetIterator(), w; w = it.next(); i++) if (w == item) return i;
    }
    return -1;
  };
  SelectWidget.prototype.toggleItemSelection = function (item) {
    if (item.isSelected()) this._removeItemFromSelection(item);else this._addItemToSelection(item);
    this.updateFormData();
  };
  /**
   * Deselects all of the currently selected items and selects the given item.
   * <p>
   * It is the same as {@link setSelectedItem}.
   *
   * @param item - the item to select. If null, all items are deselected.
   */
  SelectWidget.prototype.selectItem = function (item) {
    if (!item) this.setSelectedIndex(-1);else if (this._multiple || !item.isSelected()) this.setSelectedIndex(this.indexOfItem(item));
  };
  /** @internal */
  SelectWidget.prototype._addItemToSelection = function (item) {
    if (!item.isSelected()) {
      if (!this._multiple) {
        this._selectedIndex = this.indexOfItem(item);
      } else {
        var index = this.indexOfItem(item);
        if (index < this._selectedIndex || this._selectedIndex < 0) {
          this._selectedIndex = index;
        }
        item._setSelectedDirectly(true);
      }
      this._selItems.push(item);
    }
  };
  /** @internal */
  SelectWidget.prototype._removeItemFromSelection = function (item) {
    if (item.isSelected()) {
      if (!this._multiple) {
        this.clearSelection();
      } else {
        item._setSelectedDirectly(false);
        this._selItems.$remove(item);
      }
    }
  };
  /**
   * Clears the selection.
   */
  SelectWidget.prototype.clearSelection = function () {
    if (this._selItems.length) {
      for (var item; item = this._selItems.pop();) item._setSelectedDirectly(false);
      this._selectedIndex = -1;
      this._updHeaderCM();
    } else {
      //Bug ZK-3528: should reset _focusItem after clearing selected item
      this._focusItem = undefined;
      //Bug ZK-1834: should reset Focus Element after clearing selected item
      this._anchorTop = this._anchorLeft = 0;
      this._syncFocus();
    }
  };
  //super
  /** @internal */
  SelectWidget.prototype.focus_ = function (timeout) {
    var btn = this.$n('a');
    if (btn) {
      if (this._focusItem) {
        for (var it = this.getBodyWidgetIterator(), w; w = it.next();) if (this._isFocus(w)) {
          w.focus_(timeout);
          break;
        }
      } else {
        // Bug ZK-414
        if (this._currentTop) {
          // Bug ZK-2987: _currentTop might still holds the value from
          // previous page, make sure the anchor does not goes beyond
          // table height
          var offsetTop = this.ebody.scrollHeight;
          if (this._currentTop > offsetTop) btn.style.top = "".concat(offsetTop, "px");else btn.style.top = "".concat(this._currentTop, "px");
        }
        if (this._currentLeft) btn.style.left = "".concat(this._currentLeft, "px");
      }
      this.focusA_(btn, timeout);
      return true;
    }
    return false;
  };
  /** @internal */
  SelectWidget.prototype.focusA_ = function (btn, timeout) {
    zk(btn).focus(timeout);
  };
  /** @internal */
  SelectWidget.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    var btn = this.$n('a');
    if (btn) this.domListen_(btn, 'onFocus', 'doFocus_').domListen_(btn, 'onKeyDown').domListen_(btn, 'onBlur', 'doBlur_');
    this.updateFormData();
    this._updHeaderCM();
  };
  /** @internal */
  SelectWidget.prototype.unbind_ = function (skipper, after, keepRod) {
    var btn = this.$n('a');
    if (btn) this.domUnlisten_(btn, 'onFocus', 'doFocus_').domUnlisten_(btn, 'onKeyDown').domUnlisten_(btn, 'onBlur', 'doBlur_');
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  SelectWidget.prototype.clearCache = function () {
    _super.prototype.clearCache.call(this);
    this.efield = undefined;
  };
  /** @internal */
  SelectWidget.prototype.doFocus_ = function (evt) {
    var _a;
    var row = (_a = this._focusItem) !== null && _a !== void 0 ? _a : this._lastSelectedItem;
    if (row) row._doFocusIn();
    _super.prototype.doFocus_.call(this, evt);
  };
  /** @internal */
  SelectWidget.prototype.doBlur_ = function (evt) {
    if (this._focusItem) {
      this._lastSelectedItem = this._focusItem;
      this._focusItem._doFocusOut();
    }
    this._focusItem = undefined;
    _super.prototype.doBlur_.call(this, evt);
  };
  /**
   * @returns whether to ignore the selection.
   * It is called when selecting an item ({@link ItemWidget#doSelect_}).
   * @defaultValue always false (don't ignore) unless {@link rightSelect} is true and event is onRightClick.
   * Notice that clicking on button/textbox are already ignored, i.e.,
   * this method won't be called if the user clicks on, say, a button.
   * @param evt - the event
   * @param row - the row about to be selected
   * 0 (false): select if single select, and toggle selection if multiple,<br/>
   * and -1: always select (even if multiple)
   * @internal
   */
  SelectWidget.prototype.shallIgnoreSelect_ = function (evt, row) {
    //see also _shallIgnore
    return evt.name == 'onRightClick' ? this.rightSelect ? -1 : true : false;
  };
  //@param bSel whether it is called by _doItemSelect
  /** @internal */
  SelectWidget.prototype._shallIgnore = function (evt, bSel) {
    // F70-ZK-2433
    if (this.checkOnHighlightDisabled_()) return true;
    if (!evt.domTarget || !evt.target.canActivate()) return true;
    if (bSel) {
      try {
        // eslint-disable-next-line zk/noNull
        var el = evt.domTarget;
        if (el)
          //Not use jq.isAncestor since it calls vparentNode
          for (;;) {
            if (el.id == this.uuid)
              //listbox
              break;
            // eslint-disable-next-line zk/noNull
            if (!(el = el.parentNode)) return true; //vparent
          }
      } catch (e) {
        zk.debugLog(e.message || e);
      }
      if (typeof (bSel = this.nonselectableTags) == 'string') {
        if (!bSel) return false; //not ignore
        if (bSel == '*') return true;
        var tn = jq.nodeName(evt.domTarget),
          bInpBtn = tn == 'input' && evt.domTarget.type.toLowerCase() == 'button';
        if (!bSel.includes(tn)) {
          return bSel.includes('button') && (_isButton(evt) || bInpBtn);
        }
        return !bInpBtn || bSel.includes('button');
      }
    }
    return _focusable(evt);
  };
  // F70-ZK-2433 to be overridden
  /** @internal */
  SelectWidget.prototype.checkOnHighlightDisabled_ = function () {
    return false;
  };
  /** @internal */
  SelectWidget.prototype._doItemSelect = function (row, evt) {
    //It is better not to change selection only if dragging selected
    //(like Windows does)
    //However, FF won't fire onclick if dragging, so the spec is
    //not to change selection if dragging (selected or not)
    var alwaysSelect,
      tg = evt.domTarget,
      cm = row.$n('cm'),
      cmClicked = this._checkmark && (tg == cm || tg.parentNode == cm);
    if (zk.dragging || !cmClicked && (this._shallIgnore(evt, true) || (alwaysSelect = this.shallIgnoreSelect_(evt, row)) && !(alwaysSelect = alwaysSelect < 0))) return;
    var skipFocus = _focusable(evt); //skip focus if evt is on a focusable element
    if (this._checkmark && !evt.data.shiftKey && !(evt.data.ctrlKey || evt.data.metaKey) && (!this._cdo || cmClicked)) {
      // Bug 2997034
      this._syncFocus(row);
      if (this._multiple) {
        var seled = row.isSelected();
        if (!seled || !alwaysSelect) this._toggleSelect(row, !seled, evt, skipFocus);
      } else this._select(row, evt, skipFocus);
    } else {
      //Bug 1650540: double click as select again
      //Note: we don't handle if clicking on checkmark, since FF always
      //toggle and it causes incosistency
      if ((zk.gecko || zk.webkit) && row.isListen('onDoubleClick')) {
        var now = jq.now(),
          last = row._last;
        row._last = now;
        if (last && now - last < 900) return; //ignore double-click
      }
      this._syncFocus(row);
      if (this._multiple) {
        if (evt.data.shiftKey) this._selectUpto(row, evt, skipFocus);else if (evt.data.ctrlKey || evt.data.metaKey)
          //let multiple selection without checkmark work on tablet
          this._toggleSelect(row, !row.isSelected(), evt, skipFocus);else if (!alwaysSelect || !row.isSelected())
          // Bug: 1973470
          this._select(row, evt, skipFocus);
      } else this._select(row, evt, skipFocus);
      //since row might was selected, we always enforce focus here
      if (!skipFocus) row.focus();
      //if (evt) evt.stop();
      //No much reason to eat the event.
      //In opposite, it disabled popup (bug 1578659)
    }
  };
  /* Handles keydown sent to the body. */
  /** @internal */
  SelectWidget.prototype.doKeyDown_ = function (evt) {
    var _a, _b;
    if (!this._shallIgnore(evt)) {
      // Note: We don't intercept body's onfocus to gain focus back to anchor.
      // Otherwise, it cause scroll problem on IE:
      // When user clicks on the scrollbar, it scrolls first and call onfocus,
      // then it will scroll back to the focus because _focusToAnc is called
      switch (evt.data.keyCode) {
        case 33: //PgUp
        case 34: //PgDn
        case 38: //UP
        case 40: //DOWN
        case 37: //LEFT
        case 39: //RIGHT
        case 32: //SPACE
        case 36: //Home
        case 35:
          //End
          if (!jq.nodeName(evt.domTarget, 'a')) this.focus();
          if (evt.domTarget == this.$n('a')) {
            // for test tool.
            if (evt.target == this)
              //try to avoid the condition inside the _doKeyDown()
              evt.target = this._focusItem || this.getSelectedItem() || this;
            this._doKeyDown(evt);
          }
          evt.stop();
          return;
      }
    }
    // disable item's content selection excluding input box and textarea
    if (!jq.nodeName(evt.domTarget, 'input', 'textarea')) {
      this._disableSelection_ = true;
      zk(this.$n()).disableSelection();
    }
    // Feature #1978624
    if (evt.target == this)
      //try to give to the focus item
      evt.target = (_b = (_a = this._focusItem) !== null && _a !== void 0 ? _a : this.getSelectedItem()) !== null && _b !== void 0 ? _b : this;
    _super.prototype.doKeyDown_.call(this, evt);
  };
  /** @internal */
  SelectWidget.prototype.doKeyUp_ = function (evt) {
    if (this._disableSelection_) {
      this._disableSelection_ = false;
      zk(this.$n()).enableSelection();
    }
    evt.stop({
      propagation: true
    });
    _super.prototype.doKeyUp_.call(this, evt);
  };
  /** @internal */
  SelectWidget.prototype._doKeyDown = function (evt) {
    var _a, _b, _c;
    if (_beforeChildKey(this, evt)) return true;
    var row = (_a = this._focusItem) !== null && _a !== void 0 ? _a : this.getSelectedItem(),
      data = evt.data,
      shift = data.shiftKey,
      ctrl = data.ctrlKey || data.metaKey;
    if (shift && !this._multiple) shift = false; //OK to
    // F85-ZK-3507
    if (this._startRow && !shift && this._multiple) this._startRow = undefined;else if (!this._startRow && shift) this._startRow = row;
    var endless = false,
      step,
      lastrow;
    // for test tool when browser is webkit
    if (zk.webkit && typeof data.keyCode == 'string') data.keyCode = zk.parseInt(data.keyCode);
    switch (data.keyCode) {
      case 33: //PgUp
      case 34:
        //PgDn
        var pgnl = (_b = this.paging) !== null && _b !== void 0 ? _b : this._paginal;
        if (row && pgnl && !pgnl.isDisabled()) {
          // F60-ZK-715
          var npg = this.getActivePage() + (data.keyCode == 33 ? -1 : 1);
          // TODO: concern ctrl
          if (npg > -1 && npg < this.getPageCount()) this.fire('onAcrossPage', {
            page: npg,
            offset: this.indexOfItem(row),
            shift: !shift || !this._multiple ? 0 : data.keyCode == 33 ? this.getPageSize() : -this.getPageSize()
          });
          return false;
        }
        step = this._setOrGetVisibleRows();
        if (step == 0) step = this.getPageSize() || 20;
        if (data.keyCode == 33) step = -step;
        break;
      case 38: //UP
      case 40:
        //DOWN
        step = data.keyCode == 40 ? 1 : -1;
        break;
      case 32:
        //SPACE
        if (row) {
          if (this._multiple) this._toggleSelect(row, !row.isSelected(), evt);else this._select(row, evt);
        }
        break;
      case 36: //Home
      case 35:
        //End
        step = data.keyCode == 35 ? 1 : -1;
        endless = true;
        break;
      case 37:
        //LEFT
        if (row) this._doLeft(row);
        break;
      case 39:
        //RIGHT
        if (row) this._doRight(row);
        break;
    }
    if (step > 0 || step < 0 && row) {
      if (row && shift && !row.isDisabled() && row.isSelectable()) {
        // Bug ZK-1715: not select item if disabled.
        // F85-ZK-3507: shift + up/down: select item when moving outwards,
        // and deselect item when moving inwards
        this._toggleSelect(row, this._getToSelFlag(row, this._startRow, step), evt);
      }
      // eslint-disable-next-line zk/noNull
      var nrow = row ? row.$n() : undefined;
      for (;;) {
        if (!nrow) {
          // no focused/selected item yet
          var w = this.getBodyWidgetIterator().next();
          if (w) nrow = w.$n(); // F60-ZK-423: first row
          else return false; // empty
        } else nrow = step > 0 ? nrow.nextSibling : nrow.previousSibling;
        if (!nrow) {
          // F60-ZK-715: across to next/previous page if any
          if (endless) break; // ignore Home/End key
          var pg = (_c = this.paging) !== null && _c !== void 0 ? _c : this._paginal,
            pnum;
          if (pg && !pg.isDisabled()) {
            pnum = pg.getActivePage();
            // TODO: concern ctrl
            if (step > 0 ? pnum + 1 < pg.getPageCount() : pnum > 0) {
              this.fire('onAcrossPage', {
                page: pnum + (step > 0 ? 1 : 0),
                offset: step > 0 ? 0 : -1,
                shift: !this._multiple || !shift ? 0 : step > 0 ? -1 : 1
              });
              var $class = this.$class;
              $class.shallSyncSelInView || ($class.shallSyncSelInView = {});
              $class.shallSyncSelInView[this.uuid] = true;
            }
          }
          break;
        }
        var r = zk.Widget.$(nrow);
        if (r instanceof zul.sel.Treerow) r = r.parent;
        if (!r.isDisabled() && r.isSelectable()) {
          // F85-ZK-3507
          if (shift) this._toggleSelect(r, endless ? this._getToSelFlag(r, this._startRow, step) : true, evt);
          if (zk(nrow).isVisible()) {
            // ZK-2971: save last row even when pressing shift
            lastrow = r;
            if (!endless) {
              if (step > 0) --step;else ++step;
              if (step == 0) break;
            }
          }
        }
      }
    }
    if (lastrow) {
      if (!shift) {
        // ZK-2971: already handled in the previous code block, ignore shift
        if (ctrl) this._focus0(lastrow);else this._select(lastrow, evt);
      }
      this._syncFocus(lastrow);
      var bar = this._scrollbar;
      if (bar) bar.scrollToElement(lastrow.$n_());else {
        // 1823278: key up until selection is out of view port, then it should scroll.
        zk(lastrow.$n()).scrollIntoView(this.ebody); // Bug #1823947 and #1823278
      }
    }
    return _afterChildKey(evt);
  };
  /** @internal */
  SelectWidget.prototype._getToSelFlag = function (row, startRow, step) {
    if (!startRow) return true;
    var pos = startRow.compareItemPos_(row);
    return pos == 0 || pos == -1 && step == -1 || pos == 1 && step == 1;
  };
  /** @internal */
  SelectWidget.prototype._doKeyUp = function (evt) {
    return _beforeChildKey(this, evt) || _afterChildKey(evt);
  };
  /** @internal */
  SelectWidget.prototype._doLeft = function (row) {
    // An empty default implementation.
  };
  /** @internal */
  SelectWidget.prototype._doRight = function (row) {
    // An empty default implementation.
  };
  /* maintain the offset of the focus proxy*/
  /** @internal */
  SelectWidget.prototype._syncFocus = function (row) {
    var focusEl = this.$n('a');
    if (!focusEl)
      //Bug ZK-1480: widget may not rendered when ROD enabled
      return;
    var focusElStyle = focusEl.style,
      oldTop = this._anchorTop,
      oldLeft = this._anchorLeft,
      offs,
      n;
    if (row && (n = row.$n())) {
      offs = zk(n).revisedOffset();
      offs = this._toStyleOffset(focusEl, offs[0] + this.ebody.scrollLeft, offs[1]);
    } else
      // ZK-798, use old value if exists
      offs = [oldLeft ? oldLeft : 0, oldTop ? oldTop : 0];
    this.fixAnchor_(offs, focusEl);
    if (this._anchorTop != offs[1] || this._anchorLeft != offs[0]) {
      //ZK-798, to prevent firing onAnchorPos too many times when moust over a rod listbox,
      //if _anchorTop/_anchorLeft is the same , just ignore the event.
      this._anchorTop = offs[1];
      this._anchorLeft = offs[0];
      this.fire('onAnchorPos', {
        top: this._anchorTop,
        left: this._anchorLeft
      });
    }
    focusElStyle.top = "".concat(this._anchorTop, "px");
    focusElStyle.left = "".concat(this._anchorLeft, "px");
  };
  /** @internal */
  SelectWidget.prototype._toStyleOffset = function (el, x, y) {
    var ofs1 = zk(el).revisedOffset(),
      x2 = zk.parseFloat(el.style.left),
      y2 = zk.parseFloat(el.style.top);
    return [x - ofs1[0] + x2, y - ofs1[1] + y2];
  };
  /**
   * May need fix anchor.
   * @param offs - The anchor offset [left, top]
   * @since 6.0.0
   * @internal
   */
  SelectWidget.prototype.fixAnchor_ = function (offs, focusEl) {
    var body = this.ebody,
      sw = body.scrollWidth,
      sh = body.scrollHeight;
    if (offs[0] >= sw) offs[0] = sw - jq(focusEl).width();
    if (offs[1] >= sh) offs[1] = sh - jq(focusEl).height();
  };
  /* Selects an item, notify server and change focus if necessary. */
  /** @internal */
  SelectWidget.prototype._select = function (row, evt, skipFocus) {
    if (this._selectOne(row, skipFocus)) {
      //notify server
      this.fireOnSelect(row, evt);
    }
  };
  /* Selects a range from the last focus up to the specified one.
   * Callable only if multiple
   */
  /** @internal */
  SelectWidget.prototype._selectUpto = function (row, evt, skipFocus) {
    var _a;
    if (row.isSelected()) {
      if (!skipFocus) this._focus0(row);
      return; //nothing changed
    }
    var focusfound = false,
      rowfound = false,
      // ZK-1096: this._lastSelectedItem is only updated when doBlur
      lastSelected = (_a = this._focusItem) !== null && _a !== void 0 ? _a : this._lastSelectedItem;
    //Bugfix: if lastSelected is no longer selected, look for closest selected item as starting point
    if (!lastSelected.isSelected()) {
      var rowIndex = this.indexOfItem(row),
        min = Number.MAX_VALUE,
        closestSelItem;
      // eslint-disable-next-line @typescript-eslint/prefer-for-of
      for (var i = 0; i < this._selItems.length; ++i) {
        var item = this._selItems[i],
          index = this.indexOfItem(item),
          diff = rowIndex - index,
          oldmin = min;
        if (diff <= 0 && closestSelItem) break;
        min = Math.min(diff, min);
        if (min != oldmin) lastSelected = item;
      }
    }
    for (var it = this.getBodyWidgetIterator(), si = this.getSelectedItem(), w; w = it.next();) {
      if (w.isDisabled() || !w.isSelectable()) continue; // Bug: 2030986
      if (focusfound) {
        this._changeSelect(w, true);
        if (w == row) break;
      } else if (rowfound) {
        this._changeSelect(w, true);
        if (this._isFocus(w) || w == lastSelected) break;
      } else if (!si) {
        // Bug: 3337441
        if (w != row) continue;
        this._changeSelect(w, true);
        break;
      } else {
        rowfound = w == row;
        focusfound = this._isFocus(w) || w == lastSelected;
        if (rowfound || focusfound) {
          this._changeSelect(w, true);
          if (rowfound && focusfound) break;
        }
      }
    }
    if (!skipFocus) this._focus0(row);
    this.fireOnSelect(row, evt);
  };
  /**
   * Selects all items.
   * @param selectAll - if true, fire onSelect event to server
   */
  SelectWidget.prototype.setSelectAll = function (selectAll, evt) {
    for (var it = this.getBodyWidgetIterator(), w; w = it.next();) if (w._loaded && !w.isDisabled() && w.isSelectable()) this._changeSelect(w, true);
    if (selectAll && evt instanceof zk.Event) this.fireOnSelect(this.getSelectedItem(), evt);
    return this;
  };
  /**
   * Selects all items.
   * @param selectAll - if true, fire onSelect event to server
   */
  SelectWidget.prototype.selectAll = function (selectAll, evt) {
    return this.setSelectAll(selectAll, evt);
  };
  /* Selects one and deselect others, and return whehter any changes.
   * It won't notify the server.
   */
  /** @internal */
  SelectWidget.prototype._selectOne = function (row, skipFocus) {
    var selItem = this.getSelectedItem();
    if (this._multiple) {
      if (row) this._unsetFocusExcept(row);
      var changed = this._unsetSelectAllExcept(row);
      if (!changed && row && selItem == row) {
        if (!skipFocus) this._setFocus(row, true);
        return false; //not changed
      }
    } else {
      if (selItem) {
        if (selItem == row) {
          if (!skipFocus) this._setFocus(row, true);
          return false; //not changed
        }
        this._changeSelect(selItem, false);
        if (row) if (!skipFocus) this._setFocus(selItem, false);
      }
      if (row) this._unsetFocusExcept(row);
    }
    //we always invoke _changeSelect to change focus
    if (row) {
      this._changeSelect(row, true);
      this._lastSelectedItem = row;
      if (!skipFocus) this._setFocus(row, true);
    }
    return true;
  };
  /* Toggle the selection and notifies server. */
  /** @internal */
  SelectWidget.prototype._toggleSelect = function (row, toSel, evt, skipFocus) {
    //B70-ZK-2588: don't jump the focus if item is deselected and _multiple is true
    this._isSelecting = toSel;
    if (!this._multiple) {
      var old = this.getSelectedItem();
      if (row != old && toSel) this._changeSelect(row, false);
    }
    this._changeSelect(row, toSel);
    if (!skipFocus) this._focus0(row);
    //notify server
    this.fireOnSelect(row, evt);
  };
  /**
   * Fires the onSelect event.
   * If the widget is created at the server, the event will be sent
   * to the server too.
   * @param ref - the reference which causes this onSelect event.
   * Ignored if null.
   * @since 5.0.5
   */
  SelectWidget.prototype.fireOnSelect = function (ref, evt) {
    var _a, _b;
    var data = [];
    for (var it = this.getSelectedItems(), len = it.length, j = 0; j < len; j++) if (it[j].isSelected()) data.push(it[j]);
    var edata,
      keep = true,
      checkSelectAll = false;
    if (this._multiple && this._headercm) {
      checkSelectAll = jq(this._headercm).hasClass(zk.Widget.$(this._headercm).$s('checked'));
    }
    if (evt) {
      edata = evt.data;
      if (this._multiple) {
        // B50-ZK-421
        // Bug ZK-2969
        if (this._headercm && jq.isAncestor(this._headercm, evt.domTarget) && !checkSelectAll) {
          keep = false;
        } else {
          var tg = evt.domTarget,
            cm = ref === null || ref === void 0 ? void 0 : ref.$n('cm');
          keep = !!(edata.ctrlKey || edata.metaKey || edata.shiftKey || this._checkmark && (!this._cdo || tg == cm || tg.parentNode == cm || checkSelectAll));
        }
      }
    }
    this.fire('onSelect', zk.copy({
      items: data,
      // The shape of `rodItemIndexRange` is the same as `range` in listbox-rod#fireOnSelectByRange
      rodItemIndexRange: {
        start: (_a = this.firstItem) === null || _a === void 0 ? void 0 : _a._index,
        end: (_b = this.lastItem) === null || _b === void 0 ? void 0 : _b._index
      },
      // ZK-2658
      reference: ref,
      clearFirst: !keep,
      selectAll: checkSelectAll
    }, edata), {
      rtags: {
        selectAll: checkSelectAll
      },
      toServer: !!this._model
    });
  };
  /* Changes the specified row as focused. */
  /** @internal */
  SelectWidget.prototype._focus0 = function (row) {
    if (this.canActivate({
      checkOnly: true
    })) {
      this._unsetFocusExcept(row);
      this._setFocus(row, true);
    }
  };
  /* Changes the selected status of an item without affecting other items
   * and return true if the status is really changed.
   */
  /** @internal */
  SelectWidget.prototype._changeSelect = function (row, toSel) {
    var changed = !!row.isSelected() != toSel;
    if (changed) {
      row.setSelected(toSel);
      //row._toggleEffect(true);
    }
    return changed;
  };
  /** @internal */
  SelectWidget.prototype._isFocus = function (row) {
    return this._focusItem == row;
  };
  /* Changes the focus status, and return whether it is changed. */
  /** @internal */
  SelectWidget.prototype._setFocus = function (row, bFocus) {
    var changed = this._isFocus(row) != bFocus;
    if (changed) {
      if (bFocus) {
        if (!row.focus()) this.focus();
        if (!this.paging && zk.gecko) this.fireOnRender(5);
        //Firefox doesn't call onscroll when we moving by cursor, so...
      }
    }
    if (!bFocus) row._doFocusOut();
    return changed;
  };
  /* Cleans selected except the specified one, and returns any selected status
   * is changed.
   */
  /** @internal */
  SelectWidget.prototype._unsetSelectAllExcept = function (row) {
    this.$$selectAll = undefined;
    var changed = false;
    for (var it = this.getSelectedItems(), j = it.length; j--;) {
      if (it[j] != row && this._changeSelect(it[j], false)) changed = true;
    }
    return changed;
  };
  /* Cleans focus except the specified one.
   */
  /** @internal */
  SelectWidget.prototype._unsetFocusExcept = function (row) {
    if (this._focusItem && this._focusItem != row) {
      this._setFocus(this._focusItem, false);
      this._focusItem = undefined;
    }
  };
  /** @internal */
  SelectWidget.prototype._updHeaderCM = function () {
    var _this = this;
    if (this._headercm && this._multiple) {
      this._nUpdHeaderCM = 1 + Math.max(0, this._nUpdHeaderCM || 0); // in case `_nUpdHeaderCM` is undefined or NaN
      setTimeout(function () {
        return _updHeaderCM(_this);
      }, 100); //do it in batch
    }
  };
  SelectWidget.prototype.$fireService = function (evtName, data, callback) {
    if (!this._$services) {
      this._$services = {};
    }
    if (!this._$services[evtName]) {
      this._$services[evtName] = [];
    }
    this._$services[evtName].push(callback);
    this.fire(evtName, data, {
      toServer: true
    }, 250);
  };
  SelectWidget.prototype.$doService = function (evtName, data) {
    var _a;
    var s = (_a = this._$services) === null || _a === void 0 ? void 0 : _a[evtName];
    if (s) {
      while (s.length) s.shift().bind(this)(data);
      this._$services[evtName] = undefined;
    }
  };
  SelectWidget.prototype.$hasService = function (evtName) {
    var _a;
    return !!((_a = this._$services) === null || _a === void 0 ? void 0 : _a[evtName]);
  };
  /** @internal */
  SelectWidget.prototype._isAllSelected = function () {
    //B70-ZK-1953: if selectedItems is empty return false.
    if (!this._selItems.length) {
      if (this._headercm && this._model && !this.$hasService('onUpdateSelectAll')) {
        var headerWgt = zk.Widget.$(this._headercm),
          /*safe*/zcls = headerWgt.getZclass() + '-checked',
          $headercm = jq(this._headercm);
        $headercm.removeClass(zcls);
        headerWgt._checked = false;
      }
      return false;
    }
    if (this._model) {
      if (!this.$hasService('onUpdateSelectAll')) {
        this.$fireService('onUpdateSelectAll', undefined, function (v) {
          if (this.desktop && this._headercm && this._multiple) {
            var headerWgt = zk.Widget.$(this._headercm),
              /*safe*/zcls = headerWgt.getZclass() + '-checked',
              $headercm = jq(this._headercm);
            $headercm[v ? 'addClass' : 'removeClass'](zcls);
            headerWgt._checked = v;
            this.$$selectAll = v;
          }
        });
      }
      // use the server's state
      if (this.$$selectAll != undefined) {
        return this.$$selectAll;
      }
    }
    var isGroupSelect = this.groupSelect;
    for (var it = this.getBodyWidgetIterator({
        skipHidden: true
      }), w; w = it.next();) {
      //Bug ZK-1998: skip listgroup and listgroupfoot widget if groupSelect is false
      if ((_isListgroup(w) || _isListgroupfoot(w)) && !isGroupSelect) continue;
      if (w._loaded && !w.isDisabled() && w.isSelectable() && !w.isSelected()) return false;
    }
    return true;
  };
  /** @internal */
  SelectWidget.prototype._ignoreHghExt = function () {
    return this._rows > 0;
  };
  SelectWidget.prototype.onResponse = function (ctl, opts) {
    if (this._shallSyncFocus) {
      var child = this._shallSyncFocus;
      // Bug ZK-2901
      if (child && child === true) {
        // called by Tree.js
        this._anchorTop = this._anchorLeft = 0;
        jq(this.$n_('a')).css({
          top: 0,
          left: 0
        });
      } else {
        // 1. Bug ZK-1473: when using template to render listbox,
        //   this._focusItem still remain the removed one,
        //   set it with the newly rendered one to prevent keyboard navigation jump back to top
        // 2. ZK-2048: should ignore Treechildren
        // 3. for ZK-2342 Bug, we move the invoking of this._syncFocus() from onChildRemoved_() and onChildAdded_() to here.
        if (!child.desktop) {
          child = this.getSelectedItem();
          if (!child && jq.isNumeric(this.getSelectedIndex())) {
            var selIndex = this.getSelectedIndex();
            if (selIndex >= 0) {
              for (var it = this.getBodyWidgetIterator(); it.hasNext();) {
                var row = it.next();
                if (row && row._index == selIndex) {
                  child = row;
                  break;
                }
              }
            }
          }
        }
        this._focusItem = child;
        this._syncFocus(child);
      }
      this._shallSyncFocus = false;
    }
    if (this._shallSyncCM) {
      if (!opts.rtags.selectAll) this._updHeaderCM();
      this._shallSyncCM = false;
    }
    _super.prototype.onResponse.call(this, ctl, opts);
  };
  /** @internal */
  SelectWidget.prototype.onChildAdded_ = function (child) {
    _super.prototype.onChildAdded_.call(this, child);
    if (this.desktop) {
      if (child instanceof zul.sel.ItemWidget && child.isSelected()) this._shallSyncFocus = child;
    }
  };
  /** @internal */
  SelectWidget.prototype.onChildRemoved_ = function (child) {
    _super.prototype.onChildRemoved_.call(this, child);
    var selItems = this._selItems,
      len;
    if (this.desktop && (len = selItems.length) && child instanceof zul.sel.ItemWidget) this._shallSyncFocus = selItems[len - 1];
    //	Bug ZK-1473: when using template to render listbox,
    //   the item will be remove but current this._focusItem still remain,
    //   disable it to prevent keyboard navigation jump back to top
    if (this._focusItem == child) {
      // If true, child is guaranteed to be an ItemWidget
      this._focusItem = undefined;
      // Bug in test case ZK-2534, we need to resync the lastSelectedItem if onBlur event is not triggered.
      this._lastSelectedItem = this._focusItem;
      //ZK-2804: the first selected item may be removed in rod when
      //select multiple items with shift key
      this._itemForSelect = child;
    }
  };
  SelectWidget.prototype.replaceWidget = function (newwgt, skipper) {
    _super.prototype.replaceWidget.call(this, newwgt, skipper);
    newwgt._lastSelectedItem = _fixReplace(this._lastSelectedItem);
    newwgt._focusItem = _fixReplace(this._focusItem);
  };
  var SelectWidget_1;
  SelectWidget = SelectWidget_1 = __decorate([zk.WrapClass('zul.sel.SelectWidget')], SelectWidget);
  return SelectWidget;
}(zul.mesh.MeshWidget);
exports.SelectWidget = SelectWidget;
if (!window.zul) window.zul = {};
if (!window.zul.sel) window.zul.sel = {};
if (!window.zul.sel.SelectWidget) window.zul.sel.SelectWidget = {};
window.zul.sel.SelectWidget._ = {
  _beforeChildKey: _beforeChildKey,
  _afterChildKey: _afterChildKey,
  _updHeaderCM: _updHeaderCM,
  _isButton: _isButton,
  _isInputWidget: _isInputWidget,
  _focusable: _focusable,
  _fixReplace: _fixReplace,
  _isListgroup: _isListgroup,
  _isListgroupfoot: _isListgroupfoot,
  SelectWidget: SelectWidget
};

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/sel/Tree.ts":
/*!*******************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/sel/Tree.ts ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.TreeItemIter = exports.Tree = void 0;
/* Tree.ts

    Purpose:

    Description:

    History:
        Wed Jun 10 16:32:29     2009, Created by jumperchen

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.0 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 *  A container which can be used to hold a tabular
 * or hierarchical set of rows of elements.
 *
 * <p>Event:
 * <ol>
 * <li>onSelect event is sent when user changes the selection.</li>
 * </ol>
 *
 * @defaultValue {@link getZclass}: z-tree.
 */
var Tree = /** @class */function (_super) {
  __extends(Tree, _super);
  function Tree() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._scrollbar = undefined;
    /** @internal */
    _this._barPos = undefined;
    /**
     * @returns the tree item iterator.
     * @see {@link itemIterator}
     */
    _this.getBodyWidgetIterator = Tree_1.prototype.itemIterator;
    return _this;
  }
  Tree_1 = Tree;
  /** @internal */
  Tree.prototype.unbind_ = function (skipper, after, keepRod) {
    this.destroyBar_();
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  Tree.prototype.onSize = function () {
    _super.prototype.onSize.call(this);
    var self = this,
      frozen = this.frozen;
    if (this._shallSyncFrozen && frozen && this._nativebar) {
      frozen.onSize();
      this._shallSyncFrozen = false;
    }
    setTimeout(function () {
      if (self.desktop && !self._nativebar) {
        if (!self._scrollbar) self._scrollbar = zul.mesh.Scrollbar.init(self);
        self.refreshBar_();
      }
    }, 200);
  };
  /** @internal */
  Tree.prototype.refreshBar_ = function (showBar, scrollToTop) {
    var bar = this._scrollbar;
    if (bar) {
      var scrollPosition;
      if (this._currentLeft || this._currentTop) {
        scrollPosition = {
          l: this._currentLeft,
          t: this._currentTop
        };
      }
      //open/close tree node in paging mold will invalidate
      //  keep scroll position before sync scrollbar size
      if (this.inPagingMold() && scrollPosition) {
        showBar = true;
      }
      bar.syncSize(showBar || this._shallShowScrollbar);
      delete this._shallShowScrollbar; // use undefined rather false
      // ZK-355: Scroll to current position
      if (scrollPosition) {
        bar.scrollTo(scrollPosition.l, scrollPosition.t);
        scrollPosition = undefined;
      }
      //sync frozen
      var frozen = this.frozen,
        start;
      if (frozen && (start = frozen._start) != 0) {
        frozen._doScrollNow(start);
        bar.setBarPosition(start);
      }
    }
  };
  /** @internal */
  Tree.prototype.destroyBar_ = function () {
    var bar = this._scrollbar;
    if (bar) {
      bar.destroy();
      bar = this._scrollbar = undefined;
    }
  };
  /**
   * clears the tree children.
   */
  Tree.prototype.clear = function () {
    if (!this.treechildren || !this.treechildren.nChildren) return;
    for (var w = this.treechildren.firstChild; w; w = w.nextSibling) w.detach();
  };
  Tree.prototype.insertBefore = function (child, sibling, ignoreDom) {
    if (_super.prototype.insertBefore.call(this, child, sibling, !this.z_rod)) {
      this._fixOnAdd(child, ignoreDom, ignoreDom);
      return true;
    }
    return false;
  };
  Tree.prototype.appendChild = function (child, ignoreDom) {
    if (_super.prototype.appendChild.call(this, child, !this.z_rod)) {
      if (!this.insertingBefore_) this._fixOnAdd(child, ignoreDom, ignoreDom);
      return true;
    }
    return false;
  };
  /** @internal */
  Tree.prototype._fixOnAdd = function (child, ignoreDom, _noSync) {
    if (child instanceof zul.sel.Treecols) this.treecols = child;else if (child instanceof zul.sel.Treechildren) {
      this.treechildren = child;
      this._fixSelectedSet();
    } else if (child instanceof zul.mesh.Paging) {
      this.paging = child;
      this.paging.setMeshWidget(this);
    } else if (child instanceof zul.sel.Treefoot) this.treefoot = child;else if (child instanceof zul.mesh.Frozen) this.frozen = child;
    if (!ignoreDom) this.rerender();
    if (!_noSync) this._syncSize();
  };
  // ZK-5050
  /** @internal */
  Tree.prototype.beforeChildReplaced_ = function (oldc, newc) {
    this._fixOnAdd(newc, true, true);
  };
  /** @internal */
  Tree.prototype.onChildRemoved_ = function (child) {
    _super.prototype.onChildRemoved_.call(this, child);
    if (child == this.treecols) this.treecols = undefined;else if (child == this.treefoot) this.treefoot = undefined;else if (child == this.treechildren) {
      this.treechildren = undefined;
      this._selItems = [];
      this._sel = undefined;
    } else if (child == this.paging) {
      this.paging.setMeshWidget(undefined);
      this.paging = undefined;
    } else if (child == this.frozen) {
      this.frozen = undefined;
      this.destroyBar_();
    }
    if (!this.childReplacing_)
      //NOT called by onChildReplaced_
      this._syncSize();
  };
  /** @internal */
  Tree.prototype.onChildAdded_ = function (child) {
    _super.prototype.onChildAdded_.call(this, child);
    if (this.childReplacing_)
      //called by onChildReplaced_
      this._fixOnAdd(child, true);
    //else handled by insertBefore/appendChild
  };
  /** @internal */
  Tree.prototype._onTreeitemAdded = function (item) {
    this._fixNewChild(item);
    this._onTreechildrenAdded(item.treechildren);
  };
  /** @internal */
  Tree.prototype._onTreeitemRemoved = function (item) {
    var fixSel;
    if (item.isSelected()) {
      this._selItems.$remove(item);
      fixSel = this._sel == item;
      if (fixSel && !this._multiple) {
        this._sel = undefined;
      }
    }
    this._onTreechildrenRemoved(item.treechildren);
    if (fixSel) this._fixSelected();
    // ZK-5529: Tree focus is lost after loading new rows
    if (item.isSelected()) {
      var upperItem = item.previousSibling || item.getParentItem();
      if (upperItem) {
        this._shallSyncFocus = upperItem;
      } else {
        this._shallSyncFocus = true; // reset the anchor to the top;
      }
    } else {
      this._shallSyncFocus = this._sel;
    }
  };
  /** @internal */
  Tree.prototype._onTreechildrenAdded = function (tchs) {
    if (!tchs || tchs.parent == this) return; //the rest is already being processed by insertBefore
    //maintain the selected status
    for (var j = 0, items = tchs.getItems(), k = items.length; j < k; ++j) if (items[j]) this._fixNewChild(items[j]);
  };
  /** @internal */
  Tree.prototype._onTreechildrenRemoved = function (tchs) {
    if (tchs == null || tchs.parent == this) return; //already being processed by onChildRemoved
    //maintain the selected status
    var fixSel;
    for (var j = 0, items = tchs.getItems(), k = items.length; j < k; ++j) {
      var item = items[j];
      if (item.isSelected()) {
        this._selItems.$remove(item);
        if (this._sel == item) {
          if (!this._multiple) {
            this._sel = undefined;
            return; //done
          }
          fixSel = true;
        }
      }
    }
    if (fixSel) this._fixSelected();
  };
  /** @internal */
  Tree.prototype._fixNewChild = function (item) {
    if (item.isSelected()) {
      if (this._sel && !this._multiple) {
        item._selected = false;
        item.rerender();
      } else {
        if (!this._sel) this._sel = item;
        this._selItems.push(item);
      }
    }
  };
  /** @internal */
  Tree.prototype._fixSelectedSet = function () {
    this._sel = undefined;
    this._selItems = [];
    for (var j = 0, items = this.getItems(), k = items.length; j < k; ++j) {
      if (items[j].isSelected()) {
        if (this._sel == null) {
          this._sel = items[j];
        } else if (!this._multiple) {
          items[j]._selected = false;
          continue;
        }
        this._selItems.push(items[j]);
      }
    }
  };
  /** @internal */
  Tree.prototype._fixSelected = function () {
    var sel;
    switch (this._selItems.length) {
      case 1:
        sel = this._selItems[0];
      // fallthrough
      case 0:
        break;
      default:
        for (var j = 0, items = this.getItems(), k = items.length; j < k; ++j) {
          if (items[j].isSelected()) {
            sel = items[j];
            break;
          }
        }
    }
    if (sel != this._sel) {
      this._sel = sel;
      return true;
    }
    return false;
  };
  /** @internal */
  Tree.prototype._sizeOnOpen = function () {
    this._shallShowScrollbar = true;
    var cols = this.treecols,
      wd;
    if (!cols || this.isSizedByContent() || this._hflex == 'min') this.syncSize();else {
      for (var w = cols.firstChild; w; w = w.nextSibling) if (w._hflex || !(wd = w._width) || wd == 'auto') {
        this.syncSize();
        return;
      }
    }
    this.doResizeScroll_();
  };
  /**
   * @returns the head widget class. i.e. {@link Treecols}
   */
  Tree.prototype.getHeadWidgetClass = function () {
    return zul.sel.Treecols;
  };
  /**
   * @returns the tree item iterator.
   */
  Tree.prototype.itemIterator = function (opts) {
    return new zul.sel.TreeItemIter(this, opts);
  };
  /** @internal */
  Tree.prototype._updHeaderCM = function () {
    var _a;
    var tc = (_a = this.treecols) === null || _a === void 0 ? void 0 : _a.firstChild;
    if (this._headercm && this._multiple && tc) tc._checked = this._isAllSelected();
    _super.prototype._updHeaderCM.call(this);
  };
  /**
   * @returns a readonly list of all descending {@link Treeitem}
   * (children's children and so on).
   *
   * <p>Note: the performance of the size method of returned collection
   * is no good.
   */
  Tree.prototype.getItems = function (opts) {
    return this.treechildren ? this.treechildren.getItems(undefined, opts) : [];
  };
  /**
   * @returns the number of child {@link Treeitem}.
   * The same as {@link getItems}.size().
   * <p>Note: the performance of this method is no good.
   */
  Tree.prototype.getItemCount = function (opts) {
    return this.treechildren != null ? this.treechildren.getItemCount(opts) : 0;
  };
  /** @internal */
  Tree.prototype._doLeft = function (row) {
    if (row.isOpen()) {
      row.setOpen(false);
    }
  };
  /** @internal */
  Tree.prototype._doRight = function (row) {
    if (!row.isOpen()) {
      row.setOpen(true);
    }
  };
  /**
   * @returns whether to ignore the selection.
   * It is called when selecting an item ({@link ItemWidget#doSelect_}).
   * @defaultValue ignore the selection if it is clicked on the open icon or {@link rightSelect} is true and event is onRightClick.
   * @param evt - the event
   * @param row - the row about to be selected
   * @internal
   */
  Tree.prototype.shallIgnoreSelect_ = function (evt, row) {
    var n = evt.domTarget;
    if (n) {
      var id = n.id;
      return id.endsWith('open') || id.endsWith('icon') || evt.name == 'onRightClick' && !this.rightSelect;
    }
    return false;
  }; // Bug ZK-2295
  Tree.prototype.clearSelection = function () {
    _super.prototype.clearSelection.call(this);
    this._sel = undefined;
  }; // Bug ZK-2295
  /** @internal */
  Tree.prototype._addItemToSelection = function (item) {
    _super.prototype._addItemToSelection.call(this, item);
    this._sel = this._selItems[0]; // resync
  }; // Bug ZK-2295
  /** @internal */
  Tree.prototype._removeItemFromSelection = function (item) {
    _super.prototype._removeItemFromSelection.call(this, item);
    this._sel = this._selItems[0]; // resync
  }; // @Override F70-ZK-2433
  /** @internal */
  Tree.prototype.checkOnHighlightDisabled_ = function () {
    if (this._selectOnHighlightDisabled) {
      // eslint-disable-next-line @typescript-eslint/dot-notation
      var selection = window.getSelection || document['selection'];
      if (selection) {
        return selection().toString().length > 0;
      }
    }
    return false;
  };
  var Tree_1;
  Tree = Tree_1 = __decorate([zk.WrapClass('zul.sel.Tree')], Tree);
  return Tree;
}(zul.sel.SelectWidget);
exports.Tree = Tree;
/**
 * Tree item iterator.
 */
var TreeItemIter = /** @class */function (_super) {
  __extends(TreeItemIter, _super);
  /**
   * @param tree - the widget that the iterator belongs to
   */
  function TreeItemIter(tree, opts) {
    var _this = _super.call(this) || this;
    _this.tree = tree;
    _this.opts = opts;
    return _this;
  }
  /** @internal */
  TreeItemIter.prototype._init = function () {
    if (!this._isInit) {
      this._isInit = true;
      this.items = this.tree.getItems(this.opts);
      this.length = this.items.length;
      this.cur = 0;
    }
  };
  /**
  * @returns `true` if the iteration has more elements
  */
  TreeItemIter.prototype.hasNext = function () {
    this._init();
    return this.cur < this.length;
  };
  /**
   * @returns the next element in the iteration.
   */
  TreeItemIter.prototype.next = function () {
    this._init();
    return this.items[this.cur++];
  };
  TreeItemIter = __decorate([zk.WrapClass('zul.sel.TreeItemIter')], TreeItemIter);
  return TreeItemIter;
}(zk.Object);
exports.TreeItemIter = TreeItemIter;
if (!window.zul) window.zul = {};
if (!window.zul.sel) window.zul.sel = {};
if (!window.zul.sel.Tree) window.zul.sel.Tree = {};
window.zul.sel.Tree._ = {
  Tree: Tree,
  TreeItemIter: TreeItemIter
};

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/sel/Treecell.ts":
/*!***********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/sel/Treecell.ts ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Treecell = void 0;
/* Treecell.ts

    Purpose:

    Description:

    History:
        Wed Jun 10 15:32:39     2009, Created by jumperchen

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.0 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * A treecell.
 *
 * <p>In XUL, treecell cannot have any child, but ZUL allows it.
 * Thus, you could place any kind of children in it. They will be placed
 * right after the image and label.
 *
 * @defaultValue {@link getZclass}: z-treecell
 */
var Treecell = /** @class */function (_super) {
  __extends(Treecell, _super);
  function Treecell() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._colspan = 1;
    return _this;
  }
  /**
   * The width can't be specified in this component.
   */
  Treecell.prototype.setWidth = function (width) {
    // This function simply does nothing.
    return this;
  };
  /**
   * @returns number of columns to span this cell.
   * @defaultValue `1`.
   */
  Treecell.prototype.getColspan = function () {
    return this._colspan;
  };
  /**
   * Sets the number of columns to span this cell.
   * <p>It is the same as the colspan attribute of HTML TD tag.
   */
  Treecell.prototype.setColspan = function (colspan, opts) {
    var o = this._colspan;
    this._colspan = colspan = Math.max(colspan, 1);
    if (o !== colspan || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var n = this.$n();
      if (n) n.colSpan = this._colspan;
    }
    return this;
  };
  /**
   * @returns the tree that owns this cell.
   */
  Treecell.prototype.getTree = function () {
    return this.parent ? this.parent.getTree() : undefined;
  };
  /** @internal */
  Treecell.prototype.domStyle_ = function (no) {
    no = zk.copy(no, {
      width: true
    }); //bug#3185657: not span content if given width
    var style = '',
      tc = this.getTreecol();
    // B70-ZK-2946: adds the text-align from treecol, same as Listcell
    if (tc) {
      if (tc._align) style += 'text-align: ' + tc._align + ';';
      if (!tc.isVisible()) no = zk.copy(no, {
        visible: true
      });
    }
    return _super.prototype.domStyle_.call(this, no) + style;
  };
  /**
   * @returns the tree col associated with this cell, or null if not available.
   */
  Treecell.prototype.getTreecol = function () {
    var tree = this.getTree();
    if (tree && tree.treecols) {
      var j = this.getChildIndex();
      if (j < tree.treecols.nChildren) return tree.treecols.getChildAt(j);
    }
    return undefined;
  };
  /**
   * @returns the level this cell is. The root is level 0.
   */
  Treecell.prototype.getLevel = function () {
    return this.parent ? this.parent.getLevel() : 0;
  };
  /**
   * @returns the maximal length of each item's label.
   */
  Treecell.prototype.getMaxlength = function () {
    var tc = this.getTreecol();
    return tc ? tc.getMaxlength() : 0;
  };
  /** @internal */
  Treecell.prototype.domLabel_ = function () {
    return zUtl.encodeXML(this.getLabel(), {
      maxlength: this.getMaxlength()
    });
  };
  Treecell.prototype.getTextNode = function () {
    return this.getCaveNode();
  };
  /** @internal */
  Treecell.prototype.domContent_ = function () {
    var /*safe*/s1 = _super.prototype.domContent_.call(this),
      s2 = this._colHtmlPre();
    return s1 ? s2 ? s2 + '<span class="' + this.$s('text') + '">' + s1 + '</span>' : s1 : s2;
  };
  /** @internal */
  Treecell.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    if (this._clearCache) {
      // B60-ZK-1348
      this._clearCache = false;
      var p = this.parent;
      if (p) {
        p.clearCache(); //$n('open')
      }
    }
  };
  /** @internal */
  Treecell.prototype.doMouseOver_ = function (evt) {
    var n = this.$n();
    // ZK-2136: all children should apply -moz-user-select: none
    if (n && zk.gecko && (this._draggable || this.parent._draggable) && !jq.nodeName(evt.domTarget, 'input', 'textarea')) {
      jq(n).addClass('z-draggable-over');
    }
    _super.prototype.doMouseOver_.call(this, evt);
  };
  /** @internal */
  Treecell.prototype.doMouseOut_ = function (evt) {
    var n = this.$n();
    // ZK-2136: all children should apply -moz-user-select: none
    if (n && zk.gecko && (this._draggable || this.parent._draggable) && !jq.nodeName(evt.domTarget, 'input', 'textarea')) {
      jq(n).removeClass('z-draggable-over'); // Bug ZK-580
    }
    _super.prototype.doMouseOut_.call(this, evt);
  };
  /** @internal */
  Treecell.prototype.doFocus_ = function (evt) {
    _super.prototype.doFocus_.call(this, evt);
    //sync frozen
    var tree = this.getTree(),
      frozen = tree ? tree.frozen : undefined,
      tbody = tree && tree.treechildren ? tree.treechildren.$n() : undefined;
    if (frozen && tbody) {
      var tds = jq(evt.domTarget).parents('td');
      for (var i = 0, j = tds.length; i < j; i++) {
        var td = tds[i];
        if (td.parentNode.parentNode == tbody) {
          tree._moveToHidingFocusCell(td.cellIndex);
          break;
        }
      }
    }
  };
  /** @internal */
  Treecell.prototype._syncIcon = function (isRemoved) {
    this.rerender(isRemoved ? -1 : undefined);
    if (this.parent) {
      this._clearCache = true;
    }
  };
  /** @internal */
  Treecell.prototype._colHtmlPre = function () {
    var _a;
    if (this.parent.firstChild == this) {
      var item = this.parent.parent,
        tree = item.getTree(),
        out = new zk.Buffer();
      if (tree) {
        if (tree.isCheckmark()) {
          var chkable = item.isSelectable(),
            multi = tree.isMultiple(),
            cmCls = multi ? item.$s('checkbox') : item.$s('radio'),
            ckCls = multi ? ' z-icon-check' : ' z-icon-radio';
          out.push('<span id="', /*safe*/this.parent.uuid, '-cm" class="', item.$s('checkable'), ' ', /*safe*/cmCls);
          if (!chkable || item.isDisabled()) out.push(' ', item.$s('disabled'));
          out.push('"');
          if (!chkable) out.push(' style="visibility:hidden"');
          out.push('><i class="', item.$s('icon'), /*safe*/ckCls, '"></i></span>');
        }
      }
      var iconScls = zUtl.encodeXML(tree ? tree.getZclass() : ''),
        pitems = this._getTreeitems(item, tree);
      for (var j = 0, k = pitems.length; j < k; ++j) {
        // ZK-4494: Add information about whether a line should be omitted when decorating
        var omit = j < k - 1 && ((_a = pitems[j + 1].treerow) === null || _a === void 0 ? void 0 : _a.isLastVisibleChild_());
        this._appendIcon(out, iconScls, 'spacer', false, omit);
      }
      if (item.isContainer()) {
        var name = item.isOpen() ? 'open' : 'close';
        this._appendIcon(out, iconScls, name, true);
      } else {
        this._appendIcon(out, iconScls, 'spacer', false);
      }
      return out.join('');
    } else {
      // ZK-4679: We don't have to generate &nbsp; for empty cell to correct the tree's height in IE anymore
      return '';
    }
  };
  /** @internal */
  Treecell.prototype._getTreeitems = function (item, tree) {
    var pitems = [],
      p = item;
    for (;;) {
      var tch = p.parent;
      if (!tch) break;
      p = tch.parent;
      if (!p || p == tree) break;
      pitems.unshift(p);
    }
    return pitems;
  };
  /** @internal */
  Treecell.prototype._appendIcon = function (sb, iconScls, name, button, omit) {
    var openCloseIcon = '';
    sb.push('<span class="');
    if (name == 'spacer') {
      // ZK-4494: Add information about whether a line should be omitted when decorating lines
      sb.push(iconScls, '-line ', iconScls, '-', name, omit ? ' ' + iconScls + '-line-omit' : '', '"');
    } else {
      var id = '';
      if (button) {
        var item = this.parent;
        if (item) id = item.uuid + '-icon';
      }
      sb.push(iconScls, '-icon"');
      var icon = this.getIconOpenClass_();
      if (name.includes('close')) icon = this.getIconCloseClass_();
      /*safe*/
      openCloseIcon += '<i id="' + /*safe*/id + '" class="' + /*safe*/icon + ' ' + /*safe*/iconScls + '-' + /*safe*/name + '"></i>';
    }
    if (button) {
      var item = this.parent; // B65-ZK-1608, appendChild() will invoke before treeitem._fixOnAdd()
      if (item) sb.push(' id="', item.uuid, '-open"');
    }
    /*safe*/
    sb.push('>', openCloseIcon, '</span>');
  };
  /** @internal */
  Treecell.prototype.getIconOpenClass_ = function () {
    return 'z-icon-caret-down';
  };
  /** @internal */
  Treecell.prototype.getIconCloseClass_ = function () {
    return 'z-icon-caret-right';
  };
  Treecell.prototype.getWidth = function () {
    var col = this.getTreecol();
    return col ? col.getWidth() : undefined;
  };
  /** @internal */
  Treecell.prototype.domAttrs_ = function (no) {
    return _super.prototype.domAttrs_.call(this, no) + (this._colspan > 1 ? ' colspan="' + this._colspan + '"' : '');
  };
  /** @internal */
  Treecell.prototype.domClass_ = function (no) {
    var /*safe*/scls = _super.prototype.domClass_.call(this, no),
      col = this.getTreecol();
    if (col) {
      if (!col.isVisible()) scls += ' ' + this.$s('hidden-col');
    }
    return scls;
  };
  /** @internal */
  Treecell.prototype.updateDomContent_ = function () {
    _super.prototype.updateDomContent_.call(this);
    if (this.parent) this.parent.clearCache();
  };
  /** @internal */
  Treecell.prototype.deferRedrawHTML_ = function (out) {
    out.push('<td', this.domAttrs_({
      domClass: true
    }), ' class="z-renderdefer"></td>');
  };
  Treecell = __decorate([zk.WrapClass('zul.sel.Treecell')], Treecell);
  return Treecell;
}(zul.LabelImageWidget);
exports.Treecell = Treecell;
if (!window.zul) window.zul = {};
if (!window.zul.sel) window.zul.sel = {};
if (!window.zul.sel.Treecell) window.zul.sel.Treecell = {};
window.zul.sel.Treecell._ = {
  Treecell: Treecell
};

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/sel/Treechildren.ts":
/*!***************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/sel/Treechildren.ts ***!
  \***************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Treechildren = void 0;
/* Treechildren.ts

    Purpose:

    Description:

    History:
        Wed Jun 10 15:32:40     2009, Created by jumperchen

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.0 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
function _prevsib(child) {
  var p = child.parent;
  if (p && p.lastChild == child) return child.previousSibling;
}
function _fixOnAdd(oldsib, child, ignoreDom) {
  if (!ignoreDom) {
    if (oldsib) oldsib._syncIcon();
    var p = child.parent,
      q = child.previousSibling;
    if (p && p.lastChild == child && q) q._syncIcon();
  }
}
function _syncFrozen(wgt) {
  var tree = wgt.getTree(),
    frozen;
  if ((tree === null || tree === void 0 ? void 0 : tree._nativebar) && (frozen = tree.frozen)) frozen._syncFrozen();
}
var Treechildren = /** @class */function (_super) {
  __extends(Treechildren, _super);
  function Treechildren() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  Treechildren_1 = Treechildren;
  /** @internal */
  Treechildren.prototype.bind_ = function (desktop, skipper, after) {
    var _this = this;
    _super.prototype.bind_.call(this, desktop, skipper, after);
    zWatch.listen({
      onResponse: this
    });
    after.push(function () {
      return _syncFrozen(_this);
    });
  };
  /** @internal */
  Treechildren.prototype.unbind_ = function (skipper, after, keepRod) {
    zWatch.unlisten({
      onResponse: this
    });
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  Treechildren.prototype.onResponse = function () {
    if (this.desktop) {
      var tree = this.getTree();
      if (tree === null || tree === void 0 ? void 0 : tree.frozen) {
        tree._shallSyncFrozen = true;
        tree.onSize();
      }
    }
  };
  /**
   * @returns the {@link Tree} instance containing this element.
   */
  Treechildren.prototype.getTree = function () {
    return this.isTopmost() ? this.parent : this.parent ? this.parent.getTree() : undefined;
  };
  /**
   * @returns the {@link Treerow} that is associated with
   * this treechildren, or null if no such treerow.
   */
  Treechildren.prototype.getLinkedTreerow = function () {
    // optimised to assume the tree doesn't have treerow property
    return this.parent ? this.parent.treerow : undefined;
  };
  /**
   * @returns whether this treechildren is topmost.
   * @since 5.0.6
   */
  Treechildren.prototype.isTopmost = function () {
    // null/undefined can only be instanceof null/undefined, respectively
    return this.parent instanceof zul.sel.Tree;
  };
  Treechildren.prototype.isRealElement = function () {
    return false; // fixed for ZK Client selector issue
  };
  Treechildren.prototype.insertBefore = function (child, sibling, ignoreDom) {
    var oldsib = _prevsib(child);
    if (_super.prototype.insertBefore.call(this, child, sibling, ignoreDom)) {
      _fixOnAdd(oldsib, child, ignoreDom);
      return true;
    }
    return false;
  };
  Treechildren.prototype.appendChild = function (child, ignoreDom) {
    var oldsib = _prevsib(child);
    if (_super.prototype.appendChild.call(this, child, ignoreDom)) {
      if (!this.insertingBefore_) _fixOnAdd(oldsib, child, ignoreDom);
      return true;
    }
    return false;
  };
  /** @internal */
  Treechildren.prototype.insertChildHTML_ = function (child, before_, desktop) {
    var _a;
    var ben,
      isTopmost = this.isTopmost(),
      before = before_;
    if (before) before = before.$n() ? before.getFirstNode_() : undefined; //Bug ZK-1424: fine tune performance when open with rod
    if (!before && !isTopmost) ben = (_a = this.getCaveNode()) !== null && _a !== void 0 ? _a : this.parent.getCaveNode();
    if (before) jq(before).before( /*safe*/child.redrawHTML_());else if (ben) jq(ben).after( /*safe*/child.redrawHTML_());else {
      if (isTopmost) jq(this.parent.$n_('rows')).append( /*safe*/child.redrawHTML_());else jq(this).append( /*safe*/child.redrawHTML_());
    }
    child.bind(desktop);
  };
  Treechildren.prototype.getCaveNode = function () {
    for (var w = this.lastChild; w; w = w.previousSibling) {
      var cn = w.getCaveNode();
      if (cn) {
        // Bug 2909820
        if (w.treechildren) {
          var _cn = w.treechildren.getCaveNode();
          if (_cn) cn = _cn;
        }
        return cn;
      }
    }
  };
  Treechildren.prototype.isRealVisible = function (opts) {
    return !!this._isRealVisible() && _super.prototype.isRealVisible.call(this, opts);
  };
  /** @internal */
  Treechildren.prototype._isRealVisible = function () {
    var p = this.parent;
    return this.isVisible() && !!(this.isTopmost() || (p === null || p === void 0 ? void 0 : p.isOpen()) && p._isRealVisible());
  };
  /**
   * @returns a readonly list of all descending {@link Treeitem}
   * (children's children and so on).
   *
   * <p>Note: the performance of the size method of returned collection
   * is no good.
   */
  Treechildren.prototype.getItems = function (items, opts) {
    items = items !== null && items !== void 0 ? items : [];
    var skiphd = opts === null || opts === void 0 ? void 0 : opts.skipHidden;
    for (var w = this.firstChild; w; w = w.nextSibling) if (!skiphd || w.isVisible()) {
      items.push(w);
      if (w.treechildren && (!skiphd || w.isOpen())) w.treechildren.getItems(items, opts);
    }
    return items;
  };
  /**
   * @returns the number of child {@link Treeitem}
   * including all descendants. The same as {@link getItems}.size().
   * <p>Note: the performance is no good.
   */
  Treechildren.prototype.getItemCount = function (opts) {
    var sz = 0,
      skiphd = opts === null || opts === void 0 ? void 0 : opts.skipHidden;
    for (var w = this.firstChild; w; w = w.nextSibling) if (!skiphd || w.isVisible()) {
      sz++;
      if (w.treechildren && (!skiphd || w.isOpen())) sz += w.treechildren.getItemCount(opts);
    }
    return sz;
  };
  /** @internal */
  Treechildren.prototype.beforeParentChanged_ = function (newParent) {
    var oldtree = this.getTree();
    if (oldtree) oldtree._onTreechildrenRemoved(this);
    if (newParent) {
      var tree = newParent instanceof zul.sel.Tree ? newParent : newParent.getTree();
      if (tree) tree._onTreechildrenAdded(this);
    }
    _super.prototype.beforeParentChanged_.call(this, newParent);
  };
  /** @internal */
  Treechildren.prototype.removeHTML_ = function (n) {
    for (var w = this.firstChild; w; w = w.nextSibling) {
      var cn = w.$n();
      if (cn) w.removeHTML_(cn);
    }
    _super.prototype.removeHTML_.call(this, n);
  };
  /** @internal */
  Treechildren.prototype.getOldWidget_ = function (n) {
    var old = _super.prototype.getOldWidget_.call(this, n);
    if (old && old instanceof zul.sel.Treerow) {
      var ti = old.parent;
      if (ti) return ti.treechildren;
      return undefined;
    }
    return old;
  };
  // FIXME: make this generic? Note that its super method is generic.
  Treechildren.prototype.$n = function (nm) {
    if (this.isTopmost()) return this.getTree().$n('rows');
    // to support @treechildren selector on zk.Widget.$(),
    // the original implementation may not work properly, because
    // its firstChild.$n() may not exists (in ROD case) but itself does, so
    // we use parent.$n() instead here to prevent this issue, and from the
    // other part of the implementation in Treechildren.js seems not to
    // depend on this.$n() if isTopmost() is returned with false
    return this.parent.$n();
  };
  Treechildren.prototype.replaceWidget = function (newwgt, skipper) {
    var _a, _b;
    while (this.firstChild != this.lastChild) this.lastChild.detach();
    (_b = (_a = this.firstChild) === null || _a === void 0 ? void 0 : _a.treechildren) === null || _b === void 0 ? void 0 : _b.detach();
    zul.sel.Treeitem._syncSelItems(this, newwgt);
    _super.prototype.replaceWidget.call(this, newwgt, skipper);
  };
  /** @internal */
  Treechildren.prototype.onChildAdded_ = function (child) {
    _super.prototype.onChildAdded_.call(this, child);
    if (this.desktop) this.getTree()._syncSize();
  };
  /** @internal */
  Treechildren.prototype.onChildRemoved_ = function (child) {
    _super.prototype.onChildRemoved_.call(this, child);
    if (this.desktop) this.getTree()._syncSize();
  };
  /** @internal */
  Treechildren.prototype.replaceChildHTML_ = function (child, n, desktop, skipper, _trim_) {
    var oldwgt = child.getOldWidget_(n);
    if (oldwgt) oldwgt.unbind(skipper); //unbind first (w/o removal)
    else if (this.shallChildROD_(child)) this.$class._unbindrod(child); //possible (e.g., Errorbox: jq().replaceWith)
    jq(n).replaceWith( /*safe*/child.redrawHTML_(skipper, _trim_));
    child.bind(desktop, skipper);
  };
  /** @internal */
  Treechildren.prototype.getLastVisibleItem_ = function () {
    for (var w = this.lastChild; w; w = w.previousSibling) {
      if (w._isVisibleInTree()) return w;
    }
    return undefined;
  };
  var Treechildren_1;
  Treechildren = Treechildren_1 = __decorate([zk.WrapClass('zul.sel.Treechildren')], Treechildren);
  return Treechildren;
}(zul.Widget);
exports.Treechildren = Treechildren;
if (!window.zul) window.zul = {};
if (!window.zul.sel) window.zul.sel = {};
if (!window.zul.sel.Treechildren) window.zul.sel.Treechildren = {};
window.zul.sel.Treechildren._ = {
  _prevsib: _prevsib,
  _fixOnAdd: _fixOnAdd,
  _syncFrozen: _syncFrozen,
  Treechildren: Treechildren
};

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/sel/Treecol.ts":
/*!**********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/sel/Treecol.ts ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Treecol = void 0;
/* Treecol.ts

    Purpose:

    Description:

    History:
        Wed Jun 10 15:32:40     2009, Created by jumperchen

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.0 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
function _updCells(tch, jcol) {
  if (tch) for (var w = tch.firstChild; w; w = w.nextSibling) {
    var tr = w.treerow;
    if (tr && jcol < tr.nChildren) tr.getChildAt(jcol).rerender();
    _updCells(w.treechildren, jcol); //recursive
  }
}
function _sort0(treechildren, col, dir, sorting, isNumber) {
  var d = [];
  for (var i = 0, z = 0, w = treechildren.firstChild; w; w = w.nextSibling, z++) {
    if (w.treechildren) _sort0(w.treechildren, col, dir, sorting, isNumber);
    for (var k = 0, cell = w.getFirstCell(); cell; cell = cell.nextSibling, k++) if (k == col) {
      d[i++] = {
        wgt: cell,
        index: z
      };
    }
  }
  var dsc = dir == 'ascending' ? -1 : 1;
  d.sort(function (a, b) {
    var v = sorting(a.wgt, b.wgt, isNumber) * dsc;
    if (v == 0) {
      v = a.index < b.index ? -1 : 1;
    }
    return v;
  });
  for (var i = 0, k = d.length; i < k; i++) {
    treechildren.appendChild(d[i].wgt.parent.parent);
  }
}
/**
 * A treecol.
 * @defaultValue {@link getZclass}: z-treecol
 */
var Treecol = /** @class */function (_super) {
  __extends(Treecol, _super);
  function Treecol() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  /**
   * @returns the tree that it belongs to.
   */
  Treecol.prototype.getTree = function () {
    return this.parent ? this.parent.parent : undefined;
  };
  /**
   * @returns the mesh body that this belongs to.
   * @since 5.0.6
   */
  Treecol.prototype.getMeshBody = function () {
    var tree = this.getTree();
    return tree ? tree.treechildren : undefined;
  };
  /** @internal */
  Treecol.prototype.checkClientSort_ = function (ascending) {
    var tree;
    return !(!this.getMeshBody() || !(tree = this.getTree()) || 'paging' == tree._mold) && _super.prototype.checkClientSort_.call(this, ascending);
  };
  /** @internal */
  Treecol.prototype.replaceCavedChildrenInOrder_ = function (ascending) {
    var mesh = this.getMeshWidget(),
      body = this.getMeshBody(),
      desktop = body.desktop;
    try {
      body.unbind();
      _sort0(body, this.getChildIndex(), this.getSortDirection(), this.sorting, this[ascending ? '_sortAscending' : '_sortDescending'] == 'client(number)');
      this._fixDirection(ascending);
    } finally {
      var old = mesh._syncingbodyrows;
      mesh._syncingbodyrows = true;
      try {
        mesh.clearCache();
        jq(mesh.$n_('rows')).replaceWith( /*safe*/body.redrawHTML_());
        body.bind(desktop);
        mesh._bindDomNode();
      } finally {
        mesh._syncingbodyrows = old;
      }
    }
  };
  /**
   * @returns the maximal length of each item's label.
   */
  Treecol.prototype.getMaxlength = function () {
    return this._maxlength;
  };
  /**
   * Sets the maximal length of each item's label.
   */
  Treecol.prototype.setMaxlength = function (maxlength, opts) {
    var o = this._maxlength,
      v = maxlength;
    this._maxlength = maxlength = !v || v < 0 ? 0 : v;
    if (o !== maxlength || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      if (this.desktop) {
        this.rerender();
        this.updateCells_();
      }
    }
    return this;
  };
  /** @internal */
  Treecol.prototype.updateCells_ = function () {
    var tree = this.getTree();
    if (tree) {
      var jcol = this.getChildIndex(),
        tf = tree.treefoot;
      _updCells(tree.treechildren, jcol);
      if (tf && jcol < tf.nChildren) tf.getChildAt(jcol).rerender();
    }
  };
  /** @internal */
  Treecol.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    var n = this.$n();
    if (n) this.domListen_(n, 'onMouseOver', '_doSortMouseEvt').domListen_(n, 'onMouseOut', '_doSortMouseEvt');
    var cm = this.$n('cm');
    if (cm) {
      var tree = this.getTree();
      if (tree) tree._headercm = cm;
      this.domListen_(cm, 'onClick', '_doCheckmarkClick');
    }
  };
  /** @internal */
  Treecol.prototype.unbind_ = function (skipper, after, keepRod) {
    var n = this.$n();
    if (n) this.domUnlisten_(n, 'onMouseOver', '_doSortMouseEvt').domUnlisten_(n, 'onMouseOut', '_doSortMouseEvt');
    var cm = this.$n('cm');
    if (cm) {
      var tree = this.getTree();
      if (tree) tree._headercm = undefined;
      this._checked = undefined;
      this.domUnlisten_(cm, 'onClick', '_doCheckmarkClick');
    }
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /** @internal */
  Treecol.prototype._doSortMouseEvt = function (evt) {
    var sort = this.getSortAscending();
    if (sort != 'none') jq(this.$n_())[evt.name == 'onMouseOver' ? 'addClass' : 'removeClass'](this.getZclass() + '-sort-over');
  };
  /** @internal */
  Treecol.prototype.domContent_ = function () {
    var /*safe*/s = _super.prototype.domContent_.call(this),
      tree = this.getTree();
    if (this._hasCheckbox()) /*safe*/s = '<span id="' + this.uuid + '-cm" class="' + this.$s('checkable') + (tree.$$selectAll ? ' ' + this.$s('checked') : '') + '"><i class="' + this.$s('icon') + ' z-icon-check"></i></span>' + (s ? '&nbsp;' + /*safe*/s : '');
    return s;
  };
  /** @internal */
  Treecol.prototype._hasCheckbox = function () {
    var tree = this.getTree();
    return !!(tree != null && this.parent.firstChild == this && tree._checkmark && tree._multiple && !tree._tree$noSelectAll);
  };
  /** @internal */
  Treecol.prototype.domLabel_ = function () {
    return zUtl.encodeXML(this.getLabel(), {
      maxlength: this._maxlength
    });
  };
  /** @internal */
  Treecol.prototype._doCheckmarkClick = function (evt) {
    this._checked = !this._checked;
    var tree = this.getTree(),
      cm = this.$n_('cm'),
      $n = jq(cm);
    if (this._checked) {
      $n.addClass(this.$s('checked'));
      tree.selectAll(true, evt);
    } else {
      $n.removeClass(this.$s('checked'));
      tree._select(undefined, evt);
    }
    tree.fire('onCheckSelectAll', this._checked, {
      toServer: true
    });
  };
  /** @internal */
  Treecol.prototype.doClick_ = function (evt, popupOnly) {
    var tree = this.getTree(),
      cm = this.$n('cm');
    if (tree && tree._checkmark) {
      var n = evt.domTarget;
      if (n == cm || n.parentNode == cm) {
        return;
      }
    }
    _super.prototype.doClick_.call(this, evt, popupOnly);
  };
  Treecol = __decorate([zk.WrapClass('zul.sel.Treecol')], Treecol);
  return Treecol;
}(zul.mesh.SortWidget);
exports.Treecol = Treecol;
if (!window.zul) window.zul = {};
if (!window.zul.sel) window.zul.sel = {};
if (!window.zul.sel.Treecol) window.zul.sel.Treecol = {};
window.zul.sel.Treecol._ = {
  _updCells: _updCells,
  _sort0: _sort0,
  Treecol: Treecol
};

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/sel/Treecols.ts":
/*!***********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/sel/Treecols.ts ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Treecols = void 0;
/* Treecols.ts

    Purpose:

    Description:

    History:
        Wed Jun 10 15:32:41     2009, Created by jumperchen

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.0 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * A treecols.
 * @defaultValue {@link getZclass}: z-treecols
 */
var Treecols = /** @class */function (_super) {
  __extends(Treecols, _super);
  function Treecols() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  /**
   * @returns the tree that it belongs to.
   */
  Treecols.prototype.getTree = function () {
    return this.parent;
  };
  Treecols.prototype.setVisible = function (visible, opts) {
    if (this._visible != visible) {
      _super.prototype.setVisible.call(this, visible, opts);
      this.getTree().rerender();
    }
    return this;
  };
  Treecols = __decorate([zk.WrapClass('zul.sel.Treecols')], Treecols);
  return Treecols;
}(zul.mesh.HeadWidget);
exports.Treecols = Treecols;
if (!window.zul) window.zul = {};
if (!window.zul.sel) window.zul.sel = {};
if (!window.zul.sel.Treecols) window.zul.sel.Treecols = {};
window.zul.sel.Treecols._ = {
  Treecols: Treecols
};

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/sel/Treefoot.ts":
/*!***********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/sel/Treefoot.ts ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Treefoot = void 0;
/* Treefoot.ts

    Purpose:

    Description:

    History:
        Wed Jun 10 15:32:41     2009, Created by jumperchen

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.0 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * A row of {@link Treefooter}.
 *
 * <p>Like {@link Treecols}, each tree has at most one {@link Treefoot}.
 * @defaultValue {@link getZclass}: z-treefoot
 */
var Treefoot = /** @class */function (_super) {
  __extends(Treefoot, _super);
  function Treefoot() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  /**
   * @returns the tree that it belongs to.
   */
  Treefoot.prototype.getTree = function () {
    return this.parent;
  };
  //bug #3014664
  Treefoot.prototype.setVflex = function (vflex) {
    var vflex0 = false;
    return _super.prototype.setVflex.call(this, vflex0);
  };
  //bug #3014664
  Treefoot.prototype.setHflex = function (hflex) {
    var hflex0 = false;
    return _super.prototype.setHflex.call(this, hflex0);
  };
  /** @internal */
  Treefoot.prototype.deferRedrawHTML_ = function (out) {
    out.push('<tr', this.domAttrs_({
      domClass: true
    }), ' class="z-renderdefer"></tr>');
  };
  Treefoot = __decorate([zk.WrapClass('zul.sel.Treefoot')], Treefoot);
  return Treefoot;
}(zul.Widget);
exports.Treefoot = Treefoot;
if (!window.zul) window.zul = {};
if (!window.zul.sel) window.zul.sel = {};
if (!window.zul.sel.Treefoot) window.zul.sel.Treefoot = {};
window.zul.sel.Treefoot._ = {
  Treefoot: Treefoot
};

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/sel/Treefooter.ts":
/*!*************************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/sel/Treefooter.ts ***!
  \*************************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Treefooter = void 0;
/* Treefooter.ts

    Purpose:

    Description:

    History:
        Wed Jun 10 15:32:42     2009, Created by jumperchen

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.0 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * A column of the footer of a tree ({@link Tree}).
 * Its parent must be {@link Treefoot}.
 *
 * <p>Unlike {@link Treecol}, you could place any child in a tree footer.
 * <p>Note: {@link Treecell} also accepts children.
 * @defaultValue {@link getZclass}: z-treefooter
 */
var Treefooter = /** @class */function (_super) {
  __extends(Treefooter, _super);
  function Treefooter() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  // NOTE: The parent of Treefooter should be Treefoot, but Treefoot is not a HeadWidget.
  // override parent!: zul.sel.Treefoot | null;
  /**
   * @returns the tree that this belongs to.
   */
  Treefooter.prototype.getTree = function () {
    return this.getMeshWidget();
  };
  /**
   * @returns the tree header that is in the same column as
   * this footer, or null if not available.
   */
  Treefooter.prototype.getTreecol = function () {
    return this.getHeaderWidget();
  };
  /**
   * @returns the maximal length for this cell.
   * It is the same as the correponding {@link getTreecol}'s
   * {@link Treecol#getMaxlength}.
   * @since 5.0.5
   */
  Treefooter.prototype.getMaxlength = function () {
    var tc = this.getTreecol();
    return tc ? tc.getMaxlength() : 0;
  };
  /** @internal */
  Treefooter.prototype.domLabel_ = function () {
    return zUtl.encodeXML(this.getLabel(), {
      maxlength: this.getMaxlength()
    });
  };
  Treefooter = __decorate([zk.WrapClass('zul.sel.Treefooter')], Treefooter);
  return Treefooter;
}(zul.mesh.FooterWidget);
exports.Treefooter = Treefooter;
if (!window.zul) window.zul = {};
if (!window.zul.sel) window.zul.sel = {};
if (!window.zul.sel.Treefooter) window.zul.sel.Treefooter = {};
window.zul.sel.Treefooter._ = {
  Treefooter: Treefooter
};

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/sel/Treeitem.ts":
/*!***********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/sel/Treeitem.ts ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Treeitem = void 0;
/* Treeitem.ts

    Purpose:

    Description:

    History:
        Wed Jun 10 15:32:43     2009, Created by jumperchen

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.0 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
//test if a treexxx is closed or any parent treeitem is closed
function _closed(treechildren) {
  for (var ti = treechildren; ti && !(ti instanceof zul.sel.Tree); ti = ti.parent) if (ti.isOpen && !ti.isOpen()) return true;
  return false;
}
function _rmSelItemsDown(items, wgt) {
  var _a;
  if (wgt.isSelected()) items.$remove(wgt);
  for (var w = (_a = wgt.treechildren) === null || _a === void 0 ? void 0 : _a.firstChild; w && items.length; w = w.nextSibling) _rmSelItemsDown(items, w);
}
function _addSelItemsDown(items, wgt) {
  var _a;
  if (wgt.isSelected()) items.push(wgt);
  for (var w = (_a = wgt.treechildren) === null || _a === void 0 ? void 0 : _a.firstChild; w; w = w.nextSibling) _addSelItemsDown(items, w);
}
function _showDOM(wgt, visible) {
  var _a;
  var n = wgt.$n();
  if (n) n.style.display = visible ? '' : 'none';
  for (var w = (_a = wgt.treechildren) === null || _a === void 0 ? void 0 : _a.firstChild; w; w = w.nextSibling) if (w._visible && w._open)
    // optimized, need to recurse only if open and visible
    _showDOM(w, visible);
}
function _getTreePath(tree, node) {
  var paths = [];
  for (var p = node; p && p instanceof zul.sel.Treeitem; p = p.parent.parent) paths.unshift(p.getChildIndex());
  return paths;
}
// return -1 if thisPath is before itemPath,
// return 1 if thisPath is after itemPath,
function _compareTreePath(thisPath, itemPath) {
  var depth = 0;
  while (true) {
    if (thisPath[depth] < itemPath[depth]) {
      return -1;
    } else if (thisPath[depth] > itemPath[depth]) {
      return 1;
    } else if (thisPath[depth] == itemPath[depth]) {
      if (thisPath[depth] == undefined)
        //just in case, it should never be run into this line.
        break;
      depth++;
      continue;
    } else {
      if (thisPath[depth] == undefined) {
        // shorter is at before
        return -1;
      } else {
        return 1;
      }
    }
  }
  return 1;
}
/**
 * A treeitem.
 *
 * <p>Event:
 * <ol>
 * <li>onOpen is sent when a tree item is opened or closed by user.</li>
 * <li>onDoubleClick is sent when user double-clicks the treeitem.</li>
 * <li>onRightClick is sent when user right-clicks the treeitem.</li>
 * </ol>
 *
 */
var Treeitem = /** @class */function (_super) {
  __extends(Treeitem, _super);
  function Treeitem() {
    var _this = _super !== null && _super.apply(this, arguments) || this;
    /** @internal */
    _this._open = true;
    /**
     * @returns the {@link Tree}.
     * @see {@link getMeshWidget}
     */
    _this.getTree = Treeitem_1.prototype.getMeshWidget;
    return _this;
  }
  Treeitem_1 = Treeitem;
  /**
   * @returns whether this container is open.
   * @defaultValue `true`.
   */
  Treeitem.prototype.isOpen = function () {
    return this._open;
  };
  /**
   * Sets whether this container is open.
   */
  Treeitem.prototype.setOpen = function (open, fromServer, opts) {
    var o = this._open;
    this._open = open;
    if (o !== open || (opts === null || opts === void 0 ? void 0 : opts.force)) {
      var img = this.$n('open'),
        icon = this.$n('icon');
      if (!img || _closed(this.parent)) {
        if (icon) {
          // B65-ZK-1609: Tree close/open icon is not correct after calling clearOpen and reopen a node
          var cn = icon.className;
          icon.className = open ? cn.replace('-right', '-down').replace('-close', '-open') : cn.replace('-down', '-right').replace('-open', '-close');
        }
        return this;
      }
      // (just in case)
      if (icon) {
        var cn = icon.className;
        icon.className = open ? cn.replace('-right', '-down').replace('-close', '-open') : cn.replace('-down', '-right').replace('-open', '-close');
      }
      var tree = this.getTree(),
        ebodytbl = tree ? tree.ebodytbl : undefined,
        oldwd = ebodytbl ? ebodytbl.clientWidth : 0; // ebodytbl shall not be null
      if (!open) zWatch.fireDown('onHide', this);
      this._showKids(open);
      if (open) {
        zUtl.fireShown(this);
        tree._updHeaderCM();
      }
      if (tree) {
        tree._sizeOnOpen();
        if (!fromServer) this.fire('onOpen', {
          open: open
        }, {
          toServer: tree.inPagingMold() || tree.isModel()
        });
        tree._syncFocus(this);
        if (ebodytbl) {
          tree._fixhdwcnt = tree._fixhdwcnt || 0;
          if (!tree._fixhdwcnt++) tree._fixhdoldwd = oldwd;
          setTimeout(function () {
            if (! --tree._fixhdwcnt && tree.$n() && tree._fixhdoldwd != ebodytbl.clientWidth) tree._calcSize();
          }, 250);
        }
      }
    }
    return this;
  };
  /** @internal */
  Treeitem.prototype._showKids = function (open) {
    var tc = this.treechildren;
    if (tc) for (var w = tc.firstChild, vi = tc._isRealVisible(); w; w = w.nextSibling) {
      var n = w.$n();
      if (n) n.style.display = vi && w.isVisible() && open ? '' : 'none';
      if (w.isOpen()) w._showKids(open);
    }
  };
  /** @internal */
  Treeitem.prototype.isStripeable_ = function () {
    return false;
  };
  /**
   * @returns the mesh widget. i.e. {@link Tree}
   */
  Treeitem.prototype.getMeshWidget = function () {
    return this.parent ? this.parent.getTree() : undefined;
  };
  Treeitem.prototype.getZclass = function () {
    // NOTE: Dead code. Treeitem is not rendered. A treerow is rendered instead,
    // so this function will not be called.
    if (this.treerow) return this.treerow.getZclass();
    return '';
  };
  Treeitem.prototype.$n = function (nm) {
    if (this.treerow) return nm ? this.treerow.$n(nm) : this.treerow.$n() || jq(this.treerow.uuid, zk)[0];
    return undefined;
  };
  /**
   * @returns whether the element is to act as a container
   * which can have child elements.
   */
  Treeitem.prototype.isContainer = function () {
    return this.treechildren != null;
  };
  /**
   * @returns whether this element contains no child elements.
   */
  Treeitem.prototype.isEmpty = function () {
    return !this.treechildren || !this.treechildren.nChildren;
  };
  /**
   * @returns the level this cell is. The root is level 0.
   */
  Treeitem.prototype.getLevel = function () {
    var level = 0;
    for (var item = this;; ++level) {
      if (!item.parent) break;
      item = item.parent.parent;
      if (!item || item instanceof zul.sel.Tree) break;
    }
    return level;
  };
  /**
   * @returns the label of the {@link Treecell} it contains, or null
   * if no such cell.
   */
  Treeitem.prototype.getLabel = function () {
    var cell = this.getFirstCell();
    return cell ? cell.getLabel() : undefined;
  };
  /**
   * Sets the label of the {@link Treecell} it contains.
   * <p>If it is not created, we automatically create it.
   */
  Treeitem.prototype.setLabel = function (label) {
    this._autoFirstCell().setLabel(label);
    return this;
  };
  /**
   * @returns the first treecell.
   */
  Treeitem.prototype.getFirstCell = function () {
    return this.treerow ? this.treerow.firstChild : undefined;
  };
  /** @internal */
  Treeitem.prototype._autoFirstCell = function () {
    if (!this.treerow) this.appendChild(new zul.sel.Treerow());
    var cell = this.treerow.firstChild;
    if (!cell) {
      cell = new zul.sel.Treecell();
      this.treerow.appendChild(cell);
    }
    return cell;
  };
  /**
   * @returns the image of the {@link Treecell} it contains.
   */
  Treeitem.prototype.getImage = function () {
    var cell = this.getFirstCell();
    return cell ? cell.getImage() : undefined;
  };
  /**
   * Sets the image of the {@link Treecell} it contains.
   * <p>If it is not created, we automatically create it.
   */
  Treeitem.prototype.setImage = function (image) {
    this._autoFirstCell().setImage(image);
    return this;
  };
  /**
   * @returns the parent tree item,
   * or null if this item is already the top level of the tree.
   * The parent tree item is actually the grandparent if any.
   */
  Treeitem.prototype.getParentItem = function () {
    var _a;
    var p = (_a = this.parent) === null || _a === void 0 ? void 0 : _a.parent; // null/undefined are not instances of any Object
    return p instanceof zul.sel.Treeitem ? p : undefined;
  };
  /** @internal */
  Treeitem.prototype._isRealVisible = function () {
    var p = this.parent;
    return this.isVisible() && !!p && p._isRealVisible();
  };
  /** @internal */
  Treeitem.prototype._isVisibleInTree = function () {
    // used by Treecell#_isLastVisibleChild
    if (!this.isVisible()) return false;
    var c = this.parent,
      p;
    if (!c || !c.isVisible() || !(p = c.parent)) return false;
    if (p instanceof zul.sel.Tree) return true;
    // Treeitem
    return p._isVisibleInTree(); // timing issue, does not concern open state
  };
  Treeitem.prototype.setVisible = function (visible) {
    if (this.isVisible() != visible) {
      _super.prototype.setVisible.call(this, visible);
      if (this.treerow) this.treerow.setVisible(visible);
      // Bug: B50-3293724
      _showDOM(this, this._isRealVisible());
    }
    return this;
  };
  /** @internal */
  Treeitem.prototype.beforeParentChanged_ = function (newParent) {
    var oldtree = this.getTree();
    if (oldtree) oldtree._onTreeitemRemoved(this);
    if (newParent) {
      var tree = newParent.getTree();
      if (tree) tree._onTreeitemAdded(this);
    }
    _super.prototype.beforeParentChanged_.call(this, newParent);
  };
  Treeitem.prototype.isRealElement = function () {
    return false; // fixed for ZK Client selector issue
  };
  Treeitem.prototype.insertBefore = function (child, sibling, ignoreDom) {
    if (_super.prototype.insertBefore.call(this, child, sibling, ignoreDom || !this.z_rod && child instanceof zul.sel.Treechildren)) {
      this._fixOnAdd(child, ignoreDom);
      return true;
    }
    return false;
  };
  Treeitem.prototype.appendChild = function (child, ignoreDom) {
    if (_super.prototype.appendChild.call(this, child, ignoreDom || !this.z_rod && child instanceof zul.sel.Treechildren)) {
      if (!this.insertingBefore_) this._fixOnAdd(child, ignoreDom);
      return true;
    }
    return false;
  };
  /** @internal */
  Treeitem.prototype._fixOnAdd = function (child, ignoreDom) {
    if (child instanceof zul.sel.Treerow) this.treerow = child;else if (child instanceof zul.sel.Treechildren) {
      this.treechildren = child;
      if (!ignoreDom && this.treerow) this.rerender();
    }
  };
  /** @internal */
  Treeitem.prototype.onChildRemoved_ = function (child) {
    _super.prototype.onChildRemoved_.call(this, child);
    if (child == this.treerow) {
      this.treerow = undefined;
    } else if (child == this.treechildren) {
      this.treechildren = undefined;
      if (!this.childReplacing_)
        //NOT called by onChildReplaced_
        this._syncIcon(true); // remove the icon
    }
  };
  /** @internal */
  Treeitem.prototype.onChildAdded_ = function (child) {
    _super.prototype.onChildAdded_.call(this, child);
    if (this.childReplacing_)
      //called by onChildReplaced_
      this._fixOnAdd(child, true);else if (this.desktop) this._fixOnAdd(child, true); // fixed dynamically change treerow. B65-ZK-1608
  };
  /** @internal */
  Treeitem.prototype.removeHTML_ = function (n) {
    for (var w = this.firstChild; w; w = w.nextSibling) {
      var cn = w.$n();
      if (cn) w.removeHTML_(cn);
    }
    _super.prototype.removeHTML_.call(this, n);
  };
  Treeitem.prototype.replaceWidget = function (newwgt, skipper) {
    zul.sel.Treeitem._syncSelItems(this, newwgt);
    if (this.treechildren) this.treechildren.detach();
    _super.prototype.replaceWidget.call(this, newwgt, skipper);
  };
  /** @internal */
  Treeitem.prototype._removeChildHTML = function (n) {
    for (var cn, w = this.firstChild; w; w = w.nextSibling) {
      if (w != this.treerow && (cn = w.$n())) w.removeHTML_(cn);
    }
  };
  /** @internal */
  Treeitem.prototype._renderChildHTML = function (childHTML) {
    var tree = this.getTree(),
      erows = tree.ebodyrows;
    // has children
    if (erows && erows.childNodes.length) {
      // do binary search for the insertion point
      var low = 0,
        children = erows.childNodes,
        high = children.length - 1,
        mid = 0,
        thisPath = _getTreePath(tree, this);
      while (low <= high) {
        mid = low + high >>> 1;
        var item = zk.Widget.$(children[mid].id).parent,
          itemPath = _getTreePath(tree, item);
        if (_compareTreePath(thisPath, itemPath) == 1) {
          low = mid + 1;
        } else {
          high = mid - 1;
          if (low >= high) mid -= 1;
        }
      }
      if (mid >= 0) jq(children[mid]).after( /*safe*/childHTML);else if (erows.firstChild)
        // the first one
        jq(erows.firstChild).before( /*safe*/childHTML);else jq(erows).append( /*safe*/childHTML);
    } else {
      jq(erows).append( /*safe*/childHTML);
    }
  };
  /** @internal */
  Treeitem.prototype.insertChildHTML_ = function (child, before, desktop) {
    var nodeOfBefore = before ? before.getFirstNode_() : undefined;
    if (nodeOfBefore) jq(nodeOfBefore).before( /*safe*/child.redrawHTML_());else this._renderChildHTML( /*safe*/child.redrawHTML_());
    child.bind(desktop);
  };
  /** @internal */
  Treeitem.prototype.getOldWidget_ = function (n) {
    var old = _super.prototype.getOldWidget_.call(this, n);
    if (old && old instanceof zul.sel.Treerow) return old.parent;
    return old;
  };
  Treeitem.prototype.replaceHTML = function (n, desktop, skipper, _trim_, _callback_) {
    this._removeChildHTML(n);
    _super.prototype.replaceHTML.call(this, n, desktop, skipper, _trim_, _callback_);
  };
  /** @internal */
  Treeitem.prototype._syncIcon = function (isRemoved) {
    var _a;
    if (this.desktop && this.treerow) {
      var treecell = this.treerow.firstChild;
      if (treecell) treecell._syncIcon(isRemoved);
      for (var i = (_a = this.treechildren) === null || _a === void 0 ? void 0 : _a.firstChild; i; i = i.nextSibling) i._syncIcon(isRemoved);
    }
  };
  /** @internal */
  Treeitem.prototype.compareItemPos_ = function (item) {
    if (this == item) return 0;
    var tree = this.getTree();
    return _compareTreePath(_getTreePath(tree, item), _getTreePath(tree, this));
  };
  //package utiltiy: sync selected items for replaceWidget
  /** @internal */
  Treeitem._syncSelItems = function (oldwgt, newwgt) {
    var _a;
    var items = (_a = oldwgt.getTree()) === null || _a === void 0 ? void 0 : _a._selItems;
    if (items) if (oldwgt instanceof zul.sel.Treechildren) {
      // If true, newwgt would also be Treechildren.
      for (var item = oldwgt.firstChild; item; item = item.nextSibling) _rmSelItemsDown(items, item);
      for (var item = newwgt.firstChild; item; item = item.nextSibling) _addSelItemsDown(items, item);
    } else {
      // Both oldwgt and newwgt would be Treeitem.
      _rmSelItemsDown(items, oldwgt);
      _addSelItemsDown(items, newwgt);
    }
  };
  var Treeitem_1;
  Treeitem = Treeitem_1 = __decorate([zk.WrapClass('zul.sel.Treeitem')], Treeitem);
  return Treeitem;
}(zul.sel.ItemWidget);
exports.Treeitem = Treeitem;
if (!window.zul) window.zul = {};
if (!window.zul.sel) window.zul.sel = {};
if (!window.zul.sel.Treeitem) window.zul.sel.Treeitem = {};
window.zul.sel.Treeitem._ = {
  _closed: _closed,
  _rmSelItemsDown: _rmSelItemsDown,
  _addSelItemsDown: _addSelItemsDown,
  _showDOM: _showDOM,
  _getTreePath: _getTreePath,
  _compareTreePath: _compareTreePath,
  Treeitem: Treeitem
};

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/sel/Treerow.ts":
/*!**********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/sel/Treerow.ts ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __extends = __webpack_require__(/*! ./extends.js */ "./extends.js")["default"];
/* provided dependency */ var __decorate = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__decorate"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports.Treerow = void 0;
/* Treerow.ts

    Purpose:

    Description:

    History:
        Wed Jun 10 15:32:43     2009, Created by jumperchen

Copyright (C) 2009 Potix Corporation. All Rights Reserved.

This program is distributed under LGPL Version 2.0 in the hope that
it will be useful, but WITHOUT ANY WARRANTY.
*/
/**
 * A treerow.
 * @defaultValue {@link getZclass}: z-treerow
 */
var Treerow = /** @class */function (_super) {
  __extends(Treerow, _super);
  function Treerow() {
    return _super !== null && _super.apply(this, arguments) || this;
  }
  /**
   * @returns the {@link Tree} instance containing this element.
   */
  Treerow.prototype.getTree = function () {
    return this.parent ? this.parent.getTree() : undefined;
  };
  /**
   * @returns the level this cell is. The root is level 0.
   */
  Treerow.prototype.getLevel = function () {
    return this.parent ? this.parent.getLevel() : 0;
  };
  /**
   * @returns the {@link Treechildren} associated with this {@link Treerow}.
   */
  Treerow.prototype.getLinkedTreechildren = function () {
    return this.parent ? this.parent.treechildren : undefined;
  };
  /** @internal */
  Treerow.prototype.domClass_ = function (no) {
    var /*safe*/scls = _super.prototype.domClass_.call(this, no),
      p = this.parent;
    if (p && (!no || !no.zclass)) {
      if (p.isDisabled()) scls += (scls ? ' ' : '') + this.$s('disabled');
      if (p.isSelected()) scls += (scls ? ' ' : '') + this.$s('selected');
    }
    return scls;
  };
  /** @internal */
  Treerow.prototype.domTooltiptext_ = function () {
    return this._tooltiptext || this.parent._tooltiptext || this.parent.parent._tooltiptext;
  };
  /** @internal */
  Treerow.prototype.domStyle_ = function (no) {
    // patch the case that treerow is hidden by treeitem visibility
    return (this.parent && !this.parent._isRealVisible() && this.isVisible() ? 'display:none;' : '') + _super.prototype.domStyle_.call(this, no);
  };
  Treerow.prototype.removeChild = function (child, ignoreDom) {
    for (var w = child.firstChild; w;) {
      var n = w.nextSibling; //remember, since remove will null the link
      child.removeChild(w); //deep first
      w = n;
    }
    _super.prototype.removeChild.call(this, child, ignoreDom);
    // FIXME: Prior to TS migration, this function returns nothing ,which will
    // evaluate to undefined, which is falsey. But, doesn't it make more sense
    // to return `super.removeChild(child, ignoreDom)`?
    return false;
  };
  /** @internal */
  Treerow.prototype.doClick_ = function (evt, popupOnly) {
    var ti = this.parent,
      tg = evt.domTarget;
    if (tg == this.$n('open') || tg == this.$n('icon')) {
      ti.setOpen(!ti._open);
      evt.stop();
      this.getTree().focus();
    } else if (!ti.isDisabled()) _super.prototype.doClick_.call(this, evt, popupOnly);
  };
  Treerow.prototype.scrollIntoView = function () {
    var bar = this.getTree()._scrollbar;
    if (bar) {
      bar.syncSize();
      bar.scrollToElement(this.$n_());
    } else {
      _super.prototype.scrollIntoView.call(this);
    }
    return this;
  };
  /** @internal */
  Treerow.prototype.deferRedrawHTML_ = function (out) {
    out.push('<tr', this.domAttrs_({
      domClass: true
    }), ' class="z-renderdefer"></tr>');
  };
  /** @internal */
  Treerow.prototype.bind_ = function (desktop, skipper, after) {
    _super.prototype.bind_.call(this, desktop, skipper, after);
    zWatch.listen({
      onResponse: this
    });
  };
  /** @internal */
  Treerow.prototype.unbind_ = function (skipper, after, keepRod) {
    zWatch.unlisten({
      onResponse: this
    });
    _super.prototype.unbind_.call(this, skipper, after, keepRod);
  };
  /** @internal */
  Treerow.prototype.onChildAdded_ = function (child) {
    _super.prototype.onChildAdded_.call(this, child);
    // ZK-5107
    this._shallCheckClearCache = true;
  };
  /** @internal */
  Treerow.prototype.onChildRemoved_ = function (child) {
    _super.prototype.onChildRemoved_.call(this, child);
    // ZK-5107
    this._shallCheckClearCache = true;
  };
  Treerow.prototype.onResponse = function () {
    var _a;
    if (this._shallCheckClearCache) {
      this._shallCheckClearCache = false;
      if ((_a = this.getTree()) === null || _a === void 0 ? void 0 : _a.isCheckmark()) {
        this.clearCache();
      }
    }
  };
  /** @internal */
  Treerow.prototype.isLastVisibleChild_ = function () {
    var _a;
    var treeitem = this.parent;
    return !!treeitem && treeitem == ((_a = treeitem.parent) === null || _a === void 0 ? void 0 : _a.getLastVisibleItem_());
  };
  Treerow = __decorate([zk.WrapClass('zul.sel.Treerow')], Treerow);
  return Treerow;
}(zul.Widget);
exports.Treerow = Treerow;
if (!window.zul) window.zul = {};
if (!window.zul.sel) window.zul.sel = {};
if (!window.zul.sel.Treerow) window.zul.sel.Treerow = {};
window.zul.sel.Treerow._ = {
  Treerow: Treerow
};

/***/ }),

/***/ "./zul/src/main/resources/web/js/zul/sel/index.ts":
/*!********************************************************!*\
  !*** ./zul/src/main/resources/web/js/zul/sel/index.ts ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {

/* provided dependency */ var __exportStar = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js")["__exportStar"];


Object.defineProperty(exports, "__esModule", ({
  value: true
}));
exports["default"] = {};
__exportStar(__webpack_require__(/*! ./SelectWidget */ "./zul/src/main/resources/web/js/zul/sel/SelectWidget.ts"), exports); // jsdoc="true"
__exportStar(__webpack_require__(/*! ./ItemWidget */ "./zul/src/main/resources/web/js/zul/sel/ItemWidget.ts"), exports); // jsdoc="true"
__exportStar(__webpack_require__(/*! ./Listbox */ "./zul/src/main/resources/web/js/zul/sel/Listbox.ts"), exports);
__exportStar(__webpack_require__(/*! ./Listitem */ "./zul/src/main/resources/web/js/zul/sel/Listitem.ts"), exports);
__exportStar(__webpack_require__(/*! ./Listcell */ "./zul/src/main/resources/web/js/zul/sel/Listcell.ts"), exports);
__exportStar(__webpack_require__(/*! ./Listhead */ "./zul/src/main/resources/web/js/zul/sel/Listhead.ts"), exports);
__exportStar(__webpack_require__(/*! ./Listheader */ "./zul/src/main/resources/web/js/zul/sel/Listheader.ts"), exports);
__exportStar(__webpack_require__(/*! ./Listfoot */ "./zul/src/main/resources/web/js/zul/sel/Listfoot.ts"), exports);
__exportStar(__webpack_require__(/*! ./Listfooter */ "./zul/src/main/resources/web/js/zul/sel/Listfooter.ts"), exports);
__exportStar(__webpack_require__(/*! ./Option */ "./zul/src/main/resources/web/js/zul/sel/Option.ts"), exports);
__exportStar(__webpack_require__(/*! ./Optgroup */ "./zul/src/main/resources/web/js/zul/sel/Optgroup.ts"), exports);
__exportStar(__webpack_require__(/*! ./Select */ "./zul/src/main/resources/web/js/zul/sel/Select.ts"), exports);
__exportStar(__webpack_require__(/*! ./Tree */ "./zul/src/main/resources/web/js/zul/sel/Tree.ts"), exports);
__exportStar(__webpack_require__(/*! ./Treecol */ "./zul/src/main/resources/web/js/zul/sel/Treecol.ts"), exports);
__exportStar(__webpack_require__(/*! ./Treecols */ "./zul/src/main/resources/web/js/zul/sel/Treecols.ts"), exports);
__exportStar(__webpack_require__(/*! ./Treechildren */ "./zul/src/main/resources/web/js/zul/sel/Treechildren.ts"), exports);
__exportStar(__webpack_require__(/*! ./Treeitem */ "./zul/src/main/resources/web/js/zul/sel/Treeitem.ts"), exports);
__exportStar(__webpack_require__(/*! ./Treerow */ "./zul/src/main/resources/web/js/zul/sel/Treerow.ts"), exports);
__exportStar(__webpack_require__(/*! ./Treecell */ "./zul/src/main/resources/web/js/zul/sel/Treecell.ts"), exports);
__exportStar(__webpack_require__(/*! ./Treefoot */ "./zul/src/main/resources/web/js/zul/sel/Treefoot.ts"), exports);
__exportStar(__webpack_require__(/*! ./Treefooter */ "./zul/src/main/resources/web/js/zul/sel/Treefooter.ts"), exports);

/***/ }),

/***/ "./node_modules/tslib/tslib.es6.js":
/*!*****************************************!*\
  !*** ./node_modules/tslib/tslib.es6.js ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   __addDisposableResource: function() { return /* binding */ __addDisposableResource; },
/* harmony export */   __assign: function() { return /* binding */ __assign; },
/* harmony export */   __asyncDelegator: function() { return /* binding */ __asyncDelegator; },
/* harmony export */   __asyncGenerator: function() { return /* binding */ __asyncGenerator; },
/* harmony export */   __asyncValues: function() { return /* binding */ __asyncValues; },
/* harmony export */   __await: function() { return /* binding */ __await; },
/* harmony export */   __awaiter: function() { return /* binding */ __awaiter; },
/* harmony export */   __classPrivateFieldGet: function() { return /* binding */ __classPrivateFieldGet; },
/* harmony export */   __classPrivateFieldIn: function() { return /* binding */ __classPrivateFieldIn; },
/* harmony export */   __classPrivateFieldSet: function() { return /* binding */ __classPrivateFieldSet; },
/* harmony export */   __createBinding: function() { return /* binding */ __createBinding; },
/* harmony export */   __decorate: function() { return /* binding */ __decorate; },
/* harmony export */   __disposeResources: function() { return /* binding */ __disposeResources; },
/* harmony export */   __esDecorate: function() { return /* binding */ __esDecorate; },
/* harmony export */   __exportStar: function() { return /* binding */ __exportStar; },
/* harmony export */   __extends: function() { return /* binding */ __extends; },
/* harmony export */   __generator: function() { return /* binding */ __generator; },
/* harmony export */   __importDefault: function() { return /* binding */ __importDefault; },
/* harmony export */   __importStar: function() { return /* binding */ __importStar; },
/* harmony export */   __makeTemplateObject: function() { return /* binding */ __makeTemplateObject; },
/* harmony export */   __metadata: function() { return /* binding */ __metadata; },
/* harmony export */   __param: function() { return /* binding */ __param; },
/* harmony export */   __propKey: function() { return /* binding */ __propKey; },
/* harmony export */   __read: function() { return /* binding */ __read; },
/* harmony export */   __rest: function() { return /* binding */ __rest; },
/* harmony export */   __runInitializers: function() { return /* binding */ __runInitializers; },
/* harmony export */   __setFunctionName: function() { return /* binding */ __setFunctionName; },
/* harmony export */   __spread: function() { return /* binding */ __spread; },
/* harmony export */   __spreadArray: function() { return /* binding */ __spreadArray; },
/* harmony export */   __spreadArrays: function() { return /* binding */ __spreadArrays; },
/* harmony export */   __values: function() { return /* binding */ __values; }
/* harmony export */ });
/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise, SuppressedError, Symbol */

var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
    return extendStatics(d, b);
};

function __extends(d, b) {
    if (typeof b !== "function" && b !== null)
        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    }
    return __assign.apply(this, arguments);
}

function __rest(s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
}

function __decorate(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
}

function __param(paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
}

function __esDecorate(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};

function __runInitializers(thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};

function __propKey(x) {
    return typeof x === "symbol" ? x : "".concat(x);
};

function __setFunctionName(f, name, prefix) {
    if (typeof name === "symbol") name = name.description ? "[".concat(name.description, "]") : "";
    return Object.defineProperty(f, "name", { configurable: true, value: prefix ? "".concat(prefix, " ", name) : name });
};

function __metadata(metadataKey, metadataValue) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
}

function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

function __generator(thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
}

var __createBinding = Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
});

function __exportStar(m, o) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p)) __createBinding(o, m, p);
}

function __values(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}

function __read(o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
}

/** @deprecated */
function __spread() {
    for (var ar = [], i = 0; i < arguments.length; i++)
        ar = ar.concat(__read(arguments[i]));
    return ar;
}

/** @deprecated */
function __spreadArrays() {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
}

function __spreadArray(to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
}

function __await(v) {
    return this instanceof __await ? (this.v = v, this) : new __await(v);
}

function __asyncGenerator(thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i;
    function verb(n) { if (g[n]) i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
}

function __asyncDelegator(o) {
    var i, p;
    return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
    function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v; } : f; }
}

function __asyncValues(o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
}

function __makeTemplateObject(cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};

var __setModuleDefault = Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
};

function __importStar(mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
}

function __importDefault(mod) {
    return (mod && mod.__esModule) ? mod : { default: mod };
}

function __classPrivateFieldGet(receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
}

function __classPrivateFieldSet(receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
}

function __classPrivateFieldIn(state, receiver) {
    if (receiver === null || (typeof receiver !== "object" && typeof receiver !== "function")) throw new TypeError("Cannot use 'in' operator on non-object");
    return typeof state === "function" ? receiver === state : state.has(receiver);
}

function __addDisposableResource(env, value, async) {
    if (value !== null && value !== void 0) {
        if (typeof value !== "object" && typeof value !== "function") throw new TypeError("Object expected.");
        var dispose;
        if (async) {
            if (!Symbol.asyncDispose) throw new TypeError("Symbol.asyncDispose is not defined.");
            dispose = value[Symbol.asyncDispose];
        }
        if (dispose === void 0) {
            if (!Symbol.dispose) throw new TypeError("Symbol.dispose is not defined.");
            dispose = value[Symbol.dispose];
        }
        if (typeof dispose !== "function") throw new TypeError("Object not disposable.");
        env.stack.push({ value: value, dispose: dispose, async: async });
    }
    else if (async) {
        env.stack.push({ async: true });
    }
    return value;
}

var _SuppressedError = typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
    var e = new Error(message);
    return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};

function __disposeResources(env) {
    function fail(e) {
        env.error = env.hasError ? new _SuppressedError(e, env.error, "An error was suppressed during disposal.") : e;
        env.hasError = true;
    }
    function next() {
        while (env.stack.length) {
            var rec = env.stack.pop();
            try {
                var result = rec.dispose && rec.dispose.call(rec.value);
                if (rec.async) return Promise.resolve(result).then(next, function(e) { fail(e); return next(); });
            }
            catch (e) {
                fail(e);
            }
        }
        if (env.hasError) throw env.error;
    }
    return next();
}

/* harmony default export */ __webpack_exports__["default"] = ({
    __extends: __extends,
    __assign: __assign,
    __rest: __rest,
    __decorate: __decorate,
    __param: __param,
    __metadata: __metadata,
    __awaiter: __awaiter,
    __generator: __generator,
    __createBinding: __createBinding,
    __exportStar: __exportStar,
    __values: __values,
    __read: __read,
    __spread: __spread,
    __spreadArrays: __spreadArrays,
    __spreadArray: __spreadArray,
    __await: __await,
    __asyncGenerator: __asyncGenerator,
    __asyncDelegator: __asyncDelegator,
    __asyncValues: __asyncValues,
    __makeTemplateObject: __makeTemplateObject,
    __importStar: __importStar,
    __importDefault: __importDefault,
    __classPrivateFieldGet: __classPrivateFieldGet,
    __classPrivateFieldSet: __classPrivateFieldSet,
    __classPrivateFieldIn: __classPrivateFieldIn,
    __addDisposableResource: __addDisposableResource,
    __disposeResources: __disposeResources,
});


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	!function() {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = function(exports, definition) {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	!function() {
/******/ 		__webpack_require__.o = function(obj, prop) { return Object.prototype.hasOwnProperty.call(obj, prop); }
/******/ 	}();
/******/ 	
/******/ 	/* webpack/runtime/make namespace object */
/******/ 	!function() {
/******/ 		// define __esModule on exports
/******/ 		__webpack_require__.r = function(exports) {
/******/ 			if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 				Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 			}
/******/ 			Object.defineProperty(exports, '__esModule', { value: true });
/******/ 		};
/******/ 	}();
/******/ 	
/************************************************************************/
/******/ 	
/******/ 	// startup
/******/ 	// Load entry module and return exports
/******/ 	// This entry module is referenced by other modules so it can't be inlined
/******/ 	var __webpack_exports__ = __webpack_require__("./zul/src/main/resources/web/js/zul/sel/index.ts");
/******/ 	var __webpack_export_target__ = window;
/******/ 	var __webpack_exports_export__ = __webpack_exports__["default"];
/******/ 	for(var i in __webpack_exports_export__) __webpack_export_target__[i] = __webpack_exports_export__[i];
/******/ 	if(__webpack_exports_export__.__esModule) Object.defineProperty(__webpack_export_target__, "__esModule", { value: true });
/******/ 	
/******/ })()
;