/*
 * Decompiled with CFR 0.152.
 */
package de.rototor.pdfbox.graphics2d;

import de.rototor.pdfbox.graphics2d.IPdfBoxGraphics2DColorMapper;
import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2DCMYKColor;
import de.rototor.pdfbox.graphics2d.PdfBoxGraphics2DPaintApplier;
import java.awt.Color;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceCMYK;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;

public class PdfBoxGraphics2DColorMapper
implements IPdfBoxGraphics2DColorMapper {
    @Override
    public PDColor mapColor(PDPageContentStream contentStream, Color color) {
        if (color == null) {
            return new PDColor(new float[]{1.0f, 1.0f, 1.0f}, (PDColorSpace)PDDeviceRGB.INSTANCE);
        }
        if (color.getClass().getSimpleName().equals("CMYKColor")) {
            float c = ((Float)PdfBoxGraphics2DPaintApplier.getPropertyValue(color, "getCyan")).floatValue();
            float m = ((Float)PdfBoxGraphics2DPaintApplier.getPropertyValue(color, "getMagenta")).floatValue();
            float y = ((Float)PdfBoxGraphics2DPaintApplier.getPropertyValue(color, "getYellow")).floatValue();
            float k = ((Float)PdfBoxGraphics2DPaintApplier.getPropertyValue(color, "getBlack")).floatValue();
            return new PDColor(new float[]{c, m, y, k}, (PDColorSpace)PDDeviceCMYK.INSTANCE);
        }
        if (color instanceof PdfBoxGraphics2DCMYKColor) {
            return ((PdfBoxGraphics2DCMYKColor)color).toPDColor();
        }
        float[] components = new float[]{(float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f};
        return new PDColor(components, (PDColorSpace)PDDeviceRGB.INSTANCE);
    }
}

