/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zul;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zkoss.zul.AbstractChartModel;
import org.zkoss.zul.XYModel;

public class SimpleXYModel
extends AbstractChartModel
implements XYModel {
    private static final long serialVersionUID = 20091008182904L;
    protected Map<Comparable<?>, List<XYPair>> _seriesMap = new HashMap(8);
    protected List<Comparable<?>> _seriesList = new ArrayList();
    private boolean _autoSort = true;

    @Override
    public Comparable<?> getSeries(int index) {
        return this._seriesList.get(index);
    }

    @Override
    public Collection<Comparable<?>> getSeries() {
        return this._seriesList;
    }

    @Override
    public int getDataCount(Comparable<?> series) {
        List<XYPair> xyPairs = this._seriesMap.get(series);
        return xyPairs != null ? xyPairs.size() : 0;
    }

    @Override
    public Number getX(Comparable<?> series, int index) {
        List<XYPair> xyPairs = this._seriesMap.get(series);
        if (xyPairs != null) {
            return xyPairs.get(index).getX();
        }
        return null;
    }

    @Override
    public Number getY(Comparable<?> series, int index) {
        List<XYPair> xyPairs = this._seriesMap.get(series);
        if (xyPairs != null) {
            return xyPairs.get(index).getY();
        }
        return null;
    }

    @Override
    public void setValue(Comparable<?> series, Number x, Number y, int index) {
        this.removeValue0(series, index);
        int cIndex = this.addValue0(series, x, y, index);
        this.fireEvent(0, series, (Comparable)((Object)x), this._seriesList.indexOf(series), cIndex, y);
    }

    @Override
    public void addValue(Comparable<?> series, Number x, Number y) {
        this.addValue(series, x, y, -1);
    }

    @Override
    public void addValue(Comparable<?> series, Number x, Number y, int index) {
        int cIndex = this.addValue0(series, x, y, index);
        this.fireEvent(1, series, (Comparable)((Object)x), this._seriesList.indexOf(series), cIndex, y);
    }

    private int addValue0(Comparable<?> series, Number x, Number y, int index) {
        List<XYPair> xyPairs = this._seriesMap.get(series);
        if (xyPairs == null) {
            xyPairs = new ArrayList<XYPair>(15);
            this._seriesMap.put(series, xyPairs);
            this._seriesList.add(series);
        }
        int i = index;
        if (index >= 0) {
            xyPairs.add(index, new XYPair(x, y));
        } else {
            i = xyPairs.size();
            xyPairs.add(new XYPair(x, y));
        }
        return i;
    }

    @Override
    public void setAutoSort(boolean auto) {
        this._autoSort = auto;
    }

    @Override
    public boolean isAutoSort() {
        return this._autoSort;
    }

    @Override
    public void removeSeries(Comparable<?> series) {
        this._seriesMap.remove(series);
        int sIndex = this._seriesList.indexOf(series);
        this._seriesList.remove(series);
        this.fireEvent(2, series, null, sIndex, -1, null);
    }

    @Override
    public void removeValue(Comparable<?> series, int index) {
        XYPair pair = this.removeValue0(series, index);
        this.fireEvent(2, series, (Comparable)((Object)(pair != null ? (Number)pair.getX() : (Number)null)), this._seriesList.indexOf(series), index, pair != null ? (Number)pair.getY() : (Number)null);
    }

    private XYPair removeValue0(Comparable<?> series, int index) {
        List<XYPair> xyPairs = this._seriesMap.get(series);
        if (xyPairs == null) {
            return null;
        }
        return xyPairs.remove(index);
    }

    @Override
    public void clear() {
        this._seriesMap.clear();
        this._seriesList.clear();
        this.fireEvent(2, null, null, -1, -1, null);
    }

    @Override
    public Object clone() {
        SimpleXYModel clone = (SimpleXYModel)super.clone();
        if (this._seriesMap != null) {
            clone._seriesMap = new HashMap(this._seriesMap);
        }
        if (this._seriesList != null) {
            clone._seriesList = new ArrayList(this._seriesList);
        }
        return clone;
    }

    protected static class XYPair
    implements Serializable {
        private static final long serialVersionUID = 20091008182941L;
        private Number _x;
        private Number _y;

        protected XYPair(Number x, Number y) {
            this._x = x;
            this._y = y;
        }

        public Number getX() {
            return this._x;
        }

        public Number getY() {
            return this._y;
        }

        public Number[] toNumbers() {
            return new Number[]{this._x, this._y};
        }
    }
}

