/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.SBook;
import io.keikai.model.STableStyle;
import io.keikai.model.impl.AbstractTableStyleAdv;
import io.keikai.model.impl.AbstractTableStyleInfoAdv;
import io.keikai.model.sys.EngineFactory;
import org.zkoss.lang.Objects;

public class TableStyleInfoImpl
extends AbstractTableStyleInfoAdv {
    private static final long serialVersionUID = 7484917725933371393L;
    private String name;
    private boolean showColumnStripes;
    private boolean showRowStripes;
    private boolean showFirstColumn;
    private boolean showLastColumn;
    private STableStyle tableStyle;

    public TableStyleInfoImpl(String name, boolean showColumnStripes, boolean showRowStrips, boolean showFirstColumn, boolean showLastColumn) {
        this.name = name;
        this.showColumnStripes = showColumnStripes;
        this.showRowStripes = showRowStrips;
        this.showFirstColumn = showFirstColumn;
        this.showLastColumn = showLastColumn;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (!Objects.equals((Object)name, (Object)this.name)) {
            this.tableStyle = null;
        }
        this.name = name;
    }

    @Override
    public boolean isShowColumnStripes() {
        return this.showColumnStripes;
    }

    @Override
    public void setShowColumnStripes(boolean b) {
        this.showColumnStripes = b;
    }

    @Override
    public boolean isShowRowStripes() {
        return this.showRowStripes;
    }

    @Override
    public void setShowRowStripes(boolean b) {
        this.showRowStripes = b;
    }

    @Override
    public boolean isShowLastColumn() {
        return this.showLastColumn;
    }

    @Override
    public void setShowLastColumn(boolean b) {
        this.showLastColumn = b;
    }

    @Override
    public boolean isShowFirstColumn() {
        return this.showFirstColumn;
    }

    @Override
    public void setShowFirstColumn(boolean b) {
        this.showFirstColumn = b;
    }

    @Override
    @Deprecated
    public STableStyle getTableStyle() {
        return this.getTableStyle(null);
    }

    @Override
    public STableStyle getTableStyle(SBook book) {
        if (this.tableStyle == null) {
            this.tableStyle = EngineFactory.getInstance().createFormatEngine().getTableStyle(book, this.name);
        }
        return this.tableStyle;
    }

    @Override
    AbstractTableStyleInfoAdv cloneTableStyleInfo(SBook book) {
        TableStyleInfoImpl dest = new TableStyleInfoImpl(this.name, this.showColumnStripes, this.showRowStripes, this.showFirstColumn, this.showLastColumn);
        dest.tableStyle = this.tableStyle == null ? null : ((AbstractTableStyleAdv)this.tableStyle).cloneTableStyle(book);
        return dest;
    }
}

