/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.SBook;
import io.keikai.model.SColor;
import io.keikai.model.SFont;
import io.keikai.model.impl.AbstractBookAdv;
import io.keikai.model.impl.AbstractFontAdv;
import io.keikai.model.impl.ColorImpl;
import io.keikai.model.util.Validations;

public class FontImpl
extends AbstractFontAdv {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT_GENERAL = "General";
    private String _fontName = "Calibri";
    private int _fontHeightPoint = 11;
    private SColor _fontColor = ColorImpl.BLACK;
    private SFont.Boldweight _fontBoldweight = SFont.Boldweight.NORMAL;
    private boolean _fontItalic = false;
    private boolean _fontStrikeout = false;
    private SFont.TypeOffset _fontTypeOffset = SFont.TypeOffset.NONE;
    private SFont.Underline _fontUnderline = SFont.Underline.NONE;
    private boolean overrideName;
    private boolean overrideColor;
    private boolean overrideBold;
    private boolean overrideItalic;
    private boolean overrideStrikeout;
    private boolean overrideUnderline;
    private boolean overrideHeightPoints;
    private boolean overrideTypeOffset;
    public static final SFont BLANK_FONT = new FontImpl(null, false, false, false, SFont.Underline.NONE);

    public FontImpl() {
    }

    public FontImpl(String fontColor, boolean bold, boolean fontItalic, boolean fontStrikeout, SFont.Underline fontUnderline) {
        this._fontColor = fontColor != null ? new ColorImpl(fontColor) : ColorImpl.BLACK;
        this._fontBoldweight = bold ? SFont.Boldweight.BOLD : SFont.Boldweight.NORMAL;
        this._fontItalic = fontItalic;
        this._fontStrikeout = fontStrikeout;
        this._fontUnderline = fontUnderline;
    }

    @Override
    public String getName() {
        return this._fontName;
    }

    @Override
    public void setName(String fontName) {
        this._fontName = fontName;
    }

    @Override
    public SColor getColor() {
        return this._fontColor;
    }

    @Override
    public void setColor(SColor fontColor) {
        Validations.argNotNull(fontColor);
        this._fontColor = fontColor;
    }

    @Override
    public SFont.Boldweight getBoldweight() {
        return this._fontBoldweight;
    }

    @Override
    public void setBoldweight(SFont.Boldweight fontBoldweight) {
        Validations.argNotNull(new Object[]{fontBoldweight});
        this._fontBoldweight = fontBoldweight;
    }

    @Override
    public int getHeightPoints() {
        return this._fontHeightPoint < 0 ? 11 : this._fontHeightPoint;
    }

    @Override
    public void setHeightPoints(int fontHeightPoint) {
        this._fontHeightPoint = fontHeightPoint;
    }

    @Override
    public boolean isItalic() {
        return this._fontItalic;
    }

    @Override
    public void setItalic(boolean fontItalic) {
        this._fontItalic = fontItalic;
    }

    @Override
    public boolean isStrikeout() {
        return this._fontStrikeout;
    }

    @Override
    public void setStrikeout(boolean fontStrikeout) {
        this._fontStrikeout = fontStrikeout;
    }

    @Override
    public SFont.TypeOffset getTypeOffset() {
        return this._fontTypeOffset;
    }

    @Override
    public void setTypeOffset(SFont.TypeOffset fontTypeOffset) {
        Validations.argNotNull(new Object[]{fontTypeOffset});
        this._fontTypeOffset = fontTypeOffset;
    }

    @Override
    public SFont.Underline getUnderline() {
        return this._fontUnderline;
    }

    @Override
    public void setUnderline(SFont.Underline fontUnderline) {
        Validations.argNotNull(new Object[]{fontUnderline});
        this._fontUnderline = fontUnderline;
    }

    @Override
    public void copyFrom(SFont src) {
        if (src == this) {
            return;
        }
        Validations.argInstance(src, FontImpl.class);
        this.setName(src.getName());
        this.setColor(src.getColor());
        this.setBoldweight(src.getBoldweight());
        this.setHeightPoints(src.getHeightPoints());
        this.setItalic(src.isItalic());
        this.setStrikeout(src.isStrikeout());
        this.setTypeOffset(src.getTypeOffset());
        this.setUnderline(src.getUnderline());
    }

    @Override
    String getStyleKey() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._fontName).append(".").append(this._fontColor.getHtmlColor()).append(".").append(this._fontBoldweight.ordinal()).append(".").append(this._fontHeightPoint).append(".").append(this._fontItalic ? "T" : "F").append(".").append(this._fontStrikeout ? "T" : "F").append(".").append(this._fontTypeOffset.ordinal()).append(".").append(this._fontUnderline.ordinal());
        return sb.toString();
    }

    public int hashCode() {
        return this.getStyleKey().hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FontImpl)) {
            return false;
        }
        FontImpl o = (FontImpl)other;
        return this.getStyleKey().equals(o.getStyleKey());
    }

    @Override
    public void setOverrideName(boolean overrideName) {
        this.overrideName = overrideName;
    }

    @Override
    public void setOverrideColor(boolean overrideColor) {
        this.overrideColor = overrideColor;
    }

    @Override
    public void setOverrideBold(boolean overrideBold) {
        this.overrideBold = overrideBold;
    }

    @Override
    public void setOverrideItalic(boolean overrideItalic) {
        this.overrideItalic = overrideItalic;
    }

    @Override
    public void setOverrideStrikeout(boolean overrideStrikeout) {
        this.overrideStrikeout = overrideStrikeout;
    }

    @Override
    public void setOverrideUnderline(boolean overrideUnderline) {
        this.overrideUnderline = overrideUnderline;
    }

    @Override
    public void setOverrideHeightPoints(boolean overrideHeightPoints) {
        this.overrideHeightPoints = overrideHeightPoints;
    }

    @Override
    public void setOverrideTypeOffset(boolean overrideTypeOffset) {
        this.overrideTypeOffset = overrideTypeOffset;
    }

    @Override
    public boolean isOverrideName() {
        return this.overrideName;
    }

    @Override
    public boolean isOverrideColor() {
        return this.overrideColor;
    }

    @Override
    public boolean isOverrideBold() {
        return this.overrideBold;
    }

    @Override
    public boolean isOverrideItalic() {
        return this.overrideItalic;
    }

    @Override
    public boolean isOverrideStrikeout() {
        return this.overrideStrikeout;
    }

    @Override
    public boolean isOverrideUnderline() {
        return this.overrideUnderline;
    }

    @Override
    public boolean isOverrideHeightPoints() {
        return this.overrideHeightPoints;
    }

    @Override
    public boolean isOverrideTypeOffset() {
        return this.overrideTypeOffset;
    }

    @Override
    SFont cloneFont(SBook book) {
        return book == null ? this : ((AbstractBookAdv)book).getOrCreateFont(this);
    }
}

