

(function () {
	
	function _redrawOpacity (obj) {
		var inner = obj.icomp,
			cloneInner = jq(inner).clone()[0];
		jq(inner).replaceWith(cloneInner);
		obj.icomp = cloneInner;
	}

	
	function _showSelectionArea (obj, redrawOpacity) {
		var range = obj.lastRange;
		if (!range) return;
		jq(obj.comp).css('display', 'block');
		jq(obj.icomp)[((range.top != range.bottom) || (range.left != range.right)) ? 'addClass' : 'removeClass']("zsselecti-r");
		if ((zk.ie8 && zk.ie < 11) && redrawOpacity)
			_redrawOpacity(obj);
	}


zss.AreaCtrl = zk.$extends(zk.Object, {
	$init: function (sheet, cmp, range, mode) {
		this.$supers('$init', arguments);
		this.id = cmp.id;
		cmp.ctrl = this;
		this.comp = cmp;
		this.icomp = cmp.firstChild;
		this.sheet = sheet;
		this.lastRange = range ? range : new zss.Range(0,0,0,0);
		this.mode = mode;
	},
	cleanup: function () {
		this.invalid = true;
		if (this.comp) this.comp.ctrl = null;
		this.comp = this.icomp = this.sheet = null;
	},
	
	relocate: function (range) {
		var sheet = this.sheet;
		if (!range) {
			range = this.lastRange;
			if (!range) return;
		} else
			this.lastRange = range;

		var custColWidth = sheet.custColWidth,
			custRowHeight = sheet.custRowHeight,
			l = custColWidth.getStartPixel(range.left),
			t = custRowHeight.getStartPixel(range.top),
			w = custColWidth.getStartPixel(range.right + 1) - l,
			h = custRowHeight.getStartPixel(range.bottom + 1) - t;
		
		this.relocate_(l, t, w, h);
	},
	relocate_: function(l, t, w, h) {

		var sheet = this.sheet,
			dp = sheet.dp;
		
		l += sheet.leftWidth;
		t += sheet.topHeight + 1;
		l = l - 2;
		t = t - 2;
		w = w + 3;
		h = h + 3;
		if (this.mode == "inner") {
			l = l + 1;
			t = t + 1;
			w = w - 2;
			h = h - 2;
		}

		jq(this.comp).css({'width': jq.px0(w), 'height': jq.px0(h), 'left': jq.px(l), 'top': jq.px(t)});
	},
	isVisible: function () {
		return this.comp.style.display == 'block';
	},
	
	showArea: function () {
		var range = this.lastRange;
		if (!range) return;

		jq(this.comp).css('display', 'block');
	},
	
	hideArea: function () {
		jq(this.comp).css('display', 'none');
	}
});


zss.SelAreaCtrl = zk.$extends(zss.AreaCtrl, {
	
	$init: function (sheet, cmp, range, mode) {
		this.$supers('$init', arguments);
		var wgt = this.sheet._wgt,
			n = this.comp;
		wgt.domListen_(n, 'onMouseMove', '_doSelAreaMouseMove');
		wgt.domListen_(n, 'onMouseOut', '_doSelAreaMouseOut');
	},
	cleanup: function () {
		var wgt = this.sheet._wgt,
			n = this.comp;
		wgt.domUnlisten_(n, 'onMouseMove', '_doSelAreaMouseMove');
		wgt.domUnlisten_(n, 'onMouseOut', '_doSelAreaMouseOut');
		this.$supers('cleanup', arguments);
	},
	showArea: function () {
		_showSelectionArea(this, true);
	},
	_doMouseMove: function (evt) {
		var sheet = this.sheet,
			mx = evt.pageX,
			my = evt.pageY,
			cellpos = zss.SSheetCtrl._calCellPos(sheet, mx, my, false),
			row = cellpos[0],
			col = cellpos[1],
			cell = sheet.getCell(row, col);
		
		if (cell.isMerged()) {
			cell = sheet.getCell(cell.mert,cell.merl);
		}
		if (cell) {
			
			if (sheet._showCellComment)
				sheet._showCellComment(cell);
			if (this._isStartHyperlink()) return; 
			var jqa = jq(cell.comp).find('a');
			if (jqa.length>0) {
				var aelm = jqa[0];
				if(zkS.isOverlapByPoint(aelm, mx, my)) {
					jq(this.icomp).css('cursor', 'pointer');
					this._setHyperlinkElment(aelm);
					return;
				}
			}
			this._resetHyperlink();
		}
	},
	_doMouseOut: function (evt) {
		this._resetHyperlink();
		
		
		var sheet = this.sheet,
			mx = evt.pageX,
			my = evt.pageY,
			cellpos = zss.SSheetCtrl._calCellPos(sheet, mx, my, false),
			row = cellpos[0],
			col = cellpos[1],
			cell = sheet.getCell(row, col);
		if (cell && cell.isMerged()) {
			cell = sheet.getCell(cell.mert,cell.merl);
		}
		if (cell && sheet._showCellComment) {
			sheet._showCellComment(cell);
		}
	},
	_setHyperlinkElment: function (elm) {
		this._hyperlinkElm = elm;
	},
	_startHyperlink: function(aelm) { 
		this._stopHyperlink(); 
		
		
		if(zk.ie8 && zk.ie < 11) this._start = true;
		var t = 1000;
		this._mdtimeout = (new Date()).getTime() + t;
		if((aelm && aelm.tagName.toLowerCase() == 'a') || this._hyperlinkElm) {
			var selArea = this, 
				anchor = aelm;
			setTimeout(function() {selArea._resetHyperlinkCursor(anchor)}, t);
		}
	},
	_tryAndEndHyperlink: function (row, col, evt) { 
		var elm = this._hyperlinkElm;
		if (elm && elm.tagName.toLowerCase() == 'a') {
			if (!this._isHyperlinkTimeout(new Date().getTime())) {
				var href = elm.getAttribute('z.href'),
					type = elm.getAttribute('z.t');
				type = parseInt(type);
				this.sheet._wgt.linkTo(href, type, evt);
				
				
				if (type == 2) {
					var wgt = this.sheet._wgt,
						cacheCtrl = wgt._cacheCtrl,
						currSheetId = wgt.getSheetId();
					cacheCtrl.snap(currSheetId); 
				}

				this.sheet._sendOnCellHyperlink(row, col, href, type, evt);
			}
		}
		
		this._stopHyperlink();
	},
	_stopHyperlink: function () {
		
		
		if(zk.ie8 && zk.ie < 11) delete this._start;
		delete this._mdtimeout;
		if (this._aelm) {
			jq(this._aelm).css('cursor', '');
			delete this._aelm;
		}
	},
	_isStartHyperlink: function() {
		return this._mdtimeout;
	},
	_isHyperlinkTimeout: function(t) {
		return t >= this._mdtimeout;
	},
	_resetHyperlinkCursor: function (aelm) {
		if (!aelm) {
			jq(this.icomp).css('cursor', 'default');
		} else {
			this._aelm = aelm;
			jq(aelm).css('cursor', 'default');
		}
	},
	_resetHyperlink: function () {
		
		
		if ((!zk.ie8 || zk.ie >= 11)|| !this._start) {
			delete this._hyperlinkElm;
			this._resetHyperlinkCursor();
		}
	}
});


zss.SelChgCtrl = zk.$extends(zss.AreaCtrl, {});


zss.AreaCtrlCorner = zk.$extends(zss.AreaCtrl, {});


zss.SelAreaCtrlCorner = zk.$extends(zss.AreaCtrlCorner, {
	
	showArea: function () {
		_showSelectionArea(this);
	}
});


zss.SelChgCtrlCorner = zk.$extends(zss.AreaCtrlCorner, {});


zss.AreaCtrlLeft = zk.$extends(zss.AreaCtrl, {
	
  	relocate_: function (l, t, w, h) {
		var sheet = this.sheet;
		l += sheet.leftWidth - 1;
		
		if (sheet.lp.toppad) {
			t -= sheet.lp.toppad;
		}
		
		l = l - 2;
		t = t - 2;
		w = w + 3;
		h = h + 3;
		if (this.mode == "inner") {
			l = l + 1;
			t = t + 1;
			w = w - 2;
			h = h - 2;
		}

		jq(this.comp).css({'width': jq.px0(w), 'height': jq.px0(h), 'left': jq.px(l),'top' : jq.px(t)});
	}
});


zss.SelAreaCtrlLeft = zk.$extends(zss.AreaCtrlLeft, {
	
	showArea: function () {
		_showSelectionArea(this);
	}
});


zss.SelChgCtrlLeft = zk.$extends(zss.AreaCtrlLeft, {});


zss.AreaCtrlTop = zk.$extends(zss.AreaCtrl, {
	
  	relocate_: function(l , t, w, h) {
		var sheet = this.sheet;
		t += sheet.topHeight;

		l = l - 2;
		t = t - 2;
		w = w + 3;
		h = h + 3;
		if (this.mode == "inner") {
			l = l + 1;
			t = t + 1;
			w = w - 2;
			h = h - 2;
		}

		jq(this.comp).css({'width': jq.px0(w), 'height': jq.px0(h), 'left': jq.px(l), 'top': jq.px(t)});
	}
});


zss.SelAreaCtrlTop = zk.$extends(zss.AreaCtrlTop, {
	
	showArea: function () {
		_showSelectionArea(this);
	}
});


zss.SelChgCtrlTop = zk.$extends(zss.AreaCtrlTop, {});
})();