/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.range.impl;

import io.keikai.model.SCell;
import io.keikai.model.SDataValidation;
import io.keikai.model.SSheet;
import io.keikai.model.impl.FormulaResultCellValue;
import io.keikai.model.sys.CalendarUtil;
import io.keikai.model.sys.EngineFactory;
import io.keikai.model.sys.formula.FormulaEngine;
import io.keikai.model.sys.formula.FormulaEvaluationContext;
import io.keikai.model.sys.formula.FormulaExpression;
import io.keikai.model.sys.formula.FormulaParseContext;
import io.keikai.model.sys.input.InputEngine;
import io.keikai.model.sys.input.InputParseContext;
import io.keikai.model.sys.input.InputResult;
import java.io.Serializable;
import java.util.Date;
import java.util.Locale;
import org.zkoss.poi.ss.usermodel.ZssContext;

public class DataValidationHelper
implements Serializable {
    private static final long serialVersionUID = 8830650650352922612L;
    private final SDataValidation _validation;
    private final SSheet _sheet;

    public DataValidationHelper(SDataValidation validation) {
        this._validation = validation;
        this._sheet = validation.getSheet();
    }

    public boolean validate(int row, int col, String editText, String dataformat) {
        InputResult result = this.normalizeInput(editText, dataformat, ZssContext.getCurrent().getLocale());
        return this.validate(row, col, result.getType(), result.getValue(), dataformat);
    }

    public boolean validate(int row, int col, SCell.CellType cellType, Object value, String dataformat) {
        SDataValidation.ValidationType vtype = this._validation.getValidationType();
        if (vtype == SDataValidation.ValidationType.ANY) {
            return true;
        }
        if (vtype != SDataValidation.ValidationType.TEXT_LENGTH && (value == null || value instanceof String && ((String)value).length() == 0) && this._validation.isIgnoreBlank()) {
            return true;
        }
        if (cellType == SCell.CellType.FORMULA) {
            FormulaEngine engine = EngineFactory.getInstance().createFormulaEngine();
            FormulaExpression expr = engine.parse((String)value, new FormulaParseContext(this._sheet, null));
            if (expr.hasError()) {
                return false;
            }
            FormulaResultCellValue result = new FormulaResultCellValue(engine.evaluate(expr, new FormulaEvaluationContext(this._sheet, null)));
            value = result.getValue();
            cellType = result.getCellType();
        }
        CalendarUtil cal = EngineFactory.getInstance().getCalendarUtil();
        boolean success = true;
        switch (vtype) {
            case INTEGER: {
                if (DataValidationHelper.isInteger(value) && this.validateOperation((Number)value)) break;
                success = false;
                break;
            }
            case DECIMAL: {
                if (DataValidationHelper.isDecimal(value) && this.validateOperation((Number)value)) break;
                success = false;
                break;
            }
            case DATE: 
            case TIME: {
                success = value instanceof Date && this.validateOperation(cal.dateToDoubleValue((Date)value));
                break;
            }
            case LIST: {
                if (this.validateListOperation(row, col, value instanceof Date ? Double.valueOf(cal.dateToDoubleValue((Date)value)) : value, dataformat)) break;
                success = false;
                break;
            }
            case TEXT_LENGTH: {
                if ((value == null || DataValidationHelper.isString(value)) && this.validateOperation(value == null ? 0 : ((String)value).length())) break;
                success = false;
                break;
            }
            case CUSTOM: {
                success = false;
            }
        }
        return success;
    }

    private static boolean isInteger(Object value) {
        if (value instanceof Number) {
            return (double)((Number)value).intValue() == ((Number)value).doubleValue();
        }
        return false;
    }

    private static boolean isDecimal(Object value) {
        return value instanceof Number;
    }

    private static boolean isString(Object value) {
        return value instanceof String;
    }

    private boolean validateOperation(Number value) {
        if (value == null) {
            return false;
        }
        Object value1 = this._validation.getValue1(0);
        if (!(value1 instanceof Number)) {
            return false;
        }
        Object value2 = this._validation.getValue2(0);
        double v1 = ((Number)value1).doubleValue();
        double v = value.doubleValue();
        switch (this._validation.getOperatorType()) {
            case BETWEEN: {
                if (!(value2 instanceof Number)) {
                    return false;
                }
                double v2 = ((Number)value2).doubleValue();
                return v >= v1 && v <= v2;
            }
            case NOT_BETWEEN: {
                if (!(value2 instanceof Number)) {
                    return false;
                }
                double v2 = ((Number)value2).doubleValue();
                return v < v1 || v > v2;
            }
            case EQUAL: {
                return v == v1;
            }
            case NOT_EQUAL: {
                return v != v1;
            }
            case GREATER_THAN: {
                return v > v1;
            }
            case LESS_THAN: {
                return v < v1;
            }
            case GREATER_OR_EQUAL: {
                return v >= v1;
            }
            case LESS_OR_EQUAL: {
                return v <= v1;
            }
        }
        return true;
    }

    private boolean validateListOperation(int row, int col, Object value, String dataformat) {
        if (value == null) {
            return false;
        }
        if (this._validation.hasReferToCellList()) {
            for (SCell cell : this._validation.getReferToCellList(row, col)) {
                Object val = cell.getValue();
                if (!value.equals(val)) continue;
                return true;
            }
        } else {
            int size = this._validation.getNumOfValue1();
            for (int i = 0; i < size; ++i) {
                Object val = this._validation.getValue1(i);
                if (value.equals(val)) {
                    return true;
                }
                if (!(val instanceof String) || !value.equals(this.normalizeValue((String)val, dataformat))) continue;
                return true;
            }
        }
        return false;
    }

    private InputResult normalizeInput(String editText, String dataformat, Locale locale) {
        InputEngine ie = EngineFactory.getInstance().createInputEngine();
        return ie.parseInput(editText == null ? "" : editText, dataformat, new InputParseContext(locale));
    }

    private Object normalizeValue(String editText, String dataformat) {
        return this.normalizeInput(editText, dataformat, Locale.US).getValue();
    }
}

