/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel;

import java.util.List;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorder;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorderPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellAlignment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellProtection;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTFont;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTPatternFill;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTXf;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STBorderStyle;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STHorizontalAlignment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STPatternType;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STVerticalAlignment;
import org.zkoss.poi.POIXMLException;
import org.zkoss.poi.ss.usermodel.BorderStyle;
import org.zkoss.poi.ss.usermodel.BuiltinFormats;
import org.zkoss.poi.ss.usermodel.CellStyle;
import org.zkoss.poi.ss.usermodel.Color;
import org.zkoss.poi.ss.usermodel.FillPatternType;
import org.zkoss.poi.ss.usermodel.Font;
import org.zkoss.poi.ss.usermodel.HorizontalAlignment;
import org.zkoss.poi.ss.usermodel.IndexedColors;
import org.zkoss.poi.ss.usermodel.VerticalAlignment;
import org.zkoss.poi.util.Internal;
import org.zkoss.poi.xssf.model.StylesTable;
import org.zkoss.poi.xssf.model.ThemesTable;
import org.zkoss.poi.xssf.usermodel.XSSFColor;
import org.zkoss.poi.xssf.usermodel.XSSFDataFormat;
import org.zkoss.poi.xssf.usermodel.XSSFFont;
import org.zkoss.poi.xssf.usermodel.extensions.XSSFCellAlignment;
import org.zkoss.poi.xssf.usermodel.extensions.XSSFCellBorder;
import org.zkoss.poi.xssf.usermodel.extensions.XSSFCellFill;

public class XSSFCellStyle
implements CellStyle {
    private int _cellXfId;
    private StylesTable _stylesSource;
    private CTXf _cellXf;
    private CTXf _cellStyleXf;
    private XSSFFont _font;
    private XSSFCellAlignment _cellAlignment;
    private ThemesTable _theme;

    public XSSFCellStyle(int cellXfId, int cellStyleXfId, StylesTable stylesSource, ThemesTable theme) {
        this._cellXfId = cellXfId;
        this._stylesSource = stylesSource;
        this._cellXf = this._cellXfId < 0 ? null : stylesSource.getCellXfAt(this._cellXfId);
        this._cellStyleXf = cellStyleXfId == -1 ? null : stylesSource.getCellStyleXfAt(cellStyleXfId);
        this._theme = theme;
    }

    public XSSFCellStyle(CTXf cellStyleXf, StylesTable stylesSource, ThemesTable theme) {
        this._cellXfId = -1;
        this._stylesSource = stylesSource;
        this._cellXf = null;
        this._cellStyleXf = cellStyleXf;
        this._theme = theme;
    }

    @Internal
    public CTXf getCoreXf() {
        return this._cellXf;
    }

    @Internal
    public CTXf getStyleXf() {
        return this._cellStyleXf;
    }

    public XSSFCellStyle(StylesTable stylesSource) {
        this._stylesSource = stylesSource;
        this._cellXf = CTXf.Factory.newInstance();
        this._cellStyleXf = null;
    }

    public void verifyBelongsToStylesSource(StylesTable src) {
        if (this._stylesSource != src) {
            throw new IllegalArgumentException("This Style does not belong to the supplied Workbook Stlyes Source. Are you trying to assign a style from one workbook to the cell of a differnt workbook?");
        }
    }

    @Override
    public void cloneStyleFrom(CellStyle source) {
        if (source instanceof XSSFCellStyle) {
            XSSFCellStyle src = (XSSFCellStyle)source;
            if (src._stylesSource == this._stylesSource) {
                this._cellXf.set((XmlObject)src.getCoreXf());
                this._cellStyleXf.set((XmlObject)src.getStyleXf());
            } else {
                try {
                    if (this._cellXf.isSetAlignment()) {
                        this._cellXf.unsetAlignment();
                    }
                    if (this._cellXf.isSetExtLst()) {
                        this._cellXf.unsetExtLst();
                    }
                    this._cellXf = CTXf.Factory.parse((String)src.getCoreXf().toString());
                    this._stylesSource.replaceCellXfAt(this._cellXfId, this._cellXf);
                }
                catch (XmlException e) {
                    throw new POIXMLException(e);
                }
                String fmt = src.getDataFormatString();
                this.setDataFormat(new XSSFDataFormat(this._stylesSource).getFormat(fmt));
                try {
                    CTFont ctFont = CTFont.Factory.parse((String)src.getFont().getCTFont().toString());
                    XSSFFont font = new XSSFFont(ctFont);
                    font.registerTo(this._stylesSource);
                    this.setFont(font);
                }
                catch (XmlException e) {
                    throw new POIXMLException(e);
                }
                if (src.getCoreXf().getApplyFill()) {
                    try {
                        CTFill ctFill = CTFill.Factory.parse((String)src.getCTFill().toString());
                        int index = this._stylesSource.putFill(new XSSFCellFill(ctFill));
                        this._cellXf.setFillId((long)index);
                        this._cellXf.setApplyFill(true);
                    }
                    catch (XmlException e) {
                        throw new POIXMLException(e);
                    }
                }
                if (src.getCoreXf().getApplyBorder()) {
                    try {
                        CTBorder ctBorder = CTBorder.Factory.parse((String)src.getCTBorder().toString());
                        int index = this._stylesSource.putBorder(new XSSFCellBorder(ctBorder, this._theme));
                        this._cellXf.setBorderId((long)index);
                        this._cellXf.setApplyBorder(true);
                    }
                    catch (XmlException e) {
                        throw new POIXMLException(e);
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Can only clone from one XSSFCellStyle to another, not between HSSFCellStyle and XSSFCellStyle");
        }
        this._font = null;
        this._cellAlignment = null;
    }

    @Override
    public short getAlignment() {
        return (short)this.getAlignmentEnum().ordinal();
    }

    public HorizontalAlignment getAlignmentEnum() {
        CTCellAlignment align;
        if (this._cellXf != null && this._cellXf.isSetAlignment() && (align = this._cellXf.getAlignment()) != null && align.isSetHorizontal()) {
            return HorizontalAlignment.values()[align.getHorizontal().intValue() - 1];
        }
        CTCellAlignment cTCellAlignment = align = this._cellStyleXf == null ? null : this._cellStyleXf.getAlignment();
        if (align != null && align.isSetHorizontal()) {
            return HorizontalAlignment.values()[align.getHorizontal().intValue() - 1];
        }
        return HorizontalAlignment.GENERAL;
    }

    @Override
    public short getBorderBottom() {
        int idx;
        if (this._cellXf != null && this._cellXf.getApplyBorder()) {
            int idx2 = (int)this._cellXf.getBorderId();
            CTBorder ct = this._stylesSource.getBorderAt(idx2).getCTBorder();
            STBorderStyle.Enum ptrn = ct.isSetBottom() ? ct.getBottom().getStyle() : null;
            return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
        }
        int n = idx = this._cellStyleXf == null ? -1 : (int)this._cellStyleXf.getBorderId();
        if (idx >= 0) {
            CTBorder ct = this._stylesSource.getBorderAt(idx).getCTBorder();
            STBorderStyle.Enum ptrn = ct.isSetBottom() ? ct.getBottom().getStyle() : null;
            return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
        }
        return 0;
    }

    public BorderStyle getBorderBottomEnum() {
        short style = this.getBorderBottom();
        return BorderStyle.values()[style];
    }

    @Override
    public short getBorderLeft() {
        int idx;
        if (this._cellXf != null && this._cellXf.getApplyBorder()) {
            int idx2 = (int)this._cellXf.getBorderId();
            CTBorder ct = this._stylesSource.getBorderAt(idx2).getCTBorder();
            STBorderStyle.Enum ptrn = ct.isSetLeft() ? ct.getLeft().getStyle() : null;
            return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
        }
        int n = idx = this._cellStyleXf == null ? -1 : (int)this._cellStyleXf.getBorderId();
        if (idx >= 0) {
            CTBorder ct = this._stylesSource.getBorderAt(idx).getCTBorder();
            STBorderStyle.Enum ptrn = ct.isSetLeft() ? ct.getLeft().getStyle() : null;
            return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
        }
        return 0;
    }

    public BorderStyle getBorderLeftEnum() {
        short style = this.getBorderLeft();
        return BorderStyle.values()[style];
    }

    @Override
    public short getBorderRight() {
        int idx;
        if (this._cellXf != null && this._cellXf.getApplyBorder()) {
            int idx2 = (int)this._cellXf.getBorderId();
            CTBorder ct = this._stylesSource.getBorderAt(idx2).getCTBorder();
            STBorderStyle.Enum ptrn = ct.isSetRight() ? ct.getRight().getStyle() : null;
            return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
        }
        int n = idx = this._cellStyleXf == null ? -1 : (int)this._cellStyleXf.getBorderId();
        if (idx >= 0) {
            CTBorder ct = this._stylesSource.getBorderAt(idx).getCTBorder();
            STBorderStyle.Enum ptrn = ct.isSetRight() ? ct.getRight().getStyle() : null;
            return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
        }
        return 0;
    }

    public BorderStyle getBorderRightEnum() {
        short style = this.getBorderRight();
        return BorderStyle.values()[style];
    }

    @Override
    public short getBorderTop() {
        int idx;
        if (this._cellXf != null && this._cellXf.getApplyBorder()) {
            int idx2 = (int)this._cellXf.getBorderId();
            CTBorder ct = this._stylesSource.getBorderAt(idx2).getCTBorder();
            STBorderStyle.Enum ptrn = ct.isSetTop() ? ct.getTop().getStyle() : null;
            return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
        }
        int n = idx = this._cellStyleXf == null ? -1 : (int)this._cellStyleXf.getBorderId();
        if (idx >= 0) {
            CTBorder ct = this._stylesSource.getBorderAt(idx).getCTBorder();
            STBorderStyle.Enum ptrn = ct.isSetTop() ? ct.getTop().getStyle() : null;
            return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
        }
        return 0;
    }

    public BorderStyle getBorderTopEnum() {
        short style = this.getBorderTop();
        return BorderStyle.values()[style];
    }

    @Override
    public short getBottomBorderColor() {
        XSSFColor clr = this.getBottomBorderXSSFColor();
        return clr == null ? IndexedColors.BLACK.getIndex() : clr.getIndexed();
    }

    public XSSFColor getBottomBorderXSSFColor() {
        int idx;
        if (this._cellXf != null && this._cellXf.getApplyBorder()) {
            int idx2 = (int)this._cellXf.getBorderId();
            XSSFCellBorder border = this._stylesSource.getBorderAt(idx2);
            return border.getBorderColor(XSSFCellBorder.BorderSide.BOTTOM);
        }
        int n = idx = this._cellStyleXf == null ? -1 : (int)this._cellStyleXf.getBorderId();
        if (idx >= 0) {
            XSSFCellBorder border = this._stylesSource.getBorderAt(idx);
            return border.getBorderColor(XSSFCellBorder.BorderSide.BOTTOM);
        }
        return null;
    }

    @Override
    public short getDataFormat() {
        if (this._cellXf != null && this._cellXf.getApplyNumberFormat()) {
            return (short)this._cellXf.getNumFmtId();
        }
        return this._cellStyleXf == null ? (short)0 : (short)this._cellStyleXf.getNumFmtId();
    }

    @Override
    public String getDataFormatString() {
        short idx = this.getDataFormat();
        return new XSSFDataFormat(this._stylesSource).getFormat(idx);
    }

    @Override
    public String getRawDataFormatString() {
        short idx = this.getDataFormat();
        return new XSSFDataFormat(this._stylesSource).getRawFormat(idx);
    }

    @Override
    public boolean isBuiltinDataFormat() {
        short idx = this.getDataFormat();
        return this._stylesSource.getNumberFormatAt(idx) == null && BuiltinFormats.getBuiltinFormat(idx) != null;
    }

    @Override
    public short getFillBackgroundColor() {
        XSSFColor clr = this.getFillBackgroundXSSFColor();
        return clr == null ? IndexedColors.AUTOMATIC.getIndex() : clr.getIndexed();
    }

    @Override
    public XSSFColor getFillBackgroundColorColor() {
        return this.getFillBackgroundXSSFColor();
    }

    public XSSFColor getFillBackgroundXSSFColor() {
        int fillIndex = this.getFillId();
        if (fillIndex < 0) {
            return null;
        }
        XSSFCellFill fg = this._stylesSource.getFillAt(fillIndex);
        XSSFColor fillBackgroundColor = fg.getFillBackgroundColor();
        if (fillBackgroundColor != null && this._theme != null) {
            this._theme.inheritFromThemeAsRequired(fillBackgroundColor);
        }
        return fillBackgroundColor;
    }

    @Override
    public short getFillForegroundColor() {
        XSSFColor clr = this.getFillForegroundXSSFColor();
        return clr == null ? IndexedColors.AUTOMATIC.getIndex() : clr.getIndexed();
    }

    @Override
    public XSSFColor getFillForegroundColorColor() {
        return this.getFillForegroundXSSFColor();
    }

    public XSSFColor getFillForegroundXSSFColor() {
        int fillIndex = this.getFillId();
        if (fillIndex < 0) {
            return null;
        }
        XSSFCellFill fg = this._stylesSource.getFillAt(fillIndex);
        XSSFColor fillForegroundColor = fg.getFillForegroundColor();
        if (fillForegroundColor != null && this._theme != null) {
            this._theme.inheritFromThemeAsRequired(fillForegroundColor);
        }
        return fillForegroundColor;
    }

    private int getFillId() {
        if (this._cellXf != null && this._cellXf.getApplyFill()) {
            return (int)this._cellXf.getFillId();
        }
        return this._cellStyleXf != null ? (int)this._cellStyleXf.getFillId() : -1;
    }

    @Override
    public short getFillPattern() {
        int fillIndex = this.getFillId();
        if (fillIndex < 0) {
            return 0;
        }
        XSSFCellFill fill = this._stylesSource.getFillAt(fillIndex);
        STPatternType.Enum ptrn = fill.getPatternType();
        if (ptrn == null) {
            return 0;
        }
        return (short)(ptrn.intValue() - 1);
    }

    public FillPatternType getFillPatternEnum() {
        short style = this.getFillPattern();
        return FillPatternType.values()[style];
    }

    public XSSFFont getFont() {
        if (this._font == null) {
            this._font = this._stylesSource.getFontAt(this.getFontId());
        }
        return this._font;
    }

    @Override
    public short getFontIndex() {
        return (short)this.getFontId();
    }

    @Override
    public boolean getHidden() {
        if (this._cellXf != null && this._cellXf.isSetProtection() && this._cellXf.getProtection().isSetHidden()) {
            return this._cellXf.getProtection().getHidden();
        }
        if (this._cellStyleXf != null && this._cellStyleXf.isSetProtection() && this._cellStyleXf.getProtection().isSetHidden()) {
            return this._cellStyleXf.getProtection().getHidden();
        }
        return false;
    }

    @Override
    public short getIndention() {
        if (this._cellXf != null && this._cellXf.isSetAlignment()) {
            CTCellAlignment align = this._cellXf.getAlignment();
            return (short)(align == null ? 0L : align.getIndent());
        }
        CTCellAlignment align = this._cellStyleXf == null ? null : this._cellStyleXf.getAlignment();
        return (short)(align == null ? 0L : align.getIndent());
    }

    @Override
    public int getIndex() {
        return this._cellXfId;
    }

    @Override
    public short getLeftBorderColor() {
        XSSFColor clr = this.getLeftBorderXSSFColor();
        return clr == null ? IndexedColors.BLACK.getIndex() : clr.getIndexed();
    }

    public XSSFColor getLeftBorderXSSFColor() {
        if (this._cellXf != null && this._cellXf.getApplyBorder()) {
            int idx = (int)this._cellXf.getBorderId();
            XSSFCellBorder border = this._stylesSource.getBorderAt(idx);
            return border.getBorderColor(XSSFCellBorder.BorderSide.LEFT);
        }
        if (this._cellStyleXf != null) {
            int idx = (int)this._cellStyleXf.getBorderId();
            XSSFCellBorder border = this._stylesSource.getBorderAt(idx);
            return border.getBorderColor(XSSFCellBorder.BorderSide.LEFT);
        }
        return null;
    }

    @Override
    public boolean getLocked() {
        if (this._cellXf != null && this._cellXf.isSetProtection() && this._cellXf.getProtection().isSetLocked()) {
            return this._cellXf.getProtection().getLocked();
        }
        if (this._cellStyleXf != null && this._cellStyleXf.isSetProtection() && this._cellStyleXf.getProtection().isSetLocked()) {
            return this._cellStyleXf.getProtection().getLocked();
        }
        return true;
    }

    @Override
    public short getRightBorderColor() {
        XSSFColor clr = this.getRightBorderXSSFColor();
        return clr == null ? IndexedColors.BLACK.getIndex() : clr.getIndexed();
    }

    public XSSFColor getRightBorderXSSFColor() {
        if (this._cellXf != null && this._cellXf.getApplyBorder()) {
            int idx = (int)this._cellXf.getBorderId();
            XSSFCellBorder border = this._stylesSource.getBorderAt(idx);
            return border.getBorderColor(XSSFCellBorder.BorderSide.RIGHT);
        }
        if (this._cellStyleXf != null) {
            int idx = (int)this._cellStyleXf.getBorderId();
            XSSFCellBorder border = this._stylesSource.getBorderAt(idx);
            return border.getBorderColor(XSSFCellBorder.BorderSide.RIGHT);
        }
        return null;
    }

    @Override
    public short getRotation() {
        if (this._cellXf != null && this._cellXf.isSetAlignment()) {
            CTCellAlignment align = this._cellXf.getAlignment();
            return this.convertToUIRotation((short)(align == null ? 0L : align.getTextRotation()));
        }
        CTCellAlignment align = this._cellStyleXf == null ? null : this._cellStyleXf.getAlignment();
        return this.convertToUIRotation((short)(align == null ? 0L : align.getTextRotation()));
    }

    private short convertToUIRotation(short rotation) {
        if (90 < rotation && rotation <= 180) {
            rotation = (short)(90 - rotation);
        }
        return rotation;
    }

    @Override
    public short getTopBorderColor() {
        XSSFColor clr = this.getTopBorderXSSFColor();
        return clr == null ? IndexedColors.BLACK.getIndex() : clr.getIndexed();
    }

    public XSSFColor getTopBorderXSSFColor() {
        if (this._cellXf != null && this._cellXf.getApplyBorder()) {
            int idx = (int)this._cellXf.getBorderId();
            XSSFCellBorder border = this._stylesSource.getBorderAt(idx);
            return border.getBorderColor(XSSFCellBorder.BorderSide.TOP);
        }
        if (this._cellStyleXf != null) {
            int idx = (int)this._cellStyleXf.getBorderId();
            XSSFCellBorder border = this._stylesSource.getBorderAt(idx);
            return border.getBorderColor(XSSFCellBorder.BorderSide.TOP);
        }
        return null;
    }

    @Override
    public short getVerticalAlignment() {
        return (short)this.getVerticalAlignmentEnum().ordinal();
    }

    public VerticalAlignment getVerticalAlignmentEnum() {
        CTCellAlignment align;
        if (this._cellXf != null) {
            if (this._cellXf.isSetAlignment() && (align = this._cellXf.getAlignment()) != null && align.isSetVertical() && align.xgetVertical().validate()) {
                return VerticalAlignment.values()[align.getVertical().intValue() - 1];
            }
            if (this._cellXf.isSetApplyAlignment() && this._cellXf.getApplyAlignment()) {
                return VerticalAlignment.BOTTOM;
            }
        }
        if (this._cellStyleXf != null && (align = this._cellStyleXf.getAlignment()) != null && align.isSetVertical() && align.xgetVertical().validate()) {
            return VerticalAlignment.values()[align.getVertical().intValue() - 1];
        }
        return VerticalAlignment.BOTTOM;
    }

    @Override
    public boolean getWrapText() {
        if (this._cellXf != null && this._cellXf.isSetAlignment()) {
            CTCellAlignment align = this._cellXf.getAlignment();
            return align != null && align.getWrapText();
        }
        CTCellAlignment align = this._cellStyleXf == null ? null : this._cellStyleXf.getAlignment();
        return align != null && align.getWrapText();
    }

    @Override
    public void setAlignment(short align) {
        this.getCellAlignment().setHorizontal(HorizontalAlignment.values()[align]);
        this._cellXf.setApplyAlignment(true);
    }

    public void setAlignment(HorizontalAlignment align) {
        this.setAlignment((short)align.ordinal());
    }

    @Override
    public void setBorderBottom(short border) {
        CTBorderPr pr;
        CTBorder ct = this.getCTBorder();
        CTBorderPr cTBorderPr = pr = ct.isSetBottom() ? ct.getBottom() : ct.addNewBottom();
        if (border == 0) {
            ct.unsetBottom();
        } else {
            pr.setStyle(STBorderStyle.Enum.forInt((int)(border + 1)));
        }
        int idx = this._stylesSource.putBorder(new XSSFCellBorder(ct, this._theme));
        this._cellXf.setBorderId((long)idx);
        this._cellXf.setApplyBorder(true);
    }

    public void setBorderBottom(BorderStyle border) {
        this.setBorderBottom((short)border.ordinal());
    }

    @Override
    public void setBorderLeft(short border) {
        CTBorderPr pr;
        CTBorder ct = this.getCTBorder();
        CTBorderPr cTBorderPr = pr = ct.isSetLeft() ? ct.getLeft() : ct.addNewLeft();
        if (border == 0) {
            ct.unsetLeft();
        } else {
            pr.setStyle(STBorderStyle.Enum.forInt((int)(border + 1)));
        }
        int idx = this._stylesSource.putBorder(new XSSFCellBorder(ct, this._theme));
        this._cellXf.setBorderId((long)idx);
        this._cellXf.setApplyBorder(true);
    }

    public void setBorderLeft(BorderStyle border) {
        this.setBorderLeft((short)border.ordinal());
    }

    @Override
    public void setBorderRight(short border) {
        CTBorderPr pr;
        CTBorder ct = this.getCTBorder();
        CTBorderPr cTBorderPr = pr = ct.isSetRight() ? ct.getRight() : ct.addNewRight();
        if (border == 0) {
            ct.unsetRight();
        } else {
            pr.setStyle(STBorderStyle.Enum.forInt((int)(border + 1)));
        }
        int idx = this._stylesSource.putBorder(new XSSFCellBorder(ct, this._theme));
        this._cellXf.setBorderId((long)idx);
        this._cellXf.setApplyBorder(true);
    }

    public void setBorderRight(BorderStyle border) {
        this.setBorderRight((short)border.ordinal());
    }

    @Override
    public void setBorderTop(short border) {
        CTBorderPr pr;
        CTBorder ct = this.getCTBorder();
        CTBorderPr cTBorderPr = pr = ct.isSetTop() ? ct.getTop() : ct.addNewTop();
        if (border == 0) {
            ct.unsetTop();
        } else {
            pr.setStyle(STBorderStyle.Enum.forInt((int)(border + 1)));
        }
        int idx = this._stylesSource.putBorder(new XSSFCellBorder(ct, this._theme));
        this._cellXf.setBorderId((long)idx);
        this._cellXf.setApplyBorder(true);
    }

    public void setBorderTop(BorderStyle border) {
        this.setBorderTop((short)border.ordinal());
    }

    @Override
    public void setBottomBorderColor(short color) {
        XSSFColor clr = new XSSFColor();
        clr.setIndexed(color);
        this.setBottomBorderColor(clr);
    }

    public void setBottomBorderColor(XSSFColor color) {
        CTBorderPr pr;
        CTBorder ct = this.getCTBorder();
        if (color == null && !ct.isSetBottom()) {
            return;
        }
        CTBorderPr cTBorderPr = pr = ct.isSetBottom() ? ct.getBottom() : ct.addNewBottom();
        if (color != null) {
            pr.setColor(color.getCTColor());
        } else {
            pr.unsetColor();
        }
        int idx = this._stylesSource.putBorder(new XSSFCellBorder(ct, this._theme));
        this._cellXf.setBorderId((long)idx);
        this._cellXf.setApplyBorder(true);
    }

    @Override
    public void setDataFormat(short fmt) {
        if (this.isDefaultNumFmtId(fmt)) {
            if (this._cellXf.isSetApplyNumberFormat()) {
                this._cellXf.unsetApplyNumberFormat();
            }
        } else {
            this._cellXf.setApplyNumberFormat(true);
        }
        this._cellXf.setNumFmtId((long)fmt);
    }

    public void setFillBackgroundColor(XSSFColor color) {
        CTFill ct = this.getCTFill();
        CTPatternFill ptrn = ct.getPatternFill();
        if (color == null) {
            if (ptrn != null) {
                ptrn.unsetBgColor();
            }
        } else {
            if (ptrn == null) {
                ptrn = ct.addNewPatternFill();
            }
            ptrn.setBgColor(color.getCTColor());
        }
        int idx = this._stylesSource.putFill(new XSSFCellFill(ct));
        this._cellXf.setFillId((long)idx);
        this._cellXf.setApplyFill(true);
    }

    @Override
    public void setFillBackgroundColor(short bg) {
        XSSFColor clr = new XSSFColor();
        clr.setIndexed(bg);
        this.setFillBackgroundColor(clr);
    }

    public void setFillForegroundColor(XSSFColor color) {
        CTFill ct = this.getCTFill();
        CTPatternFill ptrn = ct.getPatternFill();
        if (color == null) {
            if (ptrn != null) {
                ptrn.unsetFgColor();
            }
        } else {
            if (ptrn == null) {
                ptrn = ct.addNewPatternFill();
            }
            ptrn.setFgColor(color.getCTColor());
        }
        int idx = this._stylesSource.putFill(new XSSFCellFill(ct));
        this._cellXf.setFillId((long)idx);
        this._cellXf.setApplyFill(true);
    }

    @Override
    public void setFillForegroundColor(short fg) {
        XSSFColor clr = new XSSFColor();
        clr.setIndexed(fg);
        this.setFillForegroundColor(clr);
    }

    private CTFill getCTFill() {
        CTFill ct;
        if (this._cellXf.getApplyFill()) {
            int fillIndex = this.getFillId();
            if (fillIndex < 0) {
                fillIndex = 0;
            }
            XSSFCellFill cf = this._stylesSource.getFillAt(fillIndex);
            ct = (CTFill)cf.getCTFill().copy();
        } else {
            ct = CTFill.Factory.newInstance();
        }
        return ct;
    }

    private CTBorder getCTBorder() {
        CTBorder ct;
        if (this._cellXf.getApplyBorder()) {
            int idx = (int)this._cellXf.getBorderId();
            XSSFCellBorder cf = this._stylesSource.getBorderAt(idx);
            ct = (CTBorder)cf.getCTBorder().copy();
        } else {
            ct = CTBorder.Factory.newInstance();
        }
        return ct;
    }

    @Override
    public void setFillPattern(short fp) {
        CTPatternFill ptrn;
        CTFill ct = this.getCTFill();
        CTPatternFill cTPatternFill = ptrn = ct.isSetPatternFill() ? ct.getPatternFill() : ct.addNewPatternFill();
        if (fp == 0 && ptrn.isSetPatternType()) {
            ptrn.unsetPatternType();
        } else {
            ptrn.setPatternType(STPatternType.Enum.forInt((int)(fp + 1)));
        }
        int idx = this._stylesSource.putFill(new XSSFCellFill(ct));
        this._cellXf.setFillId((long)idx);
        this._cellXf.setApplyFill(true);
    }

    public void setFillPattern(FillPatternType ptrn) {
        this.setFillPattern((short)ptrn.ordinal());
    }

    @Override
    public void setFont(Font font) {
        if (font != null) {
            long index = font.getIndex();
            this._cellXf.setFontId(index);
            if (this.isDefaultFontId(index)) {
                if (this._cellXf.isSetApplyFont()) {
                    this._cellXf.unsetApplyFont();
                }
            } else {
                this._cellXf.setApplyFont(true);
            }
        } else if (this._cellXf.isSetApplyFont()) {
            this._cellXf.unsetApplyFont();
        }
    }

    @Override
    public void setHidden(boolean hidden) {
        if (!this._cellXf.isSetProtection()) {
            this._cellXf.addNewProtection();
        }
        this._cellXf.getProtection().setHidden(hidden);
    }

    @Override
    public void setIndention(short indent) {
        this.getCellAlignment().setIndent(indent);
        this._cellXf.setApplyAlignment(true);
    }

    @Override
    public void setLeftBorderColor(short color) {
        XSSFColor clr = new XSSFColor();
        clr.setIndexed(color);
        this.setLeftBorderColor(clr);
    }

    public void setLeftBorderColor(XSSFColor color) {
        CTBorderPr pr;
        CTBorder ct = this.getCTBorder();
        if (color == null && !ct.isSetLeft()) {
            return;
        }
        CTBorderPr cTBorderPr = pr = ct.isSetLeft() ? ct.getLeft() : ct.addNewLeft();
        if (color != null) {
            pr.setColor(color.getCTColor());
        } else {
            pr.unsetColor();
        }
        int idx = this._stylesSource.putBorder(new XSSFCellBorder(ct, this._theme));
        this._cellXf.setBorderId((long)idx);
        this._cellXf.setApplyBorder(true);
    }

    @Override
    public void setLocked(boolean locked) {
        if (!this._cellXf.isSetProtection()) {
            this._cellXf.addNewProtection();
        }
        this._cellXf.getProtection().setLocked(locked);
    }

    @Override
    public void setRightBorderColor(short color) {
        XSSFColor clr = new XSSFColor();
        clr.setIndexed(color);
        this.setRightBorderColor(clr);
    }

    public void setRightBorderColor(XSSFColor color) {
        CTBorderPr pr;
        CTBorder ct = this.getCTBorder();
        if (color == null && !ct.isSetRight()) {
            return;
        }
        CTBorderPr cTBorderPr = pr = ct.isSetRight() ? ct.getRight() : ct.addNewRight();
        if (color != null) {
            pr.setColor(color.getCTColor());
        } else {
            pr.unsetColor();
        }
        int idx = this._stylesSource.putBorder(new XSSFCellBorder(ct, this._theme));
        this._cellXf.setBorderId((long)idx);
        this._cellXf.setApplyBorder(true);
    }

    @Override
    public void setRotation(short rotation) {
        this.getCellAlignment().setTextRotation(rotation);
        this._cellXf.setApplyAlignment(true);
    }

    @Override
    public void setTopBorderColor(short color) {
        XSSFColor clr = new XSSFColor();
        clr.setIndexed(color);
        this.setTopBorderColor(clr);
    }

    public void setTopBorderColor(XSSFColor color) {
        CTBorderPr pr;
        CTBorder ct = this.getCTBorder();
        if (color == null && !ct.isSetTop()) {
            return;
        }
        CTBorderPr cTBorderPr = pr = ct.isSetTop() ? ct.getTop() : ct.addNewTop();
        if (color != null) {
            pr.setColor(color.getCTColor());
        } else {
            pr.unsetColor();
        }
        int idx = this._stylesSource.putBorder(new XSSFCellBorder(ct, this._theme));
        this._cellXf.setBorderId((long)idx);
        this._cellXf.setApplyBorder(true);
    }

    @Override
    public void setVerticalAlignment(short align) {
        this.getCellAlignment().setVertical(VerticalAlignment.values()[align]);
        this._cellXf.setApplyAlignment(true);
    }

    public void setVerticalAlignment(VerticalAlignment align) {
        this.getCellAlignment().setVertical(align);
        this._cellXf.setApplyAlignment(true);
    }

    @Override
    public void setWrapText(boolean wrapped) {
        this.getCellAlignment().setWrapText(wrapped);
        this._cellXf.setApplyAlignment(true);
    }

    public XSSFColor getBorderColor(XSSFCellBorder.BorderSide side) {
        switch (side) {
            case BOTTOM: {
                return this.getBottomBorderXSSFColor();
            }
            case RIGHT: {
                return this.getRightBorderXSSFColor();
            }
            case TOP: {
                return this.getTopBorderXSSFColor();
            }
            case LEFT: {
                return this.getLeftBorderXSSFColor();
            }
        }
        throw new IllegalArgumentException("Unknown border: " + (Object)((Object)side));
    }

    public void setBorderColor(XSSFCellBorder.BorderSide side, XSSFColor color) {
        switch (side) {
            case BOTTOM: {
                this.setBottomBorderColor(color);
                break;
            }
            case RIGHT: {
                this.setRightBorderColor(color);
                break;
            }
            case TOP: {
                this.setTopBorderColor(color);
                break;
            }
            case LEFT: {
                this.setLeftBorderColor(color);
                break;
            }
            case DIAGONAL: {
                this.setDiagonalBorderColor(color);
                break;
            }
            case HORIZONTAL: {
                this.setHorizontalBorderColor(color);
                break;
            }
            case VERTICAL: {
                this.setVerticalBorderColor(color);
            }
        }
    }

    private int getFontId() {
        if (this._cellXf != null && this._cellXf.isSetFontId()) {
            return (int)this._cellXf.getFontId();
        }
        return (int)this._cellStyleXf.getFontId();
    }

    protected XSSFCellAlignment getCellAlignment() {
        if (this._cellAlignment == null) {
            this._cellAlignment = new XSSFCellAlignment(this.getCTCellAlignment());
        }
        return this._cellAlignment;
    }

    private CTCellAlignment getCTCellAlignment() {
        if (this._cellXf != null && this._cellXf.getAlignment() == null) {
            this._cellXf.setAlignment(CTCellAlignment.Factory.newInstance());
        }
        return this._cellXf.getAlignment();
    }

    public int hashCode() {
        return this._cellXf != null ? this._cellXf.toString().hashCode() : this._cellStyleXf.toString().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof XSSFCellStyle)) {
            return false;
        }
        XSSFCellStyle cf = (XSSFCellStyle)o;
        return this._cellXf != null ? this._cellXf.toString().equals(cf.getCoreXf().toString()) : this._cellStyleXf.toString().equals(cf.getStyleXf().toString());
    }

    public Object clone() {
        CTXf xf = (CTXf)this._cellXf.copy();
        int xfSize = this._stylesSource._getStyleXfsSize();
        int indexXf = this._stylesSource.putCellXf(xf);
        return new XSSFCellStyle(indexXf - 1, xfSize - 1, this._stylesSource, this._theme);
    }

    private void extractColorFromTheme(XSSFColor originalColor) {
        XSSFColor themeColor = this._theme.getThemeColor(originalColor.getTheme());
        if (themeColor != null) {
            originalColor.setRgb(themeColor.getRgb());
        }
    }

    @Override
    public XSSFColor getLeftBorderColorColor() {
        return this.getLeftBorderXSSFColor();
    }

    @Override
    public XSSFColor getRightBorderColorColor() {
        return this.getRightBorderXSSFColor();
    }

    @Override
    public XSSFColor getTopBorderColorColor() {
        return this.getTopBorderXSSFColor();
    }

    @Override
    public XSSFColor getBottomBorderColorColor() {
        return this.getBottomBorderXSSFColor();
    }

    @Override
    public void setFontColorColor(Color color) {
        this.setFontColorColor((XSSFColor)color);
    }

    private void setFontColorColor(XSSFColor color) {
        this.getFont().setColor(color);
    }

    @Internal
    public CTXf getCellXf() {
        return this._cellXf;
    }

    @Override
    @Internal
    public void setBorder(short left, Color leftColor, short top, Color topColor, short right, Color rightColor, short bottom, Color bottomColor) {
        XSSFCellBorder border = new XSSFCellBorder(this.getCTBorder());
        border.prepareBorder(left, leftColor, top, topColor, right, rightColor, bottom, bottomColor);
        List<XSSFCellBorder> borders = this._stylesSource.getBorders();
        int bj = borders.indexOf(border);
        if (bj < 0) {
            bj = borders.size();
            borders.add(border);
        } else {
            border = borders.get(bj);
        }
        this._cellXf.setBorderId((long)bj);
        if (this.isDefaultBorderId(bj)) {
            if (this._cellXf.isSetApplyBorder()) {
                this._cellXf.unsetApplyBorder();
            }
        } else {
            this._cellXf.setApplyBorder(true);
        }
    }

    @Override
    public void setFill(Color fillColor, Color backColor, short patternType) {
        CTFill ct = this.getCTFill();
        XSSFCellFill fill = new XSSFCellFill(ct);
        fill.prepareFill(fillColor, backColor, patternType);
        List<XSSFCellFill> fills = this._stylesSource.getFills();
        int fj = fills.indexOf(fill);
        if (fj < 0) {
            fj = fills.size();
            fills.add(fill);
        } else {
            fill = fills.get(fj);
        }
        this._cellXf.setFillId((long)fj);
        if (this.isDefaultFillId(fj)) {
            if (this._cellXf.isSetApplyFill()) {
                this._cellXf.unsetApplyFill();
            }
        } else {
            this._cellXf.setApplyFill(true);
        }
    }

    @Override
    @Deprecated
    public void setCellAlignment(short hAlign, short vAlign, boolean wrapText) {
        this.setCellAlignment(hAlign, vAlign, wrapText, (short)0);
    }

    @Override
    public void setCellAlignment(short hAlign, short vAlign, boolean wrapText, short rotation) {
        short defaultHAlign = 0;
        short defaultVAlign = 2;
        boolean defaultWrapText = false;
        short defaultTextRotation = 0;
        if (defaultHAlign != hAlign) {
            this.setAlignment(hAlign);
        }
        if (defaultVAlign == vAlign) {
            this._cellXf.setApplyAlignment(true);
        } else {
            this.setVerticalAlignment(vAlign);
        }
        if (defaultWrapText != wrapText && wrapText) {
            this.setWrapText(wrapText);
        }
        if (defaultTextRotation != rotation) {
            this.setRotation(rotation);
        }
    }

    @Override
    public void setProtection(boolean locked, boolean hidden) {
        boolean defaultLocked = true;
        boolean defaultHidden = false;
        if (this._cellStyleXf != null && this._cellStyleXf.isSetProtection()) {
            CTCellProtection ctprot = this._cellStyleXf.getProtection();
            if (ctprot.isSetHidden()) {
                defaultHidden = ctprot.getHidden();
            }
            if (ctprot.isSetLocked()) {
                defaultLocked = ctprot.getLocked();
            }
        }
        if (locked != defaultLocked && !locked) {
            this.setLocked(locked);
        }
        if (hidden != defaultHidden && !hidden) {
            this.setHidden(hidden);
        }
        if (this._cellXf.isSetProtection()) {
            this._cellXf.setApplyProtection(true);
        }
    }

    @Override
    public void setBorderDiagonal(short border) {
        CTBorderPr pr;
        CTBorder ct = this.getCTBorder();
        CTBorderPr cTBorderPr = pr = ct.isSetDiagonal() ? ct.getDiagonal() : ct.addNewDiagonal();
        if (border == 0) {
            ct.unsetDiagonal();
        } else {
            pr.setStyle(STBorderStyle.Enum.forInt((int)(border + 1)));
        }
        int idx = this._stylesSource.putBorder(new XSSFCellBorder(ct, this._theme));
        this._cellXf.setBorderId((long)idx);
        this._cellXf.setApplyBorder(true);
    }

    @Override
    public short getBorderDiagonal() {
        int idx;
        if (this._cellXf != null && this._cellXf.getApplyBorder()) {
            int idx2 = (int)this._cellXf.getBorderId();
            CTBorder ct = this._stylesSource.getBorderAt(idx2).getCTBorder();
            STBorderStyle.Enum ptrn = ct.isSetLeft() ? ct.getLeft().getStyle() : null;
            return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
        }
        int n = idx = this._cellStyleXf == null ? -1 : (int)this._cellStyleXf.getBorderId();
        if (idx >= 0) {
            CTBorder ct = this._stylesSource.getBorderAt(idx).getCTBorder();
            STBorderStyle.Enum ptrn = ct.isSetLeft() ? ct.getLeft().getStyle() : null;
            return ptrn == null ? (short)0 : (short)(ptrn.intValue() - 1);
        }
        return 0;
    }

    @Override
    public Color getDiagonalBorderColorColor() {
        return this.getDiagonalBorderXSSFColor();
    }

    @Override
    public void setDiagonalBorderColor(short color) {
        XSSFColor clr = new XSSFColor();
        clr.setIndexed(color);
        this.setDiagonalBorderColor(clr);
    }

    @Override
    public short getDiagonalBorderColor() {
        XSSFColor clr = this.getDiagonalBorderXSSFColor();
        return clr == null ? IndexedColors.BLACK.getIndex() : clr.getIndexed();
    }

    public XSSFColor getDiagonalBorderXSSFColor() {
        if (this._cellXf != null && this._cellXf.getApplyBorder()) {
            int idx = (int)this._cellXf.getBorderId();
            XSSFCellBorder border = this._stylesSource.getBorderAt(idx);
            return border.getBorderColor(XSSFCellBorder.BorderSide.DIAGONAL);
        }
        if (this._cellStyleXf != null) {
            int idx = (int)this._cellStyleXf.getBorderId();
            XSSFCellBorder border = this._stylesSource.getBorderAt(idx);
            return border.getBorderColor(XSSFCellBorder.BorderSide.DIAGONAL);
        }
        return null;
    }

    public XSSFColor getVerticalBorderXSSFColor() {
        if (this._cellXf != null && this._cellXf.getApplyBorder()) {
            int idx = (int)this._cellXf.getBorderId();
            XSSFCellBorder border = this._stylesSource.getBorderAt(idx);
            return border.getBorderColor(XSSFCellBorder.BorderSide.VERTICAL);
        }
        if (this._cellStyleXf != null) {
            int idx = (int)this._cellStyleXf.getBorderId();
            XSSFCellBorder border = this._stylesSource.getBorderAt(idx);
            return border.getBorderColor(XSSFCellBorder.BorderSide.VERTICAL);
        }
        return null;
    }

    public XSSFColor getHorizontalBorderXSSFColor() {
        if (this._cellXf != null && this._cellXf.getApplyBorder()) {
            int idx = (int)this._cellXf.getBorderId();
            XSSFCellBorder border = this._stylesSource.getBorderAt(idx);
            return border.getBorderColor(XSSFCellBorder.BorderSide.HORIZONTAL);
        }
        if (this._cellStyleXf != null) {
            int idx = (int)this._cellStyleXf.getBorderId();
            XSSFCellBorder border = this._stylesSource.getBorderAt(idx);
            return border.getBorderColor(XSSFCellBorder.BorderSide.HORIZONTAL);
        }
        return null;
    }

    public void setDiagonalBorderColor(XSSFColor color) {
        CTBorderPr pr;
        CTBorder ct = this.getCTBorder();
        if (color == null && !ct.isSetDiagonal()) {
            return;
        }
        CTBorderPr cTBorderPr = pr = ct.isSetDiagonal() ? ct.getDiagonal() : ct.addNewDiagonal();
        if (color != null) {
            pr.setColor(color.getCTColor());
        } else {
            pr.unsetColor();
        }
        int idx = this._stylesSource.putBorder(new XSSFCellBorder(ct, this._theme));
        this._cellXf.setBorderId((long)idx);
        this._cellXf.setApplyBorder(true);
    }

    public void setHorizontalBorderColor(XSSFColor color) {
        CTBorderPr pr;
        CTBorder ct = this.getCTBorder();
        if (color == null && !ct.isSetHorizontal()) {
            return;
        }
        CTBorderPr cTBorderPr = pr = ct.isSetHorizontal() ? ct.getHorizontal() : ct.addNewHorizontal();
        if (color != null) {
            pr.setColor(color.getCTColor());
        } else {
            pr.unsetColor();
        }
        int idx = this._stylesSource.putBorder(new XSSFCellBorder(ct, this._theme));
        this._cellXf.setBorderId((long)idx);
        this._cellXf.setApplyBorder(true);
    }

    public void setVerticalBorderColor(XSSFColor color) {
        CTBorderPr pr;
        CTBorder ct = this.getCTBorder();
        if (color == null && !ct.isSetVertical()) {
            return;
        }
        CTBorderPr cTBorderPr = pr = ct.isSetVertical() ? ct.getVertical() : ct.addNewVertical();
        if (color != null) {
            pr.setColor(color.getCTColor());
        } else {
            pr.unsetColor();
        }
        int idx = this._stylesSource.putBorder(new XSSFCellBorder(ct, this._theme));
        this._cellXf.setBorderId((long)idx);
        this._cellXf.setApplyBorder(true);
    }

    @Override
    public boolean isShowDiagonalUpBorder() {
        CTBorder ct = this.getCTBorder();
        return ct.getDiagonalUp();
    }

    @Override
    public boolean isShowDiagonalDownBorder() {
        CTBorder ct = this.getCTBorder();
        return ct.getDiagonalDown();
    }

    @Override
    public void setShowDiagonalUpBorder(boolean up) {
        CTBorder ct = this.getCTBorder();
        ct.setDiagonalUp(up);
    }

    @Override
    public void setShowDiagonalDownBorder(boolean down) {
        CTBorder ct = this.getCTBorder();
        ct.setDiagonalDown(down);
    }

    @Override
    @Internal
    public void setBorder(short left, Color leftColor, short top, Color topColor, short right, Color rightColor, short bottom, Color bottomColor, short diagonal, Color diagonalColor, short horizontal, Color horizontalColor, short vertical, Color verticalColor, boolean diaUp, boolean diaDown) {
        List<XSSFCellBorder> borders;
        int bj;
        CTBorder ct = this.getCTBorder();
        XSSFCellBorder border = new XSSFCellBorder(ct);
        border.setDiagonalUp(diaUp);
        border.setDiagonalDown(diaDown);
        border.setBorderStyle(XSSFCellBorder.BorderSide.LEFT, left);
        border.setBorderStyle(XSSFCellBorder.BorderSide.TOP, top);
        border.setBorderStyle(XSSFCellBorder.BorderSide.RIGHT, right);
        border.setBorderStyle(XSSFCellBorder.BorderSide.BOTTOM, bottom);
        border.setBorderStyle(XSSFCellBorder.BorderSide.DIAGONAL, diagonal);
        border.setBorderStyle(XSSFCellBorder.BorderSide.HORIZONTAL, horizontal);
        border.setBorderStyle(XSSFCellBorder.BorderSide.VERTICAL, vertical);
        if (left != 0) {
            border.setBorderColor(XSSFCellBorder.BorderSide.LEFT, (XSSFColor)leftColor);
        }
        if (top != 0) {
            border.setBorderColor(XSSFCellBorder.BorderSide.TOP, (XSSFColor)topColor);
        }
        if (right != 0) {
            border.setBorderColor(XSSFCellBorder.BorderSide.RIGHT, (XSSFColor)rightColor);
        }
        if (bottom != 0) {
            border.setBorderColor(XSSFCellBorder.BorderSide.BOTTOM, (XSSFColor)bottomColor);
        }
        if (diagonal != 0) {
            border.setBorderColor(XSSFCellBorder.BorderSide.DIAGONAL, (XSSFColor)diagonalColor);
        }
        if (horizontal != 0) {
            border.setBorderColor(XSSFCellBorder.BorderSide.HORIZONTAL, (XSSFColor)horizontalColor);
        }
        if (vertical != 0) {
            border.setBorderColor(XSSFCellBorder.BorderSide.VERTICAL, (XSSFColor)verticalColor);
        }
        if ((bj = (borders = this._stylesSource.getBorders()).indexOf(border)) < 0) {
            bj = borders.size();
            borders.add(border);
        } else {
            border = borders.get(bj);
        }
        this._cellXf.setBorderId((long)bj);
        if (this.isDefaultBorderId(bj)) {
            if (this._cellXf.isSetApplyBorder()) {
                this._cellXf.unsetApplyBorder();
            }
        } else {
            this._cellXf.setApplyBorder(true);
        }
    }

    public void setDefaultCellAlignment(short hAlign, short vAlign, boolean wrapText) {
        short defaultHAlign = 0;
        short defaultVAlign = 2;
        boolean defaultWrapText = false;
        if (this._cellStyleXf != null && this._cellStyleXf.isSetAlignment()) {
            CTCellAlignment ctalign = this._cellStyleXf.getAlignment();
            if (ctalign.isSetHorizontal()) {
                defaultHAlign = (short)(ctalign.getHorizontal().intValue() - 1);
            }
            if (ctalign.isSetVertical()) {
                defaultVAlign = (short)(ctalign.getVertical().intValue() - 1);
            }
            if (ctalign.isSetWrapText()) {
                defaultWrapText = ctalign.getWrapText();
            }
        }
        if (defaultHAlign != hAlign && hAlign != 0) {
            if (!this._cellStyleXf.isSetAlignment()) {
                this._cellStyleXf.setAlignment(CTCellAlignment.Factory.newInstance());
            }
            this._cellStyleXf.getAlignment().setHorizontal(STHorizontalAlignment.Enum.forInt((int)(hAlign + 1)));
        }
        if (defaultVAlign != vAlign && vAlign != 2) {
            if (!this._cellStyleXf.isSetAlignment()) {
                this._cellStyleXf.setAlignment(CTCellAlignment.Factory.newInstance());
            }
            this._cellStyleXf.getAlignment().setVertical(STVerticalAlignment.Enum.forInt((int)(vAlign + 1)));
        }
        if (defaultWrapText != wrapText && wrapText) {
            if (!this._cellStyleXf.isSetAlignment()) {
                this._cellStyleXf.setAlignment(CTCellAlignment.Factory.newInstance());
            }
            this._cellStyleXf.getAlignment().setWrapText(wrapText);
        }
    }

    public void setDefaultProtection(boolean locked, boolean hidden) {
        boolean defaultLocked = true;
        boolean defaultHidden = false;
        if (locked != defaultLocked && !locked) {
            if (!this._cellStyleXf.isSetProtection()) {
                this._cellStyleXf.addNewProtection();
            }
            this._cellStyleXf.getProtection().setLocked(locked);
        }
        if (hidden != defaultHidden && !hidden) {
            if (!this._cellStyleXf.isSetProtection()) {
                this._cellStyleXf.addNewProtection();
            }
            this._cellStyleXf.getProtection().setHidden(hidden);
        }
    }

    private boolean isDefaultFillId(int fj) {
        return this._cellStyleXf != null && this._cellStyleXf.isSetFillId() && this._cellStyleXf.getFillId() == (long)fj;
    }

    private boolean isDefaultBorderId(int bj) {
        return this._cellStyleXf != null && this._cellStyleXf.isSetBorderId() && this._cellStyleXf.getBorderId() == (long)bj;
    }

    private boolean isDefaultFontId(long fj) {
        return this._cellStyleXf != null && this._cellStyleXf.isSetFontId() && this._cellStyleXf.getFontId() == fj;
    }

    private boolean isDefaultNumFmtId(int nj) {
        return this._cellStyleXf != null && this._cellStyleXf.isSetNumFmtId() && this._cellStyleXf.getNumFmtId() == (long)nj;
    }
}

