/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.api;

import io.keikai.api.AreaRef;
import io.keikai.ui.CellSelectionType;
import org.zkoss.poi.ss.util.AreaReference;
import org.zkoss.poi.ss.util.CellReference;

public class AreaRefWithType
extends AreaRef {
    private static final long serialVersionUID = -9010990229255383948L;
    protected CellSelectionType _type = CellSelectionType.CELL;

    public AreaRefWithType(int row, int column, int lastRow, int lastColumn, CellSelectionType type) {
        this.setArea(row, column, lastRow, lastColumn);
        this._type = type;
    }

    @Override
    public Object cloneSelf() {
        return new AreaRefWithType(this._row, this._column, this._lastRow, this._lastColumn, this._type);
    }

    @Override
    public boolean contains(int tRow, int lCol, int bRow, int rCol) {
        if (this._type == CellSelectionType.ALL) {
            return true;
        }
        if (this._type == CellSelectionType.COLUMN) {
            return tRow >= this._row && bRow <= this._lastRow;
        }
        if (this._type == CellSelectionType.ROW) {
            return lCol >= this._column && rCol <= this._lastColumn;
        }
        return tRow >= this._row && lCol >= this._column && bRow <= this._lastRow && rCol <= this._lastColumn;
    }

    @Override
    public boolean overlap(int bTopRow, int bLeftCol, int bBottomRow, int bRightCol) {
        boolean xOverlap = this._type == CellSelectionType.COLUMN || this.isBetween(this._column, bLeftCol, bRightCol) || this.isBetween(bLeftCol, this._column, this._lastColumn);
        boolean yOverlap = this._type == CellSelectionType.ROW || this.isBetween(this._row, bTopRow, bBottomRow) || this.isBetween(bTopRow, this._row, this._lastRow);
        return xOverlap && yOverlap;
    }

    public boolean overlap(AreaRefWithType areaRef) {
        return this.overlap(areaRef._row, areaRef._column, areaRef._lastRow, areaRef._lastColumn);
    }

    private boolean isBetween(int value, int min, int max) {
        return value >= min && value <= max;
    }

    @Override
    public String asString() {
        return new AreaReference(new CellReference(this._row, this._column), new CellReference(this._lastRow, this._lastColumn)).formatAsString();
    }

    @Override
    public int hashCode() {
        return this._row << 14 + this._column + this._lastRow << 14 + this._lastColumn + this._type.ordinal() * 31;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof AreaRefWithType && ((AreaRef)obj)._column == this._column && ((AreaRef)obj)._lastColumn == this._lastColumn && ((AreaRef)obj)._row == this._row && ((AreaRef)obj)._lastRow == this._lastRow && ((AreaRefWithType)obj)._type == this._type;
    }

    public void setSelType(CellSelectionType type) {
        this._type = type;
    }

    public CellSelectionType getSelType() {
        return this._type;
    }
}

