/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.api;

import java.io.Serializable;
import org.zkoss.poi.ss.util.AreaReference;
import org.zkoss.poi.ss.util.CellReference;

public class AreaRef
implements Serializable {
    private static final long serialVersionUID = 8864825038504082277L;
    protected int _column = -1;
    protected int _row = -1;
    protected int _lastColumn = -1;
    protected int _lastRow = -1;

    public AreaRef() {
    }

    public AreaRef(int row, int column, int lastRow, int lastColumn) {
        this.setArea(row, column, lastRow, lastColumn);
    }

    public AreaRef(String areaReference) {
        AreaReference ar = new AreaReference(areaReference);
        this.setArea(ar.getFirstCell().getRow(), ar.getFirstCell().getCol(), ar.getLastCell().getRow(), ar.getLastCell().getCol());
    }

    public void setArea(int row, int column, int lastRow, int lastColumn) {
        this._column = column;
        this._row = row;
        this._lastColumn = lastColumn;
        this._lastRow = lastRow;
    }

    public int getColumn() {
        return this._column;
    }

    public void setColumn(int column) {
        this._column = column;
    }

    public int getRow() {
        return this._row;
    }

    public void setRow(int row) {
        this._row = row;
    }

    public int getLastColumn() {
        return this._lastColumn;
    }

    public void setLastColumn(int lastColumn) {
        this._lastColumn = lastColumn;
    }

    public int getLastRow() {
        return this._lastRow;
    }

    public void setLastRow(int lastRow) {
        this._lastRow = lastRow;
    }

    public Object cloneSelf() {
        return new AreaRef(this._row, this._column, this._lastRow, this._lastColumn);
    }

    public boolean contains(int tRow, int lCol, int bRow, int rCol) {
        return tRow >= this._row && lCol >= this._column && bRow <= this._lastRow && rCol <= this._lastColumn;
    }

    public boolean overlap(int bTopRow, int bLeftCol, int bBottomRow, int bRightCol) {
        boolean xOverlap = this.isBetween(this._column, bLeftCol, bRightCol) || this.isBetween(bLeftCol, this._column, this._lastColumn);
        boolean yOverlap = this.isBetween(this._row, bTopRow, bBottomRow) || this.isBetween(bTopRow, this._row, this._lastRow);
        return xOverlap && yOverlap;
    }

    private boolean isBetween(int value, int min, int max) {
        return value >= min && value <= max;
    }

    public String asString() {
        return new AreaReference(new CellReference(this._row, this._column), new CellReference(this._lastRow, this._lastColumn)).formatAsString();
    }

    public int hashCode() {
        return this._row << 14 + this._column + this._lastRow << 14 + this._lastColumn;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof AreaRef && ((AreaRef)obj)._column == this._column && ((AreaRef)obj)._lastColumn == this._lastColumn && ((AreaRef)obj)._row == this._row && ((AreaRef)obj)._lastRow == this._lastRow;
    }
}

