/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel.charts;

import java.util.ArrayList;
import java.util.List;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAxDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTGrouping;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTLine3DChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTLineSer;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPlotArea;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTSerTx;
import org.zkoss.poi.ss.usermodel.Chart;
import org.zkoss.poi.ss.usermodel.charts.AbstractCategoryDataSerie;
import org.zkoss.poi.ss.usermodel.charts.CategoryData;
import org.zkoss.poi.ss.usermodel.charts.CategoryDataSerie;
import org.zkoss.poi.ss.usermodel.charts.ChartAxis;
import org.zkoss.poi.ss.usermodel.charts.ChartDataSource;
import org.zkoss.poi.ss.usermodel.charts.ChartGrouping;
import org.zkoss.poi.ss.usermodel.charts.ChartTextSource;
import org.zkoss.poi.xssf.usermodel.XSSFChart;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartAxDataSource;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartNumDataSource;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartTextSource;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartUtil;

public class XSSFLine3DChartData
implements CategoryData {
    private ChartGrouping _chartGrouping;
    private CTLine3DChart ctLine3DChart;
    private List<CategoryDataSerie> series = new ArrayList<CategoryDataSerie>();

    public XSSFLine3DChartData() {
    }

    public XSSFLine3DChartData(XSSFChart chart) {
        this();
        CTPlotArea plotArea = chart.getCTChart().getPlotArea();
        CTLine3DChart[] plotCharts = plotArea.getLine3DChartArray();
        if (plotCharts != null && plotCharts.length > 0) {
            this.ctLine3DChart = plotCharts[0];
        }
        if (this.ctLine3DChart != null) {
            CTLineSer[] bsers = this.ctLine3DChart.getSerArray();
            for (int j = 0; j < bsers.length; ++j) {
                CTLineSer ser = bsers[j];
                CTSerTx serTx = ser.getTx();
                XSSFChartTextSource title = serTx == null ? null : new XSSFChartTextSource(serTx);
                XSSFChartAxDataSource cats = new XSSFChartAxDataSource(ser.getCat());
                XSSFChartNumDataSource vals = new XSSFChartNumDataSource(ser.getVal());
                this.addSerie(title, cats, vals);
            }
        }
    }

    @Override
    public CategoryDataSerie addSerie(ChartTextSource title, ChartDataSource<?> cats, ChartDataSource<? extends Number> vals) {
        if (!vals.isNumeric()) {
            throw new IllegalArgumentException("Pie data source must be numeric.");
        }
        int numOfSeries = this.series.size();
        Serie newSerie = new Serie(numOfSeries, numOfSeries, title, cats, vals);
        this.series.add(newSerie);
        return newSerie;
    }

    @Override
    public void fillChart(Chart chart, ChartAxis ... axis) {
        if (!(chart instanceof XSSFChart)) {
            throw new IllegalArgumentException("Chart must be instance of XSSFChart");
        }
        if (this.ctLine3DChart == null) {
            XSSFChart xssfChart = (XSSFChart)chart;
            CTPlotArea plotArea = xssfChart.getCTChart().getPlotArea();
            this.ctLine3DChart = plotArea.addNewLine3DChart();
            this.ctLine3DChart.addNewVaryColors().setVal(true);
            for (CategoryDataSerie s : this.series) {
                ((Serie)s).addToChart(this.ctLine3DChart);
            }
        }
        for (ChartAxis a : axis) {
            this.ctLine3DChart.addNewAxId().setVal(a.getId());
        }
    }

    @Override
    public List<? extends CategoryDataSerie> getSeries() {
        return this.series;
    }

    public ChartGrouping getGrouping() {
        if (this.ctLine3DChart != null) {
            this._chartGrouping = XSSFChartUtil.toChartGrouping(this.ctLine3DChart.getGrouping());
        }
        return this._chartGrouping;
    }

    public void setGrouping(ChartGrouping grouping) {
        this._chartGrouping = grouping;
        if (this.ctLine3DChart != null) {
            CTGrouping ctgr = this.ctLine3DChart.getGrouping();
            if (ctgr == null) {
                ctgr = this.ctLine3DChart.addNewGrouping();
            }
            ctgr.setVal(XSSFChartUtil.fromChartGrouping(grouping));
        }
    }

    static class Serie
    extends AbstractCategoryDataSerie {
        protected Serie(int id, int order, ChartTextSource title, ChartDataSource<?> cats, ChartDataSource<? extends Number> vals) {
            super(id, order, title, cats, vals);
        }

        protected void addToChart(CTLine3DChart ctLine3DChart) {
            CTLineSer lineSer = ctLine3DChart.addNewSer();
            lineSer.addNewIdx().setVal((long)this.id);
            lineSer.addNewOrder().setVal((long)this.order);
            if (this.title != null) {
                CTSerTx tx = lineSer.addNewTx();
                XSSFChartUtil.buildSerTx(tx, this.title);
            }
            if (this.categories != null && this.categories.getPointCount() > 0) {
                CTAxDataSource cats = lineSer.addNewCat();
                XSSFChartUtil.buildAxDataSource(cats, this.categories);
            }
            CTNumDataSource vals = lineSer.addNewVal();
            XSSFChartUtil.buildNumDataSource(vals, this.values);
        }
    }
}

