/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hsmf.dev;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.zkoss.poi.hsmf.datatypes.MAPIProperty;

public class TypesLister {
    public void listByName(PrintStream out) {
        ArrayList<MAPIProperty> all = new ArrayList<MAPIProperty>(MAPIProperty.getAll());
        Collections.sort(all, new Comparator<MAPIProperty>(){

            @Override
            public int compare(MAPIProperty a, MAPIProperty b) {
                return a.name.compareTo(b.name);
            }
        });
        this.list(all, out);
    }

    public void listById(PrintStream out) {
        ArrayList<MAPIProperty> all = new ArrayList<MAPIProperty>(MAPIProperty.getAll());
        Collections.sort(all, new Comparator<MAPIProperty>(){

            @Override
            public int compare(MAPIProperty a, MAPIProperty b) {
                if (a.id < b.id) {
                    return -1;
                }
                if (a.id > b.id) {
                    return 1;
                }
                return 0;
            }
        });
        this.list(all, out);
    }

    private void list(ArrayList<MAPIProperty> list, PrintStream out) {
        for (MAPIProperty attr : list) {
            String id = Integer.toHexString(attr.id);
            while (id.length() < 4) {
                id = "0" + id;
            }
            int typeId = attr.usualType.getId();
            String typeIdStr = Integer.toString(typeId);
            if (typeId > 0) {
                typeIdStr = typeIdStr + " / 0x" + Integer.toHexString(typeId);
            }
            out.println("0x" + id + " - " + attr.name);
            out.println("   " + attr.id + " - " + attr.usualType.getName() + " (" + typeIdStr + ") - " + attr.mapiProperty);
        }
    }

    public static void main(String[] args) {
        TypesLister lister = new TypesLister();
        lister.listByName(System.out);
        System.out.println();
        lister.listById(System.out);
    }
}

