/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl.undo;

import io.keikai.api.AreaRef;
import io.keikai.api.model.Book;
import io.keikai.api.model.Sheet;
import io.keikai.model.CellRegion;
import io.keikai.model.SSheet;
import io.keikai.range.SRanges;
import io.keikai.ui.sys.UndoableAction;
import java.io.Serializable;

public abstract class AbstractUndoableAction
implements UndoableAction,
Serializable {
    private static final long serialVersionUID = 8195847130717516048L;
    protected final String _label;
    protected final Sheet _sheet;
    protected final int _row;
    protected final int _column;
    protected final int _lastRow;
    protected final int _lastColumn;
    protected final boolean _wholeColumn;
    protected final boolean _wholeRow;

    public AbstractUndoableAction(String label, Sheet sheet, int row, int column, int lastRow, int lastColumn, boolean wholeColumn, boolean wholeRow) {
        this._label = label;
        this._sheet = sheet;
        this._row = row;
        this._column = column;
        this._lastRow = lastRow;
        this._lastColumn = lastColumn;
        this._wholeColumn = wholeColumn;
        this._wholeRow = wholeRow;
    }

    @Deprecated
    public AbstractUndoableAction(String label, Sheet sheet, int row, int column, int lastRow, int lastColumn, boolean wholeColumn) {
        this(label, sheet, row, column, lastRow, lastColumn, wholeColumn, false);
    }

    public AbstractUndoableAction(String label, Sheet sheet, int row, int column, int lastRow, int lastColumn) {
        this(label, sheet, row, column, lastRow, lastColumn, false, false);
    }

    @Override
    public String getLabel() {
        return this._label;
    }

    protected boolean isSheetAvailable() {
        try {
            Book book = this._sheet.getBook();
            return book.getSheetIndex(this._sheet) >= 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean isSheetProtected() {
        try {
            return this._sheet.isProtected();
        }
        catch (Exception exception) {
            return true;
        }
    }

    protected boolean isAnyCellProtected(Sheet sheet, CellRegion cellRegion) {
        return SRanges.range((SSheet)sheet.getInternalSheet(), (CellRegion)cellRegion).isAnyCellProtected();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getLabel() + ": [" + this._row + "," + this._column + "," + this._lastRow + "," + this._lastColumn + "]").append(super.toString());
        return sb.toString();
    }

    @Override
    public AreaRef getUndoSelection() {
        return new AreaRef(this._row, this._column, this._lastRow, this._lastColumn);
    }

    @Override
    public AreaRef getRedoSelection() {
        return new AreaRef(this._row, this._column, this._lastRow, this._lastColumn);
    }

    @Override
    public Sheet getUndoSheet() {
        return this._sheet;
    }

    @Override
    public Sheet getRedoSheet() {
        return this._sheet;
    }
}

