/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationexecutor.impl;

import com.hazelcast.internal.tpcengine.Reactor;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.spi.impl.operationexecutor.impl.OperationQueue;
import java.util.Queue;

public class TpcOperationQueue
implements OperationQueue {
    private Reactor reactor;
    private final Queue<Object> normalQueue;
    private final Queue<Object> priorityQueue;

    public TpcOperationQueue(Queue<Object> normalQueue, Queue<Object> priorityQueue) {
        this.normalQueue = Preconditions.checkNotNull(normalQueue, "normalQueue");
        this.priorityQueue = Preconditions.checkNotNull(priorityQueue, "priorityQueue");
    }

    @Override
    public void add(Object task, boolean priority) {
        if (priority) {
            this.priorityQueue.offer(task);
        } else {
            this.normalQueue.offer(task);
        }
        this.reactor.wakeup();
    }

    @Override
    public Object take(boolean priorityOnly) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int normalSize() {
        return this.normalQueue.size();
    }

    @Override
    public int prioritySize() {
        return this.priorityQueue.size();
    }

    @Override
    public int size() {
        return this.normalQueue.size() + this.priorityQueue.size();
    }

    @Override
    public Object poll() {
        Object item = this.priorityQueue.poll();
        if (item != null) {
            return item;
        }
        return this.normalQueue.poll();
    }

    @Override
    public boolean isEmpty() {
        return this.normalQueue.isEmpty() && this.priorityQueue.isEmpty();
    }

    public void setReactor(Reactor reactor) {
        this.reactor = reactor;
    }
}

