/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.monitor.impl;

import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.monitor.LocalFlakeIdGeneratorStats;
import com.hazelcast.internal.util.Clock;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public class LocalFlakeIdGeneratorStatsImpl
implements LocalFlakeIdGeneratorStats {
    private static final AtomicLongFieldUpdater<LocalFlakeIdGeneratorStatsImpl> BATCH_COUNT = AtomicLongFieldUpdater.newUpdater(LocalFlakeIdGeneratorStatsImpl.class, "batchCount");
    private static final AtomicLongFieldUpdater<LocalFlakeIdGeneratorStatsImpl> ID_COUNT = AtomicLongFieldUpdater.newUpdater(LocalFlakeIdGeneratorStatsImpl.class, "idCount");
    @Probe(name="creationTime", unit=ProbeUnit.MS)
    private final long creationTime = Clock.currentTimeMillis();
    @Probe(name="batchCount")
    private volatile long batchCount;
    @Probe(name="idCount")
    private volatile long idCount;

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public long getBatchCount() {
        return this.batchCount;
    }

    @Override
    public long getIdCount() {
        return this.idCount;
    }

    public void update(int batchSize) {
        BATCH_COUNT.incrementAndGet(this);
        ID_COUNT.addAndGet(this, batchSize);
    }

    public String toString() {
        return "LocalFlakeIdStatsImpl{creationTime=" + this.creationTime + ", batchCount=" + this.batchCount + ", idCount=" + this.idCount + '}';
    }
}

