/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.impl;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientMetricsConfig;
import com.hazelcast.client.properties.ClientProperty;
import com.hazelcast.config.Config;
import com.hazelcast.config.MetricsConfig;
import com.hazelcast.config.MetricsJmxConfig;
import com.hazelcast.config.MetricsManagementCenterConfig;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class MetricsConfigHelper {
    private MetricsConfigHelper() {
    }

    public static void overrideMemberMetricsConfig(Config config, ILogger logger) {
        MetricsConfig metricsConfig = config.getMetricsConfig();
        MetricsManagementCenterConfig managementCenterConfig = metricsConfig.getManagementCenterConfig();
        MetricsJmxConfig jmxConfig = metricsConfig.getJmxConfig();
        MetricsConfigHelper.tryOverride(ClusterProperty.METRICS_ENABLED, config::getProperty, prop -> {
            MetricsConfig cfr_ignored_0 = (MetricsConfig)metricsConfig.setEnabled(Boolean.parseBoolean(prop));
        }, () -> Boolean.toString(metricsConfig.isEnabled()), "MetricsConfig.enabled", logger);
        MetricsConfigHelper.tryOverride(ClusterProperty.METRICS_MC_ENABLED, config::getProperty, prop -> managementCenterConfig.setEnabled(Boolean.parseBoolean(prop)), () -> Boolean.toString(managementCenterConfig.isEnabled()), "MetricsManagementCenterConfig.enabled", logger);
        MetricsConfigHelper.tryOverride(ClusterProperty.METRICS_MC_RETENTION, config::getProperty, prop -> managementCenterConfig.setRetentionSeconds(Integer.parseInt(prop)), () -> Integer.toString(managementCenterConfig.getRetentionSeconds()), "MetricsManagementCenterConfig.retentionSeconds", logger);
        MetricsConfigHelper.tryOverride(ClusterProperty.METRICS_JMX_ENABLED, config::getProperty, prop -> jmxConfig.setEnabled(Boolean.parseBoolean(prop)), () -> Boolean.toString(jmxConfig.isEnabled()), "MetricsJmxConfig.enabled", logger);
        MetricsConfigHelper.tryOverride(ClusterProperty.METRICS_COLLECTION_FREQUENCY, config::getProperty, prop -> {
            MetricsConfig cfr_ignored_0 = (MetricsConfig)metricsConfig.setCollectionFrequencySeconds(Integer.parseInt(prop));
        }, () -> Integer.toString(metricsConfig.getCollectionFrequencySeconds()), "MetricsConfig.collectionFrequencySeconds", logger);
    }

    public static void overrideClientMetricsConfig(ClientConfig config, ILogger logger) {
        ClientMetricsConfig metricsConfig = config.getMetricsConfig();
        MetricsJmxConfig jmxConfig = metricsConfig.getJmxConfig();
        MetricsConfigHelper.tryOverride(ClientProperty.STATISTICS_PERIOD_SECONDS, config::getProperty, prop -> {
            ClientMetricsConfig cfr_ignored_0 = (ClientMetricsConfig)metricsConfig.setCollectionFrequencySeconds(Integer.parseInt(prop));
        }, () -> Integer.toString(metricsConfig.getCollectionFrequencySeconds()), "ClientMetricsConfig.collectionFrequencySeconds", logger);
        MetricsConfigHelper.tryOverride(ClientProperty.STATISTICS_ENABLED, config::getProperty, prop -> {
            ClientMetricsConfig cfr_ignored_0 = (ClientMetricsConfig)metricsConfig.setEnabled(Boolean.parseBoolean(prop));
        }, () -> Boolean.toString(metricsConfig.isEnabled()), "ClientMetricsConfig.enabled", logger);
        MetricsConfigHelper.tryOverride(ClientProperty.METRICS_ENABLED, config::getProperty, prop -> {
            ClientMetricsConfig cfr_ignored_0 = (ClientMetricsConfig)metricsConfig.setEnabled(Boolean.parseBoolean(prop));
        }, () -> Boolean.toString(metricsConfig.isEnabled()), "ClientMetricsConfig.enabled", logger);
        MetricsConfigHelper.tryOverride(ClientProperty.METRICS_JMX_ENABLED, config::getProperty, prop -> jmxConfig.setEnabled(Boolean.parseBoolean(prop)), () -> Boolean.toString(jmxConfig.isEnabled()), "MetricsJmxConfig.enabled", logger);
        MetricsConfigHelper.tryOverride(ClientProperty.METRICS_COLLECTION_FREQUENCY, config::getProperty, prop -> {
            ClientMetricsConfig cfr_ignored_0 = (ClientMetricsConfig)metricsConfig.setCollectionFrequencySeconds(Integer.parseInt(prop));
        }, () -> Integer.toString(metricsConfig.getCollectionFrequencySeconds()), "ClientMetricsConfig.collectionFrequencySeconds", logger);
    }

    private static void tryOverride(HazelcastProperty property, Function<String, String> getPropertyValueFn, Consumer<String> setterFn, Supplier<String> getterFn, String configOverridden, ILogger logger) {
        String propertyValue = getPropertyValueFn.apply(property.getName());
        try {
            if (propertyValue != null) {
                setterFn.accept(propertyValue);
                logger.info(String.format("Overridden metrics configuration with system property '%s'='%s' -> '%s'='%s'", property, propertyValue, configOverridden, getterFn.get()));
            }
        }
        catch (Exception ex) {
            logger.warning(String.format("Failed to override metrics configuration with system property '%s'='%s'. Kept '%s'='%s'", property.getName(), propertyValue, configOverridden, getterFn.get()), ex);
        }
    }

    public static ProbeLevel memberMetricsLevel(HazelcastProperties properties, ILogger logger) {
        ProbeLevel probeLevel;
        boolean debugMetrics = properties.getBoolean(ClusterProperty.METRICS_DEBUG);
        ProbeLevel probeLevel2 = probeLevel = debugMetrics ? ProbeLevel.DEBUG : ProbeLevel.INFO;
        if (probeLevel == ProbeLevel.INFO) {
            logger.fine("Collecting debug metrics and sending to diagnostics is disabled");
        } else {
            logger.info("Collecting debug metrics and sending to diagnostics is enabled");
        }
        return probeLevel;
    }

    public static ProbeLevel clientMetricsLevel(HazelcastProperties properties, ILogger logger) {
        ProbeLevel probeLevel;
        boolean debugMetrics = properties.getBoolean(ClientProperty.METRICS_DEBUG);
        ProbeLevel probeLevel2 = probeLevel = debugMetrics ? ProbeLevel.DEBUG : ProbeLevel.INFO;
        if (probeLevel == ProbeLevel.INFO) {
            logger.fine("Collecting debug metrics and sending to diagnostics is disabled");
        } else {
            logger.info("Collecting debug metrics and sending to diagnostics is enabled");
        }
        return probeLevel;
    }
}

