/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.model;

import java.util.HashMap;
import java.util.logging.Level;
import org.compiere.model.MRequiredPlugin;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.launch.Framework;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(immediate=true)
public class RequiredPluginValidator
implements FrameworkListener {
    private static CLogger s_log = CLogger.getCLogger(RequiredPluginValidator.class);
    private BundleContext bundleContext;

    @Activate
    protected void activate(BundleContext context) {
        this.bundleContext = context;
        context.addFrameworkListener((FrameworkListener)this);
    }

    @Deactivate
    protected void deactivate(BundleContext context) {
        if (context != null) {
            context.removeFrameworkListener((FrameworkListener)this);
        } else if (this.bundleContext != null) {
            this.bundleContext.removeFrameworkListener((FrameworkListener)this);
        }
        this.bundleContext = null;
    }

    public void frameworkEvent(FrameworkEvent event) {
        Object eventType;
        switch (event.getType()) {
            case 2: {
                eventType = "ERROR";
                if (!s_log.isLoggable(Level.WARNING)) break;
                s_log.warning("DS Listener - OSGi Framework Error: " + event.getThrowable().getMessage());
                break;
            }
            case 8: {
                eventType = "STARTLEVEL_CHANGED";
                this.started();
                break;
            }
            default: {
                eventType = "OTHER (" + event.getType() + ")";
            }
        }
        if (s_log.isLoggable(Level.INFO)) {
            s_log.info("DS Listener - Received OSGi Framework Event: " + (String)eventType + (String)(event.getBundle() != null ? " from Bundle: " + event.getBundle().getSymbolicName() : ""));
        }
    }

    private void started() {
        if (!DB.isConnected()) {
            return;
        }
        HashMap<String, String> bundleList = new HashMap<String, String>();
        Bundle[] bundleArray = this.bundleContext.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            bundleList.put(bundle.getSymbolicName(), MRequiredPlugin.getBundleState(bundle));
            ++n2;
        }
        StringBuilder missingPluginMessage = new StringBuilder();
        for (MRequiredPlugin rp : MRequiredPlugin.get()) {
            if (bundleList.containsKey(rp.getPluginName())) {
                String state;
                String expectedState = rp.getPluginExpectedState();
                if (Util.isEmpty(expectedState) || expectedState.equals(state = (String)bundleList.get(rp.getPluginName()))) continue;
                missingPluginMessage.append("Required plugin ").append(rp.getPluginName()).append(" is ").append(state).append(" but required state is ").append(expectedState).append("\n");
                continue;
            }
            missingPluginMessage.append("Required plugin ").append(rp.getPluginName()).append(" not found").append("\n");
        }
        if (!missingPluginMessage.isEmpty()) {
            System.out.println(missingPluginMessage.toString());
            System.out.println("Terminating");
            try {
                try {
                    this.bundleContext.getBundle(0L).stop();
                    Bundle bundle = this.bundleContext.getBundle(0L);
                    if (bundle instanceof Framework) {
                        Framework framework = (Framework)bundle;
                        framework.waitForStop(60000L);
                    }
                }
                catch (Exception exception) {
                    System.exit(1);
                }
            }
            finally {
                System.exit(1);
            }
        }
    }
}

